/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ServiceDefinition;
import org.infoglue.cms.entities.management.ServiceDefinitionVO;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ServiceDefinitionController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ServiceDefinitionController.class.getName());

    public static ServiceDefinitionController getController() {
        return new ServiceDefinitionController();
    }

    public ServiceDefinitionVO getServiceDefinitionVOWithId(Integer serviceDefinitionId) throws SystemException, Bug {
        return (ServiceDefinitionVO)ServiceDefinitionController.getVOWithId(ServiceDefinitionImpl.class, serviceDefinitionId);
    }

    public ServiceDefinitionVO getServiceDefinitionVOWithId(Integer serviceDefinitionId, Database db) throws SystemException, Bug {
        return (ServiceDefinitionVO)ServiceDefinitionController.getVOWithId(ServiceDefinitionImpl.class, serviceDefinitionId, db);
    }

    public ServiceDefinitionVO create(ServiceDefinitionVO vo) throws ConstraintException, SystemException {
        ServiceDefinition ent = new ServiceDefinitionImpl();
        ent.setValueObject(vo);
        ent = (ServiceDefinition)ServiceDefinitionController.createEntity(ent);
        return ent.getValueObject();
    }

    public void delete(ServiceDefinitionVO vo) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ServiceDefinitionController.beginTransaction(db);
        try {
            try {
                ServiceDefinition serviceDefinition = this.getServiceDefinitionWithId(vo.getServiceDefinitionId(), db);
                if (serviceDefinition.getName().equalsIgnoreCase("Core content service") || serviceDefinition.getName().equalsIgnoreCase("Core structure service")) {
                    throw new ConstraintException("ServiceDefinition.deleteAction", "3200");
                }
            }
            catch (ConstraintException ce) {
                throw ce;
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SystemException("An error occurred in ServiceDefinitionController.delete(). Reason:" + e.getMessage(), e);
            }
        }
        finally {
            ServiceDefinitionController.commitTransaction(db);
        }
        ServiceDefinitionController.deleteEntity(ServiceDefinitionImpl.class, vo.getServiceDefinitionId());
    }

    public ServiceDefinition getServiceDefinitionWithId(Integer serviceDefinitionId, Database db) throws SystemException, Bug {
        return (ServiceDefinition)ServiceDefinitionController.getObjectWithId(ServiceDefinitionImpl.class, serviceDefinitionId, db);
    }

    public List getServiceDefinitionVOList() throws SystemException, Bug {
        return this.getAllVOObjects(ServiceDefinitionImpl.class, "serviceDefinitionId");
    }

    public void deleteServiceDefinition(Integer serviceDefinitionId, Database db) throws SystemException, Bug {
        try {
            db.remove((Object)this.getServiceDefinitionWithId(serviceDefinitionId, db));
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to delete ServiceDefinition in the database. Reason: " + e.getMessage(), e);
        }
    }

    public ServiceDefinitionVO update(ServiceDefinitionVO serviceDefinitionVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ServiceDefinition serviceDefinition = null;
        ServiceDefinitionController.beginTransaction(db);
        try {
            serviceDefinition = this.getServiceDefinitionWithId(serviceDefinitionVO.getServiceDefinitionId(), db);
            serviceDefinition.setValueObject(serviceDefinitionVO);
            ceb.throwIfNotEmpty();
            ServiceDefinitionController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ServiceDefinitionController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ServiceDefinitionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return serviceDefinition.getValueObject();
    }

    public ServiceDefinitionVO getServiceDefinitionVOWithName(String name) throws SystemException, Bug {
        ServiceDefinitionVO serviceDefinitionVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ServiceDefinitionController.beginTransaction(db);
        try {
            ServiceDefinition serviceDefinition = this.getServiceDefinitionWithName(name, db, true);
            if (serviceDefinition != null) {
                serviceDefinitionVO = serviceDefinition.getValueObject();
            }
            ServiceDefinitionController.commitTransaction(db);
        }
        catch (Exception e) {
            ServiceDefinitionController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a ServiceDefinition by name. Reason:" + e.getMessage(), e);
        }
        return serviceDefinitionVO;
    }

    public ServiceDefinition getServiceDefinitionWithName(String name, Database db, boolean readOnly) throws SystemException, Bug {
        ServiceDefinition serviceDefinition = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT a FROM org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl a WHERE a.name = $1");
            oql.bind((Object)name);
            QueryResults results = null;
            if (readOnly) {
                results = oql.execute((short)0);
            } else {
                logger.info((Object)("Fetching entity in read/write mode" + name));
                results = oql.execute();
            }
            if (results.hasMore()) {
                serviceDefinition = (ServiceDefinition)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named AvailableServiceBinding. Reason:" + e.getMessage(), e);
        }
        return serviceDefinition;
    }

    public BaseEntityVO getNewVO() {
        return new ServiceDefinitionVO();
    }
}

