/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.QualifyerController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.ServiceBindingVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ServiceBindingController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ServiceBindingController.class.getName());

    public static ServiceBindingController getController() {
        return new ServiceBindingController();
    }

    public static ServiceBindingVO getServiceBindingVOWithId(Integer serviceBindingId) throws SystemException, Bug {
        return (ServiceBindingVO)ServiceBindingController.getVOWithId(ServiceBindingImpl.class, serviceBindingId);
    }

    public static ServiceBinding getServiceBindingWithId(Integer serviceBindingId, Database db) throws SystemException, Bug {
        return (ServiceBinding)ServiceBindingController.getObjectWithId(ServiceBindingImpl.class, serviceBindingId, db);
    }

    public static ServiceBinding getReadOnlyServiceBindingWithId(Integer serviceBindingId, Database db) throws SystemException, Bug {
        return (ServiceBinding)ServiceBindingController.getObjectWithIdAsReadOnly(ServiceBindingImpl.class, serviceBindingId, db);
    }

    public List getServiceBindingVOList() throws SystemException, Bug {
        return this.getAllVOObjects(ServiceBindingImpl.class, "serviceBindingId");
    }

    public List getServiceBindingList(Integer availableServiceBindingId, Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<ServiceBindingImpl> serviceBindings = new ArrayList<ServiceBindingImpl>();
        OQLQuery oql = db.getOQLQuery("SELECT sb FROM org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl sb WHERE sb.availableServiceBinding = $1 ORDER BY sb.serviceBindingId");
        oql.bind((Object)availableServiceBindingId);
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        while (results.hasMore()) {
            ServiceBindingImpl serviceBinding = (ServiceBindingImpl)results.next();
            serviceBindings.add(serviceBinding);
        }
        results.close();
        oql.close();
        return serviceBindings;
    }

    public static ServiceBindingVO create(ServiceBindingVO serviceBindingVO, String qualifyerXML, Integer availableServiceBindingId, Integer siteNodeVersionId, Integer serviceDefinitionId) throws ConstraintException, SystemException {
        logger.info((Object)"Creating a serviceBinding with the following...");
        logger.info((Object)("name:" + serviceBindingVO.getName()));
        logger.info((Object)("bindingTypeId:" + serviceBindingVO.getBindingTypeId()));
        logger.info((Object)("availableServiceBindingId:" + availableServiceBindingId));
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        logger.info((Object)("serviceDefinitionId:" + serviceDefinitionId));
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ServiceBindingImpl serviceBinding = null;
        ServiceBindingController.beginTransaction(db);
        try {
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionId, db);
            serviceBinding = new ServiceBindingImpl();
            serviceBinding.setValueObject(serviceBindingVO);
            serviceBinding.setAvailableServiceBinding((AvailableServiceBindingImpl)AvailableServiceBindingController.getController().getAvailableServiceBindingWithId(availableServiceBindingId, db));
            serviceBinding.setServiceDefinition((ServiceDefinitionImpl)ServiceDefinitionController.getController().getServiceDefinitionWithId(serviceDefinitionId, db));
            serviceBinding.setSiteNodeVersion((SiteNodeVersionImpl)siteNodeVersion);
            logger.info((Object)("createEntity: " + serviceBinding.getSiteNodeVersion().getSiteNodeVersionId()));
            serviceBinding.setBindingQualifyers(QualifyerController.createQualifyers(qualifyerXML, serviceBinding));
            db.create((Object)serviceBinding);
            siteNodeVersion.getServiceBindings().add(serviceBinding);
            RegistryController.getController().updateSiteNodeVersion(siteNodeVersion, db);
            ServiceBindingController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            e.printStackTrace();
            ServiceBindingController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return serviceBinding.getValueObject();
    }

    public ServiceBindingVO create(Database db, ServiceBindingVO serviceBindingVO, String qualifyerXML, Integer availableServiceBindingId, Integer siteNodeVersionId, Integer serviceDefinitionId) throws ConstraintException, SystemException {
        logger.info((Object)"Creating a serviceBinding with the following...");
        logger.info((Object)("name:" + serviceBindingVO.getName()));
        logger.info((Object)("bindingTypeId:" + serviceBindingVO.getBindingTypeId()));
        logger.info((Object)("availableServiceBindingId:" + availableServiceBindingId));
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        logger.info((Object)("serviceDefinitionId:" + serviceDefinitionId));
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ServiceBindingImpl serviceBinding = null;
        try {
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionId, db);
            serviceBinding = new ServiceBindingImpl();
            serviceBinding.setValueObject(serviceBindingVO);
            serviceBinding.setAvailableServiceBinding((AvailableServiceBindingImpl)AvailableServiceBindingController.getController().getAvailableServiceBindingWithId(availableServiceBindingId, db));
            serviceBinding.setServiceDefinition((ServiceDefinitionImpl)ServiceDefinitionController.getController().getServiceDefinitionWithId(serviceDefinitionId, db));
            serviceBinding.setSiteNodeVersion((SiteNodeVersionImpl)siteNodeVersion);
            logger.info((Object)("createEntity: " + serviceBinding.getSiteNodeVersion().getSiteNodeVersionId()));
            serviceBinding.setBindingQualifyers(QualifyerController.createQualifyers(qualifyerXML, serviceBinding));
            db.create((Object)serviceBinding);
            siteNodeVersion.getServiceBindings().add(serviceBinding);
            RegistryController.getController().updateSiteNodeVersion(siteNodeVersion, db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            e.printStackTrace();
            throw new SystemException(e.getMessage());
        }
        return serviceBinding.getValueObject();
    }

    protected static ServiceBinding create(ServiceBindingVO serviceBindingVO, Integer availableServiceBindingId, Integer siteNodeVersionId, Integer serviceDefinitionId, Database db) throws ConstraintException, SystemException, Exception {
        logger.info((Object)"Creating a serviceBinding with the following...");
        logger.info((Object)("name:" + serviceBindingVO.getName()));
        logger.info((Object)("bindingTypeId:" + serviceBindingVO.getBindingTypeId()));
        logger.info((Object)("availableServiceBindingId:" + availableServiceBindingId));
        logger.info((Object)("siteNodeVersionId:" + siteNodeVersionId));
        logger.info((Object)("serviceDefinitionId:" + serviceDefinitionId));
        SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionId, db);
        ServiceBindingImpl serviceBinding = null;
        serviceBinding = new ServiceBindingImpl();
        serviceBinding.setValueObject(serviceBindingVO);
        serviceBinding.setAvailableServiceBinding((AvailableServiceBindingImpl)AvailableServiceBindingController.getController().getAvailableServiceBindingWithId(availableServiceBindingId, db));
        serviceBinding.setServiceDefinition((ServiceDefinitionImpl)ServiceDefinitionController.getController().getServiceDefinitionWithId(serviceDefinitionId, db));
        serviceBinding.setSiteNodeVersion((SiteNodeVersionImpl)siteNodeVersion);
        logger.info((Object)("createEntity: " + serviceBinding.getSiteNodeVersion().getSiteNodeVersionId()));
        db.create((Object)serviceBinding);
        RegistryController.getController().updateSiteNodeVersion(siteNodeVersion, db);
        return serviceBinding;
    }

    public static ServiceBindingVO update(ServiceBindingVO serviceBindingVO, String qualifyerXML) throws ConstraintException, SystemException {
        logger.info((Object)"Updating a serviceBinding with the following...");
        logger.info((Object)("name:" + serviceBindingVO.getName()));
        logger.info((Object)("bindingTypeId:" + serviceBindingVO.getBindingTypeId()));
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ServiceBinding serviceBinding = null;
        ServiceBindingController.beginTransaction(db);
        try {
            serviceBinding = ServiceBindingController.getServiceBindingWithId(serviceBindingVO.getServiceBindingId(), db);
            serviceBinding.setPath(serviceBindingVO.getPath());
            serviceBinding.getBindingQualifyers().clear();
            Collection newQualifyers = QualifyerController.createQualifyers(qualifyerXML, serviceBinding);
            serviceBinding.setBindingQualifyers(newQualifyers);
            RegistryController.getController().updateSiteNodeVersion(serviceBinding.getSiteNodeVersion(), db);
            ServiceBindingController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            e.printStackTrace();
            ServiceBindingController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return serviceBinding.getValueObject();
    }

    public static void deleteServiceBindingsReferencingContent(Content content, Database db) throws ConstraintException, SystemException, Exception {
        OQLQuery oql = db.getOQLQuery("SELECT sb FROM org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl sb WHERE sb.bindingQualifyers.name = $1 AND sb.bindingQualifyers.value = $2 ORDER BY sb.serviceBindingId");
        oql.bind((Object)"contentId");
        oql.bind((Object)content.getContentId().toString());
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        while (results.hasMore()) {
            ServiceBindingImpl serviceBinding = (ServiceBindingImpl)results.next();
            Collection qualifyers = serviceBinding.getBindingQualifyers();
            Iterator qualifyersIterator = qualifyers.iterator();
            while (qualifyersIterator.hasNext()) {
                Qualifyer qualifyer = (Qualifyer)qualifyersIterator.next();
                if (!qualifyer.getName().equalsIgnoreCase("contentId") || !qualifyer.getValue().equals(content.getContentId().toString())) continue;
                qualifyersIterator.remove();
                serviceBinding.getBindingQualifyers().remove(qualifyer);
                if (serviceBinding.getBindingQualifyers() != null && serviceBinding.getBindingQualifyers().size() != 0) continue;
                db.remove((Object)serviceBinding);
            }
            SiteNodeVersionImpl siteNodeVersion = serviceBinding.getSiteNodeVersion();
            if (siteNodeVersion.getOwningSiteNode() != null) continue;
            SiteNodeVersionController.getController().delete(siteNodeVersion, db);
        }
        results.close();
        oql.close();
    }

    public static void deleteServiceBindingsReferencingSiteNode(SiteNode siteNode, Database db) throws ConstraintException, SystemException, Exception {
        OQLQuery oql = db.getOQLQuery("SELECT sb FROM org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl sb WHERE sb.bindingQualifyers.name = $1 AND sb.bindingQualifyers.value = $2 ORDER BY sb.serviceBindingId");
        oql.bind((Object)"siteNodeId");
        oql.bind((Object)siteNode.getSiteNodeId().toString());
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        while (results.hasMore()) {
            ServiceBindingImpl serviceBinding = (ServiceBindingImpl)results.next();
            Collection qualifyers = serviceBinding.getBindingQualifyers();
            Iterator qualifyersIterator = qualifyers.iterator();
            while (qualifyersIterator.hasNext()) {
                Qualifyer qualifyer = (Qualifyer)qualifyersIterator.next();
                if (!qualifyer.getName().equalsIgnoreCase("siteNodeId") || !qualifyer.getValue().equals(siteNode.getSiteNodeId().toString())) continue;
                qualifyersIterator.remove();
                serviceBinding.getBindingQualifyers().remove(qualifyer);
                if (serviceBinding.getBindingQualifyers() != null && serviceBinding.getBindingQualifyers().size() != 0) continue;
                db.remove((Object)serviceBinding);
            }
        }
        results.close();
        oql.close();
    }

    public static void delete(ServiceBindingVO serviceBindingVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ServiceBindingController.beginTransaction(db);
        try {
            ServiceBinding serviceBinding = ServiceBindingController.getServiceBindingWithId(serviceBindingVO.getServiceBindingId(), db);
            SiteNodeVersionImpl siteNodeVersion = serviceBinding.getSiteNodeVersion();
            db.remove((Object)serviceBinding);
            siteNodeVersion.getServiceBindings().remove(serviceBinding);
            RegistryController.getController().updateSiteNodeVersion(siteNodeVersion, db);
            ServiceBindingController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            ServiceBindingController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to remove a serviceBinding and it's qualifyers.");
        }
    }

    public static void delete(ServiceBindingVO serviceBindingVO, Database db) throws ConstraintException, SystemException, Exception {
        ServiceBinding serviceBinding = ServiceBindingController.getServiceBindingWithId(serviceBindingVO.getServiceBindingId(), db);
        db.remove((Object)serviceBinding);
        RegistryController.getController().updateSiteNodeVersion(serviceBinding.getSiteNodeVersion(), db);
    }

    public static List getQualifyerVOList(Integer serviceBindingId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List qualifyerVOList = null;
        ServiceBindingController.beginTransaction(db);
        try {
            ServiceBinding serviceBinding = ServiceBindingController.getReadOnlyServiceBindingWithId(serviceBindingId, db);
            Collection qualifyerList = serviceBinding.getBindingQualifyers();
            qualifyerVOList = ServiceBindingController.toVOList(qualifyerList);
            ceb.throwIfNotEmpty();
            ServiceBindingController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ServiceBindingController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ServiceBindingController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return qualifyerVOList;
    }

    public BaseEntityVO getNewVO() {
        return new ServiceBindingVO();
    }
}

