/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ServerNode;
import org.infoglue.cms.entities.management.ServerNodeVO;
import org.infoglue.cms.entities.management.impl.simple.ServerNodeImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.NotificationMessage;
import org.infoglue.cms.util.RemoteCacheUpdater;
import org.infoglue.deliver.util.CacheController;

public class ServerNodeController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ServerNodeController.class.getName());
    private String useUpdateSecurity = CmsPropertyHandler.getUseUpdateSecurity();

    public static ServerNodeController getController() {
        return new ServerNodeController();
    }

    public void initialize() {
    }

    public ServerNodeVO create(ServerNodeVO vo) throws ConstraintException, SystemException {
        ServerNode ent = new ServerNodeImpl();
        ent.setValueObject(vo);
        ent = (ServerNode)ServerNodeController.createEntity(ent);
        return ent.getValueObject();
    }

    public ServerNodeVO update(ServerNodeVO vo) throws ConstraintException, SystemException {
        return (ServerNodeVO)ServerNodeController.updateEntity(ServerNodeImpl.class, vo);
    }

    public ServerNode getServerNodeWithId(Integer id, Database db) throws SystemException, Bug {
        return (ServerNode)ServerNodeController.getObjectWithId(ServerNodeImpl.class, id, db);
    }

    public ServerNodeVO getServerNodeVOWithId(Integer serverNodeId) throws ConstraintException, SystemException, Bug {
        return (ServerNodeVO)ServerNodeController.getVOWithId(ServerNodeImpl.class, serverNodeId);
    }

    public ServerNodeVO getServerNodeVOWithName(String name) throws SystemException, Bug {
        ServerNodeVO serverNodeVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            ServerNodeController.beginTransaction(db);
            ServerNode serverNode = this.getServerNodeWithName(name, db);
            if (serverNode != null) {
                serverNodeVO = serverNode.getValueObject();
            }
            ServerNodeController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            ServerNodeController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return serverNodeVO;
    }

    public ServerNode getServerNodeWithName(String name, Database db) throws SystemException, Bug {
        ServerNode serverNode = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.ServerNodeImpl f WHERE f.name = $1");
            oql.bind((Object)name);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode" + name));
            if (results.hasMore()) {
                serverNode = (ServerNode)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named serverNode. Reason:" + e.getMessage(), e);
        }
        return serverNode;
    }

    public List getServerNodeVOList() throws SystemException, Bug {
        List serverNodeVOList = this.getAllVOObjects(ServerNodeImpl.class, "serverNodeId");
        return serverNodeVOList;
    }

    public void delete(ServerNodeVO serverNodeVO, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException {
        Integer serverNodeId = serverNodeVO.getId();
        ServerNodeController.deleteEntity(ServerNodeImpl.class, serverNodeVO.getId());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        Collection keys = ps.getKeys();
        for (String key : keys) {
            if (key.indexOf("serverNode_" + serverNodeId + "_") <= -1) continue;
            ps.remove(key);
        }
        try {
            CacheController.clearServerNodeProperty(true);
            InfoGlueAuthenticationFilter.initializeCMSProperties();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        NotificationMessage notificationMessage = new NotificationMessage("ViewServerNodePropertiesAction.doSave():", "ServerNodeProperties", infoGluePrincipal.getName(), 100, "0", "ServerNodeProperties");
        RemoteCacheUpdater.getSystemNotificationMessages().add(notificationMessage);
    }

    public List getAllowedAdminIPList() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String allowedAdminIP = ps.getString("allowedAdminIP");
        if (allowedAdminIP != null) {
            return Arrays.asList(allowedAdminIP.split(","));
        }
        return new ArrayList();
    }

    public boolean getIsIPAllowed(HttpServletRequest request) {
        boolean isIPAllowed = false;
        if (this.useUpdateSecurity != null && this.useUpdateSecurity.equals("true")) {
            String remoteIP = request.getRemoteAddr();
            if (remoteIP.equals("127.0.0.1")) {
                isIPAllowed = true;
            } else {
                List allowedAdminIPList = ServerNodeController.getController().getAllowedAdminIPList();
                for (String allowedIP : allowedAdminIPList) {
                    if (allowedIP.trim().equals("")) continue;
                    int index = allowedIP.indexOf(".*");
                    if (index > -1) {
                        allowedIP = allowedIP.substring(0, index);
                    }
                    if (!remoteIP.startsWith(allowedIP)) continue;
                    isIPAllowed = true;
                    break;
                }
            }
        } else {
            isIPAllowed = true;
        }
        return isIPAllowed;
    }

    public String getAllowedAdminIP() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        String allowedAdminIP = ps.getString("allowedAdminIP");
        return allowedAdminIP;
    }

    public void setAllowedAdminIP(String allowedAdminIP) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        ps.setString("allowedAdminIP", allowedAdminIP);
    }

    public BaseEntityVO getNewVO() {
        return new ServerNodeVO();
    }
}

