/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SearchController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)SearchController.class.getName());

    public static String getAttributeValue(String xml, String key) {
        String value = "";
        try {
            InputSource inputSource = new InputSource(new StringReader(xml));
            DOMParser parser = new DOMParser();
            parser.parse(inputSource);
            Document document = parser.getDocument();
            NodeList nl = document.getDocumentElement().getChildNodes();
            Node n = nl.item(0);
            nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                if (n.getNodeName().equalsIgnoreCase(key)) {
                    value = n.getFirstChild().getNodeValue();
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (value.equalsIgnoreCase("")) {
            value = "This Content is Unititled";
        }
        return value;
    }

    public static String setScoreImg(double score) {
        if (2.0 < score) {
            return "5star.gif";
        }
        if (1.0 < score) {
            return "4star.gif";
        }
        if (0.6 < score) {
            return "3star.gif";
        }
        if (0.4 < score) {
            return "2star.gif";
        }
        return "1star.gif";
    }

    public static Set getContents(Integer repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId) throws SystemException, Bug {
        return SearchController.getContents(new Integer[]{repositoryId}, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId, false);
    }

    public static Set getContents(Integer repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId, boolean searchAsset) throws SystemException, Bug {
        return SearchController.getContents(new Integer[]{repositoryId}, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId, searchAsset);
    }

    public static Set getContents(Integer[] repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId) throws SystemException, Bug {
        HashSet<ContentVO> contents = new HashSet<ContentVO>();
        List contentVersions = SearchController.getContentVersions(repositoryId, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId);
        for (ContentVersionVO contentVersionVO : contentVersions) {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentVersionVO.getContentId());
            contents.add(contentVO);
        }
        return contents;
    }

    public static Set getContents(Integer[] repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId, boolean searchAssets) throws SystemException, Bug {
        HashSet<ContentVO> contents = new HashSet<ContentVO>();
        List contentVersions = SearchController.getContentVersions(repositoryId, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId, searchAssets);
        for (ContentVersionVO contentVersionVO : contentVersions) {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentVersionVO.getContentId());
            contents.add(contentVO);
        }
        return contents;
    }

    public static List getContentVersions(Integer repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId) throws SystemException, Bug {
        List matchingContents = SearchController.getContentVersions(new Integer[]{repositoryId}, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId);
        return matchingContents;
    }

    public static List getContentVersions(Integer repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId, boolean searchAssets) throws SystemException, Bug {
        List matchingContents = SearchController.getContentVersions(new Integer[]{repositoryId}, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId, searchAssets);
        return matchingContents;
    }

    public static List getContentVersions(Integer[] repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId) throws SystemException, Bug {
        return SearchController.getContentVersions(repositoryId, searchString, maxRows, name, languageId, contentTypeDefinitionId, caseSensitive, stateId, false);
    }

    public static List getContentVersions(Integer[] repositoryId, String searchString, int maxRows, String name, Integer languageId, Integer[] contentTypeDefinitionId, Integer caseSensitive, Integer stateId, boolean searchAssets) throws SystemException, Bug {
        ArrayList<ContentVersionVO> matchingContents = new ArrayList<ContentVersionVO>();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Database db = CastorDatabaseService.getDatabase();
        try {
            SearchController.beginTransaction(db);
            String repositoryArgument = " AND (";
            int index = 3;
            ArrayList<Integer> repArguments = new ArrayList<Integer>();
            int i = 0;
            while (i < repositoryId.length) {
                if (i > 0) {
                    repositoryArgument = String.valueOf(repositoryArgument) + " OR ";
                }
                repositoryArgument = String.valueOf(repositoryArgument) + "cv.owningContent.repository.repositoryId = $" + index;
                repArguments.add(repositoryId[i]);
                ++index;
                ++i;
            }
            repositoryArgument = String.valueOf(repositoryArgument) + ")";
            String extraArguments = "";
            String inverse = "";
            ArrayList<Object> arguments = new ArrayList<Object>();
            if (name != null && !name.equalsIgnoreCase("")) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.versionModifier = $" + index;
                arguments.add(name);
                ++index;
            }
            if (languageId != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.language = $" + index;
                arguments.add(languageId);
                ++index;
            }
            if (contentTypeDefinitionId != null && contentTypeDefinitionId.length > 0 && contentTypeDefinitionId[0] != null) {
                extraArguments = String.valueOf(extraArguments) + " AND(";
                int i2 = 0;
                while (i2 < contentTypeDefinitionId.length) {
                    extraArguments = i2 == 0 ? String.valueOf(extraArguments) + " cv.owningContent.contentTypeDefinition = $" + index : String.valueOf(extraArguments) + " OR cv.owningContent.contentTypeDefinition = $" + index;
                    arguments.add(contentTypeDefinitionId[i2]);
                    ++index;
                    ++i2;
                }
                extraArguments = String.valueOf(extraArguments) + ")";
            }
            if (stateId != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.stateId = $" + index;
                arguments.add(stateId);
                ++index;
            }
            String sql = "SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.isActive = $1 AND cv.versionValue LIKE $2 " + repositoryArgument + extraArguments + " ORDER BY cv.owningContent asc, cv.language, cv.contentVersionId desc";
            logger.info((Object)("sql:" + sql));
            OQLQuery oql = db.getOQLQuery(sql);
            oql.bind((Object)new Boolean(true));
            oql.bind((Object)("%" + searchString + "%"));
            for (Integer repositoryIdAsInteger : repArguments) {
                oql.bind((Object)repositoryIdAsInteger);
            }
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                oql.bind(iterator.next());
            }
            QueryResults results = oql.execute((short)0);
            Integer previousContentId = new Integer(-1);
            Integer previousLanguageId = new Integer(-1);
            int currentCount = 0;
            while (results.hasMore() && currentCount < maxRows) {
                ContentVersion latestContentVersion;
                ContentVersion contentVersion = (ContentVersion)results.next();
                logger.info((Object)("Found a version matching " + searchString + ":" + contentVersion.getId() + "=" + contentVersion.getOwningContent().getName()));
                if (contentVersion.getOwningContent().getId().intValue() == previousContentId.intValue() && contentVersion.getLanguage().getId().intValue() == previousLanguageId.intValue() || (latestContentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVersion.getOwningContent().getId(), contentVersion.getLanguage().getId(), db)).getId().intValue() != contentVersion.getId().intValue() || caseSensitive != null && contentVersion.getVersionValue().indexOf(searchString) <= -1 || searchAssets && (contentVersion.getDigitalAssets() == null || contentVersion.getDigitalAssets().size() <= 0)) continue;
                matchingContents.add(contentVersion.getValueObject());
                previousContentId = contentVersion.getOwningContent().getId();
                previousLanguageId = contentVersion.getLanguage().getId();
                ++currentCount;
            }
            results.close();
            oql.close();
            if (searchAssets) {
                String assetSQL = "SELECT da FROM org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl da WHERE (da.assetKey LIKE $1 OR da.assetFileName LIKE $2) ORDER BY da.digitalAssetId asc";
                logger.info((Object)("assetSQL:" + assetSQL));
                OQLQuery assetOQL = db.getOQLQuery(assetSQL);
                assetOQL.bind((Object)("%" + searchString + "%"));
                assetOQL.bind((Object)("%" + searchString + "%"));
                QueryResults assetResults = assetOQL.execute((short)0);
                previousContentId = new Integer(-1);
                previousLanguageId = new Integer(-1);
                currentCount = 0;
                while (assetResults.hasMore() && currentCount < maxRows) {
                    SmallDigitalAssetImpl smallAsset = (SmallDigitalAssetImpl)assetResults.next();
                    DigitalAsset asset = DigitalAssetController.getDigitalAssetWithId(smallAsset.getId(), db);
                    logger.info((Object)("Found a asset matching " + searchString + ":" + asset.getId()));
                    Collection versions = asset.getContentVersions();
                    for (ContentVersion contentVersion : versions) {
                        ContentVersion latestContentVersion;
                        if (contentVersion.getOwningContent().getId().intValue() == previousContentId.intValue() && contentVersion.getLanguage().getId().intValue() == previousLanguageId.intValue() || (latestContentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVersion.getOwningContent().getId(), contentVersion.getLanguage().getId(), db)).getId().intValue() != contentVersion.getId().intValue() || caseSensitive != null && contentVersion.getVersionValue().indexOf(searchString) <= -1) continue;
                        matchingContents.add(contentVersion.getValueObject());
                        previousContentId = contentVersion.getOwningContent().getId();
                        previousLanguageId = contentVersion.getLanguage().getId();
                        ++currentCount;
                    }
                }
                assetResults.close();
                assetOQL.close();
            }
            SearchController.commitTransaction(db);
        }
        catch (Exception e) {
            SearchController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to search. Reason:" + e.getMessage(), e);
        }
        return matchingContents;
    }

    public static Set getContentVersions(Integer contentTypeDefinitionId, String userName, Date publishStartDate, Date publishEndDate, Date unpublishStartDate, Date unpublishEndDate) throws SystemException, Bug {
        HashSet<ContentVersionVO> matchingContentVersions = new HashSet<ContentVersionVO>();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Database db = CastorDatabaseService.getDatabase();
        try {
            SearchController.beginTransaction(db);
            int index = 2;
            String extraArguments = "";
            String inverse = "";
            ArrayList<Object> arguments = new ArrayList<Object>();
            if (userName != null && !userName.equalsIgnoreCase("")) {
                extraArguments = String.valueOf(extraArguments) + " cv.versionModifier = $" + index;
                arguments.add(userName);
                ++index;
            }
            if (contentTypeDefinitionId != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.owningContent.contentTypeDefinition = $" + index;
                arguments.add(contentTypeDefinitionId);
                ++index;
            }
            if (publishStartDate != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.owningContent.publishDateTime > $" + index;
                arguments.add(publishStartDate);
                ++index;
            }
            if (publishEndDate != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.owningContent.publishDateTime < $" + index;
                arguments.add(publishEndDate);
                ++index;
            }
            if (unpublishStartDate != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.owningContent.expireDateTime > $" + index;
                arguments.add(unpublishStartDate);
                ++index;
            }
            if (unpublishEndDate != null) {
                extraArguments = String.valueOf(extraArguments) + " AND cv.owningContent.expireDateTime < $" + index;
                arguments.add(unpublishEndDate);
                ++index;
            }
            String sql = "SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.FullContentVersionImpl cv WHERE cv.isActive = $1 AND " + extraArguments + " ORDER BY cv.contentId asc, cv.language, cv.contentVersionId desc";
            if (logger.isInfoEnabled()) {
                logger.info((Object)("sql:" + sql));
            }
            OQLQuery oql = db.getOQLQuery(sql);
            oql.bind((Object)new Boolean(true));
            Iterator iterator = arguments.iterator();
            while (iterator.hasNext()) {
                oql.bind(iterator.next());
            }
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                ContentVersion latestContentVersion;
                ContentVersion contentVersion = (ContentVersion)results.next();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Found a version matching:" + contentVersion.getId() + ":" + contentVersion.getOwningContent().getExpireDateTime()));
                }
                if ((latestContentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVersion.getValueObject().getContentId(), contentVersion.getValueObject().getLanguageId(), db)).getId().intValue() != contentVersion.getId().intValue()) continue;
                matchingContentVersions.add(contentVersion.getValueObject());
            }
            results.close();
            oql.close();
            SearchController.commitTransaction(db);
        }
        catch (Exception e) {
            SearchController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to search. Reason:" + e.getMessage(), e);
        }
        return matchingContentVersions;
    }

    public static int replaceString(String searchString, String replaceString, String[] contentVersionIds, InfoGluePrincipal infoGluePrincipal) throws SystemException, Bug {
        int replacements = 0;
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Database db = CastorDatabaseService.getDatabase();
        try {
            SearchController.beginTransaction(db);
            int i = 0;
            while (i < contentVersionIds.length) {
                String contentVersionId = contentVersionIds[i];
                logger.info((Object)("contentVersionId:" + contentVersionId));
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(new Integer(contentVersionIds[i]), db);
                if (contentVersion.getStateId().intValue() != ContentVersionVO.WORKING_STATE.intValue()) {
                    ArrayList events = new ArrayList();
                    contentVersion = ContentStateController.changeState(contentVersion.getId(), ContentVersionVO.WORKING_STATE, "Automatic by the replace function", true, null, infoGluePrincipal, null, db, events);
                    logger.info((Object)"Setting the version to working before replacing string...");
                }
                String value = contentVersion.getVersionValue();
                value = value.replaceAll(searchString, replaceString);
                contentVersion.setVersionValue(value);
                ++replacements;
                ++i;
            }
            SearchController.commitTransaction(db);
        }
        catch (Exception e) {
            SearchController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a list of users in this role. Reason:" + e.getMessage(), e);
        }
        return replacements;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

