/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.dom4j.Document;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PropertiesCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.PropertiesCategoryVO;
import org.infoglue.cms.entities.management.RoleContentTypeDefinition;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.RolePropertiesVO;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.RoleContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.RolePropertiesImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RolePropertiesController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)RolePropertiesController.class.getName());

    public static RolePropertiesController getController() {
        return new RolePropertiesController();
    }

    public RoleProperties getRolePropertiesWithId(Integer rolePropertiesId, Database db) throws SystemException, Bug {
        return (RoleProperties)RolePropertiesController.getObjectWithId(RolePropertiesImpl.class, rolePropertiesId, db);
    }

    public RolePropertiesVO getRolePropertiesVOWithId(Integer rolePropertiesId) throws SystemException, Bug {
        return (RolePropertiesVO)RolePropertiesController.getVOWithId(RolePropertiesImpl.class, rolePropertiesId);
    }

    public List getRolePropertiesVOList() throws SystemException, Bug {
        return this.getAllVOObjects(RolePropertiesImpl.class, "rolePropertiesId");
    }

    public RolePropertiesVO create(Integer languageId, Integer contentTypeDefinitionId, RolePropertiesVO rolePropertiesVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RoleProperties roleProperties = null;
        RolePropertiesController.beginTransaction(db);
        try {
            roleProperties = this.create(languageId, contentTypeDefinitionId, rolePropertiesVO, db);
            RolePropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return roleProperties.getValueObject();
    }

    public RoleProperties create(Integer languageId, Integer contentTypeDefinitionId, RolePropertiesVO rolePropertiesVO, Database db) throws ConstraintException, SystemException, Exception {
        Language language = LanguageController.getController().getLanguageWithId(languageId, db);
        ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
        RolePropertiesImpl roleProperties = new RolePropertiesImpl();
        roleProperties.setLanguage((LanguageImpl)language);
        roleProperties.setContentTypeDefinition(contentTypeDefinition);
        roleProperties.setValueObject(rolePropertiesVO);
        db.create((Object)roleProperties);
        return roleProperties;
    }

    public RolePropertiesVO update(Integer languageId, Integer contentTypeDefinitionId, RolePropertiesVO rolePropertiesVO) throws ConstraintException, SystemException {
        RolePropertiesVO realRolePropertiesVO = rolePropertiesVO;
        if (rolePropertiesVO.getId() == null) {
            logger.info((Object)("Creating the entity because there was no version at all for: " + contentTypeDefinitionId + " " + languageId));
            realRolePropertiesVO = this.create(languageId, contentTypeDefinitionId, rolePropertiesVO);
        }
        return (RolePropertiesVO)RolePropertiesController.updateEntity(RolePropertiesImpl.class, realRolePropertiesVO);
    }

    public RolePropertiesVO update(RolePropertiesVO rolePropertiesVO, String[] extranetUsers) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RoleProperties roleProperties = null;
        RolePropertiesController.beginTransaction(db);
        try {
            roleProperties = this.getRolePropertiesWithId(rolePropertiesVO.getRolePropertiesId(), db);
            roleProperties.setValueObject(rolePropertiesVO);
            ceb.throwIfNotEmpty();
            RolePropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RolePropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return roleProperties.getValueObject();
    }

    public List getRolePropertiesVOList(String roleName, Integer languageId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List rolePropertiesVOList = new ArrayList();
        RolePropertiesController.beginTransaction(db);
        try {
            List roleProperties = this.getRolePropertiesList(roleName, languageId, db, true);
            rolePropertiesVOList = RolePropertiesController.toVOList(roleProperties);
            ceb.throwIfNotEmpty();
            RolePropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RolePropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return rolePropertiesVOList;
    }

    public List getRolePropertiesList(String roleName, Integer languageId, Database db, boolean readOnly) throws ConstraintException, SystemException, Exception {
        ArrayList<RoleProperties> rolePropertiesList = new ArrayList<RoleProperties>();
        OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.RolePropertiesImpl f WHERE f.roleName = $1 AND f.language = $2");
        oql.bind((Object)roleName);
        oql.bind((Object)languageId);
        QueryResults results = null;
        if (readOnly) {
            results = oql.execute((short)0);
        } else {
            logger.info((Object)("Fetching entity in read/write mode:" + roleName));
            results = oql.execute();
        }
        while (results.hasMore()) {
            RoleProperties roleProperties = (RoleProperties)results.next();
            rolePropertiesList.add(roleProperties);
        }
        results.close();
        oql.close();
        return rolePropertiesList;
    }

    public void delete(RolePropertiesVO rolePropertiesVO) throws ConstraintException, SystemException {
        RolePropertiesController.deleteEntity(RolePropertiesImpl.class, rolePropertiesVO.getRolePropertiesId());
    }

    public List getDigitalAssetVOList(Integer rolePropertiesId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List digitalAssetVOList = new ArrayList();
        RolePropertiesController.beginTransaction(db);
        try {
            RoleProperties roleProperties = RolePropertiesController.getController().getRolePropertiesWithId(rolePropertiesId, db);
            if (roleProperties != null) {
                Collection digitalAssets = roleProperties.getDigitalAssets();
                digitalAssetVOList = RolePropertiesController.toVOList(digitalAssets);
            }
            RolePropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to fetch the list of digitalAssets belonging to this roleProperties:" + e));
            e.printStackTrace();
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVOList;
    }

    public void deleteDigitalAssetRelation(Integer rolePropertiesId, DigitalAsset digitalAsset, Database db) throws SystemException, Bug {
        RoleProperties roleProperties = this.getRolePropertiesWithId(rolePropertiesId, db);
        roleProperties.getDigitalAssets().remove(digitalAsset);
        digitalAsset.getRoleProperties().remove(roleProperties);
    }

    public List getContentTypeDefinitionVOList(String roleName) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
        RolePropertiesController.beginTransaction(db);
        try {
            List roleContentTypeDefinitionList = this.getRoleContentTypeDefinitionList(roleName, db);
            for (RoleContentTypeDefinition roleContentTypeDefinition : roleContentTypeDefinitionList) {
                contentTypeDefinitionVOList.add(roleContentTypeDefinition.getContentTypeDefinition().getValueObject());
            }
            ceb.throwIfNotEmpty();
            RolePropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RolePropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentTypeDefinitionVOList;
    }

    public List getRoleContentTypeDefinitionList(String roleName, Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<RoleContentTypeDefinition> roleContentTypeDefinitionList = new ArrayList<RoleContentTypeDefinition>();
        OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.RoleContentTypeDefinitionImpl f WHERE f.roleName = $1");
        oql.bind((Object)roleName);
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        while (results.hasMore()) {
            RoleContentTypeDefinition roleContentTypeDefinition = (RoleContentTypeDefinition)results.next();
            roleContentTypeDefinitionList.add(roleContentTypeDefinition);
        }
        results.close();
        oql.close();
        return roleContentTypeDefinitionList;
    }

    public void updateContentTypeDefinitions(String roleName, String[] contentTypeDefinitionIds) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList contentTypeDefinitionVOList = new ArrayList();
        RolePropertiesController.beginTransaction(db);
        try {
            List roleContentTypeDefinitionList = this.getRoleContentTypeDefinitionList(roleName, db);
            for (RoleContentTypeDefinition roleContentTypeDefinition : roleContentTypeDefinitionList) {
                db.remove((Object)roleContentTypeDefinition);
            }
            int i = 0;
            while (i < contentTypeDefinitionIds.length) {
                Integer contentTypeDefinitionId = new Integer(contentTypeDefinitionIds[i]);
                ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
                RoleContentTypeDefinitionImpl roleContentTypeDefinitionImpl = new RoleContentTypeDefinitionImpl();
                roleContentTypeDefinitionImpl.setRoleName(roleName);
                roleContentTypeDefinitionImpl.setContentTypeDefinition(contentTypeDefinition);
                db.create((Object)roleContentTypeDefinitionImpl);
                ++i;
            }
            ceb.throwIfNotEmpty();
            RolePropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RolePropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updateAttributeValue(Integer rolePropertiesId, String attributeName, String attributeValue) throws SystemException, Bug {
        RolePropertiesVO rolePropertiesVO = this.getRolePropertiesVOWithId(rolePropertiesId);
        if (rolePropertiesVO != null) {
            try {
                logger.info((Object)("attributeName:" + attributeName));
                logger.info((Object)("versionValue:" + rolePropertiesVO.getValue()));
                logger.info((Object)("attributeValue:" + attributeValue));
                InputSource inputSource = new InputSource(new StringReader(rolePropertiesVO.getValue()));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                org.w3c.dom.Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                Node attributesNode = nl.item(0);
                boolean existed = false;
                nl = attributesNode.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    if (n.getNodeName().equalsIgnoreCase(attributeName)) {
                        if (n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                            n.getFirstChild().setNodeValue(attributeValue);
                            existed = true;
                            break;
                        }
                        CDATASection cdata = document.createCDATASection(attributeValue);
                        n.appendChild(cdata);
                        existed = true;
                        break;
                    }
                    ++i;
                }
                if (!existed) {
                    Element attributeElement = document.createElement(attributeName);
                    attributesNode.appendChild(attributeElement);
                    CDATASection cdata = document.createCDATASection(attributeValue);
                    attributeElement.appendChild(cdata);
                }
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(document.getDocumentElement(), sb);
                logger.info((Object)("sb:" + sb));
                rolePropertiesVO.setValue(sb.toString());
                this.update(rolePropertiesVO.getLanguageId(), rolePropertiesVO.getContentTypeDefinitionId(), rolePropertiesVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAttributeValue(String roleName, Integer languageId, String attributeName) throws SystemException {
        String value = "";
        Database db = CastorDatabaseService.getDatabase();
        RolePropertiesController.beginTransaction(db);
        try {
            List roleProperties = this.getRolePropertiesList(roleName, languageId, db, true);
            Iterator iterator = roleProperties.iterator();
            RoleProperties roleProperty = null;
            if (iterator.hasNext()) {
                roleProperty = (RoleProperties)iterator.next();
            }
            value = this.getAttributeValue(roleProperty.getValue(), attributeName, false);
            RolePropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return value;
    }

    public String getAttributeValue(Integer rolePropertiesId, String attributeName, boolean escapeHTML) throws SystemException, Bug {
        String value = "";
        RolePropertiesVO rolePropertiesVO = this.getRolePropertiesVOWithId(rolePropertiesId);
        if (rolePropertiesVO != null) {
            value = this.getAttributeValue(rolePropertiesVO.getValue(), attributeName, escapeHTML);
        }
        return value;
    }

    public String getAttributeValue(String xml, String attributeName, boolean escapeHTML) throws SystemException, Bug {
        String value = "";
        try {
            InputSource inputSource = new InputSource(new StringReader(xml));
            DOMParser parser = new DOMParser();
            parser.parse(inputSource);
            org.w3c.dom.Document document = parser.getDocument();
            NodeList nl = document.getDocumentElement().getChildNodes();
            Node n = nl.item(0);
            nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                if (n.getNodeName().equalsIgnoreCase(attributeName) && n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                    value = n.getFirstChild().getNodeValue();
                    if (value != null && escapeHTML) {
                        value = new VisualFormatter().escapeHTML(value);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public List getRelatedContents(String roleName, Integer languageId, String attributeName) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        List relatedContentVOList = new ArrayList();
        RolePropertiesController.beginTransaction(db);
        try {
            List roleProperties = this.getRolePropertiesList(roleName, languageId, db, true);
            Iterator iterator = roleProperties.iterator();
            RoleProperties roleProperty = null;
            if (iterator.hasNext()) {
                roleProperty = (RoleProperties)iterator.next();
            }
            String xml = this.getAttributeValue(roleProperty.getValue(), attributeName, false);
            List contents = this.getRelatedContentsFromXML(db, xml);
            relatedContentVOList = RolePropertiesController.toVOList(contents);
            RolePropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return relatedContentVOList;
    }

    public List getRelatedSiteNodes(String roleName, Integer languageId, String attributeName) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        List relatedSiteNodeVOList = new ArrayList();
        RolePropertiesController.beginTransaction(db);
        try {
            List roleProperties = this.getRolePropertiesList(roleName, languageId, db, true);
            Iterator iterator = roleProperties.iterator();
            RoleProperties roleProperty = null;
            if (iterator.hasNext()) {
                roleProperty = (RoleProperties)iterator.next();
            }
            String xml = this.getAttributeValue(roleProperty.getValue(), attributeName, false);
            List siteNodes = this.getRelatedSiteNodesFromXML(db, xml);
            relatedSiteNodeVOList = RolePropertiesController.toVOList(siteNodes);
            RolePropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RolePropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return relatedSiteNodeVOList;
    }

    private List getRelatedContentsFromXML(Database db, String qualifyerXML) {
        ArrayList<Content> contents = new ArrayList<Content>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return contents;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (org.dom4j.Element child : children) {
                String id = child.getStringValue();
                Content content = ContentController.getContentController().getContentWithId(new Integer(id), db);
                contents.add(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    private List getRelatedSiteNodesFromXML(Database db, String qualifyerXML) {
        ArrayList<SiteNode> siteNodes = new ArrayList<SiteNode>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return siteNodes;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (org.dom4j.Element child : children) {
                String id = child.getStringValue();
                SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(id), db);
                siteNodes.add(siteNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return siteNodes;
    }

    public List getRelatedCategories(String roleName, Integer languageId, String attribute) {
        ArrayList<CategoryVO> relatedCategories = new ArrayList<CategoryVO>();
        try {
            List rolePropertiesVOList = this.getRolePropertiesVOList(roleName, languageId);
            Iterator iterator = rolePropertiesVOList.iterator();
            RolePropertiesVO rolePropertyVO = null;
            if (iterator.hasNext()) {
                rolePropertyVO = (RolePropertiesVO)iterator.next();
            }
            if (rolePropertyVO != null && rolePropertyVO.getId() != null) {
                List propertiesCategoryVOList = PropertiesCategoryController.getController().findByPropertiesAttribute(attribute, RoleProperties.class.getName(), rolePropertyVO.getId());
                for (PropertiesCategoryVO propertiesCategoryVO : propertiesCategoryVOList) {
                    relatedCategories.add(propertiesCategoryVO.getCategory());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return relatedCategories;
    }

    public BaseEntityVO getNewVO() {
        return new RolePropertiesVO();
    }
}

