/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class RoleControllerProxy
extends BaseController {
    private AuthorizationModule authorizationModule = null;
    private Database transactionObject = null;

    public RoleControllerProxy(Database transactionObject) {
        this.transactionObject = transactionObject;
    }

    public static RoleControllerProxy getController() {
        return new RoleControllerProxy(null);
    }

    public static RoleControllerProxy getController(Database transactionObject) {
        return new RoleControllerProxy(transactionObject);
    }

    private AuthorizationModule getAuthorizationModule() {
        try {
            this.authorizationModule = (AuthorizationModule)Class.forName(InfoGlueAuthenticationFilter.authorizerClass).newInstance();
            this.authorizationModule.setExtraProperties(InfoGlueAuthenticationFilter.extraProperties);
            this.authorizationModule.setTransactionObject(this.transactionObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.authorizationModule;
    }

    public boolean getSupportUpdate() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportUpdate();
    }

    public boolean getSupportDelete() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportDelete();
    }

    public boolean getSupportCreate() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportCreate();
    }

    public List getAllRoles() throws ConstraintException, SystemException, Exception {
        List roles = new ArrayList();
        roles = this.getAuthorizationModule().getRoles();
        Collections.sort(roles, new ReflectionComparator("displayName"));
        return roles;
    }

    public InfoGlueRole getRole(String roleName) throws ConstraintException, SystemException, Exception {
        InfoGlueRole infoGlueRole = null;
        infoGlueRole = this.getAuthorizationModule().getAuthorizedInfoGlueRole(roleName);
        return infoGlueRole;
    }

    public List getInfoGluePrincipals(String roleName) throws ConstraintException, SystemException, Exception {
        List infoGluePrincipals = new ArrayList();
        infoGluePrincipals = this.getAuthorizationModule().getUsers(roleName);
        Collections.sort(infoGluePrincipals, new ReflectionComparator("displayName"));
        return infoGluePrincipals;
    }

    public InfoGlueRole createRole(RoleVO roleVO) throws ConstraintException, SystemException, Exception {
        Object infoGlueRole = null;
        this.getAuthorizationModule().createInfoGlueRole(roleVO);
        return this.getRole(roleVO.getRoleName());
    }

    public void updateRole(RoleVO roleVO, String[] userNames) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().updateInfoGlueRole(roleVO, userNames);
    }

    public void deleteRole(String roleName) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().deleteInfoGlueRole(roleName);
        AccessRightController.getController().delete(roleName);
    }

    public BaseEntityVO getNewVO() {
        return null;
    }

    public List getAvailableRoles(InfoGluePrincipal infoGluePrincipal, String interceptionPointName) throws ConstraintException, SystemException, Exception {
        ArrayList<InfoGlueRole> availableRoles = new ArrayList<InfoGlueRole>();
        List allRoles = this.getAuthorizationModule().getRoles();
        if (this.transactionObject == null) {
            Database db = CastorDatabaseService.getDatabase();
            try {
                RoleControllerProxy.beginTransaction(db);
                for (InfoGlueRole role : allRoles) {
                    boolean hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, interceptionPointName, role.getName());
                    if (!hasAccess) continue;
                    availableRoles.add(role);
                }
                RoleControllerProxy.commitTransaction(db);
            }
            catch (Exception e) {
                RoleControllerProxy.rollbackTransaction(db);
                throw new SystemException(e);
            }
        } else {
            for (InfoGlueRole role : allRoles) {
                boolean hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(this.transactionObject, infoGluePrincipal, interceptionPointName, role.getName());
                if (!hasAccess) continue;
                availableRoles.add(role);
            }
        }
        return availableRoles;
    }
}

