/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SystemUserController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Role;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUser;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.entities.management.impl.simple.RoleImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class RoleController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)RoleController.class.getName());

    public static RoleController getController() {
        return new RoleController();
    }

    public Role getRoleWithId(Integer roleId, Database db) throws SystemException, Bug {
        return (Role)RoleController.getObjectWithId(RoleImpl.class, roleId, db);
    }

    public Role getRoleWithName(String roleName, Database db) throws SystemException, Bug {
        return (Role)RoleController.getObjectWithId(RoleImpl.class, roleName, db);
    }

    public RoleVO getRoleVOWithId(Integer roleId) throws SystemException, Bug {
        return (RoleVO)RoleController.getVOWithId(RoleImpl.class, roleId);
    }

    public RoleVO getRoleVOWithId(String roleName) throws SystemException, Bug {
        return (RoleVO)RoleController.getVOWithId(RoleImpl.class, roleName);
    }

    public RoleVO getRoleVOWithId(String roleName, Database db) throws SystemException, Bug {
        return (RoleVO)RoleController.getVOWithId(RoleImpl.class, roleName, db);
    }

    public List getRoleVOList() throws SystemException, Bug {
        return this.getAllVOObjects(RoleImpl.class, "roleName");
    }

    public List getRoleVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(RoleImpl.class, "roleName", db);
    }

    public RoleVO create(RoleVO roleVO) throws ConstraintException, SystemException {
        Role role = new RoleImpl();
        role.setValueObject(roleVO);
        role = (Role)RoleController.createEntity(role);
        return role.getValueObject();
    }

    public Role create(RoleVO roleVO, Database db) throws ConstraintException, SystemException, Exception {
        Role role = new RoleImpl();
        role.setValueObject(roleVO);
        role = (Role)RoleController.createEntity(role, db);
        return role;
    }

    public void delete(RoleVO roleVO) throws ConstraintException, SystemException {
        RoleController.deleteEntity(RoleImpl.class, roleVO.getRoleName());
    }

    public void delete(RoleVO roleVO, Database db) throws ConstraintException, SystemException, Exception {
        RoleController.deleteEntity(RoleImpl.class, roleVO.getRoleName(), db);
    }

    public void delete(String roleName) throws ConstraintException, SystemException {
        RoleController.deleteEntity(RoleImpl.class, roleName);
    }

    public void delete(String roleName, Database db) throws ConstraintException, SystemException, Exception {
        RoleController.deleteEntity(RoleImpl.class, roleName, db);
    }

    public List getRoleSystemUserVOList(String userName, Database db) throws SystemException, Bug {
        Collection systemUsers = null;
        ArrayList<SystemUserVO> systemUsersVO = new ArrayList<SystemUserVO>();
        Role role = null;
        try {
            role = this.getRoleWithName(userName, db);
            systemUsers = role.getSystemUsers();
            for (SystemUser systemUser : systemUsers) {
                systemUsersVO.add(systemUser.getValueObject());
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of users in this role. Reason:" + e.getMessage(), e);
        }
        return systemUsersVO;
    }

    public List getRoleSystemUserVOList(String roleName) throws SystemException, Bug {
        List systemUsersVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            RoleController.beginTransaction(db);
            systemUsersVO = this.getRoleSystemUserVOList(roleName, db);
            RoleController.commitTransaction(db);
        }
        catch (Exception e) {
            RoleController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a list of users in this role. Reason:" + e.getMessage(), e);
        }
        return systemUsersVO;
    }

    public RoleVO update(RoleVO roleVO) throws ConstraintException, SystemException {
        return (RoleVO)RoleController.updateEntity(RoleImpl.class, roleVO);
    }

    public RoleVO update(RoleVO roleVO, String[] systemUsers) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Role role = null;
        RoleController.beginTransaction(db);
        try {
            role = this.update(roleVO, systemUsers, db);
            ceb.throwIfNotEmpty();
            RoleController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RoleController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RoleController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return role.getValueObject();
    }

    public Role update(RoleVO roleVO, String[] systemUsers, Database db) throws ConstraintException, SystemException {
        Role role = this.getRoleWithName(roleVO.getRoleName(), db);
        role.getSystemUsers().clear();
        if (systemUsers != null) {
            int i = 0;
            while (i < systemUsers.length) {
                SystemUser systemUser = SystemUserController.getController().getSystemUserWithName(systemUsers[i], db);
                role.getSystemUsers().add(systemUser);
                systemUser.getRoles().add(role);
                ++i;
            }
        }
        role.setValueObject(roleVO);
        return role;
    }

    public List getRoleVOList(String userName) throws SystemException, Bug {
        List roleVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            RoleController.beginTransaction(db);
            SystemUser systemUser = SystemUserController.getController().getSystemUserWithName(userName, db);
            roleVOList = RoleController.toVOList(systemUser.getRoles());
            RoleController.commitTransaction(db);
        }
        catch (Exception e) {
            RoleController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a list of users in this role. Reason:" + e.getMessage(), e);
        }
        return roleVOList;
    }

    public Collection getRoleList(String userName, Database db) throws SystemException, Bug {
        Collection roleList = null;
        SystemUser systemUser = SystemUserController.getController().getSystemUserWithName(userName, db);
        roleList = systemUser.getRoles();
        return roleList;
    }

    public BaseEntityVO getNewVO() {
        return new RoleVO();
    }
}

