/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.RepositoryLanguageVO;
import org.infoglue.cms.entities.management.impl.simple.RepositoryLanguageImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.util.CacheController;

public class RepositoryLanguageController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)RepositoryLanguageController.class.getName());

    public static RepositoryLanguageController getController() {
        return new RepositoryLanguageController();
    }

    public RepositoryLanguage getRepositoryLanguageWithId(Integer id, Database db) throws SystemException, Bug {
        return (RepositoryLanguage)RepositoryLanguageController.getObjectWithId(RepositoryLanguageImpl.class, id, db);
    }

    public RepositoryLanguage getRepositoryLanguageWithId(Integer repositoryLanguageId) throws ConstraintException, SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguage repositoryLanguage = null;
        try {
            RepositoryLanguageController.beginTransaction(db);
            repositoryLanguage = this.getRepositoryLanguageWithId(repositoryLanguageId, db);
            ceb.throwIfNotEmpty();
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RepositoryLanguageController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return repositoryLanguage;
    }

    public List getRepositoryLanguageVOList() throws SystemException, Bug {
        return this.getAllVOObjects(RepositoryLanguageImpl.class, "repositoryLanguageImplId");
    }

    public List getRepositoryLanguageVOListWithLanguageId(Integer languageId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList<RepositoryLanguageVO> repositoryLanguageList = new ArrayList<RepositoryLanguageVO>();
        RepositoryLanguageController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT rl FROM org.infoglue.cms.entities.management.impl.simple.RepositoryLanguageImpl rl WHERE rl.language = $1 order by rl.sortOrder, rl.language.languageId");
            oql.bind((Object)languageId);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                RepositoryLanguage repositoryLanguage = (RepositoryLanguage)results.next();
                repositoryLanguageList.add(repositoryLanguage.getValueObject());
            }
            results.close();
            oql.close();
            ceb.throwIfNotEmpty();
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return repositoryLanguageList;
    }

    public List getRepositoryLanguageVOListWithRepositoryId(Integer repositoryId) throws SystemException, Bug {
        List repositoryLanguageList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguageController.beginTransaction(db);
        try {
            repositoryLanguageList = this.getRepositoryLanguageVOListWithRepositoryId(repositoryId, db);
            ceb.throwIfNotEmpty();
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return repositoryLanguageList;
    }

    public List getRepositoryLanguageVOListWithRepositoryId(Integer repositoryId, Database db) throws SystemException, Bug, Exception {
        ArrayList<RepositoryLanguage> repositoryLanguageList = new ArrayList<RepositoryLanguage>();
        OQLQuery oql = db.getOQLQuery("SELECT rl FROM org.infoglue.cms.entities.management.impl.simple.RepositoryLanguageImpl rl WHERE rl.repository = $1 ORDER BY rl.sortOrder, rl.language.languageId");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            RepositoryLanguage repositoryLanguage = (RepositoryLanguage)results.next();
            repositoryLanguageList.add(repositoryLanguage);
        }
        results.close();
        oql.close();
        return repositoryLanguageList;
    }

    public List getAvailableLanguageVOListForRepositoryId(Integer repositoryId) throws ConstraintException, SystemException, Exception {
        ArrayList<LanguageVO> repositoryLanguageVOList = null;
        String repositoryLanguageListKey = "" + repositoryId;
        logger.info((Object)("repositoryLanguageListKey:" + repositoryLanguageListKey));
        repositoryLanguageVOList = (ArrayList<LanguageVO>)CacheController.getCachedObject("repositoryLanguageListCache", repositoryLanguageListKey);
        if (repositoryLanguageVOList != null) {
            logger.info((Object)("There was an cached list:" + repositoryLanguageVOList));
        } else {
            Database db = CastorDatabaseService.getDatabase();
            ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
            RepositoryLanguageController.beginTransaction(db);
            try {
                List availableRepositoryLanguageList = RepositoryLanguageController.getController().getRepositoryLanguageListWithRepositoryId(repositoryId, db);
                repositoryLanguageVOList = new ArrayList<LanguageVO>();
                for (RepositoryLanguage repositoryLanguage : availableRepositoryLanguageList) {
                    repositoryLanguageVOList.add(repositoryLanguage.getLanguage().getValueObject());
                }
                CacheController.cacheObject("repositoryLanguageListCache", repositoryLanguageListKey, repositoryLanguageVOList);
                ceb.throwIfNotEmpty();
                RepositoryLanguageController.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
                RepositoryLanguageController.rollbackTransaction(db);
                throw new SystemException(e.getMessage());
            }
        }
        return repositoryLanguageVOList;
    }

    public List getRepositoryLanguageListWithRepositoryId(Integer repositoryId, Database db) throws SystemException, Bug, Exception {
        ArrayList<RepositoryLanguage> repositoryLanguageList = new ArrayList<RepositoryLanguage>();
        OQLQuery oql = db.getOQLQuery("SELECT rl FROM org.infoglue.cms.entities.management.impl.simple.RepositoryLanguageImpl rl WHERE rl.repository = $1 ORDER BY rl.sortOrder, rl.language.languageId");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        while (results.hasMore()) {
            RepositoryLanguage repositoryLanguage = (RepositoryLanguage)results.next();
            repositoryLanguageList.add(repositoryLanguage);
        }
        results.close();
        oql.close();
        return repositoryLanguageList;
    }

    public void delete(RepositoryLanguageVO vo) throws ConstraintException, SystemException {
        RepositoryLanguageController.deleteEntity(RepositoryLanguageImpl.class, vo.getRepositoryLanguageId());
    }

    public void deleteRepositoryLanguages(Repository repository, Database db) throws SystemException, Bug {
        try {
            Collection repositoryLanguages = repository.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : repositoryLanguages) {
                Language language = repositoryLanguage.getLanguage();
                language.getRepositoryLanguages().remove(repositoryLanguage);
                db.remove((Object)repositoryLanguage);
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to find the matching RepositoryLanguage in the database. Reason: " + e.getMessage(), e);
        }
    }

    public RepositoryLanguage deleteAllRepositoryLanguageWithLanguageId(Integer languageId) throws SystemException, Bug {
        try {
            List repositoryLanguages = this.getRepositoryLanguageVOListWithLanguageId(languageId);
            for (RepositoryLanguageVO repositoryLanguage : repositoryLanguages) {
                RepositoryLanguageController.deleteEntity(RepositoryLanguageImpl.class, repositoryLanguage.getRepositoryLanguageId());
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to find the matching RepositoryLanguage in the database. Reason: " + e.getMessage(), e);
        }
        return null;
    }

    public RepositoryLanguage deleteAllRepositoryLanguageWithLanguage(Language language, Database db) throws SystemException, Bug {
        try {
            Collection repositoryLanguages = language.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : repositoryLanguages) {
                Repository repository = repositoryLanguage.getRepository();
                repository.getRepositoryLanguages().remove(repositoryLanguage);
                db.remove((Object)repositoryLanguage);
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to delete a RepositoryLanguage in the database. Reason: " + e.getMessage(), e);
        }
        return null;
    }

    public RepositoryLanguage create(Integer repositoryId, Integer languageId, Integer sortOrder, Database db) throws Exception {
        RepositoryLanguageImpl repositoryLanguage = new RepositoryLanguageImpl();
        repositoryLanguage.setIsPublished(new Boolean(false));
        repositoryLanguage.setLanguage(LanguageController.getController().getLanguageWithId(languageId, db));
        repositoryLanguage.setRepository(RepositoryController.getController().getRepositoryWithId(repositoryId, db));
        repositoryLanguage.setSortOrder(sortOrder);
        db.create((Object)repositoryLanguage);
        return repositoryLanguage;
    }

    public void publishRepositoryLanguage(RepositoryLanguageVO repositoryLanguageVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguage repositoryLanguage = null;
        RepositoryLanguageController.beginTransaction(db);
        try {
            repositoryLanguage = this.getRepositoryLanguageWithId(repositoryLanguageVO.getRepositoryLanguageId(), db);
            repositoryLanguage.setIsPublished(new Boolean(true));
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void unpublishRepositoryLanguage(RepositoryLanguageVO repositoryLanguageVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguage repositoryLanguage = null;
        RepositoryLanguageController.beginTransaction(db);
        try {
            repositoryLanguage = this.getRepositoryLanguageWithId(repositoryLanguageVO.getRepositoryLanguageId(), db);
            repositoryLanguage.setIsPublished(new Boolean(false));
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void moveRepositoryLanguage(RepositoryLanguageVO repositoryLanguageVO, boolean down) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguageController.beginTransaction(db);
        try {
            RepositoryLanguage originalRepositoryLanguage = this.getRepositoryLanguageWithId(repositoryLanguageVO.getRepositoryLanguageId(), db);
            List repositoryLanguages = this.getRepositoryLanguageListWithRepositoryId(originalRepositoryLanguage.getRepository().getId(), db);
            int i = 0;
            while (i < repositoryLanguages.size()) {
                RepositoryLanguage repositoryLanguage = (RepositoryLanguage)repositoryLanguages.get(i);
                if (repositoryLanguage.getRepositoryLanguageId().intValue() == repositoryLanguageVO.getRepositoryLanguageId().intValue()) {
                    Integer currentSortOrder;
                    if (down && i != repositoryLanguages.size() - 1) {
                        RepositoryLanguage nextRepositoryLanguage = (RepositoryLanguage)repositoryLanguages.get(i + 1);
                        currentSortOrder = repositoryLanguage.getSortOrder();
                        repositoryLanguage.setSortOrder(nextRepositoryLanguage.getSortOrder());
                        nextRepositoryLanguage.setSortOrder(currentSortOrder);
                    } else if (!down && i != 0) {
                        RepositoryLanguage previousRepositoryLanguage = (RepositoryLanguage)repositoryLanguages.get(i - 1);
                        currentSortOrder = repositoryLanguage.getSortOrder();
                        repositoryLanguage.setSortOrder(previousRepositoryLanguage.getSortOrder());
                        previousRepositoryLanguage.setSortOrder(currentSortOrder);
                    }
                }
                ++i;
            }
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void createRepositoryLanguage(Integer repositoryId, Integer languageId, Integer sortOrder) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguage repositoryLanguage = null;
        RepositoryLanguageController.beginTransaction(db);
        try {
            repositoryLanguage = this.create(repositoryId, languageId, sortOrder, db);
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updateRepositoryLanguages(Integer repositoryId, String[] languageValues) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryLanguageController.beginTransaction(db);
        try {
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
            this.deleteRepositoryLanguages(repository, db);
            ArrayList<RepositoryLanguage> repositoryLanguageList = new ArrayList<RepositoryLanguage>();
            if (languageValues != null) {
                int i = 0;
                while (i < languageValues.length) {
                    Language language = LanguageController.getController().getLanguageWithId(new Integer(languageValues[i]), db);
                    RepositoryLanguage repositoryLanguage = this.create(repository.getId(), new Integer(languageValues[i]), new Integer(i), db);
                    repositoryLanguageList.add(repositoryLanguage);
                    ++i;
                }
            }
            repository.setRepositoryLanguages(repositoryLanguageList);
            ceb.throwIfNotEmpty();
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not completes the transaction:" + ce), (Throwable)ce);
            RepositoryLanguageController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public List getRemainingLanguages(Integer repositoryId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList remainingLanguages = new ArrayList();
        RepositoryLanguageController.beginTransaction(db);
        try {
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
            Collection repositoryLanguageList = repository.getRepositoryLanguages();
            List languageList = LanguageController.getController().getLanguageVOList();
            remainingLanguages.addAll(languageList);
            for (LanguageVO languageVO : languageList) {
                logger.info((Object)("Language:" + languageVO.getName()));
                for (RepositoryLanguage repositoryLanguage : repositoryLanguageList) {
                    logger.info((Object)("Comparing" + languageVO.getLanguageId() + " and " + repositoryLanguage.getLanguage().getLanguageId()));
                    if (languageVO.getLanguageId().intValue() != repositoryLanguage.getLanguage().getLanguageId().intValue()) continue;
                    remainingLanguages.remove(languageVO);
                }
            }
            ceb.throwIfNotEmpty();
            RepositoryLanguageController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            RepositoryLanguageController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            e.printStackTrace();
            RepositoryLanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return remainingLanguages;
    }

    public BaseEntityVO getNewVO() {
        return new RepositoryLanguageVO();
    }
}

