/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryLanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ReflectionComparator;
import org.infoglue.deliver.util.CacheController;

public class RepositoryController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)RepositoryController.class.getName());

    public static RepositoryController getController() {
        return new RepositoryController();
    }

    public RepositoryVO create(RepositoryVO vo) throws ConstraintException, SystemException {
        Repository ent = new RepositoryImpl();
        ent.setValueObject(vo);
        ent = (Repository)RepositoryController.createEntity(ent);
        return ent.getValueObject();
    }

    public void delete(RepositoryVO repositoryVO, String userName, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException {
        this.delete(repositoryVO, userName, false, infoGluePrincipal);
    }

    public void delete(RepositoryVO repositoryVO, String userName, boolean forceDelete, InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Repository repository = null;
        RepositoryController.beginTransaction(db);
        try {
            SiteNodeVO siteNodeVO;
            repository = this.getRepositoryWithId(repositoryVO.getRepositoryId(), db);
            RepositoryLanguageController.getController().deleteRepositoryLanguages(repository, db);
            ContentVO contentVO = ContentControllerProxy.getController().getRootContentVO(repositoryVO.getRepositoryId(), userName, false);
            if (contentVO != null) {
                if (forceDelete) {
                    ContentController.getContentController().delete(contentVO, db, true, true, true, infoGluePrincipal);
                } else {
                    ContentController.getContentController().delete(contentVO, infoGluePrincipal, db);
                }
            }
            if ((siteNodeVO = SiteNodeController.getController().getRootSiteNodeVO(repositoryVO.getRepositoryId())) != null) {
                if (forceDelete) {
                    SiteNodeController.getController().delete(siteNodeVO, db, true, infoGluePrincipal);
                } else {
                    SiteNodeController.getController().delete(siteNodeVO, db, infoGluePrincipal);
                }
            }
            RepositoryController.deleteEntity(RepositoryImpl.class, repositoryVO.getRepositoryId(), db);
            ceb.throwIfNotEmpty();
            RepositoryController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not completes the transaction:" + ce), (Throwable)ce);
            RepositoryController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            RepositoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public RepositoryVO update(RepositoryVO vo) throws ConstraintException, SystemException {
        return (RepositoryVO)RepositoryController.updateEntity(RepositoryImpl.class, vo);
    }

    public RepositoryVO update(RepositoryVO repositoryVO, String[] languageValues) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        RepositoryController.beginTransaction(db);
        try {
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryVO.getRepositoryId(), db);
            RepositoryLanguageController.getController().deleteRepositoryLanguages(repository, db);
            ArrayList<RepositoryLanguage> repositoryLanguageList = new ArrayList<RepositoryLanguage>();
            if (languageValues != null) {
                int i = 0;
                while (i < languageValues.length) {
                    Language language = LanguageController.getController().getLanguageWithId(new Integer(languageValues[i]), db);
                    RepositoryLanguage repositoryLanguage = RepositoryLanguageController.getController().create(repositoryVO.getRepositoryId(), new Integer(languageValues[i]), new Integer(i), db);
                    repositoryLanguageList.add(repositoryLanguage);
                    language.getRepositoryLanguages().add(repositoryLanguage);
                    ++i;
                }
            }
            repository.setValueObject(repositoryVO);
            repository.setRepositoryLanguages(repositoryLanguageList);
            repositoryVO = repository.getValueObject();
            ceb.throwIfNotEmpty();
            RepositoryController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not completes the transaction:" + ce), (Throwable)ce);
            RepositoryController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            RepositoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return repositoryVO;
    }

    public Repository getRepositoryWithId(Integer id, Database db) throws SystemException, Bug {
        return (Repository)RepositoryController.getObjectWithId(RepositoryImpl.class, id, db);
    }

    public RepositoryVO getRepositoryVOWithId(Integer repositoryId) throws ConstraintException, SystemException, Bug {
        return (RepositoryVO)RepositoryController.getVOWithId(RepositoryImpl.class, repositoryId);
    }

    public RepositoryVO getRepositoryVOWithId(Integer repositoryId, Database db) throws ConstraintException, SystemException, Bug {
        return (RepositoryVO)RepositoryController.getVOWithId(RepositoryImpl.class, repositoryId, db);
    }

    public RepositoryVO getRepositoryVOWithName(String name) throws SystemException, Bug {
        RepositoryVO repositoryVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            RepositoryController.beginTransaction(db);
            Repository repository = this.getRepositoryWithName(name, db);
            if (repository != null) {
                repositoryVO = repository.getValueObject();
            }
            RepositoryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            RepositoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return repositoryVO;
    }

    public Repository getRepositoryWithName(String name, Database db) throws SystemException, Bug {
        Repository repository = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.RepositoryImpl f WHERE f.name = $1");
            oql.bind((Object)name);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode" + name));
            if (results.hasMore()) {
                repository = (Repository)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named repository. Reason:" + e.getMessage(), e);
        }
        return repository;
    }

    public List getRepositoryVOList() throws ConstraintException, SystemException, Bug {
        String key = "repositoryVOList";
        logger.info((Object)("key:" + key));
        List cachedRepositoryVOList = (List)CacheController.getCachedObject("repositoryCache", key);
        if (cachedRepositoryVOList != null) {
            logger.info((Object)("There was an cached authorization:" + cachedRepositoryVOList.size()));
            return cachedRepositoryVOList;
        }
        List repositoryVOList = this.getAllVOObjects(RepositoryImpl.class, "repositoryId");
        CacheController.cacheObject("repositoryCache", key, repositoryVOList);
        return repositoryVOList;
    }

    public List getAuthorizedRepositoryVOList(InfoGluePrincipal infoGluePrincipal, boolean isBindingDialog) throws ConstraintException, SystemException, Bug {
        ArrayList<RepositoryVO> accessableRepositories = new ArrayList<RepositoryVO>();
        List allRepositories = this.getRepositoryVOList();
        for (RepositoryVO repositoryVO : allRepositories) {
            if (!this.getIsAccessApproved(repositoryVO.getRepositoryId(), infoGluePrincipal, isBindingDialog)) continue;
            accessableRepositories.add(repositoryVO);
        }
        Collections.sort(accessableRepositories, new ReflectionComparator("name"));
        return accessableRepositories;
    }

    public RepositoryVO getFirstRepositoryVO() throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        RepositoryVO repositoryVO = null;
        try {
            RepositoryController.beginTransaction(db);
            OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RepositoryImpl r ORDER BY r.repositoryId");
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            if (results.hasMore()) {
                Repository repository = (Repository)results.next();
                repositoryVO = repository.getValueObject();
            }
            results.close();
            oql.close();
            RepositoryController.commitTransaction(db);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of roles in the repository. Reason:" + e.getMessage(), e);
        }
        return repositoryVO;
    }

    public void delete(Integer repositoryId, Database db) throws SystemException, Bug {
        try {
            db.remove((Object)this.getRepositoryWithId(repositoryId, db));
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to delete Repository in the database. Reason: " + e.getMessage(), e);
        }
    }

    public boolean getIsAccessApproved(Integer repositoryId, InfoGluePrincipal infoGluePrincipal, boolean isBindingDialog) throws SystemException {
        logger.info((Object)("getIsAccessApproved for " + repositoryId + " AND " + infoGluePrincipal + " AND " + isBindingDialog));
        boolean hasAccess = false;
        Database db = CastorDatabaseService.getDatabase();
        RepositoryController.beginTransaction(db);
        try {
            hasAccess = isBindingDialog ? AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Repository.Read", repositoryId.toString()) || AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Repository.ReadForBinding", repositoryId.toString()) : AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Repository.Read", repositoryId.toString());
            RepositoryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            RepositoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return hasAccess;
    }

    public BaseEntityVO getNewVO() {
        return new RepositoryVO();
    }
}

