/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.databeans.ReferenceBean;
import org.infoglue.cms.applications.databeans.ReferenceVersionBean;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.Registry;
import org.infoglue.cms.entities.management.RegistryVO;
import org.infoglue.cms.entities.management.impl.simple.RegistryImpl;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;

public class RegistryController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)RegistryController.class.getName());
    private static final RegistryController instance = new RegistryController();

    public static RegistryController getController() {
        return instance;
    }

    private RegistryController() {
    }

    public List getRegistryVOList() throws SystemException, Bug {
        return this.getAllVOObjects(RegistryImpl.class, "registryId");
    }

    public List getRegistryVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(RegistryImpl.class, "registryId", db);
    }

    public RegistryVO getRegistryVOWithId(Integer registryId) throws SystemException, Exception {
        RegistryVO registryVO = (RegistryVO)RegistryController.getVOWithId(RegistryImpl.class, registryId);
        return registryVO;
    }

    public RegistryVO create(RegistryVO valueObject, Database db) throws ConstraintException, SystemException, Exception {
        RegistryImpl registry = new RegistryImpl();
        registry.setValueObject(valueObject);
        db.create((Object)registry);
        return registry.getValueObject();
    }

    public RegistryVO update(RegistryVO valueObject, Database db) throws ConstraintException, SystemException {
        return (RegistryVO)RegistryController.updateEntity(RegistryImpl.class, valueObject, db);
    }

    public void delete(Integer registryId) throws ConstraintException, SystemException {
        RegistryController.deleteEntity(RegistryImpl.class, registryId);
    }

    public void updateContentVersion(ContentVersionVO contentVersionVO) throws ConstraintException, SystemException {
        String versionValue = contentVersionVO.getVersionValue();
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionVO.getContentVersionId(), db);
            this.updateContentVersion(contentVersion, db);
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            RegistryController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch which sitenode uses a metainfo. Reason:" + e.getMessage(), e);
        }
    }

    public void updateContentVersion(ContentVersion contentVersion, Database db) throws ConstraintException, SystemException, Exception {
        String versionValue = contentVersion.getVersionValue();
        ContentVersion oldContentVersion = contentVersion;
        ContentImpl oldContent = oldContentVersion.getOwningContent();
        if (oldContent.getContentTypeDefinition().getName().equalsIgnoreCase("Meta info")) {
            logger.info((Object)"It was a meta info so lets check it for other stuff as well");
            SiteNodeVersion siteNodeVersion = this.getLatestActiveSiteNodeVersionWhichUsesContentVersionAsMetaInfo(oldContentVersion, db);
            if (siteNodeVersion != null) {
                logger.info((Object)("Going to use " + siteNodeVersion.getId() + " as reference"));
                this.clearRegistryVOList(SiteNodeVersion.class.getName(), siteNodeVersion.getId().toString(), db);
                this.getComponents(siteNodeVersion, versionValue, db);
                this.getComponentBindings(siteNodeVersion, versionValue, db);
                this.getPageBindings(siteNodeVersion, db);
            }
            this.getInlineSiteNodes(oldContentVersion, versionValue, db);
            this.getInlineContents(oldContentVersion, versionValue, db);
            this.getRelationSiteNodes(oldContentVersion, versionValue, db);
            this.getRelationContents(oldContentVersion, versionValue, db);
        } else {
            this.clearRegistryVOList(ContentVersion.class.getName(), oldContentVersion.getContentVersionId().toString(), db);
            this.getInlineSiteNodes(oldContentVersion, versionValue, db);
            this.getInlineContents(oldContentVersion, versionValue, db);
            this.getRelationSiteNodes(oldContentVersion, versionValue, db);
            this.getRelationContents(oldContentVersion, versionValue, db);
        }
    }

    public void updateContentVersion(ContentVersion contentVersion, SiteNodeVersion siteNodeVersion, Database db) throws ConstraintException, SystemException, Exception {
        String versionValue = contentVersion.getVersionValue();
        ContentVersion oldContentVersion = contentVersion;
        ContentImpl oldContent = oldContentVersion.getOwningContent();
        if (oldContent.getContentTypeDefinition().getName().equalsIgnoreCase("Meta info")) {
            logger.info((Object)"It was a meta info so lets check it for other stuff as well");
            if (siteNodeVersion != null) {
                logger.info((Object)("Going to use " + siteNodeVersion.getId() + " as reference"));
                this.clearRegistryVOList(SiteNodeVersion.class.getName(), siteNodeVersion.getId().toString(), db);
                this.getComponents(siteNodeVersion, versionValue, db);
                this.getComponentBindings(siteNodeVersion, versionValue, db);
                this.getPageBindings(siteNodeVersion, db);
            }
            this.getInlineSiteNodes(oldContentVersion, versionValue, db);
            this.getInlineContents(oldContentVersion, versionValue, db);
            this.getRelationSiteNodes(oldContentVersion, versionValue, db);
            this.getRelationContents(oldContentVersion, versionValue, db);
        } else {
            this.clearRegistryVOList(ContentVersion.class.getName(), oldContentVersion.getContentVersionId().toString(), db);
            if (siteNodeVersion != null) {
                this.getPageBindings(siteNodeVersion, db);
            }
            this.getInlineSiteNodes(oldContentVersion, versionValue, db);
            this.getInlineContents(oldContentVersion, versionValue, db);
            this.getRelationSiteNodes(oldContentVersion, versionValue, db);
            this.getRelationContents(oldContentVersion, versionValue, db);
        }
    }

    public void updateSiteNodeVersion(SiteNodeVersionVO siteNodeVersionVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            logger.info((Object)"Starting RegistryController.updateSiteNodeVersion...");
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionVO.getId(), db);
            logger.info((Object)"Before RegistryController.updateSiteNodeVersion...");
            this.updateSiteNodeVersion(siteNodeVersion, db);
            logger.info((Object)"Before commit RegistryController.updateSiteNodeVersion...");
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            RegistryController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch which sitenode uses a metainfo. Reason:" + e.getMessage(), e);
        }
    }

    public void updateSiteNodeVersion(SiteNodeVersion siteNodeVersion, Database db) throws ConstraintException, SystemException, Exception {
        SiteNodeVersion oldSiteNodeVersion = siteNodeVersion;
        SiteNodeImpl oldSiteNode = oldSiteNodeVersion.getOwningSiteNode();
        logger.info((Object)"Before clearing old registry...");
        this.clearRegistryVOList(SiteNodeVersion.class.getName(), siteNodeVersion.getId().toString(), db);
        logger.info((Object)"After clearing old registry...");
        Collection serviceBindings = siteNodeVersion.getServiceBindings();
        for (ServiceBinding serviceBinding : serviceBindings) {
            if (serviceBinding.getBindingQualifyers() == null) continue;
            for (Qualifyer qualifyer : serviceBinding.getBindingQualifyers()) {
                String name = qualifyer.getName();
                String value = qualifyer.getValue();
                try {
                    RegistryVO registryVO = new RegistryVO();
                    registryVO.setReferenceType(RegistryVO.PAGE_BINDING);
                    if (name.equalsIgnoreCase("contentId")) {
                        Content content = ContentController.getContentController().getContentWithId(new Integer(value), db);
                        registryVO.setEntityId(value);
                        registryVO.setEntityName(Content.class.getName());
                        registryVO.setReferencingEntityId(siteNodeVersion.getId().toString());
                        registryVO.setReferencingEntityName(SiteNodeVersion.class.getName());
                        registryVO.setReferencingEntityCompletingId(oldSiteNode.getId().toString());
                        registryVO.setReferencingEntityCompletingName(SiteNode.class.getName());
                        Language masterLanguage = LanguageController.getController().getMasterLanguage(db, siteNodeVersion.getOwningSiteNode().getRepository().getId());
                        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(content.getContentId(), masterLanguage.getId(), db);
                        this.getComponents(siteNodeVersion, contentVersion.getVersionValue(), db);
                        this.getComponentBindings(siteNodeVersion, contentVersion.getVersionValue(), db);
                    } else if (name.equalsIgnoreCase("siteNodeId")) {
                        SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(value), db);
                        registryVO.setEntityId(value);
                        registryVO.setEntityName(SiteNode.class.getName());
                        registryVO.setReferencingEntityId(siteNodeVersion.getId().toString());
                        registryVO.setReferencingEntityName(SiteNodeVersion.class.getName());
                        registryVO.setReferencingEntityCompletingId(oldSiteNode.getId().toString());
                        registryVO.setReferencingEntityCompletingName(SiteNode.class.getName());
                    }
                    logger.info((Object)"Before creating registry entry...");
                    this.create(registryVO, db);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void getPageBindings(SiteNodeVersion siteNodeVersion, Database db) throws ConstraintException, SystemException, Exception {
        SiteNodeImpl oldSiteNode = siteNodeVersion.getOwningSiteNode();
        Collection serviceBindings = siteNodeVersion.getServiceBindings();
        for (ServiceBinding serviceBinding : serviceBindings) {
            if (serviceBinding.getBindingQualifyers() == null) continue;
            for (Qualifyer qualifyer : serviceBinding.getBindingQualifyers()) {
                String name = qualifyer.getName();
                String value = qualifyer.getValue();
                try {
                    RegistryVO registryVO = new RegistryVO();
                    registryVO.setReferenceType(RegistryVO.PAGE_BINDING);
                    if (name.equalsIgnoreCase("contentId")) {
                        Content content = ContentController.getContentController().getContentWithId(new Integer(value), db);
                        registryVO.setEntityId(value);
                        registryVO.setEntityName(Content.class.getName());
                        registryVO.setReferencingEntityId(siteNodeVersion.getId().toString());
                        registryVO.setReferencingEntityName(SiteNodeVersion.class.getName());
                        registryVO.setReferencingEntityCompletingId(oldSiteNode.getId().toString());
                        registryVO.setReferencingEntityCompletingName(SiteNode.class.getName());
                    } else if (name.equalsIgnoreCase("siteNodeId")) {
                        SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(value), db);
                        registryVO.setEntityId(value);
                        registryVO.setEntityName(SiteNode.class.getName());
                        registryVO.setReferencingEntityId(siteNodeVersion.getId().toString());
                        registryVO.setReferencingEntityName(SiteNodeVersion.class.getName());
                        registryVO.setReferencingEntityCompletingId(oldSiteNode.getId().toString());
                        registryVO.setReferencingEntityCompletingName(SiteNode.class.getName());
                    }
                    logger.info((Object)"Before creating registry entry...");
                    this.create(registryVO, db);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void getInlineSiteNodes(ContentVersion contentVersion, String versionValue, Database db) throws ConstraintException, SystemException, Exception {
        Pattern pattern = Pattern.compile("\\$templateLogic\\.getPageUrl\\(.*?\\)");
        Matcher matcher = pattern.matcher(versionValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int siteNodeStartIndex = match.indexOf("(");
            int siteNodeEndIndex = match.indexOf(",");
            if (siteNodeStartIndex <= 0 || siteNodeEndIndex <= 0 || siteNodeEndIndex <= siteNodeStartIndex) continue;
            String siteNodeIdString = match.substring(siteNodeStartIndex + 1, siteNodeEndIndex);
            try {
                if (siteNodeIdString.indexOf("templateLogic.siteNodeId") != -1) continue;
                Integer siteNodeId = new Integer(siteNodeIdString);
                logger.info((Object)("siteNodeId:" + siteNodeId));
                RegistryVO registryVO = new RegistryVO();
                registryVO.setEntityId(siteNodeId.toString());
                registryVO.setEntityName(SiteNode.class.getName());
                registryVO.setReferenceType(RegistryVO.INLINE_LINK);
                registryVO.setReferencingEntityId(contentVersion.getContentVersionId().toString());
                registryVO.setReferencingEntityName(ContentVersion.class.getName());
                registryVO.setReferencingEntityCompletingId(contentVersion.getOwningContent().getContentId().toString());
                registryVO.setReferencingEntityCompletingName(Content.class.getName());
                this.create(registryVO, db);
            }
            catch (Exception e) {
                logger.warn((Object)("Tried to register inline sitenodes with exception as result:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void getInlineContents(ContentVersion contentVersion, String versionValue, Database db) throws ConstraintException, SystemException, Exception {
        Pattern pattern = Pattern.compile("\\$templateLogic\\.getInlineAssetUrl\\(.*?\\)");
        Matcher matcher = pattern.matcher(versionValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int contentStartIndex = match.indexOf("(");
            int contentEndIndex = match.indexOf(",");
            if (contentStartIndex <= 0 || contentEndIndex <= 0 || contentEndIndex <= contentStartIndex) continue;
            Integer contentId = new Integer(match.substring(contentStartIndex + 1, contentEndIndex));
            logger.info((Object)("contentId:" + contentId));
            RegistryVO registryVO = new RegistryVO();
            registryVO.setEntityId(contentId.toString());
            registryVO.setEntityName(Content.class.getName());
            registryVO.setReferenceType(RegistryVO.INLINE_ASSET);
            registryVO.setReferencingEntityId(contentVersion.getContentVersionId().toString());
            registryVO.setReferencingEntityName(ContentVersion.class.getName());
            registryVO.setReferencingEntityCompletingId(contentVersion.getOwningContent().getContentId().toString());
            registryVO.setReferencingEntityCompletingName(Content.class.getName());
            this.create(registryVO, db);
        }
    }

    public void getRelationSiteNodes(ContentVersion contentVersion, String versionValue, Database db) throws ConstraintException, SystemException, Exception {
        Pattern pattern = Pattern.compile("<qualifyer entity='SiteNode'>.*?</qualifyer>");
        Matcher matcher = pattern.matcher(versionValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int siteNodeStartIndex = match.indexOf("<id>");
            int siteNodeEndIndex = match.indexOf("</id>");
            while (siteNodeStartIndex > 0 && siteNodeEndIndex > 0 && siteNodeEndIndex > siteNodeStartIndex) {
                Integer siteNodeId = new Integer(match.substring(siteNodeStartIndex + 4, siteNodeEndIndex));
                logger.info((Object)("siteNodeId:" + siteNodeId));
                RegistryVO registryVO = new RegistryVO();
                registryVO.setEntityId(siteNodeId.toString());
                registryVO.setEntityName(SiteNode.class.getName());
                registryVO.setReferenceType(RegistryVO.INLINE_SITE_NODE_RELATION);
                registryVO.setReferencingEntityId(contentVersion.getContentVersionId().toString());
                registryVO.setReferencingEntityName(ContentVersion.class.getName());
                registryVO.setReferencingEntityCompletingId(contentVersion.getOwningContent().getContentId().toString());
                registryVO.setReferencingEntityCompletingName(Content.class.getName());
                this.create(registryVO, db);
                siteNodeStartIndex = match.indexOf("<id>", siteNodeEndIndex);
                siteNodeEndIndex = match.indexOf("</id>", siteNodeStartIndex);
            }
        }
    }

    public void getRelationContents(ContentVersion contentVersion, String versionValue, Database db) throws ConstraintException, SystemException, Exception {
        Pattern pattern = Pattern.compile("<qualifyer entity='Content'>.*?</qualifyer>");
        Matcher matcher = pattern.matcher(versionValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int contentStartIndex = match.indexOf("<id>");
            int contentEndIndex = match.indexOf("</id>");
            while (contentStartIndex > 0 && contentEndIndex > 0 && contentEndIndex > contentStartIndex) {
                Integer contentId = new Integer(match.substring(contentStartIndex + 4, contentEndIndex));
                logger.info((Object)("contentId:" + contentId));
                RegistryVO registryVO = new RegistryVO();
                registryVO.setEntityId(contentId.toString());
                registryVO.setEntityName(Content.class.getName());
                registryVO.setReferenceType(RegistryVO.INLINE_CONTENT_RELATION);
                registryVO.setReferencingEntityId(contentVersion.getContentVersionId().toString());
                registryVO.setReferencingEntityName(ContentVersion.class.getName());
                registryVO.setReferencingEntityCompletingId(contentVersion.getOwningContent().getContentId().toString());
                registryVO.setReferencingEntityCompletingName(Content.class.getName());
                this.create(registryVO, db);
                contentStartIndex = match.indexOf("<id>", contentEndIndex);
                contentEndIndex = match.indexOf("</id>", contentStartIndex);
            }
        }
    }

    public void getComponents(SiteNodeVersion siteNodeVersion, String versionValue, Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<Integer> foundComponents = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("contentId=\".*?\"");
        Matcher matcher = pattern.matcher(versionValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int contentStartIndex = match.indexOf("\"");
            int contentEndIndex = match.lastIndexOf("\"");
            if (contentStartIndex <= 0 || contentEndIndex <= 0 || contentEndIndex <= contentStartIndex) continue;
            Integer contentId = new Integer(match.substring(contentStartIndex + 1, contentEndIndex));
            logger.info((Object)("contentId:" + contentId));
            if (foundComponents.contains(contentId)) continue;
            RegistryVO registryVO = new RegistryVO();
            registryVO.setEntityId(contentId.toString());
            registryVO.setEntityName(Content.class.getName());
            registryVO.setReferenceType(RegistryVO.PAGE_COMPONENT);
            registryVO.setReferencingEntityId(siteNodeVersion.getSiteNodeVersionId().toString());
            registryVO.setReferencingEntityName(SiteNodeVersion.class.getName());
            registryVO.setReferencingEntityCompletingId(siteNodeVersion.getOwningSiteNode().getSiteNodeId().toString());
            registryVO.setReferencingEntityCompletingName(SiteNode.class.getName());
            this.create(registryVO, db);
            foundComponents.add(contentId);
        }
    }

    public void getComponentBindings(SiteNodeVersion siteNodeVersion, String versionValue, Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<String> foundComponents = new ArrayList<String>();
        Pattern pattern = Pattern.compile("<binding entity=\".*?\" entityId=\".*?\">");
        Matcher matcher = pattern.matcher(versionValue);
        while (matcher.find()) {
            String match = matcher.group();
            logger.info((Object)("Adding match to registry after some processing: " + match));
            int entityNameStartIndex = match.indexOf("\"");
            int entityNameEndIndex = match.indexOf("\"", entityNameStartIndex + 1);
            logger.info((Object)("entityNameStartIndex:" + entityNameStartIndex));
            logger.info((Object)("entityNameEndIndex:" + entityNameEndIndex));
            if (entityNameStartIndex <= 0 || entityNameEndIndex <= 0 || entityNameEndIndex <= entityNameStartIndex) continue;
            String entityName = match.substring(entityNameStartIndex + 1, entityNameEndIndex);
            logger.info((Object)("entityName:" + entityName));
            int entityIdStartIndex = match.indexOf("\"", entityNameEndIndex + 1);
            int entityIdEndIndex = match.indexOf("\"", entityIdStartIndex + 1);
            logger.info((Object)("entityIdStartIndex:" + entityIdStartIndex));
            logger.info((Object)("entityIdEndIndex:" + entityIdEndIndex));
            if (entityIdStartIndex <= 0 || entityIdEndIndex <= 0 || entityIdEndIndex <= entityIdStartIndex) continue;
            String entityId = match.substring(entityIdStartIndex + 1, entityIdEndIndex);
            logger.info((Object)("entityId:" + entityId));
            String key = String.valueOf(entityName) + ":" + entityId;
            if (foundComponents.contains(key)) continue;
            RegistryVO registryVO = new RegistryVO();
            if (entityName.indexOf("Content") > -1) {
                registryVO.setEntityName(Content.class.getName());
            } else {
                registryVO.setEntityName(SiteNode.class.getName());
            }
            registryVO.setEntityId(entityId);
            registryVO.setReferenceType(RegistryVO.PAGE_COMPONENT_BINDING);
            registryVO.setReferencingEntityId(siteNodeVersion.getSiteNodeVersionId().toString());
            registryVO.setReferencingEntityName(SiteNodeVersion.class.getName());
            registryVO.setReferencingEntityCompletingId(siteNodeVersion.getOwningSiteNode().getSiteNodeId().toString());
            registryVO.setReferencingEntityCompletingName(SiteNode.class.getName());
            this.create(registryVO, db);
            foundComponents.add(key);
        }
    }

    public BaseEntityVO getNewVO() {
        return new CategoryVO();
    }

    public List getReferencingObjectsForContent(Integer contentId) throws SystemException {
        return this.getReferencingObjectsForContent(contentId, -1);
    }

    public List getReferencingObjectsForContent(Integer contentId, int maxRows) throws SystemException {
        List referenceBeanList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            referenceBeanList = this.getReferencingObjectsForContent(contentId, maxRows, db);
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("One of the references was not found which is bad but not critical:" + e.getMessage()), (Throwable)e);
            RegistryController.rollbackTransaction(db);
        }
        logger.info((Object)("referenceBeanList:" + referenceBeanList.size()));
        return referenceBeanList;
    }

    public List getReferencingObjectsForContent(Integer contentId, int maxRows, Database db) throws SystemException, Exception {
        ArrayList<ReferenceBean> referenceBeanList = new ArrayList<ReferenceBean>();
        HashMap<String, ReferenceBean> entries = new HashMap<String, ReferenceBean>();
        List registryEntires = this.getMatchingRegistryVOList(Content.class.getName(), contentId.toString(), maxRows, db);
        logger.info((Object)("registryEntires:" + registryEntires.size()));
        for (RegistryVO registryVO : registryEntires) {
            logger.info((Object)("registryVO:" + registryVO.getReferencingEntityId() + ":" + registryVO.getReferencingEntityCompletingId()));
            boolean add = true;
            String key = registryVO.getReferencingEntityCompletingName() + "_" + registryVO.getReferencingEntityCompletingId();
            ReferenceBean existingReferenceBean = (ReferenceBean)entries.get(key);
            if (existingReferenceBean == null) {
                existingReferenceBean = new ReferenceBean();
                logger.info((Object)("Adding referenceBean to entries with key:" + key));
                entries.put(key, existingReferenceBean);
                referenceBeanList.add(existingReferenceBean);
            }
            ReferenceVersionBean referenceVersionBean = new ReferenceVersionBean();
            if (registryVO.getReferencingEntityName().indexOf("Content") > -1) {
                try {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(new Integer(registryVO.getReferencingEntityId()), db);
                    logger.info((Object)("contentVersion:" + contentVersion.getContentVersionId()));
                    existingReferenceBean.setName(contentVersion.getOwningContent().getName());
                    existingReferenceBean.setReferencingCompletingObject(contentVersion.getOwningContent().getValueObject());
                    referenceVersionBean.setReferencingObject(contentVersion.getValueObject());
                    referenceVersionBean.getRegistryVOList().add(registryVO);
                }
                catch (Exception e) {
                    add = false;
                    logger.info((Object)("content:" + registryVO.getReferencingEntityId() + " did not exist - skipping.."));
                }
            } else {
                try {
                    SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(new Integer(registryVO.getReferencingEntityId()), db);
                    logger.info((Object)("siteNodeVersion:" + siteNodeVersion.getSiteNodeVersionId()));
                    logger.info((Object)("siteNode:" + siteNodeVersion.getOwningSiteNode().getId()));
                    existingReferenceBean.setName(siteNodeVersion.getOwningSiteNode().getName());
                    existingReferenceBean.setReferencingCompletingObject(siteNodeVersion.getOwningSiteNode().getValueObject());
                    referenceVersionBean.setReferencingObject(siteNodeVersion.getValueObject());
                    referenceVersionBean.getRegistryVOList().add(registryVO);
                }
                catch (Exception e) {
                    add = false;
                    logger.info((Object)("siteNode:" + registryVO.getReferencingEntityId() + " did not exist - skipping.."));
                }
            }
            if (!add) continue;
            boolean exists = false;
            ReferenceVersionBean existingReferenceVersionBean2 = null;
            for (ReferenceVersionBean existingReferenceVersionBean2 : existingReferenceBean.getVersions()) {
                if (!existingReferenceVersionBean2.getReferencingObject().equals(referenceVersionBean.getReferencingObject())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                existingReferenceBean.getVersions().add(referenceVersionBean);
                continue;
            }
            existingReferenceVersionBean2.getRegistryVOList().add(registryVO);
        }
        Iterator i = referenceBeanList.iterator();
        while (i.hasNext()) {
            ReferenceBean referenceBean = (ReferenceBean)i.next();
            if (referenceBean.getVersions().size() != 0) continue;
            i.remove();
        }
        logger.info((Object)("referenceBeanList:" + referenceBeanList.size()));
        return referenceBeanList;
    }

    public List getReferencingObjectsForSiteNode(Integer siteNodeId) throws SystemException, Exception {
        return this.getReferencingObjectsForSiteNode(siteNodeId, -1);
    }

    public List getReferencingObjectsForSiteNode(Integer siteNodeId, int maxRows) throws SystemException, Exception {
        List referenceBeanList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            referenceBeanList = this.getReferencingObjectsForSiteNode(siteNodeId, maxRows, db);
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn((Object)("One of the references was not found which is bad but not critical:" + e.getMessage()), (Throwable)e);
            RegistryController.rollbackTransaction(db);
        }
        return referenceBeanList;
    }

    public List getReferencingObjectsForSiteNode(Integer siteNodeId, int maxRows, Database db) throws SystemException, Exception {
        ArrayList<ReferenceBean> referenceBeanList = new ArrayList<ReferenceBean>();
        HashMap<String, ReferenceBean> entries = new HashMap<String, ReferenceBean>();
        List registryEntires = this.getMatchingRegistryVOList(SiteNode.class.getName(), siteNodeId.toString(), maxRows, db);
        for (RegistryVO registryVO : registryEntires) {
            logger.info((Object)("registryVO:" + registryVO.getReferencingEntityId() + ":" + registryVO.getReferencingEntityCompletingId()));
            boolean add = true;
            String key = registryVO.getReferencingEntityCompletingName() + "_" + registryVO.getReferencingEntityCompletingId();
            ReferenceBean existingReferenceBean = (ReferenceBean)entries.get(key);
            if (existingReferenceBean == null) {
                existingReferenceBean = new ReferenceBean();
                logger.info((Object)("Adding referenceBean to entries with key:" + key));
                entries.put(key, existingReferenceBean);
                referenceBeanList.add(existingReferenceBean);
            }
            ReferenceVersionBean referenceVersionBean = new ReferenceVersionBean();
            if (registryVO.getReferencingEntityName().indexOf("Content") > -1) {
                try {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(new Integer(registryVO.getReferencingEntityId()), db);
                    logger.info((Object)("contentVersion:" + contentVersion.getContentVersionId()));
                    existingReferenceBean.setName(contentVersion.getOwningContent().getName());
                    existingReferenceBean.setReferencingCompletingObject(contentVersion.getOwningContent().getValueObject());
                    referenceVersionBean.setReferencingObject(contentVersion.getValueObject());
                    referenceVersionBean.getRegistryVOList().add(registryVO);
                }
                catch (Exception e) {
                    add = false;
                    logger.info((Object)("content:" + registryVO.getReferencingEntityId() + " did not exist - skipping.."));
                }
            } else {
                try {
                    SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(new Integer(registryVO.getReferencingEntityId()), db);
                    logger.info((Object)("siteNodeVersion:" + siteNodeVersion.getSiteNodeVersionId()));
                    logger.info((Object)("siteNode:" + siteNodeVersion.getOwningSiteNode().getId()));
                    existingReferenceBean.setName(siteNodeVersion.getOwningSiteNode().getName());
                    existingReferenceBean.setReferencingCompletingObject(siteNodeVersion.getOwningSiteNode().getValueObject());
                    referenceVersionBean.setReferencingObject(siteNodeVersion.getValueObject());
                    referenceVersionBean.getRegistryVOList().add(registryVO);
                }
                catch (Exception e) {
                    add = false;
                    logger.info((Object)("siteNode:" + registryVO.getReferencingEntityId() + " did not exist - skipping.."));
                }
            }
            if (!add) continue;
            boolean exists = false;
            ReferenceVersionBean existingReferenceVersionBean2 = null;
            for (ReferenceVersionBean existingReferenceVersionBean2 : existingReferenceBean.getVersions()) {
                if (!existingReferenceVersionBean2.getReferencingObject().equals(referenceVersionBean.getReferencingObject())) continue;
                exists = true;
                break;
            }
            if (!exists) {
                existingReferenceBean.getVersions().add(referenceVersionBean);
                continue;
            }
            existingReferenceVersionBean2.getRegistryVOList().add(registryVO);
        }
        Iterator i = referenceBeanList.iterator();
        while (i.hasNext()) {
            ReferenceBean referenceBean = (ReferenceBean)i.next();
            if (referenceBean.getVersions().size() != 0) continue;
            i.remove();
        }
        return referenceBeanList;
    }

    public List getMatchingRegistryVOList(String entityName, String entityId, int maxRows, Database db) throws SystemException, Exception {
        ArrayList<RegistryVO> matchingRegistryVOList = new ArrayList<RegistryVO>();
        OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RegistryImpl r WHERE r.entityName = $1 AND r.entityId = $2 ORDER BY r.registryId");
        oql.bind((Object)entityName);
        oql.bind((Object)entityId);
        QueryResults results = oql.execute((short)0);
        int i = 0;
        while (results.hasMore() && (maxRows == -1 || i < maxRows)) {
            Registry registry = (Registry)results.next();
            RegistryVO registryVO = registry.getValueObject();
            matchingRegistryVOList.add(registryVO);
            ++i;
        }
        results.close();
        oql.close();
        return matchingRegistryVOList;
    }

    public List getReferencedObjects(String referencingEntityName, String referencingEntityId) throws SystemException, Exception {
        ArrayList<BaseEntityVO> result = new ArrayList<BaseEntityVO>();
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            List registryVOList = this.getMatchingRegistryVOListForReferencingEntity(referencingEntityName, referencingEntityId, db);
            for (RegistryVO registryVO : registryVOList) {
                if (registryVO.getEntityName().indexOf("Content") > -1) {
                    try {
                        Content content = ContentController.getContentController().getContentWithId(new Integer(registryVO.getEntityId()), db);
                        logger.info((Object)("contentVersion:" + content.getContentId()));
                        result.add(content.getValueObject());
                    }
                    catch (Exception e) {
                        logger.info((Object)("content:" + registryVO.getEntityId() + " did not exist - skipping.."));
                    }
                    continue;
                }
                if (registryVO.getEntityName().indexOf("SiteNode") <= -1) continue;
                try {
                    SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(registryVO.getEntityId()), db);
                    logger.info((Object)("siteNode:" + siteNode.getId()));
                    result.add(siteNode.getValueObject());
                }
                catch (Exception e) {
                    logger.info((Object)("siteNode:" + registryVO.getEntityId() + " did not exist - skipping.."));
                }
            }
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            RegistryController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch which sitenode uses a metainfo. Reason:" + e.getMessage(), e);
        }
        return result;
    }

    public List getReferencedObjects(String referencingEntityName, String referencingEntityId, Database db) throws SystemException, Exception {
        ArrayList<BaseEntityVO> result = new ArrayList<BaseEntityVO>();
        List registryVOList = this.getMatchingRegistryVOListForReferencingEntity(referencingEntityName, referencingEntityId, db);
        for (RegistryVO registryVO : registryVOList) {
            if (registryVO.getEntityName().indexOf("Content") > -1) {
                try {
                    Content content = ContentController.getContentController().getContentWithId(new Integer(registryVO.getEntityId()), db);
                    logger.info((Object)("contentVersion:" + content.getContentId()));
                    result.add(content.getValueObject());
                }
                catch (Exception e) {
                    logger.info((Object)("content:" + registryVO.getEntityId() + " did not exist - skipping.."));
                }
                continue;
            }
            if (registryVO.getEntityName().indexOf("SiteNode") <= -1) continue;
            try {
                SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(registryVO.getEntityId()), db);
                logger.info((Object)("siteNode:" + siteNode.getId()));
                result.add(siteNode.getValueObject());
            }
            catch (Exception e) {
                logger.info((Object)("siteNode:" + registryVO.getEntityId() + " did not exist - skipping.."));
            }
        }
        return result;
    }

    public List getMatchingRegistryVOListForReferencingEntity(String referencingEntityName, String referencingEntityId, Database db) throws SystemException, Exception {
        ArrayList<RegistryVO> matchingRegistryVOList = new ArrayList<RegistryVO>();
        logger.info((Object)("referencingEntityName:" + referencingEntityName));
        logger.info((Object)("referencingEntityId:" + referencingEntityId));
        OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RegistryImpl r WHERE r.referencingEntityName = $1 AND r.referencingEntityId = $2 ORDER BY r.registryId");
        oql.bind((Object)referencingEntityName);
        oql.bind((Object)referencingEntityId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            Registry registry = (Registry)results.next();
            RegistryVO registryVO = registry.getValueObject();
            logger.info((Object)("found match:" + registryVO.getEntityName() + ":" + registryVO.getEntityId()));
            matchingRegistryVOList.add(registryVO);
        }
        results.close();
        oql.close();
        return matchingRegistryVOList;
    }

    public List clearRegistryVOList(String referencingEntityName, String referencingEntityId, Database db) throws SystemException, Exception {
        ArrayList matchingRegistryVOList = new ArrayList();
        OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RegistryImpl r WHERE r.referencingEntityName = $1 AND r.referencingEntityId = $2 ORDER BY r.registryId");
        oql.bind((Object)referencingEntityName);
        oql.bind((Object)referencingEntityId);
        QueryResults results = oql.execute();
        while (results.hasMore()) {
            Registry registry = (Registry)results.next();
            db.remove((Object)registry);
        }
        results.close();
        oql.close();
        return matchingRegistryVOList;
    }

    public void clearRegistryForReferencedEntity(String entityName, String entityId) throws SystemException, Exception {
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RegistryImpl r WHERE r.entityName = $1 AND r.entityId = $2 ORDER BY r.registryId");
            oql.bind((Object)entityName);
            oql.bind((Object)entityId);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                Registry registry = (Registry)results.next();
                db.remove((Object)registry);
            }
            results.close();
            oql.close();
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            RegistryController.rollbackTransaction(db);
        }
    }

    public void clearRegistryForReferencingEntityCompletingName(String entityCompletingName, String entityCompletingId) throws SystemException, Exception {
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RegistryImpl r WHERE r.referencingEntityCompletingName = $1 AND r.referencingEntityCompletingId = $2 ORDER BY r.registryId");
            oql.bind((Object)entityCompletingName);
            oql.bind((Object)entityCompletingId);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                Registry registry = (Registry)results.next();
                db.remove((Object)registry);
            }
            results.close();
            oql.close();
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            RegistryController.rollbackTransaction(db);
        }
    }

    public void clearRegistryForReferencingEntityName(String entityName, String entityId) throws SystemException, Exception {
        Database db = CastorDatabaseService.getDatabase();
        try {
            RegistryController.beginTransaction(db);
            OQLQuery oql = db.getOQLQuery("SELECT r FROM org.infoglue.cms.entities.management.impl.simple.RegistryImpl r WHERE r.referencingEntityName = $1 AND r.referencingEntityId = $2 ORDER BY r.registryId");
            oql.bind((Object)entityName);
            oql.bind((Object)entityId);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                Registry registry = (Registry)results.next();
                db.remove((Object)registry);
            }
            results.close();
            oql.close();
            RegistryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e));
            RegistryController.rollbackTransaction(db);
        }
    }

    public SiteNodeVersion getLatestActiveSiteNodeVersionWhichUsesContentVersionAsMetaInfo(ContentVersion contentVersion, Database db) throws SystemException, Exception {
        SiteNodeVersion siteNodeVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT snv FROM org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl snv WHERE snv.owningSiteNode.metaInfoContentId = $1 AND snv.isActive = $2 ORDER BY snv.siteNodeVersionId desc");
        oql.bind((Object)contentVersion.getValueObject().getContentId());
        oql.bind((Object)new Boolean(true));
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        if (results.hasMore()) {
            siteNodeVersion = (SiteNodeVersion)results.next();
        }
        results.close();
        oql.close();
        return siteNodeVersion;
    }
}

