/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.Redirect;
import org.infoglue.cms.entities.management.RedirectVO;
import org.infoglue.cms.entities.management.impl.simple.RedirectImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.deliver.util.CacheController;

public class RedirectController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)RedirectController.class.getName());

    public static RedirectController getController() {
        return new RedirectController();
    }

    public RedirectVO getRedirectVOWithId(Integer redirectId) throws SystemException, Bug {
        return (RedirectVO)RedirectController.getVOWithId(RedirectImpl.class, redirectId);
    }

    public Redirect getRedirectWithId(Integer redirectId, Database db) throws SystemException, Bug {
        return (Redirect)RedirectController.getObjectWithId(RedirectImpl.class, redirectId, db);
    }

    public List getRedirectVOList() throws SystemException, Bug {
        List redirectVOList = this.getAllVOObjects(RedirectImpl.class, "redirectId");
        return redirectVOList;
    }

    public List getRedirectVOList(Database db) throws SystemException, Bug {
        List redirectVOList = this.getAllVOObjects(RedirectImpl.class, "redirectId", db);
        return redirectVOList;
    }

    public RedirectVO create(RedirectVO redirectVO) throws ConstraintException, SystemException {
        Redirect redirect = new RedirectImpl();
        redirect.setValueObject(redirectVO);
        redirect = (Redirect)RedirectController.createEntity(redirect);
        return redirect.getValueObject();
    }

    public void delete(RedirectVO redirectVO) throws ConstraintException, SystemException {
        RedirectController.deleteEntity(RedirectImpl.class, redirectVO.getRedirectId());
    }

    public RedirectVO update(RedirectVO redirectVO) throws ConstraintException, SystemException {
        return (RedirectVO)RedirectController.updateEntity(RedirectImpl.class, redirectVO);
    }

    public String getRedirectUrl(HttpServletRequest request) throws Exception {
        try {
            String requestURL = request.getRequestURL().toString();
            int indexOfProtocol = requestURL.indexOf("://");
            int indexFirstSlash = requestURL.indexOf("/", indexOfProtocol + 3);
            String base = requestURL.substring(0, indexFirstSlash);
            logger.info((Object)("base:" + base));
            String requestURI = String.valueOf(base) + this.getContextURI(request);
            logger.info((Object)("requestURI:" + requestURI));
            logger.info((Object)("full requestURI:" + requestURI));
            Collection cachedRedirects = (Collection)CacheController.getCachedObject("redirectCache", "allRedirects");
            if (cachedRedirects == null) {
                cachedRedirects = RedirectController.getController().getRedirectVOList();
                CacheController.cacheObject("redirectCache", "allRedirects", cachedRedirects);
            }
            for (RedirectVO redirect : cachedRedirects) {
                logger.info((Object)("url:" + redirect.getUrl()));
                boolean matches = false;
                if (redirect.getUrl().startsWith(".*")) {
                    if (requestURI.indexOf(redirect.getUrl().substring(2)) > -1) {
                        matches = true;
                    }
                } else if (requestURI.startsWith(redirect.getUrl())) {
                    matches = true;
                }
                if (!matches) continue;
                logger.info((Object)("redirectUrl:" + redirect.getRedirectUrl()));
                String remainingURI = requestURI.replaceAll(redirect.getUrl(), "");
                logger.info((Object)("remainingURI:" + remainingURI));
                return String.valueOf(redirect.getRedirectUrl()) + remainingURI + (request.getQueryString() != null && request.getQueryString().length() > 0 ? "?" + request.getQueryString() : "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when looking for page:" + e.getMessage());
        }
        return null;
    }

    private String getContextRelativeURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && requestURI.length() > 0) {
            requestURI = requestURI.substring(contextPath.length(), requestURI.length());
        }
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    private String getContextURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    public BaseEntityVO getNewVO() {
        return new ContentTypeDefinitionVO();
    }
}

