/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceBindingController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.QualifyerVO;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.impl.simple.QualifyerImpl;
import org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class QualifyerController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)QualifyerController.class.getName());

    public static Qualifyer getQualifyerWithId(Integer qualifyerId, Database db) throws SystemException, Bug {
        return (Qualifyer)QualifyerController.getObjectWithId(QualifyerImpl.class, qualifyerId, db);
    }

    public static Collection createQualifyers(String qualifyerXML, ServiceBinding serviceBinding) throws ConstraintException, SystemException {
        ArrayList<QualifyerImpl> qualifyers = new ArrayList<QualifyerImpl>();
        List qualifyerVOList = QualifyerController.parseQualifyerList(qualifyerXML);
        for (QualifyerVO qualifyerVO : qualifyerVOList) {
            QualifyerImpl qualifyer = new QualifyerImpl();
            qualifyer.setValueObject(qualifyerVO);
            qualifyer.setServiceBinding((ServiceBindingImpl)serviceBinding);
            qualifyers.add(qualifyer);
            logger.info((Object)("ADDED:" + qualifyerVO.getValue()));
        }
        return qualifyers;
    }

    public static QualifyerVO screate(QualifyerVO qualifyerVO, Integer serviceBindingId, Database db) throws ConstraintException, SystemException, Exception {
        QualifyerImpl qualifyer = null;
        ServiceBinding serviceBinding = ServiceBindingController.getServiceBindingWithId(serviceBindingId, db);
        qualifyer = new QualifyerImpl();
        qualifyer.setValueObject(qualifyerVO);
        qualifyer.setServiceBinding((ServiceBindingImpl)serviceBinding);
        db.create((Object)qualifyer);
        return qualifyer.getValueObject();
    }

    public static List getBindingQualifyers(Integer serviceBindingId) throws SystemException, Bug, Exception {
        ArrayList<QualifyerVO> qualifyers = new ArrayList<QualifyerVO>();
        Database db = CastorDatabaseService.getDatabase();
        QualifyerController.beginTransaction(db);
        try {
            List unsortedQualifyers = ServiceBindingController.getQualifyerVOList(serviceBindingId);
            Iterator i = unsortedQualifyers.iterator();
            while (i.hasNext()) {
                boolean isAdded = false;
                QualifyerVO qualifyerVO = (QualifyerVO)i.next();
                Iterator newListIterator = qualifyers.iterator();
                int index = 0;
                while (newListIterator.hasNext()) {
                    QualifyerVO sortedQualifyerVO = (QualifyerVO)newListIterator.next();
                    if (sortedQualifyerVO.getSortOrder() < qualifyerVO.getSortOrder()) {
                        logger.info((Object)"The old copy was before me... lets not do anything..");
                        continue;
                    }
                    logger.info((Object)"The old copy was after me... lets insert the new one before it..");
                    qualifyers.add(index, qualifyerVO);
                    isAdded = true;
                    break;
                }
                if (isAdded) continue;
                qualifyers.add(qualifyerVO);
            }
            QualifyerController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            QualifyerController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return qualifyers;
    }

    private static List parseQualifyerList(String qualifyerXML) {
        ArrayList<QualifyerVO> qualifyerVOList = new ArrayList<QualifyerVO>();
        if (qualifyerXML != null) {
            try {
                logger.info((Object)("qualifyerXML:" + qualifyerXML));
                InputSource inputSource = new InputSource(new StringReader(qualifyerXML));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    String name = n.getNodeName();
                    String value = n.getFirstChild().getNodeValue();
                    logger.info((Object)("name:" + name));
                    logger.info((Object)("value:" + value));
                    QualifyerVO qualifyerVO = new QualifyerVO();
                    qualifyerVO.setName(name);
                    qualifyerVO.setValue(value);
                    qualifyerVO.setSortOrder(new Integer(i));
                    qualifyerVOList.add(qualifyerVO);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return qualifyerVOList;
    }

    public BaseEntityVO getNewVO() {
        return new QualifyerVO();
    }
}

