/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ReplicationMySqlController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.publishing.EditionBrowser;
import org.infoglue.cms.entities.publishing.Publication;
import org.infoglue.cms.entities.publishing.PublicationDetail;
import org.infoglue.cms.entities.publishing.PublicationDetailVO;
import org.infoglue.cms.entities.publishing.PublicationVO;
import org.infoglue.cms.entities.publishing.impl.simple.PublicationDetailImpl;
import org.infoglue.cms.entities.publishing.impl.simple.PublicationImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.workflow.Event;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ChangeNotificationController;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.DateHelper;
import org.infoglue.cms.util.NotificationMessage;
import org.infoglue.cms.util.RemoteCacheUpdater;
import org.infoglue.cms.util.mail.MailServiceFactory;
import org.infoglue.deliver.util.VelocityTemplateProcessor;

public class PublicationController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)PublicationController.class.getName());
    public static final int OVERIDE_WORKING = 1;
    public static final int LEAVE_WORKING = 2;

    public static PublicationController getController() {
        return new PublicationController();
    }

    public static Publication getPublicationWithId(Integer publicationId, Database db) throws SystemException {
        return (Publication)PublicationController.getObjectWithId(PublicationImpl.class, publicationId, db);
    }

    public PublicationDetailVO getPublicationDetailVOWithId(Integer publicationDetailId) throws SystemException {
        return (PublicationDetailVO)PublicationController.getVOWithId(PublicationDetailImpl.class, publicationDetailId);
    }

    public static List getPublicationEvents(Integer repositoryId) throws SystemException, Exception {
        return EventController.getPublicationEventVOListForRepository(repositoryId);
    }

    public static List getPublicationEvents(Integer repositoryId, InfoGluePrincipal principal, String filter) throws SystemException, Exception {
        return EventController.getPublicationEventVOListForRepository(repositoryId, principal, filter);
    }

    public static List getAllEditions(Integer repositoryId) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        PublicationController.beginTransaction(db);
        ArrayList<PublicationVO> res = new ArrayList<PublicationVO>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.publishing.impl.simple.PublicationImpl c WHERE c.repositoryId = $1 order by publicationDateTime desc");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Publication publication = (Publication)results.next();
                res.add(publication.getValueObject());
            }
            results.close();
            oql.close();
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return res;
    }

    public static EditionBrowser getEditionPage(Integer repositoryId, int startIndex) throws SystemException {
        int pageSize = new Integer(CmsPropertyHandler.getEditionPageSize());
        Database db = CastorDatabaseService.getDatabase();
        PublicationController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.publishing.impl.simple.PublicationImpl c WHERE c.repositoryId = $1 order by publicationDateTime desc");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            List allEditions = Collections.list(results);
            List page = allEditions.subList(startIndex, Math.min(startIndex + pageSize, allEditions.size()));
            EditionBrowser browser = new EditionBrowser(allEditions.size(), pageSize, startIndex);
            ArrayList<PublicationVO> editionVOs = new ArrayList<PublicationVO>();
            for (Publication pub : page) {
                PublicationVO pubVO = pub.getValueObject();
                editionVOs.add(pubVO);
            }
            browser.setEditions(editionVOs);
            results.close();
            oql.close();
            PublicationController.commitTransaction(db);
            return browser;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static void denyPublicationRequest(Integer eventId, InfoGluePrincipal publisher, String comment, String referenceUrl) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        PublicationController.beginTransaction(db);
        try {
            Event event = EventController.getEventWithId(eventId, db);
            if (event.getTypeId().intValue() == EventVO.PUBLISH.intValue()) {
                event.setTypeId(EventVO.PUBLISH_DENIED);
                if (event.getEntityClass().equals(ContentVersion.class.getName())) {
                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(event.getEntityId(), db);
                    if (contentVersion.getStateId().intValue() == ContentVersionVO.PUBLISHED_STATE.intValue()) {
                        EventController.delete(event, db);
                    } else {
                        ContentImpl content = contentVersion.getOwningContent();
                        LanguageImpl language = contentVersion.getLanguage();
                        event.setEntityId(ContentVersionController.getContentVersionController().getPreviousActiveContentVersionVO(content.getId(), language.getId(), contentVersion.getId(), db).getId());
                        ContentVersionController.getContentVersionController().delete(contentVersion, db);
                    }
                } else if (event.getEntityClass().equals(SiteNodeVersion.class.getName())) {
                    SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(event.getEntityId(), db);
                    if (siteNodeVersion.getStateId().intValue() == SiteNodeVersionVO.PUBLISHED_STATE.intValue()) {
                        EventController.delete(event, db);
                    } else {
                        SiteNodeImpl siteNode = siteNodeVersion.getOwningSiteNode();
                        event.setEntityId(SiteNodeVersionController.getController().getPreviousActiveSiteNodeVersionVO(siteNode.getId(), siteNodeVersion.getId(), db).getId());
                        SiteNodeVersionController.getController().delete(siteNodeVersion, db);
                    }
                }
            } else if (event.getTypeId().intValue() == EventVO.UNPUBLISH_LATEST.intValue()) {
                event.setTypeId(EventVO.UNPUBLISH_DENIED);
                if (event.getEntityClass().equals(ContentVersion.class.getName())) {
                    event.setEntityClass(Content.class.getName());
                    event.setEntityId(ContentVersionController.getContentVersionController().getContentVersionWithId(event.getEntityId(), db).getOwningContent().getId());
                } else if (event.getEntityClass().equals(SiteNodeVersion.class.getName())) {
                    event.setEntityClass(SiteNode.class.getName());
                    event.setEntityId(SiteNodeVersionController.getController().getSiteNodeVersionWithId(event.getEntityId(), db).getOwningSiteNode().getId());
                }
            }
            InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController().getUser(event.getCreator());
            PublicationController.mailNotification(event, publisher.getName(), publisher.getEmail(), infoGluePrincipal.getEmail(), comment, referenceUrl);
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static void denyPublicationRequest(List eventVOList, InfoGluePrincipal publisher, String comment, String referenceUrl) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        PublicationController.beginTransaction(db);
        try {
            for (EventVO eventVO : eventVOList) {
                Event event = EventController.getEventWithId(eventVO.getId(), db);
                InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController().getUser(event.getCreator());
                if (event.getTypeId().intValue() == EventVO.PUBLISH.intValue()) {
                    event.setTypeId(EventVO.PUBLISH_DENIED);
                    if (event.getEntityClass().equals(ContentVersion.class.getName())) {
                        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(event.getEntityId(), db);
                        if (contentVersion.getStateId().intValue() == ContentVersionVO.PUBLISHED_STATE.intValue()) {
                            EventController.delete(event, db);
                        } else {
                            ContentImpl content = contentVersion.getOwningContent();
                            LanguageImpl language = contentVersion.getLanguage();
                            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getPreviousActiveContentVersionVO(content.getId(), language.getId(), contentVersion.getId(), db);
                            if (contentVersionVO != null && event != null) {
                                event.setEntityId(contentVersionVO.getId());
                            }
                            ContentVersionController.getContentVersionController().delete(contentVersion, db);
                        }
                    } else if (event.getEntityClass().equals(SiteNodeVersion.class.getName())) {
                        SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(event.getEntityId(), db);
                        if (siteNodeVersion.getStateId().intValue() == SiteNodeVersionVO.PUBLISHED_STATE.intValue()) {
                            EventController.delete(event, db);
                        } else {
                            SiteNodeImpl siteNode = siteNodeVersion.getOwningSiteNode();
                            SiteNodeVersion previousSiteNodeVersion = SiteNodeVersionController.getController().getPreviousActiveSiteNodeVersion(siteNode.getId(), siteNodeVersion.getId(), db);
                            if (previousSiteNodeVersion != null && event != null) {
                                event.setEntityId(previousSiteNodeVersion.getId());
                            }
                            SiteNodeVersionController.getController().delete(siteNodeVersion, db);
                            SiteNodeStateController.getController().changeStateOnMetaInfo(db, previousSiteNodeVersion, previousSiteNodeVersion.getStateId(), "Denied publication", true, infoGluePrincipal, new ArrayList());
                        }
                    }
                } else if (event.getTypeId().intValue() == EventVO.UNPUBLISH_LATEST.intValue()) {
                    event.setTypeId(EventVO.UNPUBLISH_DENIED);
                    if (event.getEntityClass().equals(ContentVersion.class.getName())) {
                        event.setEntityClass(Content.class.getName());
                        event.setEntityId(ContentVersionController.getContentVersionController().getContentVersionWithId(event.getEntityId(), db).getOwningContent().getId());
                    } else if (event.getEntityClass().equals(SiteNodeVersion.class.getName())) {
                        event.setEntityClass(SiteNode.class.getName());
                        event.setEntityId(SiteNodeVersionController.getController().getSiteNodeVersionWithId(event.getEntityId(), db).getOwningSiteNode().getId());
                    }
                }
                PublicationController.mailNotification(event, publisher.getName(), publisher.getEmail(), infoGluePrincipal.getEmail(), comment, referenceUrl);
            }
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    private static void mailNotification(Event event, String editorName, String sender, String recipient, String comment, String referenceUrl) {
        String email = "";
        try {
            String contentType = CmsPropertyHandler.getMailContentType();
            if (contentType == null || contentType.length() == 0) {
                contentType = "text/html";
            }
            String template = contentType.equalsIgnoreCase("text/plain") ? FileHelper.getFileAsString(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + "cms/publishingtool/deniedPublication_plain.vm")) : FileHelper.getFileAsString(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + "cms/publishingtool/deniedPublication_html.vm"));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("event", event);
            parameters.put("editorName", editorName);
            parameters.put("recipient", recipient);
            parameters.put("comment", comment);
            parameters.put("referenceUrl", referenceUrl);
            StringWriter tempString = new StringWriter();
            PrintWriter pw = new PrintWriter(tempString);
            new VelocityTemplateProcessor().renderTemplate(parameters, pw, template);
            email = tempString.toString();
            String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
            if (systemEmailSender == null || systemEmailSender.equalsIgnoreCase("")) {
                systemEmailSender = "InfoGlueCMS@" + CmsPropertyHandler.getMailSmtpHost();
            }
            if (sender != null && !sender.equals("") && sender.indexOf("@") > -1) {
                systemEmailSender = sender;
            }
            logger.info((Object)("email:" + email));
            MailServiceFactory.getService().send(systemEmailSender, recipient, "CMS - Publishing was denied!!", email, contentType, "UTF-8");
        }
        catch (Exception e) {
            logger.error((Object)("The notification was not sent. Reason:" + e.getMessage()), (Throwable)e);
        }
    }

    public PublicationVO createAndPublish(PublicationVO publicationVO, List events, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            PublicationController.beginTransaction(db);
            publicationVO = this.createAndPublish(publicationVO, events, overrideVersionModifyer, infoGluePrincipal, db);
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to commit the publication: " + e.getMessage()), (Throwable)e);
            PublicationController.rollbackTransaction(db);
        }
        return publicationVO;
    }

    public PublicationVO createAndPublish(PublicationVO publicationVO, List events, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, Database db) throws SystemException, Exception {
        logger.info((Object)"*********************************");
        logger.info((Object)"Creating edition ");
        logger.info((Object)"*********************************");
        PublicationImpl publication = new PublicationImpl();
        publicationVO.setPublicationDateTime(Calendar.getInstance().getTime());
        publication.setValueObject(publicationVO);
        publication.setPublisher(infoGluePrincipal.getName());
        for (EventVO event : events) {
            PublicationController.createPublicationInformation(publication, EventController.getEventWithId(event.getId(), db), overrideVersionModifyer, infoGluePrincipal, db);
        }
        db.create((Object)publication);
        try {
            logger.info((Object)"Starting replication...");
            ReplicationMySqlController.updateSlaveServer();
            logger.info((Object)"Finished replication...");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to replicate the data:" + e.getMessage()), (Throwable)e);
        }
        try {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("publicationId", publicationVO.getId());
            this.intercept(hashMap, "Publication.Write", infoGluePrincipal);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to replicate the data:" + e.getMessage()), (Throwable)e);
        }
        try {
            logger.info((Object)"Notifying the entire system about a publishing...");
            NotificationMessage notificationMessage = new NotificationMessage("PublicationController.createAndPublish():", PublicationImpl.class.getName(), infoGluePrincipal.getName(), 10, publicationVO.getId(), publicationVO.getName());
            ChangeNotificationController.getInstance().addNotificationMessage(notificationMessage);
            RemoteCacheUpdater.clearSystemNotificationMessages();
            logger.info((Object)"Finished Notifying...");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to replicate the data:" + e.getMessage()), (Throwable)e);
        }
        return publicationVO;
    }

    private static void createPublicationInformation(Publication publication, Event event, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, Database db) throws Exception {
        Collection publicationDetails;
        PublicationDetailImpl publicationDetail;
        ArrayList events;
        String entityClass = event.getEntityClass();
        Integer entityId = event.getEntityId();
        Integer typeId = event.getTypeId();
        logger.info((Object)("entityClass:" + entityClass));
        logger.info((Object)("entityId:" + entityId));
        logger.info((Object)("typeId:" + typeId));
        if (entityClass.equals(ContentVersion.class.getName())) {
            ContentVersion contentVersion = null;
            ContentVersion oldContentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(entityId, db);
            if (oldContentVersion != null && oldContentVersion.getOwningContent() != null && typeId.intValue() == EventVO.UNPUBLISH_LATEST.intValue()) {
                oldContentVersion.setIsActive(new Boolean(false));
                contentVersion = oldContentVersion;
            } else if (oldContentVersion != null && oldContentVersion.getOwningContent() != null) {
                events = new ArrayList();
                Integer contentId = oldContentVersion.getOwningContent().getContentId();
                ContentVersion newContentVersion = ContentStateController.changeState(entityId, ContentVersionVO.PUBLISHED_STATE, "Published", overrideVersionModifyer, null, infoGluePrincipal, contentId, db, events);
                contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(newContentVersion.getContentVersionId(), db);
            }
            if (contentVersion != null) {
                publicationDetail = new PublicationDetailImpl();
                publicationDetail.setCreationDateTime(DateHelper.getSecondPreciseDate());
                publicationDetail.setDescription(event.getDescription());
                publicationDetail.setEntityClass(entityClass);
                publicationDetail.setEntityId(contentVersion.getId());
                publicationDetail.setName(event.getName());
                publicationDetail.setTypeId(event.getTypeId());
                publicationDetail.setPublication((PublicationImpl)publication);
                publicationDetail.setCreator(event.getCreator());
                publicationDetails = publication.getPublicationDetails();
                if (publicationDetails == null) {
                    publication.setPublicationDetails(new ArrayList());
                }
                publication.getPublicationDetails().add(publicationDetail);
                db.remove((Object)event);
            }
        }
        if (entityClass.equals(SiteNodeVersion.class.getName())) {
            SiteNodeVersion siteNodeVersion = null;
            SiteNodeVersion oldSiteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(entityId, db);
            if (oldSiteNodeVersion != null && oldSiteNodeVersion.getOwningSiteNode() != null && typeId.intValue() == EventVO.UNPUBLISH_LATEST.intValue()) {
                oldSiteNodeVersion.setIsActive(new Boolean(false));
                siteNodeVersion = oldSiteNodeVersion;
            } else if (oldSiteNodeVersion != null && oldSiteNodeVersion.getOwningSiteNode() != null) {
                events = new ArrayList();
                Integer siteNodeId = oldSiteNodeVersion.getOwningSiteNode().getSiteNodeId();
                SiteNodeVersion newSiteNodeVersion = SiteNodeStateController.getController().changeState(entityId, SiteNodeVersionVO.PUBLISHED_STATE, "Published", overrideVersionModifyer, infoGluePrincipal, siteNodeId, db, events);
                siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(newSiteNodeVersion.getSiteNodeVersionId(), db);
            }
            if (siteNodeVersion != null) {
                publicationDetail = new PublicationDetailImpl();
                publicationDetail.setCreationDateTime(DateHelper.getSecondPreciseDate());
                publicationDetail.setDescription(event.getDescription());
                publicationDetail.setEntityClass(entityClass);
                publicationDetail.setEntityId(siteNodeVersion.getId());
                publicationDetail.setName(event.getName());
                publicationDetail.setTypeId(event.getTypeId());
                publicationDetail.setPublication((PublicationImpl)publication);
                publicationDetail.setCreator(event.getCreator());
                publicationDetails = publication.getPublicationDetails();
                if (publicationDetails == null) {
                    publication.setPublicationDetails(new ArrayList());
                }
                publication.getPublicationDetails().add(publicationDetail);
                db.remove((Object)event);
            }
        }
    }

    public static PublicationVO create(PublicationVO publication) throws SystemException {
        Database db = PublicationController.beginTransaction();
        try {
            PublicationImpl p = new PublicationImpl();
            p.setValueObject(publication);
            p.setPublicationDetails(new ArrayList());
            for (PublicationDetailVO detailVO : publication.getPublicationDetails()) {
                PublicationDetailImpl pd = new PublicationDetailImpl();
                pd.setPublication(p);
                pd.setValueObject(detailVO);
                p.getPublicationDetails().add(pd);
            }
            db.create((Object)p);
            PublicationVO returnPub = p.getValueObject();
            returnPub.setPublicationDetails(PublicationController.toVOList(p.getPublicationDetails()));
            PublicationController.commitTransaction(db);
            return returnPub;
        }
        catch (Exception e) {
            e.printStackTrace();
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static List getPublicationDetailVOList(Integer publicationId) throws SystemException {
        List publicationDetails = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        PublicationController.beginTransaction(db);
        try {
            Publication publication = PublicationController.getPublicationWithId(publicationId, db);
            Collection details = publication.getPublicationDetails();
            publicationDetails = PublicationController.toVOList(details);
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return publicationDetails;
    }

    public static PublicationVO unPublish(Integer publicationId, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        logger.info((Object)"Starting unpublishing operation...");
        Database db = CastorDatabaseService.getDatabase();
        Publication publication = null;
        PublicationController.beginTransaction(db);
        try {
            publication = PublicationController.getPublicationWithId(publicationId, db);
            Collection publicationDetails = publication.getPublicationDetails();
            for (PublicationDetail publicationDetail : publicationDetails) {
                logger.info((Object)("publicationDetail:" + publicationDetail.getId() + ":" + publicationDetail.getTypeId()));
                if (publicationDetail.getTypeId().intValue() != PublicationDetailVO.UNPUBLISH_LATEST.intValue()) {
                    PublicationController.unpublishEntity(publicationDetail, infoGluePrincipal, db);
                    continue;
                }
                PublicationController.republishEntity(publicationDetail, infoGluePrincipal, db);
            }
            db.remove((Object)publication);
            PublicationController.commitTransaction(db);
            logger.info((Object)"Done unpublishing operation...");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        try {
            logger.info((Object)"Starting replication operation...");
            ReplicationMySqlController.updateSlaveServer();
            logger.info((Object)"Done replication operation...");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to replicate the data:" + e.getMessage()), (Throwable)e);
        }
        try {
            logger.info((Object)"Notifying the entire system about an unpublishing...");
            NotificationMessage notificationMessage = new NotificationMessage("PublicationController.unPublish():", PublicationImpl.class.getName(), infoGluePrincipal.getName(), 30, publication.getId(), publication.getName());
            ChangeNotificationController.getInstance().addNotificationMessage(notificationMessage);
            RemoteCacheUpdater.clearSystemNotificationMessages();
            logger.info((Object)"Finished Notifying...");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to replicate the data:" + e.getMessage()), (Throwable)e);
        }
        return publication.getValueObject();
    }

    private static void unpublishEntity(PublicationDetail publicationDetail, InfoGluePrincipal infoGluePrincipal, Database db) throws ConstraintException, SystemException {
        Integer repositoryId = null;
        try {
            if (publicationDetail.getEntityClass().equals(ContentVersion.class.getName())) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(publicationDetail.getEntityId(), db);
                contentVersion.setIsActive(new Boolean(false));
                repositoryId = contentVersion.getOwningContent().getRepository().getId();
            } else if (publicationDetail.getEntityClass().equals(SiteNodeVersion.class.getName())) {
                SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(publicationDetail.getEntityId(), db);
                siteNodeVersion.setIsActive(new Boolean(false));
                repositoryId = siteNodeVersion.getOwningSiteNode().getRepository().getId();
            }
            EventVO eventVO = new EventVO();
            eventVO.setDescription(publicationDetail.getDescription());
            eventVO.setEntityClass(publicationDetail.getEntityClass());
            eventVO.setEntityId(publicationDetail.getEntityId());
            eventVO.setName(publicationDetail.getName());
            eventVO.setTypeId(EventVO.PUBLISH);
            EventController.create(eventVO, repositoryId, infoGluePrincipal, db);
        }
        catch (Exception e) {
            logger.info((Object)("Could not unpublish entity:" + e.getMessage()), (Throwable)e);
        }
    }

    private static void republishEntity(PublicationDetail publicationDetail, InfoGluePrincipal infoGluePrincipal, Database db) throws ConstraintException, SystemException {
        Integer repositoryId = null;
        try {
            boolean createEvent = false;
            if (publicationDetail.getEntityClass().equals(ContentVersion.class.getName())) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(publicationDetail.getEntityId(), db);
                if (contentVersion.getOwningContent() != null) {
                    contentVersion.setIsActive(new Boolean(true));
                    repositoryId = contentVersion.getOwningContent().getRepository().getId();
                    createEvent = true;
                } else {
                    logger.warn((Object)("The contentVersion:" + contentVersion.getId() + " had no content - this should never happen, investigate why. Removing invalid content version."));
                    ContentVersionController.getContentVersionController().delete(contentVersion, db);
                }
            } else if (publicationDetail.getEntityClass().equals(SiteNodeVersion.class.getName())) {
                SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(publicationDetail.getEntityId(), db);
                if (siteNodeVersion.getOwningSiteNode() != null) {
                    siteNodeVersion.setIsActive(new Boolean(true));
                    repositoryId = siteNodeVersion.getOwningSiteNode().getRepository().getId();
                    createEvent = true;
                } else {
                    logger.warn((Object)("The siteNodeVersion:" + siteNodeVersion.getId() + " had no siteNode - this should never happen, investigate why. Removing invalid sitenode version."));
                    SiteNodeVersionController.getController().delete(siteNodeVersion, db);
                }
            }
            if (createEvent) {
                EventVO eventVO = new EventVO();
                eventVO.setDescription(publicationDetail.getDescription());
                eventVO.setEntityClass(publicationDetail.getEntityClass());
                eventVO.setEntityId(publicationDetail.getEntityId());
                eventVO.setName(publicationDetail.getName());
                eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                EventController.create(eventVO, repositoryId, infoGluePrincipal, db);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Could not republish entity:" + e.getMessage()), (Throwable)e);
        }
    }

    public static ContentVO getOwningContentVO(Integer id) throws SystemException {
        ContentVO contentVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersion contentVersion = null;
        PublicationController.beginTransaction(db);
        try {
            contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(id, db);
            contentVO = contentVersion.getOwningContent().getValueObject();
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVO;
    }

    public static SiteNodeVO getOwningSiteNodeVO(Integer id) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        SiteNodeVersion siteNodeVersion = null;
        PublicationController.beginTransaction(db);
        try {
            siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(id, db);
            PublicationController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            PublicationController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return siteNodeVersion.getOwningSiteNode().getValueObject();
    }

    public static void mailPublishNotification(List resultingEvents, Integer repositoryId, InfoGluePrincipal principal, String recipientFilter, Database db) {
        try {
            String recipients = PublicationController.getRecipients(principal, repositoryId, recipientFilter, db);
            if (recipients == null || recipients.length() == 0) {
                return;
            }
            String contentType = CmsPropertyHandler.getMailContentType();
            if (contentType == null || contentType.length() == 0) {
                contentType = "text/html";
            }
            String template = contentType.equalsIgnoreCase("text/plain") ? FileHelper.getFileAsString(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + "cms/publishingtool/newPublishItem_plain.vm")) : FileHelper.getFileAsString(new File(String.valueOf(CmsPropertyHandler.getContextRootPath()) + "cms/publishingtool/newPublishItem_html.vm"));
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("events", resultingEvents);
            parameters.put("principal", principal);
            StringWriter tempString = new StringWriter();
            PrintWriter pw = new PrintWriter(tempString);
            new VelocityTemplateProcessor().renderTemplate(parameters, pw, template);
            String email = tempString.toString();
            String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
            if (systemEmailSender == null || systemEmailSender.equalsIgnoreCase("")) {
                systemEmailSender = "InfoGlueCMS@" + CmsPropertyHandler.getMailSmtpHost();
            }
            logger.info((Object)("email:" + email));
            logger.info((Object)("recipients:" + recipients));
            MailServiceFactory.getService().sendEmail(systemEmailSender, systemEmailSender, recipients, "CMS - " + principal.getFirstName() + " " + principal.getLastName() + " submitted " + resultingEvents.size() + " items for publishing", email, "utf-8");
        }
        catch (Exception e) {
            logger.error((Object)("The notification was not sent. Reason:" + e.getMessage()), (Throwable)e);
        }
    }

    private static String getRecipients(InfoGluePrincipal principal, Integer repositoryId, String recipientFilter, Database db) throws Exception {
        if (recipientFilter != null && recipientFilter.equals("")) {
            return null;
        }
        String recipients = "";
        List users = new ArrayList();
        if (recipientFilter.equalsIgnoreCase("all")) {
            users = UserControllerProxy.getController(db).getAllUsers();
        } else if (recipientFilter.equalsIgnoreCase("groupBased")) {
            for (InfoGlueGroup infoGlueGroup : principal.getGroups()) {
                users = GroupControllerProxy.getController(db).getInfoGluePrincipals(infoGlueGroup.getName());
            }
        } else if (recipientFilter.indexOf("groupNameBased_") > -1) {
            String groupName = recipientFilter.substring(recipientFilter.indexOf("_") + 1);
            users = GroupControllerProxy.getController(db).getInfoGluePrincipals(groupName);
        }
        for (InfoGluePrincipal infogluePrincipal : users) {
            boolean hasAccessToRepository;
            boolean hasAccessToPublishingTool;
            if (infogluePrincipal.getGroups() == null || infogluePrincipal.getGroups().size() == 0) {
                infogluePrincipal = UserControllerProxy.getController(db).getUser(infogluePrincipal.getName());
            }
            if (!(hasAccessToPublishingTool = PublicationController.hasAccessTo("PublishingTool.Read", infogluePrincipal)) || !(hasAccessToRepository = PublicationController.hasAccessTo("Repository.Read", "" + repositoryId, infogluePrincipal)) || recipients.indexOf(infogluePrincipal.getEmail()) != -1) continue;
            if (recipients.length() > 0) {
                recipients = String.valueOf(recipients) + ";";
            }
            recipients = String.valueOf(recipients) + infogluePrincipal.getEmail();
        }
        return recipients;
    }

    public static boolean hasAccessTo(String interceptionPointName, InfoGluePrincipal principal) {
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(principal, interceptionPointName);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public static boolean hasAccessTo(String interceptionPointName, String extraParameter, InfoGluePrincipal principal) {
        try {
            return AccessRightController.getController().getIsPrincipalAuthorized(principal, interceptionPointName, extraParameter);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error checking access rights", (Throwable)e);
            return false;
        }
    }

    public BaseEntityVO getNewVO() {
        return new PublicationVO();
    }
}

