/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.PropertiesCategory;
import org.infoglue.cms.entities.management.PropertiesCategoryVO;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.entities.management.impl.simple.PropertiesCategoryImpl;
import org.infoglue.cms.exception.SystemException;

public class PropertiesCategoryController
extends BaseController {
    private static final PropertiesCategoryController instance = new PropertiesCategoryController();
    private static final String findByProperties = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.PropertiesCategoryImpl c ").append("WHERE c.entityName = $1 AND c.entityId = $2").toString();
    private static final String findByPropertiesAttribute = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.PropertiesCategoryImpl c ").append("WHERE c.attributeName = $1 ").append("AND c.entityName = $2").append("AND c.entityId = $3").append("ORDER BY c.category.name").toString();
    private static final String findByCategory = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.PropertiesCategoryImpl c ").append("WHERE c.category.categoryId = $1 ").toString();

    public static PropertiesCategoryController getController() {
        return instance;
    }

    private PropertiesCategoryController() {
    }

    public PropertiesCategoryVO findById(Integer id) throws SystemException {
        return (PropertiesCategoryVO)PropertiesCategoryController.getVOWithId(PropertiesCategoryImpl.class, id);
    }

    public List findByPropertiesAttribute(String attribute, String entityName, Integer entityId) throws SystemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(attribute);
        params.add(entityName);
        params.add(entityId);
        return PropertiesCategoryController.executeQuery(findByPropertiesAttribute, params);
    }

    public List findByPropertiesAttribute(String attribute, String entityName, Integer entityId, Database db) throws SystemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(attribute);
        params.add(entityName);
        params.add(entityId);
        return PropertiesCategoryController.executeQuery(findByPropertiesAttribute, params, db);
    }

    public List findByProperties(String entityName, Integer entityId) throws SystemException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(entityName);
        params.add(entityId);
        return PropertiesCategoryController.executeQuery(findByProperties, params);
    }

    public List findByCategory(Integer categoryId) throws SystemException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(categoryId);
        return PropertiesCategoryController.executeQuery(findByCategory, params);
    }

    public PropertiesCategoryVO save(PropertiesCategoryVO c) throws SystemException {
        return c.isUnsaved() ? this.create(c) : (PropertiesCategoryVO)PropertiesCategoryController.updateEntity(PropertiesCategoryImpl.class, c);
    }

    private PropertiesCategoryVO create(PropertiesCategoryVO c) throws SystemException {
        Database db = PropertiesCategoryController.beginTransaction();
        try {
            PropertiesCategory propertiesCategory = this.createWithDatabase(c, db);
            PropertiesCategoryController.commitTransaction(db);
            return propertiesCategory.getValueObject();
        }
        catch (Exception e) {
            PropertiesCategoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public PropertiesCategory createWithDatabase(PropertiesCategoryVO c, Database db) throws SystemException, PersistenceException {
        Category category = (Category)PropertiesCategoryController.getObjectWithId(CategoryImpl.class, c.getCategory().getId(), db);
        PropertiesCategoryImpl propertiesCategory = new PropertiesCategoryImpl();
        propertiesCategory.setValueObject(c);
        propertiesCategory.setCategory((CategoryImpl)category);
        db.create((Object)propertiesCategory);
        return propertiesCategory;
    }

    public void delete(Integer id) throws SystemException {
        PropertiesCategoryController.deleteEntity(PropertiesCategoryImpl.class, id);
    }

    public void deleteByProperties(String entityName, Integer entityId) throws SystemException {
        PropertiesCategoryController.delete(this.findByProperties(entityName, entityId));
    }

    public void deleteByPropertiesVersion(String entityName, Integer entityId, Database db) throws SystemException {
        PropertiesCategoryController.delete(this.findByProperties(entityName, entityId), db);
    }

    public void deleteByCategory(Integer categoryId) throws SystemException {
        PropertiesCategoryController.delete(this.findByCategory(categoryId));
    }

    public void deleteByCategory(Integer categoryId, Database db) throws SystemException {
        PropertiesCategoryController.delete(this.findByCategory(categoryId), db);
    }

    public void deleteByPropertiesVersionAttribute(String attribute, String entityName, Integer entityId) throws SystemException {
        PropertiesCategoryController.delete(this.findByPropertiesAttribute(attribute, entityName, entityId));
    }

    public void deleteByPropertiesVersionAttribute(String attribute, String entityName, Integer entityId, Database db) throws SystemException {
        PropertiesCategoryController.delete(this.findByPropertiesAttribute(attribute, entityName, entityId), db);
    }

    private static void delete(Collection propertiesCategories) throws SystemException {
        Database db = PropertiesCategoryController.beginTransaction();
        try {
            PropertiesCategoryController.delete(propertiesCategories, db);
            PropertiesCategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            PropertiesCategoryController.rollbackTransaction(db);
            throw new SystemException(e);
        }
    }

    private static void delete(Collection propertiesCategories, Database db) throws SystemException {
        Iterator i = propertiesCategories.iterator();
        while (i.hasNext()) {
            PropertiesCategoryController.deleteEntity(PropertiesCategoryImpl.class, ((PropertiesCategoryVO)i.next()).getId(), db);
        }
    }

    public BaseEntityVO getNewVO() {
        return new PropertiesCategoryVO();
    }
}

