/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.content.impl.simple.DigitalAssetImpl;
import org.infoglue.cms.exception.SystemException;

public class PortletAssetController
extends DigitalAssetController {
    private static final Logger logger = Logger.getLogger((String)PortletAssetController.class.getName());

    public static PortletAssetController getPortletAssetController() {
        return new PortletAssetController();
    }

    public static DigitalAsset create(DigitalAssetVO digitalAssetVO, InputStream is) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        DigitalAssetImpl digitalAsset = null;
        PortletAssetController.beginTransaction(db);
        try {
            digitalAsset = new DigitalAssetImpl();
            digitalAsset.setValueObject(digitalAssetVO);
            digitalAsset.setAssetBlob(is);
            db.create((Object)digitalAsset);
            PortletAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            PortletAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAsset;
    }

    public static List getDigitalAssetByName(String name) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        List contents = new ArrayList();
        PortletAssetController.beginTransaction(db);
        try {
            contents = PortletAssetController.getDigitalAssetByName(name, db);
            PortletAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            PortletAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contents;
    }

    public static List getDigitalAssetByName(String name, Database db) throws SystemException, Exception {
        ArrayList<Object> contents = new ArrayList<Object>();
        OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.DigitalAssetImpl c WHERE c.assetFileName = $1");
        oql.bind((Object)name);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            contents.add(results.next());
        }
        results.close();
        oql.close();
        return contents;
    }

    public DigitalAsset getPortletRegistryAsset() throws Exception {
        List das = PortletAssetController.getDigitalAssetByName("portletentityregistry.xml");
        if (das != null && das.size() > 0) {
            DigitalAsset da = (DigitalAsset)das.get(0);
            logger.debug((Object)("Registry located as id=" + da.getId()));
            return da;
        }
        logger.info((Object)"Portlet Registry not found");
        return null;
    }

    public DigitalAsset getPortletRegistryAsset(Database db) throws Exception {
        List das = PortletAssetController.getDigitalAssetByName("portletentityregistry.xml", db);
        if (das != null && das.size() > 0) {
            DigitalAsset da = (DigitalAsset)das.get(0);
            logger.debug((Object)("Registry located as id=" + da.getId()));
            return da;
        }
        logger.info((Object)"Portlet Registry not found");
        return null;
    }
}

