/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.util.TextUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.infoglue.cms.util.CmsPropertyHandler;

public class MysqlJDBCService {
    Connection jdbcMasterConnection = null;
    Connection jdbcSlaveConnection = null;
    String dbRelease = CmsPropertyHandler.getDbRelease();
    String dbUser = CmsPropertyHandler.getDbUser();
    String dbPassword = CmsPropertyHandler.getDbPassword();
    String masterServer = CmsPropertyHandler.getMasterServer();
    String slaveServer = CmsPropertyHandler.getSlaveServer();
    private boolean enabled = false;

    public MysqlJDBCService() {
        if (TextUtils.stringSet((String)this.masterServer) && TextUtils.stringSet((String)this.slaveServer)) {
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Connection getConnection() throws Exception {
        if (this.masterServer == null) {
            this.masterServer = "localhost";
        }
        Class<?> driverClass = Class.forName("com.mysql.jdbc.Driver");
        this.jdbcMasterConnection = DriverManager.getConnection("jdbc:mysql://" + this.masterServer + "/" + this.dbRelease, this.dbUser, this.dbPassword);
        return this.jdbcMasterConnection;
    }

    private Connection getSlaveConnection() throws Exception {
        Class<?> driverClass = Class.forName("com.mysql.jdbc.Driver");
        this.jdbcSlaveConnection = DriverManager.getConnection("jdbc:mysql://" + this.slaveServer + "/" + this.dbRelease, this.dbUser, this.dbPassword);
        return this.jdbcSlaveConnection;
    }

    public ResultSet executeSQL(String sql, String numOfRows) throws Exception {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        return stmt.executeQuery(String.valueOf(sql) + " limit " + numOfRows);
    }

    public ResultSet executeMasterSQL(String sql) throws Exception {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        return stmt.executeQuery(sql);
    }

    public ResultSet executeSlaveSQL(String sql) throws Exception {
        Connection conn = this.getSlaveConnection();
        Statement stmt = conn.createStatement();
        return stmt.executeQuery(sql);
    }

    public void closeMaster() throws SQLException {
        if (this.jdbcMasterConnection != null) {
            this.jdbcMasterConnection.close();
        }
    }

    public void closeSlave() throws SQLException {
        if (this.jdbcSlaveConnection != null) {
            this.jdbcSlaveConnection.close();
        }
    }
}

