/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryLanguageController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.RepositoryLanguageImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.util.CacheController;

public class LanguageController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)LanguageController.class.getName());

    public static LanguageController getController() {
        return new LanguageController();
    }

    public LanguageVO getLanguageVOWithId(Integer languageId) throws SystemException, Exception {
        String key = "" + languageId;
        logger.info((Object)("key:" + key));
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("languageCache", key);
        if (languageVO != null) {
            logger.info((Object)("There was an cached languageVO:" + languageVO));
        } else {
            languageVO = (LanguageVO)LanguageController.getVOWithId(LanguageImpl.class, languageId);
            CacheController.cacheObject("languageCache", key, languageVO);
        }
        return languageVO;
    }

    public LanguageVO getLanguageVOWithId(Integer languageId, Database db) throws SystemException, Bug {
        return (LanguageVO)LanguageController.getVOWithId(LanguageImpl.class, languageId, db);
    }

    public Locale getLocaleWithId(Integer languageId) {
        Locale locale = Locale.getDefault();
        if (languageId != null) {
            try {
                LanguageVO languageVO = this.getLanguageVOWithId(languageId);
                locale = new Locale(languageVO.getLanguageCode());
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred in getLocaleWithId: getting locale with languageid:" + languageId + "," + e), (Throwable)e);
            }
        }
        return locale;
    }

    public Locale getLocaleWithId(Integer languageId, Database db) {
        Locale locale = Locale.getDefault();
        if (languageId != null) {
            try {
                LanguageVO languageVO = this.getLanguageVOWithId(languageId, db);
                locale = new Locale(languageVO.getLanguageCode());
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred in getLocaleWithId: getting locale with languageid:" + languageId + "," + e), (Throwable)e);
            }
        }
        return locale;
    }

    public LanguageVO getLanguageVOWithName(String name) throws SystemException, Bug {
        LanguageVO languageVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            LanguageController.beginTransaction(db);
            Language language = this.getLanguageWithName(name, db);
            if (language != null) {
                languageVO = language.getValueObject();
            }
            LanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            LanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return languageVO;
    }

    public Language getLanguageWithName(String name, Database db) throws SystemException, Bug {
        Language language = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl f WHERE f.name = $1");
            oql.bind((Object)name);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode" + name));
            if (results.hasMore()) {
                language = (Language)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named language. Reason:" + e.getMessage(), e);
        }
        return language;
    }

    public LanguageVO getLanguageVOWithCode(String code, Database db) throws SystemException, Bug {
        LanguageVO languageVO = null;
        Language language = this.getLanguageWithCode(code, db);
        if (language != null) {
            languageVO = language.getValueObject();
        }
        return languageVO;
    }

    public LanguageVO getLanguageVOWithCode(String code) throws SystemException, Bug {
        String key = code;
        LanguageVO languageVO = (LanguageVO)CacheController.getCachedObject("languageCache", key);
        if (languageVO != null) {
            logger.info((Object)("There was an cached languageVO:" + languageVO));
        } else {
            Database db = CastorDatabaseService.getDatabase();
            try {
                LanguageController.beginTransaction(db);
                Language language = this.getLanguageWithCode(code, db);
                if (language != null) {
                    languageVO = language.getValueObject();
                }
                LanguageController.commitTransaction(db);
            }
            catch (Exception e) {
                logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
                LanguageController.rollbackTransaction(db);
                throw new SystemException(e.getMessage());
            }
            CacheController.cacheObject("languageCache", key, languageVO);
        }
        return languageVO;
    }

    public Language getLanguageWithCode(String code, Database db) throws SystemException, Bug {
        Language language = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl f WHERE f.languageCode = $1");
            oql.bind((Object)code);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode" + code));
            if (results.hasMore()) {
                language = (Language)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named language. Reason:" + e.getMessage(), e);
        }
        return language;
    }

    public LanguageVO create(LanguageVO languageVO) throws ConstraintException, SystemException {
        Language ent = new LanguageImpl();
        ent.setValueObject(languageVO);
        ent = (Language)LanguageController.createEntity(ent);
        return ent.getValueObject();
    }

    public LanguageVO create(Database db, LanguageVO languageVO) throws ConstraintException, SystemException, Exception {
        LanguageImpl ent = new LanguageImpl();
        ent.setValueObject(languageVO);
        db.create((Object)ent);
        return ent.getValueObject();
    }

    public void delete(LanguageVO languageVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Object language = null;
        try {
            LanguageController.beginTransaction(db);
            this.delete(db, languageVO);
            LanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            LanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(Database db, LanguageVO languageVO) throws ConstraintException, SystemException {
        Language language = this.getLanguageWithId(languageVO.getId(), db);
        RepositoryLanguageController.getController().deleteAllRepositoryLanguageWithLanguage(language, db);
        LanguageController.deleteEntity(LanguageImpl.class, languageVO.getLanguageId(), db);
    }

    public Language getLanguageWithId(Integer languageId, Database db) throws SystemException, Bug {
        return (Language)LanguageController.getObjectWithId(LanguageImpl.class, languageId, db);
    }

    public Language getLanguageWithId(Integer languageId) throws ConstraintException, SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Language language = null;
        try {
            LanguageController.beginTransaction(db);
            language = this.getLanguageWithId(languageId, db);
            ceb.throwIfNotEmpty();
            LanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            LanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return language;
    }

    public LanguageVO getLanguageVOWithRepositoryLanguageId(Integer repositoryLanguageId) throws ConstraintException, SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        LanguageVO languageVO = null;
        try {
            LanguageController.beginTransaction(db);
            languageVO = this.getLanguageWithRepositoryLanguageId(repositoryLanguageId, db).getValueObject();
            ceb.throwIfNotEmpty();
            LanguageController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            LanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return languageVO;
    }

    public Language getLanguageWithRepositoryLanguageId(Integer repositoryLanguageId, Database db) throws ConstraintException, SystemException, Bug {
        RepositoryLanguage repositoryLanguage = (RepositoryLanguage)LanguageController.getObjectWithId(RepositoryLanguageImpl.class, repositoryLanguageId, db);
        Language language = repositoryLanguage.getLanguage();
        return language;
    }

    public List getLanguageVOList(Integer repositoryId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList<LanguageVO> languageVOList = new ArrayList<LanguageVO>();
        LanguageController.beginTransaction(db);
        try {
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
            Collection repositoryLanguageList = repository.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : repositoryLanguageList) {
                languageVOList.add(repositoryLanguage.getLanguage().getValueObject());
            }
            ceb.throwIfNotEmpty();
            LanguageController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            LanguageController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            LanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return languageVOList;
    }

    public List getLanguageVOList(Integer repositoryId, Database db) throws ConstraintException, SystemException {
        ArrayList<LanguageVO> languageVOList = new ArrayList<LanguageVO>();
        Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
        Collection repositoryLanguageList = repository.getRepositoryLanguages();
        for (RepositoryLanguage repositoryLanguage : repositoryLanguageList) {
            languageVOList.add(repositoryLanguage.getLanguage().getValueObject());
        }
        return languageVOList;
    }

    public List getLanguageList(Integer repositoryId, Database db) throws ConstraintException, SystemException {
        ArrayList<Language> languageList = new ArrayList<Language>();
        Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
        Collection repositoryLanguageList = repository.getRepositoryLanguages();
        for (RepositoryLanguage repositoryLanguage : repositoryLanguageList) {
            languageList.add(repositoryLanguage.getLanguage());
        }
        return languageList;
    }

    public List getLanguageVOList(Database db) throws SystemException, Bug {
        String key = "allLanguageVOList";
        List languageVOList = (List)CacheController.getCachedObject("languageCache", key);
        if (languageVOList != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached languageVOList:" + languageVOList.size()));
            }
        } else {
            languageVOList = this.getAllVOObjects(LanguageImpl.class, "languageId", db);
            CacheController.cacheObject("languageCache", key, languageVOList);
        }
        return languageVOList;
    }

    public List getLanguageVOList() throws SystemException, Bug {
        return this.getAllVOObjects(LanguageImpl.class, "languageId");
    }

    public LanguageVO getMasterLanguage(Integer repositoryId) throws SystemException, Exception {
        LanguageVO languageVO = null;
        String languageKey = "" + repositoryId;
        logger.info((Object)("languageKey:" + languageKey));
        languageVO = (LanguageVO)CacheController.getCachedObject("masterLanguageCache", languageKey);
        if (languageVO != null) {
            logger.info((Object)("There was an cached master language:" + languageVO.getName()));
        } else {
            Database db = CastorDatabaseService.getDatabase();
            ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
            Language language = null;
            LanguageController.beginTransaction(db);
            try {
                language = this.getMasterLanguage(db, repositoryId);
                ceb.throwIfNotEmpty();
                if (language != null) {
                    languageVO = language.getValueObject();
                    CacheController.cacheObject("masterLanguageCache", languageKey, languageVO);
                }
                LanguageController.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
                LanguageController.rollbackTransaction(db);
                throw new SystemException(e.getMessage());
            }
        }
        return languageVO;
    }

    public LanguageVO getMasterLanguage(Integer repositoryId, Database db) throws SystemException, Exception {
        LanguageVO languageVO = null;
        String languageKey = "" + repositoryId;
        logger.info((Object)("languageKey:" + languageKey));
        languageVO = (LanguageVO)CacheController.getCachedObject("masterLanguageCache", languageKey);
        if (languageVO != null) {
            logger.info((Object)("There was an cached master language:" + languageVO.getName()));
        } else {
            Language language = this.getMasterLanguage(db, repositoryId);
            if (language != null) {
                languageVO = language.getValueObject();
                CacheController.cacheObject("masterLanguageCache", languageKey, languageVO);
            }
        }
        return languageVO;
    }

    public Language getMasterLanguage(Database db, Integer repositoryId) throws SystemException, Exception {
        Language language = null;
        OQLQuery oql = db.getOQLQuery("SELECT l FROM org.infoglue.cms.entities.management.impl.simple.LanguageImpl l WHERE l.repositoryLanguages.repository.repositoryId = $1 ORDER BY l.repositoryLanguages.sortOrder, l.languageId");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            language = (Language)results.next();
        }
        results.close();
        oql.close();
        return language;
    }

    public void deleteLanguage(Integer languageId, Database db) throws SystemException, Bug {
        try {
            db.remove((Object)this.getLanguageWithId(languageId, db));
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to delete Language in the database. Reason: " + e.getMessage(), e);
        }
    }

    public LanguageVO update(LanguageVO languageVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Language language = null;
        LanguageController.beginTransaction(db);
        try {
            language = this.getLanguageWithId(languageVO.getLanguageId(), db);
            language.setValueObject(languageVO);
            ceb.throwIfNotEmpty();
            LanguageController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            LanguageController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            LanguageController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return language.getValueObject();
    }

    public BaseEntityVO getNewVO() {
        return new LanguageVO();
    }
}

