/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.InterceptionPoint;
import org.infoglue.cms.entities.management.Interceptor;
import org.infoglue.cms.entities.management.InterceptorVO;
import org.infoglue.cms.entities.management.impl.simple.InterceptorImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class InterceptorController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)InterceptorController.class.getName());

    public static InterceptorController getController() {
        return new InterceptorController();
    }

    public Interceptor getInterceptorWithId(Integer interceptorId, Database db) throws SystemException, Bug {
        return (Interceptor)InterceptorController.getObjectWithId(InterceptorImpl.class, interceptorId, db);
    }

    public InterceptorVO getInterceptorVOWithId(Integer interceptorId) throws SystemException, Bug {
        return (InterceptorVO)InterceptorController.getVOWithId(InterceptorImpl.class, interceptorId);
    }

    public List getInterceptorVOList() throws SystemException, Bug {
        return this.getAllVOObjects(InterceptorImpl.class, "interceptorId");
    }

    public List getInterceptionPointVOList(Integer interceptorId) throws SystemException, Bug {
        List interceptionPointVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptorController.beginTransaction(db);
            interceptionPointVOList = this.getInterceptionPointVOList(interceptorId, db);
            InterceptorController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptorController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return interceptionPointVOList;
    }

    public List getInterceptionPointVOList(Integer interceptorId, Database db) throws SystemException, Bug {
        Interceptor interceptor = this.getInterceptorWithId(interceptorId, db);
        Collection interceptionPoints = interceptor.getInterceptionPoints();
        return InterceptorController.toVOList(interceptionPoints);
    }

    public InterceptorVO create(InterceptorVO interceptorVO) throws ConstraintException, SystemException {
        InterceptorVO newinterceptorVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptorController.beginTransaction(db);
            newinterceptorVO = this.create(interceptorVO, db);
            InterceptorController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptorController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return newinterceptorVO;
    }

    public InterceptorVO create(InterceptorVO interceptorVO, Database db) throws SystemException, Exception {
        InterceptorImpl interceptor = new InterceptorImpl();
        interceptor.setValueObject(interceptorVO);
        db.create((Object)interceptor);
        return interceptor.getValueObject();
    }

    public InterceptorVO update(InterceptorVO interceptorVO) throws ConstraintException, SystemException {
        return (InterceptorVO)InterceptorController.updateEntity(InterceptorImpl.class, interceptorVO);
    }

    public void update(InterceptorVO interceptorVO, String[] values) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptorController.beginTransaction(db);
            ConstraintExceptionBuffer ceb = interceptorVO.validate();
            ceb.throwIfNotEmpty();
            logger.info((Object)("InterceptorId:" + interceptorVO.getInterceptorId()));
            Interceptor interceptor = this.getInterceptorWithId(interceptorVO.getInterceptorId(), db);
            interceptor.setValueObject(interceptorVO);
            Collection interceptionPoints = interceptor.getInterceptionPoints();
            for (InterceptionPoint interceptionPoint : interceptionPoints) {
                interceptionPoint.getInterceptors().remove(interceptor);
            }
            interceptor.getInterceptionPoints().clear();
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    String interceptionPointId = values[i];
                    InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithId(new Integer(interceptionPointId), db);
                    interceptor.getInterceptionPoints().add(interceptionPoint);
                    interceptionPoint.getInterceptors().add(interceptor);
                    ++i;
                }
            }
            InterceptorController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptorController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(InterceptorVO interceptorVO) throws ConstraintException, SystemException {
        InterceptorController.deleteEntity(InterceptorImpl.class, interceptorVO.getInterceptorId());
    }

    public BaseEntityVO getNewVO() {
        return new InterceptorVO();
    }
}

