/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptorController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.AccessRightGroup;
import org.infoglue.cms.entities.management.AccessRightRole;
import org.infoglue.cms.entities.management.AccessRightUser;
import org.infoglue.cms.entities.management.InterceptionPoint;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.Interceptor;
import org.infoglue.cms.entities.management.impl.simple.InterceptionPointImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionPointController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)InterceptionPointController.class.getName());
    public static final Map systemInterceptionPoints = new HashMap();

    static {
        systemInterceptionPoints.put("ContentTool.Read", new InterceptionPointVO("ContentTool", "ContentTool.Read", "Gives a user access to the content tool", false));
        systemInterceptionPoints.put("ContentTool.ImportExport", new InterceptionPointVO("ContentTool", "ContentTool.ImportExport", "Intercepts exporting and importing of contents", false));
        systemInterceptionPoints.put("ManagementTool.Read", new InterceptionPointVO("ManagementTool", "ManagementTool.Read", "Gives a user access to the management tool", false));
        systemInterceptionPoints.put("MyDesktopTool.Read", new InterceptionPointVO("MyDesktopTool", "MyDesktopTool.Read", "Gives the user access to the mydesktop tool", false));
        systemInterceptionPoints.put("PublishingTool.Read", new InterceptionPointVO("PublishingTool", "PublishingTool.Read", "Gives the user access to the publishing tool", false));
        systemInterceptionPoints.put("StructureTool.Read", new InterceptionPointVO("StructureTool", "StructureTool.Read", "Gives a user access to the structure tool", false));
        systemInterceptionPoints.put("Category.Read", new InterceptionPointVO("Category", "Category.Read", "This intercepts any read towards a category", true));
        systemInterceptionPoints.put("Content.Read", new InterceptionPointVO("Content", "Content.Read", "Intercepts the read of a content", true));
        systemInterceptionPoints.put("Content.Write", new InterceptionPointVO("Content", "Content.Write", "Intercepts the write of a content", true));
        systemInterceptionPoints.put("Content.Create", new InterceptionPointVO("Content", "Content.Create", "Intercepts the creation of a new content or folder", true));
        systemInterceptionPoints.put("Content.Delete", new InterceptionPointVO("Content", "Content.Delete", "Intercepts the deletion of a content", true));
        systemInterceptionPoints.put("Content.Move", new InterceptionPointVO("Content", "Content.Move", "Intercepts the movement of a content", true));
        systemInterceptionPoints.put("Content.SubmitToPublish", new InterceptionPointVO("Content", "Content.SubmitToPublish", "Intercepts the submittance to publish of all content versions", true));
        systemInterceptionPoints.put("Content.ChangeAccessRights", new InterceptionPointVO("Content", "Content.ChangeAccessRights", "Intercepts the attempt to change access rights", true));
        systemInterceptionPoints.put("Content.CreateVersion", new InterceptionPointVO("Content", "Content.CreateVersion", "Intercepts the creation of a new contentversion", true));
        systemInterceptionPoints.put("Content.ExpireDateComingUp", new InterceptionPointVO("Content", "Content.ExpireDateComingUp", "Intercepts the event of a content coming close to it's expire date", true));
        systemInterceptionPoints.put("ContentTypeDefinition.Read", new InterceptionPointVO("ContentTypeDefinition", "ContentTypeDefinition.Read", "This point checks access to read/use a content type definition", true));
        systemInterceptionPoints.put("ContentVersion.Delete", new InterceptionPointVO("ContentVersion", "ContentVersion.Delete", "Intercepts the deletion of a contentversion", true));
        systemInterceptionPoints.put("ContentVersion.Write", new InterceptionPointVO("ContentVersion", "ContentVersion.Write", "Intercepts the editing of a contentversion", true));
        systemInterceptionPoints.put("ContentVersion.Read", new InterceptionPointVO("ContentVersion", "ContentVersion.Read", "Intercepts the read of a contentversion", true));
        systemInterceptionPoints.put("ContentVersion.Publish", new InterceptionPointVO("ContentVersion", "ContentVersion.Publish", "Intercepts the direct publishing of a content version", true));
        systemInterceptionPoints.put("Repository.Read", new InterceptionPointVO("Repository", "Repository.Read", "Gives a user access to look at a repository", true));
        systemInterceptionPoints.put("Repository.ReadForBinding", new InterceptionPointVO("Repository", "Repository.ReadForBinding", "This point intercepts when a user tries to read the repository in a binding dialog", true));
        systemInterceptionPoints.put("SiteNodeVersion.Read", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.Read", "Intercepts the read of a SiteNodeVersion", true));
        systemInterceptionPoints.put("SiteNodeVersion.Write", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.Write", "Intercepts the write of a SiteNodeVersion", true));
        systemInterceptionPoints.put("SiteNodeVersion.CreateSiteNode", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.CreateSiteNode", "Intercepts the creation of a new sitenode", true));
        systemInterceptionPoints.put("SiteNodeVersion.DeleteSiteNode", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.DeleteSiteNode", "Intercepts the deletion of a sitenode", true));
        systemInterceptionPoints.put("SiteNodeVersion.MoveSiteNode", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.MoveSiteNode", "Intercepts the movement of a sitenode", true));
        systemInterceptionPoints.put("SiteNodeVersion.SubmitToPublish", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.SubmitToPublish", "Intercepts the submittance to publish of all content versions", true));
        systemInterceptionPoints.put("SiteNodeVersion.ChangeAccessRights", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.ChangeAccessRights", "Intercepts the attempt to change access rights", true));
        systemInterceptionPoints.put("SiteNodeVersion.Publish", new InterceptionPointVO("SiteNodeVersion", "SiteNodeVersion.Publish", "Intercepts the direct publishing of a siteNode version", true));
        systemInterceptionPoints.put("SiteNode.ExpireDateComingUp", new InterceptionPointVO("SiteNode", "SiteNode.ExpireDateComingUp", "Intercepts the event of a site node coming close to it's expire date", true));
        systemInterceptionPoints.put("StructureTool.SaveTemplate", new InterceptionPointVO("StructureTool", "StructureTool.SaveTemplate", "This interception point limits who get the save-button in the toolbar", false));
        systemInterceptionPoints.put("StructureTool.Palette", new InterceptionPointVO("StructureTool", "StructureTool.Palette", "This interception point limits who sees the toolbar", false));
        systemInterceptionPoints.put("ComponentEditor.ChangeSlotAccess", new InterceptionPointVO("ComponentEditor", "ComponentEditor.ChangeSlotAccess", "This interception point limits who can set access rights to a slot", false));
        systemInterceptionPoints.put("ComponentEditor.AddComponent", new InterceptionPointVO("ComponentEditor", "ComponentEditor.AddComponent", "This interception point limits who can add a component to a specific slot", true));
        systemInterceptionPoints.put("ComponentEditor.DeleteComponent", new InterceptionPointVO("ComponentEditor", "ComponentEditor.DeleteComponent", "This interception point limits who can delete a component in a specific slot", true));
        systemInterceptionPoints.put("ComponentEditor.ChangeComponent", new InterceptionPointVO("ComponentEditor", "ComponentEditor.ChangeComponent", "This interception point limits who can change a component to another in a specific slot", true));
        systemInterceptionPoints.put("ComponentEditor.SubmitToPublish", new InterceptionPointVO("ComponentEditor", "ComponentEditor.SubmitToPublish", "This interception point limits who have access to the Submit to publish choice in edit on sight", false));
        systemInterceptionPoints.put("ComponentEditor.PageStructure", new InterceptionPointVO("ComponentEditor", "ComponentEditor.PageStructure", "This interception point limits who can see the page structure menu option in edit on sight", false));
        systemInterceptionPoints.put("ComponentEditor.OpenInNewWindow", new InterceptionPointVO("ComponentEditor", "ComponentEditor.OpenInNewWindow", "This interception point limits who can see the Open in new window in edit on sight", false));
        systemInterceptionPoints.put("ComponentEditor.ViewSource", new InterceptionPointVO("ComponentEditor", "ComponentEditor.ViewSource", "This interception point limits who can see the view source menu in edit on sight", false));
        systemInterceptionPoints.put("ComponentPropertyEditor.EditProperty", new InterceptionPointVO("ComponentPropertyEditor", "ComponentPropertyEditor.EditProperty", "This interception point limits who can edit a specific component property", true));
        systemInterceptionPoints.put("Publication.Write", new InterceptionPointVO("Publication", "Publication.Write", "This interception point intercepts publications", true));
        systemInterceptionPoints.put("Common.SubmitToPublishButton", new InterceptionPointVO("Common", "Common.SubmitToPublishButton", "Intercepts the submit to publish button", false));
        systemInterceptionPoints.put("Common.PublishButton", new InterceptionPointVO("Common", "Common.PublishButton", "Intercepts the publish button", false));
        systemInterceptionPoints.put("ManagementToolMenu.Repositories", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Repositories", "Intercepts access to the menu item 'Repositories' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.SystemUsers", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.SystemUsers", "Intercepts access to the menu item 'SystemUsers' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Roles", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Roles", "Intercepts access to the menu item 'Roles' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Groups", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Groups", "Intercepts access to the menu item 'Groups' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Languages", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Languages", "Intercepts access to the menu item 'Languages' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.InterceptionPoints", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.InterceptionPoints", "Intercepts access to the menu item 'InterceptionPoints' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Interceptors", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Interceptors", "Intercepts access to the menu item 'Interceptors' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.ServiceDefinitions", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.ServiceDefinitions", "Intercepts access to the menu item 'ServiceDefinitions' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.AvailableServiceBindings", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.AvailableServiceBindings", "Intercepts access to the menu item 'AvailableServiceBindings' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.SiteNodeTypeDefinitions", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.SiteNodeTypeDefinitions", "Intercepts access to the menu item 'SiteNodeTypeDefinitions' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Categories", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Categories", "Intercepts access to the menu item 'Categories' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.ContentTypeDefinitions", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.ContentTypeDefinitions", "Intercepts access to the menu item 'ContentTypeDefinitions' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Up2Date", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Up2Date", "Intercepts access to the menu item 'Up2Date' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Workflows", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Workflows", "Intercepts access to the menu item 'Workflows' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Portlets", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Portlets", "Intercepts access to the menu item 'Portlets' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Redirects", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Redirects", "Intercepts access to the menu item 'Redirects' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.ApplicationSettings", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.ApplicationSettings", "Intercepts access to the menu item 'Application settings' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.MessageCenter", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.MessageCenter", "Intercepts access to the menu item 'Message center' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.Diagnostics", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.Diagnostics", "Intercepts access to the menu item 'Diagnostics' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.SystemTools", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.SystemTools", "Intercepts access to the menu item 'SystemTools' in management tool", false));
        systemInterceptionPoints.put("ManagementToolMenu.TransactionHistory", new InterceptionPointVO("ManagementToolMenu", "ManagementToolMenu.TransactionHistory", "Intercepts access to the menu item 'TransactionHistory' in management tool", false));
        systemInterceptionPoints.put("Role.Read", new InterceptionPointVO("Role", "Role.Read", "Intercepts the read of a role", true));
        systemInterceptionPoints.put("Role.ReadForAssignment", new InterceptionPointVO("Role", "Role.ReadForAssignment", "Intercepts the read of a role when assigning them to a user", true));
        systemInterceptionPoints.put("Role.Write", new InterceptionPointVO("Role", "Role.Write", "Intercepts the write of a role", true));
        systemInterceptionPoints.put("Role.Create", new InterceptionPointVO("Role", "Role.Create", "Intercepts the creation of a new role", true));
        systemInterceptionPoints.put("Role.Delete", new InterceptionPointVO("Role", "Role.Delete", "Intercepts the deletion of a role", true));
        systemInterceptionPoints.put("Role.ManageUsers", new InterceptionPointVO("Role", "Role.ManageUsers", "Intercepts the management of users", true));
        systemInterceptionPoints.put("Role.ManageAccessRights", new InterceptionPointVO("Role", "Role.ManageAccessRights", "Intercepts the management of access rights", true));
        systemInterceptionPoints.put("Role.ManageAllAccessRights", new InterceptionPointVO("Role", "Role.ManageAllAccessRights", "Intercepts the management of access rights", false));
        systemInterceptionPoints.put("Group.Read", new InterceptionPointVO("Group", "Group.Read", "Intercepts the read of a group", true));
        systemInterceptionPoints.put("Group.ReadForAssignment", new InterceptionPointVO("Group", "Group.ReadForAssignment", "Intercepts the read of a group when assigning them to a user", true));
        systemInterceptionPoints.put("Group.Write", new InterceptionPointVO("Group", "Group.Write", "Intercepts the write of a group", true));
        systemInterceptionPoints.put("Group.Create", new InterceptionPointVO("Group", "Group.Create", "Intercepts the creation of a new group", true));
        systemInterceptionPoints.put("Group.Delete", new InterceptionPointVO("Group", "Group.Delete", "Intercepts the deletion of a group", true));
        systemInterceptionPoints.put("Group.ManageUsers", new InterceptionPointVO("Group", "Group.ManageUsers", "Intercepts the management of users", true));
        systemInterceptionPoints.put("Group.ManageAccessRights", new InterceptionPointVO("Group", "Group.ManageAccessRights", "Intercepts the management of access rights", true));
        systemInterceptionPoints.put("Group.ManageAllAccessRights", new InterceptionPointVO("Group", "Group.ManageAllAccessRights", "Intercepts the management of access rights", false));
    }

    public static InterceptionPointController getController() {
        return new InterceptionPointController();
    }

    public InterceptionPoint getInterceptionPointWithId(Integer interceptionPointId, Database db) throws SystemException, Bug {
        return (InterceptionPoint)InterceptionPointController.getObjectWithId(InterceptionPointImpl.class, interceptionPointId, db);
    }

    public InterceptionPointVO getInterceptionPointVOWithId(Integer interceptionPointId) throws SystemException, Bug {
        return (InterceptionPointVO)InterceptionPointController.getVOWithId(InterceptionPointImpl.class, interceptionPointId);
    }

    public List getInterceptionPointVOList() throws SystemException, Bug {
        return this.getAllVOObjects(InterceptionPointImpl.class, "interceptionPointId");
    }

    public List<InterceptionPointVO> getInactiveInterceptionPointVOList() throws SystemException, Bug {
        ArrayList<InterceptionPointVO> inactiveInterceptionPointVOList = new ArrayList<InterceptionPointVO>();
        List interceptionPointVOList = this.getInterceptionPointVOList();
        Collection allInterceptionPoints = systemInterceptionPoints.values();
        for (InterceptionPointVO possibleInterceptionPoint : allInterceptionPoints) {
            boolean exists = false;
            for (InterceptionPointVO existingInterceptionPointVO : interceptionPointVOList) {
                if (!existingInterceptionPointVO.getName().equals(possibleInterceptionPoint.getName())) continue;
                exists = true;
            }
            if (exists) continue;
            inactiveInterceptionPointVOList.add(possibleInterceptionPoint);
        }
        return inactiveInterceptionPointVOList;
    }

    public List getSortedInterceptionPointVOList() throws SystemException, Bug {
        return InterceptionPointController.getAllVOObjects(InterceptionPointImpl.class, "category", "asc");
    }

    public List getInterceptorsVOList(Integer interceptionPointId) throws SystemException, Bug {
        List interceptorVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptionPointController.beginTransaction(db);
            interceptorVOList = this.getInterceptorsVOList(interceptionPointId, db);
            InterceptionPointController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptionPointController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return interceptorVOList;
    }

    public List getInterceptorsVOList(Integer interceptionPointId, Database db) throws SystemException, Bug {
        String key = "" + interceptionPointId;
        logger.info((Object)("key:" + key));
        List cachedInterceptorVOList = (List)CacheController.getCachedObject("interceptorsCache", key);
        if (cachedInterceptorVOList != null) {
            logger.info((Object)("There was an cached InterceptorVOList:" + cachedInterceptorVOList.size()));
            return cachedInterceptorVOList;
        }
        List interceptorsVOList = null;
        InterceptionPoint interceptionPoint = this.getInterceptionPointWithId(interceptionPointId, db);
        Collection interceptors = interceptionPoint.getInterceptors();
        interceptorsVOList = InterceptionPointController.toVOList(interceptors);
        CacheController.cacheObject("interceptorsCache", key, interceptorsVOList);
        return interceptorsVOList;
    }

    public InterceptionPointVO getInterceptionPointVOWithName(String interceptorPointName) throws SystemException, Bug {
        InterceptionPointVO interceptionPointVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptionPointController.beginTransaction(db);
            InterceptionPoint interceptionPoint = this.getInterceptionPointWithName(interceptorPointName, db);
            if (interceptionPoint != null) {
                interceptionPointVO = interceptionPoint.getValueObject();
            }
            InterceptionPointController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptionPointController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return interceptionPointVO;
    }

    public InterceptionPointVO getInterceptionPointVOWithName(String interceptorPointName, Database db) throws SystemException, Bug {
        String key = interceptorPointName;
        logger.info((Object)("key:" + key));
        InterceptionPointVO interceptionPointVO = null;
        Object object = CacheController.getCachedObject("interceptionPointCache", key);
        if (object instanceof NullObject) {
            return null;
        }
        if (object != null) {
            interceptionPointVO = (InterceptionPointVO)object;
        } else {
            InterceptionPoint interceptorPoint = null;
            try {
                OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.InterceptionPointImpl f WHERE f.name = $1");
                oql.bind((Object)interceptorPointName);
                QueryResults results = oql.execute((short)0);
                if (results.hasMore()) {
                    interceptorPoint = (InterceptionPoint)results.next();
                    interceptionPointVO = interceptorPoint.getValueObject();
                    CacheController.cacheObject("interceptionPointCache", key, interceptionPointVO);
                } else {
                    CacheController.cacheObject("interceptionPointCache", key, new NullObject());
                }
                results.close();
                oql.close();
            }
            catch (Exception e) {
                throw new SystemException("An error occurred when we tried to fetch an InterceptionPointVO. Reason:" + e.getMessage(), e);
            }
        }
        return interceptionPointVO;
    }

    public InterceptionPoint getInterceptionPointWithName(String interceptorPointName, Database db) throws SystemException, Bug {
        InterceptionPoint interceptorPoint = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.InterceptionPointImpl f WHERE f.name = $1");
            oql.bind((Object)interceptorPointName);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode:" + interceptorPointName));
            if (results.hasMore()) {
                interceptorPoint = (InterceptionPoint)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch an InterceptionPointVO. Reason:" + e.getMessage(), e);
        }
        return interceptorPoint;
    }

    public List getInterceptionPointVOList(String category) throws SystemException, Bug {
        List interceptionPointVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptionPointController.beginTransaction(db);
            interceptionPointVOList = InterceptionPointController.toVOList(this.getInterceptionPointList(category, db));
            InterceptionPointController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptionPointController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return interceptionPointVOList;
    }

    public List getInterceptionPointList(String category, Database db) throws SystemException, Bug {
        ArrayList<InterceptionPoint> interceptionPoints = new ArrayList<InterceptionPoint>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.InterceptionPointImpl f WHERE f.category = $1");
            oql.bind((Object)category);
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode:" + category));
            while (results.hasMore()) {
                InterceptionPoint interceptionPoint = (InterceptionPoint)results.next();
                interceptionPoints.add(interceptionPoint);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch an InterceptionPointVO. Reason:" + e.getMessage(), e);
        }
        return interceptionPoints;
    }

    public InterceptionPointVO create(InterceptionPointVO interceptionPointVO) throws ConstraintException, SystemException {
        InterceptionPointVO newInterceptionPointVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptionPointController.beginTransaction(db);
            newInterceptionPointVO = this.create(interceptionPointVO, db);
            InterceptionPointController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptionPointController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return newInterceptionPointVO;
    }

    public InterceptionPointVO create(InterceptionPointVO interceptionPointVO, Database db) throws SystemException, Exception {
        InterceptionPointImpl interceptionPoint = new InterceptionPointImpl();
        interceptionPoint.setValueObject(interceptionPointVO);
        db.create((Object)interceptionPoint);
        return interceptionPoint.getValueObject();
    }

    public InterceptionPointVO update(InterceptionPointVO interceptionPointVO) throws ConstraintException, SystemException {
        return (InterceptionPointVO)InterceptionPointController.updateEntity(InterceptionPointImpl.class, interceptionPointVO);
    }

    public void update(InterceptionPointVO interceptionPointVO, String[] values) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            InterceptionPointController.beginTransaction(db);
            ConstraintExceptionBuffer ceb = interceptionPointVO.validate();
            ceb.throwIfNotEmpty();
            InterceptionPoint interceptionPoint = this.getInterceptionPointWithId(interceptionPointVO.getInterceptionPointId(), db);
            interceptionPoint.setValueObject(interceptionPointVO);
            Collection interceptors = interceptionPoint.getInterceptors();
            for (Interceptor interceptor : interceptors) {
                interceptor.getInterceptionPoints().remove(interceptor);
            }
            interceptionPoint.getInterceptors().clear();
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    String interceptorId = values[i];
                    Interceptor interceptor = InterceptorController.getController().getInterceptorWithId(new Integer(interceptorId), db);
                    interceptionPoint.getInterceptors().add(interceptor);
                    interceptor.getInterceptionPoints().add(interceptionPoint);
                    ++i;
                }
            }
            logger.info((Object)("Interceptors:" + interceptionPoint.getInterceptors().size()));
            InterceptionPointController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            InterceptionPointController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(InterceptionPointVO interceptionPointVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        InterceptionPointController.beginTransaction(db);
        try {
            InterceptionPoint interceptionPoint = this.getInterceptionPointWithId(interceptionPointVO.getInterceptionPointId(), db);
            List accessRights = AccessRightController.getController().getAccessRightList(interceptionPoint.getInterceptionPointId(), db);
            Iterator accessRightsIterator = accessRights.iterator();
            while (accessRightsIterator.hasNext()) {
                AccessRight accessRight = (AccessRight)accessRightsIterator.next();
                Iterator groupIterator = accessRight.getGroups().iterator();
                while (groupIterator.hasNext()) {
                    AccessRightGroup group = (AccessRightGroup)groupIterator.next();
                    groupIterator.remove();
                    db.remove((Object)group);
                }
                Iterator roleIterator = accessRight.getRoles().iterator();
                while (roleIterator.hasNext()) {
                    AccessRightRole role = (AccessRightRole)roleIterator.next();
                    roleIterator.remove();
                    db.remove((Object)role);
                }
                Iterator userIterator = accessRight.getUsers().iterator();
                while (userIterator.hasNext()) {
                    AccessRightUser user = (AccessRightUser)userIterator.next();
                    userIterator.remove();
                    db.remove((Object)user);
                }
                db.remove((Object)accessRight);
                accessRightsIterator.remove();
            }
            db.remove((Object)interceptionPoint);
            InterceptionPointController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            InterceptionPointController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    @Override
    public BaseEntityVO getNewVO() {
        return new InterceptionPointVO();
    }
}

