/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.InfoGlueProperty;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.common.settings.controllers.CastorSettingsController;
import org.infoglue.common.settings.controllers.CastorSettingsPersister;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;
import webwork.action.ActionContext;

public class InfoGlueSettingsController
extends BaseController
implements CastorSettingsPersister {
    private static Log log = LogFactory.getLog(InfoGlueSettingsController.class);
    private DOMBuilder domBuilder = new DOMBuilder();
    private CastorSettingsController settingsController = CastorSettingsController.getController(this);

    public static InfoGlueSettingsController getInfoGlueSettingsController() {
        return new InfoGlueSettingsController();
    }

    private InfoGlueSettingsController() {
    }

    public InfoGlueProperty getPropertyWithId(Integer id, Database db) throws SystemException, Bug {
        return (InfoGlueProperty)InfoGlueSettingsController.getObjectWithId(InfoGlueProperty.class, id, db);
    }

    public List getSystemSettings(String bundleName) {
        return this.settingsController.getSystemSettings(bundleName);
    }

    public List getSettingsVariations(String nameSpace, String name, Database database) throws Exception {
        return this.settingsController.getSettingsVariations(nameSpace, name, database);
    }

    private Document getPropertyDocument(String nameSpace, String name, Database database) throws Exception {
        return this.settingsController.getPropertyDocument(nameSpace, name, database);
    }

    public void addVariation(String nameSpace, String variationId, Database database) throws Exception {
        this.settingsController.addVariation(nameSpace, "systemSettings", variationId, database);
    }

    public void addVariation(String nameSpace, String name, String variationId, Database database) throws Exception {
        this.settingsController.addVariation(nameSpace, name, variationId, database);
    }

    public void removeVariation(String nameSpace, String variationId, Database database) throws Exception {
        this.settingsController.removeVariation(nameSpace, "systemSettings", variationId, database);
    }

    public void removeVariation(String nameSpace, String name, String variationId, Database database) throws Exception {
        this.settingsController.removeVariation(nameSpace, name, variationId, database);
    }

    public void removeProperty(String nameSpace, String variationId, String key, Database database) throws Exception {
        this.settingsController.removeProperty(nameSpace, "systemSettings", variationId, key, database);
    }

    public void removeProperty(String nameSpace, String name, String variationId, String key, Database database) throws Exception {
        this.settingsController.removeProperty(nameSpace, name, variationId, key, database);
    }

    public void updateSettings(String nameSpace, String variationId, Map properties, Database database) throws Exception {
        this.settingsController.updateSettings(nameSpace, "systemSettings", variationId, properties, database);
    }

    public void updateSettings(String nameSpace, String name, String variationId, Map properties, Database database) throws Exception {
        this.settingsController.updateSettings(nameSpace, name, variationId, properties, database);
    }

    public void updateSetting(String nameSpace, String name, String variationId, String key, String value, Database database) throws Exception {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        propertiesMap.put(key, value);
        this.settingsController.updateSettings(nameSpace, name, variationId, propertiesMap, database);
    }

    public String getSetting(String nameSpace, String name, String derivedValue, String variationId, Database database) throws Exception {
        return this.settingsController.getSetting(nameSpace, name, derivedValue, variationId, database);
    }

    public InfoGlueProperty getProperty(Integer id, Database database) throws Exception {
        InfoGlueProperty property = (InfoGlueProperty)database.load(InfoGlueProperty.class, (Object)id);
        return property;
    }

    public InfoGlueProperty getProperty(String nameSpace, String name, Database database) throws Exception {
        InfoGlueProperty property = null;
        boolean localTransaction = false;
        if (database == null) {
            localTransaction = true;
            database = CastorDatabaseService.getDatabase();
            database.begin();
        }
        OQLQuery oql = database.getOQLQuery("SELECT p FROM org.infoglue.cms.entities.management.InfoGlueProperty p WHERE p.nameSpace = $1 AND p.name = $2 ORDER BY p.id");
        oql.bind((Object)nameSpace);
        oql.bind((Object)name);
        QueryResults results = oql.execute();
        if (results.hasMore()) {
            property = (InfoGlueProperty)results.next();
        }
        results.close();
        oql.close();
        if (localTransaction) {
            database.commit();
            database.close();
        }
        return property;
    }

    public InfoGlueProperty createProperty(String nameSpace, String name, String value, Database database) throws Exception {
        boolean localTransaction = false;
        if (database == null) {
            localTransaction = true;
            database = CastorDatabaseService.getDatabase();
            database.begin();
        }
        InfoGlueProperty property = new InfoGlueProperty();
        property.setNameSpace(nameSpace);
        property.setName(name);
        property.setValue(value);
        database.create((Object)property);
        if (localTransaction) {
            database.commit();
            database.close();
        }
        log.debug((Object)("Creating property with:" + nameSpace + ":" + name));
        return property;
    }

    public void updateProperty(String nameSpace, String name, String value, Database database) throws Exception {
        InfoGlueProperty property;
        boolean localTransaction = false;
        if (database == null) {
            localTransaction = true;
            database = CastorDatabaseService.getDatabase();
            database.begin();
        }
        if ((property = this.getProperty(nameSpace, name, database)) == null) {
            property = this.createProperty(nameSpace, name, value, database);
        }
        this.updateProperty(property, value, database);
        if (localTransaction) {
            database.commit();
            database.close();
        }
    }

    public void updateProperty(InfoGlueProperty property, String value, Database database) throws Exception {
        property.setValue(value);
    }

    public String getProperty(String key, String variationId, boolean skipInfoGlueProperty, boolean fallbackToDefault, boolean fallbackToKey, boolean useDerivedValue, Database database) {
        return this.getProperty(key, "systemSettings", variationId, skipInfoGlueProperty, fallbackToDefault, fallbackToKey, useDerivedValue, database);
    }

    public String getProperty(String key, String name, String variationId, boolean skipInfoGlueProperty, boolean fallbackToDefault, boolean fallbackToKey, boolean useDerivedValue, Database database) {
        return this.getPropertyFromPropertySet(key, name, variationId, skipInfoGlueProperty, fallbackToDefault, fallbackToKey, useDerivedValue, database);
    }

    public String getPropertyFromPropertySet(String key, String name, String variationId, boolean skipInfoGlueProperty, boolean fallbackToDefault, boolean fallbackToKey, boolean useDerivedValue, Database database) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        return ps.getString(key);
    }

    public String getPropertyFromInfoGlue(String key, String name, String variationId, boolean skipInfoGlueProperty, boolean fallbackToDefault, boolean fallbackToKey, boolean useDerivedValue, Database database) {
        NullComparator nullComparator = new NullComparator();
        Object value = null;
        Object newValue = null;
        String cacheKey = key + "_" + name + "_" + variationId + "_" + skipInfoGlueProperty + "_" + fallbackToDefault + "_" + fallbackToKey + "_" + useDerivedValue;
        Object cacheObject = CacheController.getCachedObject("serverNodePropertiesCache", cacheKey);
        if (cacheObject instanceof NullObject) {
            return null;
        }
        if (cacheObject != null) {
            return cacheObject.toString().trim();
        }
        String property = "";
        if (fallbackToKey) {
            property = key;
        }
        try {
            Object derivedObject;
            String derivedValue = null;
            if (useDerivedValue && (derivedObject = InfoGlueSettingsController.findOnValueStack(key)) != null) {
                derivedValue = derivedObject.toString();
            }
            if (!skipInfoGlueProperty) {
                property = derivedValue != null ? InfoGlueSettingsController.getInfoGlueSettingsController().getSetting("infoglueCMS", name, derivedValue, variationId, database) : InfoGlueSettingsController.getInfoGlueSettingsController().getSetting("infoglueCMS", name, key, variationId, database);
            }
            if (skipInfoGlueProperty || (property == null || property.equals("")) && fallbackToDefault) {
                property = derivedValue != null ? CmsPropertyHandler.getProperty(derivedValue) : CmsPropertyHandler.getProperty(key);
            }
            if ((property == null || property.equals("")) && fallbackToKey) {
                property = key;
            }
            if (property == null) {
                CacheController.cacheObject("serverNodePropertiesCache", cacheKey, new NullObject());
            } else {
                CacheController.cacheObject("serverNodePropertiesCache", cacheKey, property);
            }
        }
        catch (Exception e) {
            log.warn((Object)("An property was not found for key: " + key + ": " + e.getMessage()), (Throwable)e);
        }
        return property;
    }

    public static Object findOnValueStack(String expr) {
        ActionContext a = ActionContext.getContext();
        Object value = ActionContext.getValueStack().findValue(expr);
        return value;
    }

    public void setInfoGlueProperty(String string, String string2, String string3, String allowedContentTypeNames) {
    }

    public BaseEntityVO getNewVO() {
        return null;
    }

    public InfoGlueProperty getProperty(Long id, Database database) throws Exception {
        return null;
    }
}

