/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class InfoGluePrincipalControllerProxy
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)InfoGluePrincipalControllerProxy.class.getName());

    public static InfoGluePrincipalControllerProxy getController() {
        return new InfoGluePrincipalControllerProxy();
    }

    public String getPrincipalPropertyValue(InfoGluePrincipal infoGluePrincipal, String propertyName, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, boolean escapeSpecialCharacters, boolean findLargestValue) throws Exception {
        String value = "";
        if (infoGluePrincipal == null || propertyName == null) {
            return null;
        }
        Database db = CastorDatabaseService.getDatabase();
        InfoGluePrincipalControllerProxy.beginTransaction(db);
        try {
            value = this.getPrincipalPropertyValue(db, infoGluePrincipal, propertyName, languageId, siteNodeId, useLanguageFallback, escapeSpecialCharacters, findLargestValue);
            InfoGluePrincipalControllerProxy.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            InfoGluePrincipalControllerProxy.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return value;
    }

    public String getPrincipalPropertyValue(Database db, InfoGluePrincipal infoGluePrincipal, String propertyName, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, boolean escapeSpecialCharacters, boolean findLargestValue) throws Exception {
        LanguageVO masterLanguageVO;
        String propertyXML;
        DOMBuilder domBuilder;
        Document document;
        Node node;
        String largestValue;
        String key = infoGluePrincipal.getName() + "_" + propertyName + "_" + languageId + "_" + siteNodeId + "_" + useLanguageFallback + "_" + escapeSpecialCharacters + "_" + findLargestValue;
        logger.info((Object)("key:" + key));
        String object = (String)CacheController.getCachedObject("principalPropertyValueCache", key);
        if (object instanceof NullObject) {
            logger.info((Object)("There was an cached property but it was null:" + object));
            return null;
        }
        if (object != null) {
            logger.info((Object)("There was an cached principalPropertyValue:" + object));
            return object;
        }
        String value = "";
        if (infoGluePrincipal == null || propertyName == null) {
            return null;
        }
        List userPropertiesList = UserPropertiesController.getController().getUserPropertiesList(infoGluePrincipal.getName(), languageId, db, true);
        for (UserProperties userProperties : userPropertiesList) {
            String propertyXML2;
            DOMBuilder domBuilder2;
            Document document2;
            Node node2;
            if (userProperties == null || !userProperties.getLanguage().getLanguageId().equals(languageId) || userProperties.getValue() == null || propertyName == null || (node2 = (document2 = (domBuilder2 = new DOMBuilder()).getDocument(propertyXML2 = userProperties.getValue())).getRootElement().selectSingleNode("attributes/" + propertyName)) == null) continue;
            value = node2.getStringValue();
            logger.info((Object)("Getting value: " + value));
            if (value == null || !escapeSpecialCharacters) break;
            value = new VisualFormatter().escapeHTML(value);
            break;
        }
        if (value.equals("")) {
            List roles = infoGluePrincipal.getRoles();
            largestValue = "-1";
            block1: for (InfoGlueRole role : roles) {
                List rolePropertiesList = RolePropertiesController.getController().getRolePropertiesList(role.getName(), languageId, db, true);
                for (RoleProperties roleProperties : rolePropertiesList) {
                    if (roleProperties == null || !roleProperties.getLanguage().getLanguageId().equals(languageId) || roleProperties.getValue() == null || propertyName == null || (node = (document = (domBuilder = new DOMBuilder()).getDocument(propertyXML = roleProperties.getValue())).getRootElement().selectSingleNode("attributes/" + propertyName)) == null) continue;
                    value = node.getStringValue();
                    logger.info((Object)("Getting value: " + value));
                    if (value != null && escapeSpecialCharacters) {
                        value = new VisualFormatter().escapeHTML(value);
                    }
                    if (value == null || value.equals("") || !findLargestValue || new Integer(largestValue) >= new Integer(value)) continue block1;
                    largestValue = value;
                    continue block1;
                }
            }
            if (findLargestValue) {
                value = largestValue;
            }
            if (value.equals("") && useLanguageFallback && !(masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageId().equals(languageId)) {
                value = this.getPrincipalPropertyValue(infoGluePrincipal, propertyName, masterLanguageVO.getLanguageId(), siteNodeId, useLanguageFallback, escapeSpecialCharacters, findLargestValue);
            }
        }
        if (value.equals("")) {
            List groups = infoGluePrincipal.getGroups();
            largestValue = "-1";
            block3: for (InfoGlueGroup group : groups) {
                List groupPropertiesList = GroupPropertiesController.getController().getGroupPropertiesList(group.getName(), languageId, db, true);
                for (GroupProperties groupProperties : groupPropertiesList) {
                    if (groupProperties == null || !groupProperties.getLanguage().getLanguageId().equals(languageId) || groupProperties.getValue() == null || propertyName == null || (node = (document = (domBuilder = new DOMBuilder()).getDocument(propertyXML = groupProperties.getValue())).getRootElement().selectSingleNode("attributes/" + propertyName)) == null) continue;
                    value = node.getStringValue();
                    logger.info((Object)("Getting value: " + value));
                    if (value != null && escapeSpecialCharacters) {
                        value = new VisualFormatter().escapeHTML(value);
                    }
                    if (value == null || value.equals("") || !findLargestValue || new Integer(largestValue) >= new Integer(value)) continue block3;
                    largestValue = value;
                    continue block3;
                }
            }
            if (findLargestValue) {
                value = largestValue;
            }
            if (value.equals("") && useLanguageFallback && !(masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForSiteNode(db, siteNodeId)).getLanguageId().equals(languageId)) {
                value = this.getPrincipalPropertyValue(infoGluePrincipal, propertyName, masterLanguageVO.getLanguageId(), siteNodeId, useLanguageFallback, escapeSpecialCharacters, findLargestValue);
            }
        }
        if (value != null) {
            CacheController.getCachedObject("principalPropertyValueCache", key);
        }
        if (value != null) {
            CacheController.cacheObject("principalPropertyValueCache", key, value);
        } else {
            CacheController.cacheObject("principalPropertyValueCache", key, new NullObject());
        }
        return value;
    }

    public Map getPrincipalPropertyHashValues(InfoGluePrincipal infoGluePrincipal, String propertyName, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, boolean escapeSpecialCharacters) throws Exception {
        Properties properties = new Properties();
        String attributeValue = this.getPrincipalPropertyValue(infoGluePrincipal, propertyName, languageId, siteNodeId, useLanguageFallback, escapeSpecialCharacters, false);
        ByteArrayInputStream is = new ByteArrayInputStream(attributeValue.getBytes("UTF-8"));
        properties.load(is);
        return properties;
    }

    public Map getPrincipalPropertyHashValues(Database db, InfoGluePrincipal infoGluePrincipal, String propertyName, Integer languageId, Integer siteNodeId, boolean useLanguageFallback, boolean escapeSpecialCharacters) throws Exception {
        Properties properties = new Properties();
        String attributeValue = this.getPrincipalPropertyValue(db, infoGluePrincipal, propertyName, languageId, siteNodeId, useLanguageFallback, escapeSpecialCharacters, false);
        ByteArrayInputStream is = new ByteArrayInputStream(attributeValue.getBytes("UTF-8"));
        properties.load(is);
        return properties;
    }

    public InfoGluePrincipal getTestPrincipal() {
        return new InfoGluePrincipal("TestUser", "none", "none", "none", new ArrayList(), new ArrayList(), true, null);
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

