/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RegistryVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.DateHelper;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InconsistenciesController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)InconsistenciesController.class.getName());

    public static InconsistenciesController getController() {
        return new InconsistenciesController();
    }

    public List getAllInconsistencies() throws Exception {
        ArrayList inconsistencies = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        try {
            InconsistenciesController.beginTransaction(db);
            List registryVOList = RegistryController.getController().getRegistryVOList(db);
            if (registryVOList != null && registryVOList.size() > 0) {
                for (RegistryVO registryVO : registryVOList) {
                    if (registryVO.getEntityName().equals(Content.class.getName())) {
                        try {
                            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(registryVO.getEntityId()), db);
                            if (contentVO != null) continue;
                            this.addContentInconsistency(inconsistencies, registryVO, db);
                        }
                        catch (Exception e) {
                            this.addContentInconsistency(inconsistencies, registryVO, db);
                        }
                        continue;
                    }
                    if (registryVO.getEntityName().equals(SiteNode.class.getName())) {
                        try {
                            SiteNodeController.getController();
                            SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(new Integer(registryVO.getEntityId()), db);
                            if (siteNodeVO != null) continue;
                            this.addSiteNodeInconsistency(inconsistencies, registryVO, db);
                        }
                        catch (Exception e) {
                            this.addSiteNodeInconsistency(inconsistencies, registryVO, db);
                        }
                        continue;
                    }
                    logger.error((Object)("The registry contained not supported entities:" + registryVO.getEntityName()));
                }
            }
            InconsistenciesController.commitTransaction(db);
        }
        catch (Exception e) {
            InconsistenciesController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch which sitenode uses a metainfo. Reason:" + e.getMessage(), e);
        }
        return inconsistencies;
    }

    private void addContentInconsistency(List inconsistencies, RegistryVO registryVO, Database db) throws Exception {
        try {
            String referencingEntityName = registryVO.getReferencingEntityName();
            String referencingEntityCompletingName = registryVO.getReferencingEntityCompletingName();
            Integer referencingEntityId = new Integer(registryVO.getReferencingEntityId());
            Integer referencingEntityCompletingId = new Integer(registryVO.getReferencingEntityCompletingId());
            if (referencingEntityCompletingName.equals(SiteNode.class.getName())) {
                SiteNodeController.getController();
                SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(referencingEntityCompletingId, db);
                if (siteNodeVO != null) {
                    LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(siteNodeVO.getRepositoryId());
                    SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersionVO(db, siteNodeVO.getId());
                    if (siteNodeVersionVO != null && siteNodeVersionVO.getId().intValue() == referencingEntityId.intValue()) {
                        inconsistencies.add(registryVO);
                    }
                }
            } else if (referencingEntityCompletingName.equals(Content.class.getName())) {
                ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(registryVO.getReferencingEntityCompletingId()), db);
                if (contentVO != null) {
                    LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                    ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), masterLanguageVO.getId(), db);
                    if (contentVersionVO != null && contentVersionVO.getId().intValue() == referencingEntityId.intValue()) {
                        inconsistencies.add(registryVO);
                    }
                }
            } else {
                logger.error((Object)("The registry contained a not supported referencingEntityCompletingName:" + referencingEntityCompletingName));
            }
        }
        catch (Exception e) {
            logger.error((Object)("There seems to be a problem with finding the inconsistency for registryVO " + registryVO.getRegistryId() + ":" + e.getMessage()));
        }
    }

    private void addSiteNodeInconsistency(List inconsistencies, RegistryVO registryVO, Database db) throws Exception {
        try {
            String referencingEntityName = registryVO.getReferencingEntityName();
            String referencingEntityCompletingName = registryVO.getReferencingEntityCompletingName();
            Integer referencingEntityId = new Integer(registryVO.getReferencingEntityId());
            Integer referencingEntityCompletingId = new Integer(registryVO.getReferencingEntityCompletingId());
            if (referencingEntityCompletingName.equals(SiteNode.class.getName())) {
                SiteNodeController.getController();
                SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(new Integer(registryVO.getReferencingEntityCompletingId()), db);
                if (siteNodeVO != null) {
                    LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(siteNodeVO.getRepositoryId());
                    SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersionVO(db, siteNodeVO.getId());
                    if (siteNodeVersionVO != null && siteNodeVersionVO.getId().intValue() == referencingEntityId.intValue()) {
                        inconsistencies.add(registryVO);
                    }
                }
            } else if (referencingEntityCompletingName.equals(Content.class.getName())) {
                ContentVO contentVO = ContentController.getContentController().getContentVOWithId(new Integer(registryVO.getReferencingEntityCompletingId()), db);
                if (contentVO != null) {
                    LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId());
                    ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), masterLanguageVO.getId(), db);
                    if (contentVersionVO != null && contentVersionVO.getId().intValue() == referencingEntityId.intValue()) {
                        inconsistencies.add(registryVO);
                    }
                }
            } else {
                logger.error((Object)("The registry contained a not supported referencingEntityCompletingName:" + referencingEntityCompletingName));
            }
        }
        catch (Exception e) {
            logger.error((Object)("There seems to be a problem with finding the inconsistency for registryVO " + registryVO.getRegistryId() + ":" + e.getMessage()));
        }
    }

    public void removeReferences(Integer registryId, InfoGluePrincipal infoGluePrincipal) throws SystemException, Exception {
        RegistryVO registryVO = RegistryController.getController().getRegistryVOWithId(registryId);
        String entityName = registryVO.getEntityName();
        String referencingEntityName = registryVO.getReferencingEntityName();
        String referencingEntityCompletingName = registryVO.getReferencingEntityCompletingName();
        Integer entityId = new Integer(registryVO.getEntityId());
        Integer referencingEntityId = new Integer(registryVO.getReferencingEntityId());
        Integer referencingEntityCompletingId = new Integer(registryVO.getReferencingEntityCompletingId());
        if (referencingEntityCompletingName.equals(SiteNode.class.getName())) {
            SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(new Integer(registryVO.getReferencingEntityCompletingId()));
            if (siteNodeVO != null) {
                Integer metaInfoContentId = siteNodeVO.getMetaInfoContentId();
                LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(siteNodeVO.getRepositoryId());
                String pageStructure = ContentController.getContentController().getContentAttribute(metaInfoContentId, masterLanguageVO.getId(), "ComponentStructure");
                if (registryVO.getReferenceType().equals(RegistryVO.PAGE_COMPONENT)) {
                    pageStructure = this.deleteComponentFromXML(pageStructure, new Integer(registryVO.getEntityId()));
                }
                if (registryVO.getReferenceType().equals(RegistryVO.PAGE_COMPONENT_BINDING)) {
                    pageStructure = this.deleteComponentBindingFromXML(pageStructure, new Integer(registryVO.getEntityId()), registryVO.getEntityName());
                }
                ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(metaInfoContentId, masterLanguageVO.getId());
                ContentVersionController.getContentVersionController().updateAttributeValue(contentVersionVO.getContentVersionId(), "ComponentStructure", pageStructure, infoGluePrincipal);
            }
        } else if (referencingEntityCompletingName.equals(Content.class.getName())) {
            ContentVersionVO contentVersionVO;
            if (referencingEntityName.equals(ContentVersion.class.getName()) && (contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(referencingEntityId)) != null) {
                String versionValue = contentVersionVO.getVersionValue();
                if (registryVO.getReferenceType().equals(RegistryVO.INLINE_LINK)) {
                    versionValue = this.deleteInlineLinks(versionValue, new Integer(registryVO.getEntityId()));
                }
                if (registryVO.getReferenceType().equals(RegistryVO.INLINE_ASSET)) {
                    versionValue = this.deleteInlineAssets(versionValue, new Integer(registryVO.getEntityId()));
                }
                if (registryVO.getReferenceType().equals(RegistryVO.INLINE_SITE_NODE_RELATION)) {
                    versionValue = this.deleteInlineSiteNodeRelations(versionValue, new Integer(registryVO.getEntityId()));
                }
                if (registryVO.getReferenceType().equals(RegistryVO.INLINE_CONTENT_RELATION)) {
                    versionValue = this.deleteInlineContentRelations(versionValue, new Integer(registryVO.getEntityId()));
                }
                contentVersionVO.setVersionModifier(infoGluePrincipal.getName());
                contentVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                contentVersionVO.setVersionValue(versionValue);
                ContentVersionController.getContentVersionController().update(contentVersionVO.getContentId(), contentVersionVO.getLanguageId(), contentVersionVO);
            }
        } else {
            logger.error((Object)("The registry contained a not supported referencingEntityCompletingName:" + referencingEntityCompletingName));
        }
    }

    private String deleteInlineContentRelations(String versionValue, Integer contentId) {
        String cleanedVersionValue = versionValue;
        StringBuffer cleanedVersionValueBuffer = new StringBuffer();
        int qualifyerEndIndex = 0;
        int qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity='Content'>");
        if (qualifyerStartIndex == -1) {
            qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity=\"Content\">");
        }
        while (qualifyerStartIndex > -1) {
            cleanedVersionValueBuffer.append(versionValue.substring(qualifyerEndIndex, qualifyerStartIndex));
            qualifyerEndIndex = cleanedVersionValue.indexOf("</qualifyer>", qualifyerStartIndex);
            if (qualifyerEndIndex != -1) {
                String qualifyerString = versionValue.substring(qualifyerStartIndex, qualifyerEndIndex);
                String cleanedQualifyerString = qualifyerString.replaceAll("<id>" + contentId + "</id>", "");
                cleanedVersionValueBuffer.append(cleanedQualifyerString);
            }
            if ((qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity='Content'>", qualifyerEndIndex)) != -1) continue;
            qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity=\"Content\">");
        }
        cleanedVersionValueBuffer.append(versionValue.substring(qualifyerEndIndex));
        cleanedVersionValue = cleanedVersionValueBuffer.toString();
        return cleanedVersionValue;
    }

    private String deleteInlineSiteNodeRelations(String versionValue, Integer siteNodeId) {
        String cleanedVersionValue = versionValue;
        StringBuffer cleanedVersionValueBuffer = new StringBuffer();
        int qualifyerEndIndex = 0;
        int qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity='SiteNode'>");
        if (qualifyerStartIndex == -1) {
            qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity=\"SiteNode\">");
        }
        while (qualifyerStartIndex > -1) {
            cleanedVersionValueBuffer.append(versionValue.substring(qualifyerEndIndex, qualifyerStartIndex));
            qualifyerEndIndex = cleanedVersionValue.indexOf("</qualifyer>", qualifyerStartIndex);
            if (qualifyerEndIndex != -1) {
                String qualifyerString = versionValue.substring(qualifyerStartIndex, qualifyerEndIndex);
                String cleanedQualifyerString = qualifyerString.replaceAll("<id>" + siteNodeId + "</id>", "");
                cleanedVersionValueBuffer.append(cleanedQualifyerString);
            }
            if ((qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity='SiteNode'>", qualifyerEndIndex)) != -1) continue;
            qualifyerStartIndex = cleanedVersionValue.indexOf("<qualifyer entity=\"SiteNode\">");
        }
        cleanedVersionValueBuffer.append(versionValue.substring(qualifyerEndIndex));
        cleanedVersionValue = cleanedVersionValueBuffer.toString();
        return cleanedVersionValue;
    }

    private String deleteInlineAssets(String versionValue, Integer contentId) {
        String cleanedVersionValue = versionValue;
        try {
            String linkString;
            logger.info((Object)("versionValue:" + versionValue));
            HashMap<String, String> replaces = new HashMap<String, String>();
            int startIndex = versionValue.indexOf("<a ");
            int endIndex = versionValue.indexOf("</a>", startIndex) + 4;
            int offset = startIndex;
            while (startIndex > -1 && endIndex > startIndex) {
                linkString = versionValue.substring(startIndex, endIndex);
                logger.info((Object)("linkString:" + linkString));
                if (linkString.indexOf("getInlineAssetUrl(" + contentId + ",") > -1) {
                    int linkTextStartIndex = linkString.indexOf(">");
                    int linkTextEndIndex = linkString.indexOf("</a>");
                    String linkText = linkString.substring(linkTextStartIndex + 1, linkTextEndIndex);
                    logger.info((Object)("linkText:" + linkText));
                    replaces.put(linkString, linkText);
                }
                startIndex = versionValue.indexOf("<a ", offset);
                offset = endIndex = versionValue.indexOf("</a>", startIndex) + 4;
            }
            startIndex = versionValue.indexOf("<img ");
            endIndex = versionValue.indexOf("/>", startIndex) + 2;
            offset = startIndex;
            while (startIndex > -1 && endIndex > startIndex) {
                linkString = versionValue.substring(startIndex, endIndex);
                logger.info((Object)("linkString:" + linkString));
                if (linkString.indexOf("getInlineAssetUrl(" + contentId + ",") > -1) {
                    String linkText = "";
                    replaces.put(linkString, linkText);
                }
                startIndex = versionValue.indexOf("<img ", offset);
                offset = endIndex = versionValue.indexOf("/>", startIndex) + 2;
            }
            for (String original : replaces.keySet()) {
                String linkText = (String)replaces.get(original);
                int offsetFinal = 0;
                int linkStart = cleanedVersionValue.indexOf(original, offsetFinal);
                while (linkStart > -1) {
                    StringBuffer result = new StringBuffer();
                    result.append(cleanedVersionValue.substring(offsetFinal, linkStart));
                    result.append(linkText);
                    offsetFinal = cleanedVersionValue.indexOf(original, offsetFinal) + original.length();
                    result.append(cleanedVersionValue.substring(offsetFinal));
                    cleanedVersionValue = result.toString();
                    linkStart = cleanedVersionValue.indexOf(original, offsetFinal);
                }
            }
            logger.info((Object)("cleanedVersionValue:" + cleanedVersionValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cleanedVersionValue;
    }

    private String deleteInlineLinks(String versionValue, Integer siteNodeId) {
        String cleanedVersionValue = versionValue;
        try {
            logger.info((Object)("versionValue:" + versionValue));
            int startIndex = versionValue.indexOf("<a ");
            int endIndex = versionValue.indexOf("</a>", startIndex) + 4;
            int offset = startIndex;
            HashMap<String, String> replaces = new HashMap<String, String>();
            while (startIndex > -1 && endIndex > startIndex) {
                String linkString = versionValue.substring(startIndex, endIndex);
                logger.info((Object)("linkString:" + linkString));
                if (linkString.indexOf("getPageUrl(" + siteNodeId + ",") > -1) {
                    int linkTextStartIndex = linkString.indexOf(">");
                    int linkTextEndIndex = linkString.indexOf("</a>");
                    String linkText = linkString.substring(linkTextStartIndex + 1, linkTextEndIndex);
                    logger.info((Object)("linkText:" + linkText));
                    replaces.put(linkString, linkText);
                }
                startIndex = versionValue.indexOf("<a ", offset);
                offset = endIndex = versionValue.indexOf("</a>", startIndex) + 4;
            }
            for (String original : replaces.keySet()) {
                String linkText = (String)replaces.get(original);
                int offsetFinal = 0;
                int linkStart = cleanedVersionValue.indexOf(original, offsetFinal);
                while (linkStart > -1) {
                    StringBuffer result = new StringBuffer();
                    result.append(cleanedVersionValue.substring(offsetFinal, linkStart));
                    result.append(linkText);
                    offsetFinal = cleanedVersionValue.indexOf(original, offsetFinal) + original.length();
                    result.append(cleanedVersionValue.substring(offsetFinal));
                    cleanedVersionValue = result.toString();
                    linkStart = cleanedVersionValue.indexOf(original, offsetFinal);
                }
            }
            logger.info((Object)("cleanedVersionValue:" + cleanedVersionValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cleanedVersionValue;
    }

    private String deleteComponentFromXML(String componentXML, Integer contentId) throws Exception {
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentXPath = "//component[@contentId=" + contentId + "]";
        String modifiedXML = null;
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
        int i = 0;
        while (i < anl.getLength()) {
            Element component = (Element)anl.item(i);
            component.getParentNode().removeChild(component);
            ++i;
        }
        modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
        return modifiedXML;
    }

    private String deleteComponentBindingFromXML(String componentXML, Integer entityId, String entityName) throws Exception {
        String entityNameTrigger = "Content";
        if (entityName.equals(SiteNode.class.getName())) {
            entityNameTrigger = "SiteNode";
        }
        Document document = XMLHelper.readDocumentFromByteArray(componentXML.getBytes("UTF-8"));
        String componentPropertyXPath = "//component/properties/property/binding[@entityId='" + entityId + "']";
        String modifiedXML = null;
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
        int i = 0;
        while (i < anl.getLength()) {
            Element component = (Element)anl.item(i);
            String entity = component.getAttribute("entity");
            if (entity != null && entity.equalsIgnoreCase(entityNameTrigger)) {
                Element property = (Element)component.getParentNode();
                if (property.getChildNodes().getLength() > 1) {
                    property.removeChild(component);
                } else if (property != null && property.getParentNode() != null) {
                    property.getParentNode().removeChild(property);
                }
            }
            ++i;
        }
        modifiedXML = XMLHelper.serializeDom(document, new StringBuffer()).toString();
        return modifiedXML;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

