/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Unmarshaller;
import org.infoglue.cms.controllers.kernel.impl.simple.AvailableServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentCategory;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.AccessRightGroup;
import org.infoglue.cms.entities.management.AccessRightRole;
import org.infoglue.cms.entities.management.AvailableServiceBinding;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.InterceptionPoint;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.ServiceDefinition;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinition;
import org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.InfoGlueExportImpl;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.SiteNodeTypeDefinitionImpl;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.impl.simple.ServiceBindingImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeImpl;
import org.infoglue.cms.entities.structure.impl.simple.SiteNodeVersionImpl;
import org.infoglue.cms.exception.SystemException;

public class ImportController
extends BaseController {
    public static final Logger logger = Logger.getLogger((String)ImportController.class.getName());

    public static ImportController getController() {
        return new ImportController();
    }

    public void importRepository(Database db, Mapping map, File file, String encoding, int version, String onlyLatestVersions, Map contentIdMap, Map siteNodeIdMap, List allContentIds) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)fis, encoding);
        Unmarshaller unmarshaller = new Unmarshaller(map);
        unmarshaller.setWhitespacePreserve(true);
        InfoGlueExportImpl infoGlueExportImplRead = (InfoGlueExportImpl)unmarshaller.unmarshal((Reader)reader);
        Collection contentTypeDefinitions = infoGlueExportImplRead.getContentTypeDefinitions();
        logger.info((Object)("Found " + contentTypeDefinitions.size() + " content type definitions"));
        Collection categories = infoGlueExportImplRead.getCategories();
        logger.info((Object)("Found " + categories.size() + " categories"));
        HashMap categoryIdMap = new HashMap();
        HashMap contentTypeIdMap = new HashMap();
        this.importCategories(categories, null, categoryIdMap, db);
        this.updateContentTypeDefinitions(contentTypeDefinitions, categoryIdMap);
        List readSiteNodes = infoGlueExportImplRead.getRootSiteNode();
        List readContents = infoGlueExportImplRead.getRootContent();
        HashMap<String, String> repositoryIdMap = new HashMap<String, String>();
        HashMap siteNodeVersionIdMap = new HashMap();
        ArrayList allContents = new ArrayList();
        ArrayList allSiteNodes = new ArrayList();
        HashMap readAvailableServiceBindings = new HashMap();
        HashMap<String, Content> repositoryContentMap = new HashMap<String, Content>();
        for (Content readContentCandidate : readContents) {
            repositoryContentMap.put("" + readContentCandidate.getRepositoryId(), readContentCandidate);
        }
        for (SiteNode readSiteNode : readSiteNodes) {
            RepositoryImpl repositoryRead = readSiteNode.getRepository();
            logger.info((Object)repositoryRead.getName());
            Content readContent = null;
            readContent = (Content)repositoryContentMap.get("" + repositoryRead.getId());
            readContent.setRepository(repositoryRead);
            Integer repositoryIdBefore = repositoryRead.getId();
            db.create((Object)repositoryRead);
            Integer repositoryIdAfter = repositoryRead.getId();
            repositoryIdMap.put("" + repositoryIdBefore, "" + repositoryIdAfter);
            Collection repositoryLanguages = repositoryRead.getRepositoryLanguages();
            for (RepositoryLanguage repositoryLanguage : repositoryLanguages) {
                Language originalLanguage = repositoryLanguage.getLanguage();
                Language language = LanguageController.getController().getLanguageWithCode(originalLanguage.getLanguageCode(), db);
                if (language == null) {
                    db.create((Object)originalLanguage);
                    language = originalLanguage;
                }
                repositoryLanguage.setLanguage(language);
                repositoryLanguage.setRepository(repositoryRead);
                db.create((Object)repositoryLanguage);
                logger.info((Object)("language:" + language));
                logger.info((Object)("language.getRepositoryLanguages():" + language.getRepositoryLanguages()));
                language.getRepositoryLanguages().add(repositoryLanguage);
            }
            readSiteNode.setRepository(repositoryRead);
            System.out.println("***************************************\nreadContent:" + readContent.getName());
            this.createContents(readContent, contentIdMap, contentTypeIdMap, allContents, Collections.unmodifiableCollection(contentTypeDefinitions), categoryIdMap, version, db, onlyLatestVersions);
            this.createStructure(readSiteNode, contentIdMap, siteNodeIdMap, siteNodeVersionIdMap, readAvailableServiceBindings, allSiteNodes, db, onlyLatestVersions);
        }
        for (Content content : allContents) {
            allContentIds.add(content.getContentId());
        }
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        Hashtable<String, String> repositoryProperties = infoGlueExportImplRead.getRepositoryProperties();
        for (String key : repositoryProperties.keySet()) {
            String value = (String)repositoryProperties.get(key);
            String[] splittedString = key.split("_");
            if (splittedString.length != 3) continue;
            String oldRepId = splittedString[1];
            key = key.replaceAll(oldRepId, (String)repositoryIdMap.get(oldRepId));
            if (value == null || value.equals("null")) continue;
            if (key.indexOf("_WYSIWYGConfig") > -1 || key.indexOf("_StylesXML") > -1 || key.indexOf("_extraProperties") > -1) {
                ps.setData(key, value.getBytes("utf-8"));
                continue;
            }
            ps.setString(key, value);
        }
        Hashtable<String, String> contentProperties = infoGlueExportImplRead.getContentProperties();
        for (String key : contentProperties.keySet()) {
            String value = (String)contentProperties.get(key);
            String[] splittedString = key.split("_");
            if (splittedString.length != 3) continue;
            String oldContentId = splittedString[1];
            key = key.replaceAll(oldContentId, (String)contentIdMap.get(oldContentId));
            if (value == null || value.equals("null")) continue;
            ps.setString(key, value);
        }
        Hashtable<String, String> siteNodeProperties = infoGlueExportImplRead.getSiteNodeProperties();
        for (String key : siteNodeProperties.keySet()) {
            String value = (String)siteNodeProperties.get(key);
            String[] splittedString = key.split("_");
            if (splittedString.length != 3) continue;
            String oldSiteNodeId = splittedString[1];
            key = key.replaceAll(oldSiteNodeId, (String)siteNodeIdMap.get(oldSiteNodeId));
            if (value == null || value.equals("null")) continue;
            ps.setString(key, value);
        }
        Collection<AccessRight> accessRights = infoGlueExportImplRead.getAccessRights();
        for (AccessRight accessRight : accessRights) {
            InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithName(accessRight.getInterceptionPointName(), db);
            accessRight.setInterceptionPoint(interceptionPoint);
            if (interceptionPoint.getName().indexOf("Content") > -1) {
                accessRight.setParameters((String)contentIdMap.get(accessRight.getParameters()));
            } else if (interceptionPoint.getName().indexOf("SiteNodeVersion") > -1) {
                accessRight.setParameters((String)siteNodeVersionIdMap.get(accessRight.getParameters()));
            } else if (interceptionPoint.getName().indexOf("SiteNode") > -1) {
                accessRight.setParameters((String)siteNodeIdMap.get(accessRight.getParameters()));
            } else if (interceptionPoint.getName().indexOf("Repository") > -1) {
                accessRight.setParameters((String)repositoryIdMap.get(accessRight.getParameters()));
            }
            db.create((Object)accessRight);
            for (AccessRightRole accessRightRole : accessRight.getRoles()) {
                accessRightRole.setAccessRight(accessRight);
                db.create((Object)accessRightRole);
            }
            for (AccessRightGroup accessRightGroup : accessRight.getGroups()) {
                accessRightGroup.setAccessRight(accessRight);
                db.create((Object)accessRightGroup);
            }
        }
        reader.close();
    }

    private void updateContentTypeDefinitions(Collection contentTypeDefinitions, Map categoryIdMap) {
        for (ContentTypeDefinition contentTypeDefinition : contentTypeDefinitions) {
            String schema = contentTypeDefinition.getSchemaValue();
            for (Integer oldId : categoryIdMap.keySet()) {
                Integer newId = (Integer)categoryIdMap.get(oldId);
                schema = schema.replaceAll("<categoryId>" + oldId + "</categoryId>", "<categoryId>new_" + newId + "</categoryId>");
            }
            schema = schema.replaceAll("<categoryId>new_", "<categoryId>");
            contentTypeDefinition.setSchemaValue(schema);
        }
    }

    private void importCategories(Collection categories, Category parentCategory, Map categoryIdMap, Database db) throws SystemException {
        logger.info((Object)("We want to create a list of categories if not existing under the parent category " + parentCategory));
        for (CategoryVO categoryVO : categories) {
            Category newParentCategory = null;
            List existingCategories = null;
            existingCategories = parentCategory != null ? CategoryController.getController().findByParent(parentCategory.getCategoryId(), db) : CategoryController.getController().findRootCategories(db);
            for (Category existingCategory : existingCategories) {
                logger.info((Object)("existingCategory:" + existingCategory.getName()));
                if (!existingCategory.getName().equals(categoryVO.getName())) continue;
                logger.info((Object)("Existed... setting " + existingCategory.getName() + " to new parent category."));
                newParentCategory = existingCategory;
                break;
            }
            if (newParentCategory == null) {
                logger.info((Object)("No existing category - we create it: " + categoryVO));
                Integer oldId = categoryVO.getId();
                categoryVO.setCategoryId(null);
                if (parentCategory != null) {
                    categoryVO.setParentId(parentCategory.getCategoryId());
                } else {
                    categoryVO.setParentId(null);
                }
                Category newCategory = CategoryController.getController().save(categoryVO, db);
                categoryIdMap.put(oldId, newCategory.getCategoryId());
                newParentCategory = newCategory;
            } else {
                categoryIdMap.put(categoryVO.getId(), newParentCategory.getCategoryId());
            }
            this.importCategories(categoryVO.getChildren(), newParentCategory, categoryIdMap, db);
        }
    }

    private void createStructure(SiteNode siteNode, Map contentIdMap, Map siteNodeIdMap, Map siteNodeVersionIdMap, Map readAvailableServiceBindings, List allSiteNodes, Database db, String onlyLatestVersions) throws Exception {
        logger.info((Object)("siteNode:" + siteNode.getName()));
        Integer originalSiteNodeId = siteNode.getSiteNodeId();
        logger.info((Object)("originalSiteNodeId:" + originalSiteNodeId));
        SiteNodeTypeDefinitionImpl originalSiteNodeTypeDefinition = siteNode.getSiteNodeTypeDefinition();
        SiteNodeTypeDefinition siteNodeTypeDefinition = null;
        if (originalSiteNodeTypeDefinition != null) {
            logger.info((Object)("originalSiteNodeTypeDefinition:" + originalSiteNodeTypeDefinition));
            siteNodeTypeDefinition = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionWithName(siteNode.getSiteNodeTypeDefinition().getName(), db, false);
            logger.info((Object)("siteNodeTypeDefinition:" + siteNodeTypeDefinition));
            if (siteNodeTypeDefinition == null) {
                db.create((Object)originalSiteNodeTypeDefinition);
                siteNodeTypeDefinition = originalSiteNodeTypeDefinition;
            }
            siteNode.setSiteNodeTypeDefinition((SiteNodeTypeDefinitionImpl)siteNodeTypeDefinition);
        }
        String mappedMetaInfoContentId = "-1";
        if (siteNode.getMetaInfoContentId() != null && contentIdMap.containsKey(siteNode.getMetaInfoContentId().toString())) {
            mappedMetaInfoContentId = (String)contentIdMap.get(siteNode.getMetaInfoContentId().toString());
        }
        siteNode.setMetaInfoContentId(new Integer(mappedMetaInfoContentId));
        db.create((Object)siteNode);
        allSiteNodes.add(siteNode);
        Integer newSiteNodeId = siteNode.getSiteNodeId();
        logger.info((Object)(originalSiteNodeId + ":" + newSiteNodeId));
        siteNodeIdMap.put(originalSiteNodeId.toString(), newSiteNodeId.toString());
        Collection childSiteNodes = siteNode.getChildSiteNodes();
        if (childSiteNodes != null) {
            for (SiteNode childSiteNode : childSiteNodes) {
                childSiteNode.setRepository(siteNode.getRepository());
                childSiteNode.setParentSiteNode((SiteNodeImpl)siteNode);
                this.createStructure(childSiteNode, contentIdMap, siteNodeIdMap, siteNodeVersionIdMap, readAvailableServiceBindings, allSiteNodes, db, onlyLatestVersions);
            }
        }
        ArrayList<SiteNodeVersion> siteNodeVersions = siteNode.getSiteNodeVersions();
        if (onlyLatestVersions.equalsIgnoreCase("true")) {
            logger.info((Object)("org siteNodeVersions:" + siteNodeVersions.size()));
            ArrayList<SiteNodeVersion> selectedSiteNodeVersions = new ArrayList<SiteNodeVersion>();
            for (SiteNodeVersion siteNodeVersion : siteNodeVersions) {
                Iterator selectedSiteNodeVersionsIterator = selectedSiteNodeVersions.iterator();
                boolean addVersion = true;
                while (selectedSiteNodeVersionsIterator.hasNext()) {
                    SiteNodeVersion currentSiteNodeVersion = (SiteNodeVersion)selectedSiteNodeVersionsIterator.next();
                    if (!siteNodeVersion.getIsActive().booleanValue() || siteNodeVersion.getSiteNodeVersionId() <= currentSiteNodeVersion.getSiteNodeVersionId()) continue;
                    logger.info((Object)"A later version was found... removing this one..");
                    selectedSiteNodeVersionsIterator.remove();
                    addVersion = true;
                }
                if (!addVersion) continue;
                selectedSiteNodeVersions.add(siteNodeVersion);
            }
            siteNodeVersions = selectedSiteNodeVersions;
        }
        for (SiteNodeVersion siteNodeVersion : siteNodeVersions) {
            Collection serviceBindings = siteNodeVersion.getServiceBindings();
            siteNodeVersion.setOwningSiteNode((SiteNodeImpl)siteNode);
            Integer oldSiteNodeVersionId = siteNodeVersion.getId();
            db.create((Object)siteNodeVersion);
            Integer newSiteNodeVersionId = siteNodeVersion.getId();
            siteNodeVersionIdMap.put(oldSiteNodeVersionId.toString(), newSiteNodeVersionId.toString());
            for (ServiceBinding serviceBinding : serviceBindings) {
                logger.info((Object)("serviceBinding:" + serviceBinding.getName()));
                ServiceDefinitionImpl originalServiceDefinition = serviceBinding.getServiceDefinition();
                if (originalServiceDefinition == null) {
                    logger.error((Object)("Skipping serviceBinding:" + serviceBinding.getName() + ":" + "serviceBinding:" + serviceBinding.getId() + " " + serviceBinding.getServiceDefinition()));
                    continue;
                }
                String serviceDefinitionName = originalServiceDefinition.getName();
                ServiceDefinition serviceDefinition = ServiceDefinitionController.getController().getServiceDefinitionWithName(serviceDefinitionName, db, false);
                if (serviceDefinition == null) {
                    db.create((Object)originalServiceDefinition);
                    serviceDefinition = originalServiceDefinition;
                }
                serviceBinding.setServiceDefinition((ServiceDefinitionImpl)serviceDefinition);
                AvailableServiceBindingImpl originalAvailableServiceBinding = serviceBinding.getAvailableServiceBinding();
                String availableServiceBindingName = originalAvailableServiceBinding.getName();
                logger.info((Object)("availableServiceBindingName:" + availableServiceBindingName));
                logger.info((Object)("readAvailableServiceBindings:" + readAvailableServiceBindings.size() + ":" + readAvailableServiceBindings.containsKey(availableServiceBindingName)));
                AvailableServiceBinding availableServiceBinding = (AvailableServiceBinding)readAvailableServiceBindings.get(availableServiceBindingName);
                logger.info((Object)("availableServiceBinding:" + availableServiceBinding));
                if (availableServiceBinding == null) {
                    availableServiceBinding = AvailableServiceBindingController.getController().getAvailableServiceBindingWithName(availableServiceBindingName, db, false);
                    logger.info((Object)("Read availableServiceBinding from database:" + availableServiceBindingName + "=" + availableServiceBinding));
                    readAvailableServiceBindings.put(availableServiceBindingName, availableServiceBinding);
                    logger.info((Object)("readAvailableServiceBindings:" + readAvailableServiceBindings.size() + ":" + readAvailableServiceBindings.containsKey(availableServiceBindingName)));
                }
                if (availableServiceBinding == null) {
                    logger.info((Object)("There was no availableServiceBinding registered under:" + availableServiceBindingName));
                    logger.info((Object)("originalAvailableServiceBinding:" + originalAvailableServiceBinding.getName() + ":" + originalAvailableServiceBinding.getIsInheritable()));
                    db.create((Object)originalAvailableServiceBinding);
                    availableServiceBinding = originalAvailableServiceBinding;
                    readAvailableServiceBindings.put(availableServiceBindingName, availableServiceBinding);
                    logger.info((Object)("Notifying:" + siteNodeTypeDefinition.getName() + " about the new availableServiceBinding " + availableServiceBinding.getName()));
                    if (siteNodeTypeDefinition != null) {
                        siteNodeTypeDefinition.getAvailableServiceBindings().add((AvailableServiceBindingImpl)availableServiceBinding);
                        serviceDefinition.getAvailableServiceBindings().add((AvailableServiceBindingImpl)availableServiceBinding);
                        availableServiceBinding.getSiteNodeTypeDefinitions().add((SiteNodeTypeDefinitionImpl)siteNodeTypeDefinition);
                        availableServiceBinding.getServiceDefinitions().add((ServiceDefinitionImpl)serviceDefinition);
                    }
                } else if (siteNodeTypeDefinition != null && !siteNodeTypeDefinition.getAvailableServiceBindings().contains(availableServiceBinding)) {
                    siteNodeTypeDefinition.getAvailableServiceBindings().add((AvailableServiceBindingImpl)availableServiceBinding);
                    availableServiceBinding.getSiteNodeTypeDefinitions().add(siteNodeTypeDefinition);
                }
                serviceBinding.setAvailableServiceBinding((AvailableServiceBindingImpl)availableServiceBinding);
                Collection qualifyers = serviceBinding.getBindingQualifyers();
                for (Qualifyer qualifyer : qualifyers) {
                    qualifyer.setServiceBinding((ServiceBindingImpl)serviceBinding);
                    String entityName = qualifyer.getName();
                    String entityId = qualifyer.getValue();
                    if (entityName.equalsIgnoreCase("contentId")) {
                        String mappedContentId = (String)contentIdMap.get(entityId);
                        qualifyer.setValue(mappedContentId == null ? entityId : mappedContentId);
                        continue;
                    }
                    if (!entityName.equalsIgnoreCase("siteNodeId")) continue;
                    String mappedSiteNodeId = (String)siteNodeIdMap.get(entityId);
                    qualifyer.setValue(mappedSiteNodeId == null ? entityId : mappedSiteNodeId);
                }
                serviceBinding.setSiteNodeVersion((SiteNodeVersionImpl)siteNodeVersion);
                db.create((Object)serviceBinding);
            }
        }
    }

    private List createContents(Content content, Map idMap, Map contentTypeDefinitionIdMap, List allContents, Collection contentTypeDefinitions, Map categoryIdMap, int version, Database db, String onlyLatestVersions) throws Exception {
        ContentTypeDefinitionImpl originalContentTypeDefinition;
        ContentTypeDefinition contentTypeDefinition = null;
        Integer originalContentId = content.getContentId();
        if (version == 2) {
            Integer contentTypeDefinitionId = ((ContentImpl)content).getContentTypeDefinitionId();
            if (contentTypeDefinitionId != null) {
                if (contentTypeDefinitionIdMap.containsKey(contentTypeDefinitionId)) {
                    contentTypeDefinitionId = (Integer)contentTypeDefinitionIdMap.get(contentTypeDefinitionId);
                }
                ContentTypeDefinition originalContentTypeDefinition2 = null;
                for (ContentTypeDefinition contentTypeDefinitionCandidate : contentTypeDefinitions) {
                    if (contentTypeDefinitionCandidate.getId().intValue() != contentTypeDefinitionId.intValue()) continue;
                    originalContentTypeDefinition2 = contentTypeDefinitionCandidate;
                    break;
                }
                if (originalContentTypeDefinition2 != null) {
                    contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithName(originalContentTypeDefinition2.getName(), db);
                    if (contentTypeDefinition == null) {
                        Integer before = originalContentTypeDefinition2.getId();
                        db.create((Object)originalContentTypeDefinition2);
                        contentTypeDefinition = originalContentTypeDefinition2;
                        Integer after = originalContentTypeDefinition2.getId();
                        contentTypeDefinitionIdMap.put(before, after);
                    }
                    content.setContentTypeDefinition((ContentTypeDefinitionImpl)contentTypeDefinition);
                } else {
                    logger.error((Object)("The content " + content.getName() + " had a content type not found amongst the listed ones:" + contentTypeDefinitionId));
                }
            } else {
                logger.error((Object)("The content " + content.getName() + " had no content type at all"));
            }
        } else if (version == 1 && (originalContentTypeDefinition = content.getContentTypeDefinition()) != null) {
            contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithName(originalContentTypeDefinition.getName(), db);
            if (contentTypeDefinition == null) {
                db.create((Object)originalContentTypeDefinition);
                contentTypeDefinition = originalContentTypeDefinition;
            }
            content.setContentTypeDefinition((ContentTypeDefinitionImpl)contentTypeDefinition);
        }
        if (content.getContentTypeDefinition() == null) {
            logger.error((Object)("No content type definition for content:" + content.getId()));
        }
        logger.info((Object)("Creating content:" + content.getName()));
        db.create((Object)content);
        allContents.add(content);
        Integer newContentId = content.getContentId();
        idMap.put(originalContentId.toString(), newContentId.toString());
        ArrayList<ContentVersion> contentVersions = content.getContentVersions();
        if (onlyLatestVersions.equalsIgnoreCase("true")) {
            logger.info((Object)("org contentVersions:" + contentVersions.size()));
            ArrayList<ContentVersion> selectedContentVersions = new ArrayList<ContentVersion>();
            for (ContentVersion contentVersion : contentVersions) {
                Iterator selectedContentVersionsIterator = selectedContentVersions.iterator();
                boolean addLanguageVersion = true;
                boolean noLanguageVersionFound = true;
                while (selectedContentVersionsIterator.hasNext()) {
                    ContentVersion currentContentVersion = (ContentVersion)selectedContentVersionsIterator.next();
                    logger.info((Object)(currentContentVersion.getLanguage().getLanguageCode() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!currentContentVersion.getLanguage().getLanguageCode().equals(contentVersion.getLanguage().getLanguageCode())) continue;
                    noLanguageVersionFound = false;
                    logger.info((Object)(contentVersion.getIsActive() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!contentVersion.getIsActive().booleanValue() || contentVersion.getContentVersionId() <= currentContentVersion.getContentVersionId()) continue;
                    logger.info((Object)"A later version was found... removing this one..");
                    selectedContentVersionsIterator.remove();
                    addLanguageVersion = true;
                }
                if (!addLanguageVersion && !noLanguageVersionFound) continue;
                selectedContentVersions.add(contentVersion);
            }
            contentVersions = selectedContentVersions;
        }
        logger.info((Object)("new contentVersions:" + contentVersions.size()));
        for (ContentVersion contentVersion : contentVersions) {
            Language language = LanguageController.getController().getLanguageWithCode(contentVersion.getLanguage().getLanguageCode(), db);
            logger.info((Object)("Creating contentVersion for language:" + contentVersion.getLanguage().getLanguageCode() + " on content " + content.getName()));
            contentVersion.setOwningContent((ContentImpl)content);
            contentVersion.setLanguage((LanguageImpl)language);
            Collection digitalAssets = contentVersion.getDigitalAssets();
            if (digitalAssets != null) {
                ArrayList<DigitalAsset> initialDigitalAssets = new ArrayList<DigitalAsset>();
                for (DigitalAsset digitalAsset : digitalAssets) {
                    ArrayList<ContentVersion> initialContentVersions = new ArrayList<ContentVersion>();
                    initialContentVersions.add(contentVersion);
                    digitalAsset.setContentVersions(initialContentVersions);
                    db.create((Object)digitalAsset);
                    initialDigitalAssets.add(digitalAsset);
                }
                contentVersion.setDigitalAssets(initialDigitalAssets);
            }
            Collection contentCategories = contentVersion.getContentCategories();
            logger.info((Object)("contentCategories:" + contentCategories.size()));
            db.create((Object)contentVersion);
            if (contentCategories == null) continue;
            ArrayList<ContentCategory> initialContentCategories = new ArrayList<ContentCategory>();
            for (ContentCategory contentCategory : contentCategories) {
                logger.info((Object)("contentCategory:" + contentCategory));
                contentCategory.setContentVersion((ContentVersionImpl)contentVersion);
                Integer oldCategoryId = contentCategory.getCategoryId();
                logger.info((Object)("oldCategoryId:" + oldCategoryId));
                Integer newCategoryId = (Integer)categoryIdMap.get(oldCategoryId);
                logger.info((Object)("newCategoryId:" + newCategoryId));
                if (newCategoryId == null) {
                    newCategoryId = oldCategoryId;
                }
                if (newCategoryId == null) continue;
                Category category = CategoryController.getController().findById(newCategoryId, db);
                logger.info((Object)("Got category:" + category));
                if (category == null) continue;
                contentCategory.setCategory((CategoryImpl)category);
                logger.info((Object)("Creating content category:" + contentCategory));
                db.create((Object)contentCategory);
                initialContentCategories.add(contentCategory);
            }
            contentVersion.setContentCategories(initialContentCategories);
        }
        Collection childContents = content.getChildren();
        if (childContents != null) {
            for (Content childContent : childContents) {
                childContent.setRepository(content.getRepository());
                childContent.setParentContent((ContentImpl)content);
                this.createContents(childContent, idMap, contentTypeDefinitionIdMap, allContents, contentTypeDefinitions, categoryIdMap, version, db, onlyLatestVersions);
            }
        }
        return allContents;
    }

    public void updateContentVersions(Content content, Map contentIdMap, Map siteNodeIdMap, String onlyLatestVersions) throws Exception {
        logger.info((Object)("content:" + content.getName()));
        ArrayList<ContentVersion> contentVersions = content.getContentVersions();
        if (onlyLatestVersions.equalsIgnoreCase("true")) {
            logger.info((Object)("org contentVersions:" + contentVersions.size()));
            ArrayList<ContentVersion> selectedContentVersions = new ArrayList<ContentVersion>();
            for (ContentVersion contentVersion : contentVersions) {
                Iterator selectedContentVersionsIterator = selectedContentVersions.iterator();
                boolean addLanguageVersion = true;
                boolean noLanguageVersionFound = true;
                while (selectedContentVersionsIterator.hasNext()) {
                    ContentVersion currentContentVersion = (ContentVersion)selectedContentVersionsIterator.next();
                    logger.info((Object)(currentContentVersion.getLanguage().getLanguageCode() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!currentContentVersion.getLanguage().getLanguageCode().equals(contentVersion.getLanguage().getLanguageCode())) continue;
                    noLanguageVersionFound = false;
                    logger.info((Object)(contentVersion.getIsActive() + "=" + contentVersion.getLanguage().getLanguageCode()));
                    if (!contentVersion.getIsActive().booleanValue() || contentVersion.getContentVersionId() <= currentContentVersion.getContentVersionId()) continue;
                    logger.info((Object)"A later version was found... removing this one..");
                    selectedContentVersionsIterator.remove();
                    addLanguageVersion = true;
                }
                if (!addLanguageVersion && !noLanguageVersionFound) continue;
                selectedContentVersions.add(contentVersion);
            }
            contentVersions = selectedContentVersions;
        }
        for (ContentVersion contentVersion : contentVersions) {
            String contentVersionValue = contentVersion.getVersionValue();
            contentVersionValue = contentVersionValue.replaceAll("contentId=\"", "contentId=\"oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("\\?contentId=", "\\?contentId=oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("getInlineAssetUrl\\(", "getInlineAssetUrl\\(oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("languageId,", "languageId,oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("entity=\"Content\" entityId=\"", "entity=\"Content\" entityId=\"oldContentId_");
            contentVersionValue = contentVersionValue.replaceAll("siteNodeId=\"", "siteNodeId=\"oldSiteNodeId_");
            contentVersionValue = contentVersionValue.replaceAll("detailSiteNodeId=\"", "detailSiteNodeId=\"oldSiteNodeId_");
            contentVersionValue = contentVersionValue.replaceAll("getPageUrl\\((\\d)", "getPageUrl\\(oldSiteNodeId_$1");
            contentVersionValue = contentVersionValue.replaceAll("entity=\"SiteNode\" entityId=\"", "entity=\"SiteNode\" entityId=\"oldSiteNodeId_");
            contentVersionValue = this.prepareAllRelations(contentVersionValue);
            for (String oldContentId : contentIdMap.keySet()) {
                String newContentId = (String)contentIdMap.get(oldContentId);
                contentVersionValue = contentVersionValue.replaceAll("contentId=\"oldContentId_" + oldContentId + "\"", "contentId=\"" + newContentId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("\\?contentId=oldContentId_" + oldContentId + "&", "\\?contentId=" + newContentId + "&");
                contentVersionValue = contentVersionValue.replaceAll("getInlineAssetUrl\\(oldContentId_" + oldContentId + ",", "getInlineAssetUrl\\(" + newContentId + ",");
                contentVersionValue = contentVersionValue.replaceAll("languageId,oldContentId_" + oldContentId + "\\)", "languageId," + newContentId + "\\)");
                contentVersionValue = contentVersionValue.replaceAll("entity=\"Content\" entityId=\"oldContentId_" + oldContentId + "\"", "entity=\"Content\" entityId=\"" + newContentId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("<id>oldContentId_" + oldContentId + "</id>", "<id>" + newContentId + "</id>");
            }
            for (String oldSiteNodeId : siteNodeIdMap.keySet()) {
                String newSiteNodeId = (String)siteNodeIdMap.get(oldSiteNodeId);
                contentVersionValue = contentVersionValue.replaceAll("siteNodeId=\"oldSiteNodeId_" + oldSiteNodeId + "\"", "siteNodeId=\"" + newSiteNodeId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("detailSiteNodeId=\"oldSiteNodeId_" + oldSiteNodeId + "\"", "detailSiteNodeId=\"" + newSiteNodeId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("getPageUrl\\(oldSiteNodeId_" + oldSiteNodeId + ",", "getPageUrl\\(" + newSiteNodeId + ",");
                contentVersionValue = contentVersionValue.replaceAll("entity=\"SiteNode\" entityId=\"oldSiteNodeId_" + oldSiteNodeId + "\"", "entity=\"SiteNode\" entityId=\"" + newSiteNodeId + "\"");
                contentVersionValue = contentVersionValue.replaceAll("<id>oldSiteNodeId_" + oldSiteNodeId + "</id>", "<id>" + newSiteNodeId + "</id>");
            }
            contentVersionValue = contentVersionValue.replaceAll("oldContentId_", "");
            contentVersionValue = contentVersionValue.replaceAll("oldSiteNodeId_", "");
            logger.info((Object)("new contentVersionValue:" + contentVersionValue));
            contentVersion.setVersionValue(contentVersionValue);
        }
    }

    private String prepareAllRelations(String xml) throws Exception {
        StringBuffer newXML = new StringBuffer();
        logger.info((Object)("xml: " + xml));
        String after = xml;
        String before = "";
        String qualifyer = "";
        boolean changed = false;
        int startIndex = xml.indexOf("<qualifyer");
        while (startIndex > -1) {
            String newQualifyer;
            int stopIndex = xml.indexOf("</qualifyer>", startIndex);
            if (stopIndex > -1) {
                changed = true;
                before = xml.substring(0, startIndex);
                after = xml.substring(stopIndex + 12);
                newQualifyer = qualifyer = xml.substring(startIndex, stopIndex + 12);
                if (qualifyer.indexOf("entity='Content'") > 0) {
                    newQualifyer = qualifyer.replaceAll("<id>", "<id>oldContentId_");
                } else if (qualifyer.indexOf("entity='SiteNode'") > 0) {
                    newQualifyer = qualifyer.replaceAll("<id>", "<id>oldSiteNodeId_");
                }
            } else {
                throw new Exception("Error in xml - qualifyer tag broken in " + xml);
            }
            newXML.append(before);
            newXML.append(newQualifyer);
            xml = after;
            startIndex = xml.indexOf("<qualifyer");
        }
        newXML.append(after);
        if (changed) {
            logger.info((Object)("newXML:" + newXML));
        }
        return newXML.toString();
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

