/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.dom4j.Document;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PropertiesCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.GroupContentTypeDefinition;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.GroupPropertiesVO;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.PropertiesCategory;
import org.infoglue.cms.entities.management.PropertiesCategoryVO;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.entities.management.impl.simple.GroupContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.GroupPropertiesImpl;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.XMLHelper;
import org.infoglue.cms.util.dom.DOMBuilder;
import org.infoglue.deliver.util.CacheController;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GroupPropertiesController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)GroupPropertiesController.class.getName());

    public static GroupPropertiesController getController() {
        return new GroupPropertiesController();
    }

    public GroupProperties getGroupPropertiesWithId(Integer groupPropertiesId, Database db) throws SystemException, Bug {
        return (GroupProperties)GroupPropertiesController.getObjectWithId(GroupPropertiesImpl.class, groupPropertiesId, db);
    }

    public GroupPropertiesVO getGroupPropertiesVOWithId(Integer groupPropertiesId) throws SystemException, Bug {
        return (GroupPropertiesVO)GroupPropertiesController.getVOWithId(GroupPropertiesImpl.class, groupPropertiesId);
    }

    public List getGroupPropertiesVOList() throws SystemException, Bug {
        return this.getAllVOObjects(GroupPropertiesImpl.class, "groupPropertiesId");
    }

    public GroupPropertiesVO create(Integer languageId, Integer contentTypeDefinitionId, GroupPropertiesVO groupPropertiesVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        GroupProperties groupProperties = null;
        GroupPropertiesController.beginTransaction(db);
        try {
            groupProperties = this.create(languageId, contentTypeDefinitionId, groupPropertiesVO, db);
            GroupPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return groupProperties.getValueObject();
    }

    public GroupProperties create(Integer languageId, Integer contentTypeDefinitionId, GroupPropertiesVO groupPropertiesVO, Database db) throws ConstraintException, SystemException, Exception {
        Language language = LanguageController.getController().getLanguageWithId(languageId, db);
        ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
        GroupPropertiesImpl groupProperties = new GroupPropertiesImpl();
        groupProperties.setLanguage((LanguageImpl)language);
        groupProperties.setContentTypeDefinition(contentTypeDefinition);
        groupProperties.setValueObject(groupPropertiesVO);
        db.create((Object)groupProperties);
        return groupProperties;
    }

    public GroupPropertiesVO update(Integer languageId, Integer contentTypeDefinitionId, GroupPropertiesVO groupPropertiesVO) throws ConstraintException, SystemException {
        GroupPropertiesVO realGroupPropertiesVO = groupPropertiesVO;
        if (groupPropertiesVO.getId() == null) {
            logger.info((Object)("Creating the entity because there was no version at all for: " + contentTypeDefinitionId + " " + languageId));
            realGroupPropertiesVO = this.create(languageId, contentTypeDefinitionId, groupPropertiesVO);
        }
        return (GroupPropertiesVO)GroupPropertiesController.updateEntity(GroupPropertiesImpl.class, realGroupPropertiesVO);
    }

    public GroupPropertiesVO update(GroupPropertiesVO groupPropertiesVO, String[] extranetUsers) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        GroupProperties groupProperties = null;
        GroupPropertiesController.beginTransaction(db);
        try {
            groupProperties = this.getGroupPropertiesWithId(groupPropertiesVO.getGroupPropertiesId(), db);
            groupProperties.setValueObject(groupPropertiesVO);
            ceb.throwIfNotEmpty();
            GroupPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            GroupPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return groupProperties.getValueObject();
    }

    public List getGroupPropertiesVOList(String groupName, Integer languageId) throws ConstraintException, SystemException {
        List groupPropertiesVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        GroupPropertiesController.beginTransaction(db);
        try {
            groupPropertiesVOList = this.getGroupPropertiesVOList(groupName, languageId, db);
            GroupPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return groupPropertiesVOList;
    }

    public List getGroupPropertiesVOList(String groupName, Integer languageId, Database db) throws ConstraintException, Exception {
        List groupPropertiesVOList = new ArrayList();
        String cacheKey = groupName + "_" + languageId;
        logger.info((Object)("cacheKey:" + cacheKey));
        groupPropertiesVOList = (List)CacheController.getCachedObject("groupPropertiesCache", cacheKey);
        if (groupPropertiesVOList != null) {
            logger.info((Object)("There was an cached groupPropertiesVOList:" + groupPropertiesVOList.size()));
        } else {
            List groupPropertiesList = this.getGroupPropertiesList(groupName, languageId, db, true);
            if (groupPropertiesList != null) {
                groupPropertiesVOList = GroupPropertiesController.toVOList(groupPropertiesList);
                CacheController.cacheObject("groupPropertiesCache", cacheKey, groupPropertiesVOList);
            }
        }
        return groupPropertiesVOList;
    }

    public List getGroupPropertiesList(String groupName, Integer languageId, Database db, boolean readOnly) throws ConstraintException, SystemException, Exception {
        QueryResults results;
        ArrayList<GroupProperties> groupPropertiesList = new ArrayList<GroupProperties>();
        OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.GroupPropertiesImpl f WHERE f.groupName = $1 AND f.language = $2");
        oql.bind((Object)groupName);
        oql.bind((Object)languageId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("groupName:" + groupName));
            logger.info((Object)("languageId:" + languageId));
        }
        if (readOnly) {
            logger.info((Object)"Fetching groupPropertiesList in readonly mode");
            results = oql.execute((short)0);
        } else {
            logger.info((Object)"Fetching groupPropertiesList in read/write mode");
            results = oql.execute();
        }
        while (results.hasMore()) {
            GroupProperties groupProperties = (GroupProperties)results.next();
            logger.info((Object)("Found one:" + groupProperties));
            groupPropertiesList.add(groupProperties);
        }
        logger.info((Object)("In total:" + groupPropertiesList.size()));
        results.close();
        oql.close();
        return groupPropertiesList;
    }

    public void delete(GroupPropertiesVO groupPropertiesVO) throws ConstraintException, SystemException {
        GroupPropertiesController.deleteEntity(GroupPropertiesImpl.class, groupPropertiesVO.getGroupPropertiesId());
    }

    public List getDigitalAssetVOList(Integer groupPropertiesId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List digitalAssetVOList = new ArrayList();
        GroupPropertiesController.beginTransaction(db);
        try {
            GroupProperties groupProperties = GroupPropertiesController.getController().getGroupPropertiesWithId(groupPropertiesId, db);
            if (groupProperties != null) {
                Collection digitalAssets = groupProperties.getDigitalAssets();
                digitalAssetVOList = GroupPropertiesController.toVOList(digitalAssets);
            }
            GroupPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to fetch the list of digitalAssets belonging to this groupProperties:" + e));
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVOList;
    }

    public void deleteDigitalAssetRelation(Integer groupPropertiesId, DigitalAsset digitalAsset, Database db) throws SystemException, Bug {
        GroupProperties groupProperties = this.getGroupPropertiesWithId(groupPropertiesId, db);
        groupProperties.getDigitalAssets().remove(digitalAsset);
        digitalAsset.getGroupProperties().remove(groupProperties);
    }

    public List getContentTypeDefinitionVOList(String groupName) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
        GroupPropertiesController.beginTransaction(db);
        try {
            List groupContentTypeDefinitionList = this.getGroupContentTypeDefinitionList(groupName, db);
            for (GroupContentTypeDefinition groupContentTypeDefinition : groupContentTypeDefinitionList) {
                contentTypeDefinitionVOList.add(groupContentTypeDefinition.getContentTypeDefinition().getValueObject());
            }
            ceb.throwIfNotEmpty();
            GroupPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            GroupPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentTypeDefinitionVOList;
    }

    public List getGroupContentTypeDefinitionList(String groupName, Database db) throws ConstraintException, SystemException, Exception {
        ArrayList<GroupContentTypeDefinition> groupContentTypeDefinitionList = new ArrayList<GroupContentTypeDefinition>();
        OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.GroupContentTypeDefinitionImpl f WHERE f.groupName = $1");
        oql.bind((Object)groupName);
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching groupContentTypeDefinitionList in read/write mode");
        while (results.hasMore()) {
            GroupContentTypeDefinition groupContentTypeDefinition = (GroupContentTypeDefinition)results.next();
            groupContentTypeDefinitionList.add(groupContentTypeDefinition);
        }
        results.close();
        oql.close();
        return groupContentTypeDefinitionList;
    }

    public void updateContentTypeDefinitions(String groupName, String[] contentTypeDefinitionIds) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList contentTypeDefinitionVOList = new ArrayList();
        GroupPropertiesController.beginTransaction(db);
        try {
            List groupContentTypeDefinitionList = this.getGroupContentTypeDefinitionList(groupName, db);
            for (GroupContentTypeDefinition groupContentTypeDefinition : groupContentTypeDefinitionList) {
                db.remove((Object)groupContentTypeDefinition);
            }
            int i = 0;
            while (i < contentTypeDefinitionIds.length) {
                Integer contentTypeDefinitionId = new Integer(contentTypeDefinitionIds[i]);
                ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
                GroupContentTypeDefinitionImpl groupContentTypeDefinitionImpl = new GroupContentTypeDefinitionImpl();
                groupContentTypeDefinitionImpl.setGroupName(groupName);
                groupContentTypeDefinitionImpl.setContentTypeDefinition(contentTypeDefinition);
                db.create((Object)groupContentTypeDefinitionImpl);
                ++i;
            }
            ceb.throwIfNotEmpty();
            GroupPropertiesController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            GroupPropertiesController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updateAttributeValue(Integer groupPropertiesId, String attributeName, String attributeValue) throws SystemException, Bug {
        GroupPropertiesVO groupPropertiesVO = this.getGroupPropertiesVOWithId(groupPropertiesId);
        if (groupPropertiesVO != null) {
            try {
                logger.info((Object)("attributeName:" + attributeName));
                logger.info((Object)("versionValue:" + groupPropertiesVO.getValue()));
                logger.info((Object)("attributeValue:" + attributeValue));
                InputSource inputSource = new InputSource(new StringReader(groupPropertiesVO.getValue()));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                org.w3c.dom.Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                Node attributesNode = nl.item(0);
                boolean existed = false;
                nl = attributesNode.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    if (n.getNodeName().equalsIgnoreCase(attributeName)) {
                        if (n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                            n.getFirstChild().setNodeValue(attributeValue);
                            existed = true;
                            break;
                        }
                        CDATASection cdata = document.createCDATASection(attributeValue);
                        n.appendChild(cdata);
                        existed = true;
                        break;
                    }
                    ++i;
                }
                if (!existed) {
                    Element attributeElement = document.createElement(attributeName);
                    attributesNode.appendChild(attributeElement);
                    CDATASection cdata = document.createCDATASection(attributeValue);
                    attributeElement.appendChild(cdata);
                }
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(document.getDocumentElement(), sb);
                logger.info((Object)("sb:" + sb));
                groupPropertiesVO.setValue(sb.toString());
                this.update(groupPropertiesVO.getLanguageId(), groupPropertiesVO.getContentTypeDefinitionId(), groupPropertiesVO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getAttributeValue(String groupName, Integer languageId, String attributeName) throws SystemException {
        String value = "";
        Database db = CastorDatabaseService.getDatabase();
        GroupPropertiesController.beginTransaction(db);
        try {
            value = this.getAttributeValue(groupName, languageId, attributeName, db);
            GroupPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return value;
    }

    public String getAttributeValue(String groupName, Integer languageId, String attributeName, Database db) throws SystemException, Exception {
        String value = "";
        logger.info((Object)("groupName: " + groupName));
        logger.info((Object)("languageId: " + languageId));
        logger.info((Object)("attributeName: " + attributeName));
        List groupPropertiesVO = this.getGroupPropertiesVOList(groupName, languageId, db);
        logger.info((Object)("groupPropertiesVO: " + groupPropertiesVO));
        Iterator iterator = groupPropertiesVO.iterator();
        GroupPropertiesVO groupPropertyVO = null;
        if (iterator.hasNext()) {
            groupPropertyVO = (GroupPropertiesVO)iterator.next();
            logger.info((Object)("groupPropertyVO: " + groupPropertyVO.getId() + ":" + groupPropertyVO.getValue()));
        }
        logger.info((Object)("groupPropertyVO: " + groupPropertyVO));
        if (groupPropertyVO != null) {
            value = this.getAttributeValue(groupPropertyVO.getValue(), attributeName, false);
            logger.info((Object)("value: " + value));
        }
        return value;
    }

    public String getAttributeValue(Integer groupPropertiesId, String attributeName, boolean escapeHTML) throws SystemException, Bug {
        String value = "";
        GroupPropertiesVO groupPropertiesVO = this.getGroupPropertiesVOWithId(groupPropertiesId);
        if (groupPropertiesVO != null) {
            value = this.getAttributeValue(groupPropertiesVO.getValue(), attributeName, escapeHTML);
        }
        return value;
    }

    public String getAttributeValue(String xml, String attributeName, boolean escapeHTML) throws SystemException, Bug {
        String value = "";
        try {
            InputSource inputSource = new InputSource(new StringReader(xml));
            DOMParser parser = new DOMParser();
            parser.parse(inputSource);
            org.w3c.dom.Document document = parser.getDocument();
            NodeList nl = document.getDocumentElement().getChildNodes();
            Node n = nl.item(0);
            nl = n.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                n = nl.item(i);
                if (n.getNodeName().equalsIgnoreCase(attributeName) && n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                    value = n.getFirstChild().getNodeValue();
                    if (value != null && escapeHTML) {
                        value = new VisualFormatter().escapeHTML(value);
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public List getRelatedContents(String groupName, Integer languageId, String attributeName) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        List relatedContentVOList = new ArrayList();
        GroupPropertiesController.beginTransaction(db);
        try {
            List relatedContents = this.getRelatedContents(groupName, languageId, attributeName, db);
            if (relatedContents != null) {
                relatedContentVOList = GroupPropertiesController.toVOList(relatedContents);
            }
            GroupPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return relatedContentVOList;
    }

    public List getReadOnlyRelatedContents(String groupName, Integer languageId, String attributeName, Database db) throws SystemException, Exception {
        List relatedContentList = new ArrayList();
        List groupPropertiesVO = this.getGroupPropertiesVOList(groupName, languageId, db);
        Iterator iterator = groupPropertiesVO.iterator();
        GroupPropertiesVO groupPropertyVO = null;
        if (iterator.hasNext()) {
            groupPropertyVO = (GroupPropertiesVO)iterator.next();
        }
        if (groupPropertyVO != null) {
            String xml = this.getAttributeValue(groupPropertyVO.getValue(), attributeName, false);
            relatedContentList = this.getReadOnlyRelatedContentsFromXML(db, xml);
        }
        return relatedContentList;
    }

    public List getRelatedContents(String groupName, Integer languageId, String attributeName, Database db) throws SystemException, Exception {
        List relatedContentList = new ArrayList();
        List groupPropertiesVO = this.getGroupPropertiesVOList(groupName, languageId, db);
        Iterator iterator = groupPropertiesVO.iterator();
        GroupPropertiesVO groupPropertyVO = null;
        if (iterator.hasNext()) {
            groupPropertyVO = (GroupPropertiesVO)iterator.next();
        }
        if (groupPropertyVO != null) {
            String xml = this.getAttributeValue(groupPropertyVO.getValue(), attributeName, false);
            relatedContentList = this.getRelatedContentsFromXML(db, xml);
        }
        return relatedContentList;
    }

    public List getRelatedSiteNodes(String groupName, Integer languageId, String attributeName) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        List relatedSiteNodeVOList = new ArrayList();
        GroupPropertiesController.beginTransaction(db);
        try {
            List relatedSiteNodes = this.getRelatedSiteNodes(groupName, languageId, attributeName, db);
            if (relatedSiteNodes != null) {
                relatedSiteNodeVOList = GroupPropertiesController.toVOList(relatedSiteNodes);
            }
            GroupPropertiesController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupPropertiesController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return relatedSiteNodeVOList;
    }

    public List getRelatedSiteNodes(String groupName, Integer languageId, String attributeName, Database db) throws SystemException, Exception {
        List relatedSiteNodeList = new ArrayList();
        List groupProperties = this.getGroupPropertiesVOList(groupName, languageId, db);
        Iterator iterator = groupProperties.iterator();
        GroupPropertiesVO groupPropertyVO = null;
        if (iterator.hasNext()) {
            groupPropertyVO = (GroupPropertiesVO)iterator.next();
        }
        if (groupPropertyVO != null) {
            String xml = this.getAttributeValue(groupPropertyVO.getValue(), attributeName, false);
            relatedSiteNodeList = this.getRelatedSiteNodesFromXML(db, xml);
        }
        return relatedSiteNodeList;
    }

    public List getReadOnlyRelatedSiteNodes(String groupName, Integer languageId, String attributeName, Database db) throws SystemException, Exception {
        List relatedSiteNodeList = new ArrayList();
        List groupProperties = this.getGroupPropertiesVOList(groupName, languageId, db);
        Iterator iterator = groupProperties.iterator();
        GroupPropertiesVO groupPropertyVO = null;
        if (iterator.hasNext()) {
            groupPropertyVO = (GroupPropertiesVO)iterator.next();
        }
        if (groupPropertyVO != null) {
            String xml = this.getAttributeValue(groupPropertyVO.getValue(), attributeName, false);
            relatedSiteNodeList = this.getReadOnlyRelatedSiteNodesFromXML(db, xml);
        }
        return relatedSiteNodeList;
    }

    private List getRelatedContentsFromXML(Database db, String qualifyerXML) {
        ArrayList<Content> contents = new ArrayList<Content>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return contents;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (org.dom4j.Element child : children) {
                String id = child.getStringValue();
                Content content = ContentController.getContentController().getContentWithId(new Integer(id), db);
                contents.add(content);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error getting related contents:" + e.getMessage()), (Throwable)e);
        }
        return contents;
    }

    private List getReadOnlyRelatedContentsFromXML(Database db, String qualifyerXML) {
        ArrayList<Content> contents = new ArrayList<Content>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return contents;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (org.dom4j.Element child : children) {
                String id = child.getStringValue();
                Content content = ContentController.getContentController().getReadOnlyContentWithId(new Integer(id), db);
                contents.add(content);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error getting related contents:" + e.getMessage()), (Throwable)e);
        }
        return contents;
    }

    private List getRelatedSiteNodesFromXML(Database db, String qualifyerXML) {
        ArrayList<SiteNode> siteNodes = new ArrayList<SiteNode>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return siteNodes;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (org.dom4j.Element child : children) {
                String id = child.getStringValue();
                SiteNode siteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(id), db);
                siteNodes.add(siteNode);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error getting related site nodes:" + e.getMessage()), (Throwable)e);
        }
        return siteNodes;
    }

    private List getReadOnlyRelatedSiteNodesFromXML(Database db, String qualifyerXML) {
        ArrayList<SiteNode> siteNodes = new ArrayList<SiteNode>();
        if (qualifyerXML == null || qualifyerXML.length() == 0) {
            return siteNodes;
        }
        try {
            Document document = new DOMBuilder().getDocument(qualifyerXML);
            String entity = document.getRootElement().attributeValue("entity");
            List children = document.getRootElement().elements();
            for (org.dom4j.Element child : children) {
                String id = child.getStringValue();
                SiteNodeController.getController();
                SiteNode siteNode = SiteNodeController.getSiteNodeWithId(new Integer(id), db, true);
                siteNodes.add(siteNode);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error getting related contents:" + e.getMessage()), (Throwable)e);
        }
        return siteNodes;
    }

    public List getRelatedCategories(String groupName, Integer languageId, String attribute) {
        ArrayList<CategoryVO> relatedCategories = new ArrayList<CategoryVO>();
        try {
            List groupPropertiesVOList = this.getGroupPropertiesVOList(groupName, languageId);
            Iterator iterator = groupPropertiesVOList.iterator();
            GroupPropertiesVO groupPropertyVO = null;
            if (iterator.hasNext()) {
                groupPropertyVO = (GroupPropertiesVO)iterator.next();
            }
            if (groupPropertyVO != null && groupPropertyVO.getId() != null) {
                List propertiesCategoryVOList = PropertiesCategoryController.getController().findByPropertiesAttribute(attribute, GroupProperties.class.getName(), groupPropertyVO.getId());
                for (PropertiesCategoryVO propertiesCategoryVO : propertiesCategoryVOList) {
                    relatedCategories.add(propertiesCategoryVO.getCategory());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return relatedCategories;
    }

    public List getRelatedCategoriesVOList(String groupName, Integer languageId, String attribute, Database db) throws SystemException, Exception {
        List relatedCategoriesVOList = new ArrayList();
        String cacheKey = groupName + "_" + languageId + "_" + attribute;
        logger.info((Object)("cacheKey:" + cacheKey));
        relatedCategoriesVOList = (List)CacheController.getCachedObject("relatedCategoriesCache", cacheKey);
        if (relatedCategoriesVOList != null) {
            logger.info((Object)("There was an cached groupPropertiesVOList:" + relatedCategoriesVOList.size()));
        } else {
            List relatedCategories = this.getRelatedCategories(groupName, languageId, attribute, db);
            if (relatedCategories != null) {
                relatedCategoriesVOList = GroupPropertiesController.toVOList(relatedCategories);
                CacheController.cacheObject("relatedCategoriesCache", cacheKey, relatedCategoriesVOList);
            }
        }
        return relatedCategoriesVOList;
    }

    public List getRelatedCategories(String groupName, Integer languageId, String attribute, Database db) {
        ArrayList<CategoryImpl> relatedCategories = new ArrayList<CategoryImpl>();
        try {
            List groupPropertiesVOList = this.getGroupPropertiesVOList(groupName, languageId, db);
            Iterator iterator = groupPropertiesVOList.iterator();
            GroupPropertiesVO groupPropertyVO = null;
            if (iterator.hasNext()) {
                groupPropertyVO = (GroupPropertiesVO)iterator.next();
            }
            if (groupPropertyVO != null && groupPropertyVO.getId() != null) {
                List propertiesCategoryList = PropertiesCategoryController.getController().findByPropertiesAttribute(attribute, GroupProperties.class.getName(), groupPropertyVO.getId(), db);
                for (PropertiesCategory propertiesCategory : propertiesCategoryList) {
                    relatedCategories.add(propertiesCategory.getCategory());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("We could not fetch the list of defined category keys: " + e.getMessage()), (Throwable)e);
        }
        return relatedCategories;
    }

    public BaseEntityVO getNewVO() {
        return new GroupPropertiesVO();
    }
}

