/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueAuthenticationFilter;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.sorters.ReflectionComparator;

public class GroupControllerProxy
extends BaseController {
    private AuthorizationModule authorizationModule = null;
    private Database transactionObject = null;

    public GroupControllerProxy(Database transactionObject) {
        this.transactionObject = transactionObject;
    }

    public static GroupControllerProxy getController() {
        return new GroupControllerProxy(null);
    }

    public static GroupControllerProxy getController(Database transactionObject) {
        return new GroupControllerProxy(transactionObject);
    }

    private AuthorizationModule getAuthorizationModule() {
        try {
            this.authorizationModule = (AuthorizationModule)Class.forName(InfoGlueAuthenticationFilter.authorizerClass).newInstance();
            this.authorizationModule.setExtraProperties(InfoGlueAuthenticationFilter.extraProperties);
            this.authorizationModule.setTransactionObject(this.transactionObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.authorizationModule;
    }

    public boolean getSupportUpdate() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportUpdate();
    }

    public boolean getSupportDelete() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportDelete();
    }

    public boolean getSupportCreate() throws ConstraintException, SystemException, Exception {
        return this.getAuthorizationModule().getSupportCreate();
    }

    public List getAllGroups() throws ConstraintException, SystemException, Exception {
        List groups = new ArrayList();
        groups = this.getAuthorizationModule().getGroups();
        Collections.sort(groups, new ReflectionComparator("displayName"));
        return groups;
    }

    public InfoGlueGroup getGroup(String groupName) throws ConstraintException, SystemException, Exception {
        InfoGlueGroup infoGlueGroup = null;
        infoGlueGroup = this.getAuthorizationModule().getAuthorizedInfoGlueGroup(groupName);
        return infoGlueGroup;
    }

    public List getInfoGluePrincipals(String groupName) throws ConstraintException, SystemException, Exception {
        List infoGluePrincipals = new ArrayList();
        infoGluePrincipals = this.getAuthorizationModule().getGroupUsers(groupName);
        Collections.sort(infoGluePrincipals, new ReflectionComparator("name"));
        return infoGluePrincipals;
    }

    public InfoGlueGroup createGroup(GroupVO groupVO) throws ConstraintException, SystemException, Exception {
        Object infoGlueGroup = null;
        this.getAuthorizationModule().createInfoGlueGroup(groupVO);
        return this.getGroup(groupVO.getGroupName());
    }

    public void updateGroup(GroupVO groupVO, String[] userNames) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().updateInfoGlueGroup(groupVO, userNames);
    }

    public void deleteGroup(String groupName) throws ConstraintException, SystemException, Exception {
        this.getAuthorizationModule().deleteInfoGlueGroup(groupName);
        AccessRightController.getController().delete(groupName);
    }

    public BaseEntityVO getNewVO() {
        return null;
    }

    public List getAvailableGroups(InfoGluePrincipal infoGluePrincipal, String interceptionPointName) throws ConstraintException, SystemException, Exception {
        ArrayList<InfoGlueGroup> availableGroups = new ArrayList<InfoGlueGroup>();
        List allGroups = this.getAuthorizationModule().getGroups();
        if (this.transactionObject == null) {
            Database db = CastorDatabaseService.getDatabase();
            try {
                GroupControllerProxy.beginTransaction(db);
                for (InfoGlueGroup group : allGroups) {
                    boolean hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, interceptionPointName, group.getName());
                    if (!hasAccess) continue;
                    availableGroups.add(group);
                }
                GroupControllerProxy.commitTransaction(db);
            }
            catch (Exception e) {
                GroupControllerProxy.rollbackTransaction(db);
                throw new SystemException(e);
            }
        } else {
            for (InfoGlueGroup group : allGroups) {
                boolean hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(this.transactionObject, infoGluePrincipal, interceptionPointName, group.getName());
                if (!hasAccess) continue;
                availableGroups.add(group);
            }
        }
        return availableGroups;
    }
}

