/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.SystemUserController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Group;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.SystemUser;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.entities.management.impl.simple.GroupImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.util.CacheController;

public class GroupController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)GroupController.class.getName());

    public static GroupController getController() {
        return new GroupController();
    }

    public Group getGroupWithId(Integer groupId, Database db) throws SystemException, Bug {
        return (Group)GroupController.getObjectWithId(GroupImpl.class, groupId, db);
    }

    public Group getGroupWithName(String groupName, Database db) throws SystemException, Bug {
        return (Group)GroupController.getObjectWithId(GroupImpl.class, groupName, db);
    }

    public GroupVO getGroupVOWithId(Integer groupId) throws SystemException, Bug {
        return (GroupVO)GroupController.getVOWithId(GroupImpl.class, groupId);
    }

    public GroupVO getGroupVOWithId(String groupName) throws SystemException, Bug {
        return (GroupVO)GroupController.getVOWithId(GroupImpl.class, groupName);
    }

    public GroupVO getGroupVOWithId(String groupName, Database db) throws SystemException, Bug {
        return (GroupVO)GroupController.getVOWithId(GroupImpl.class, groupName, db);
    }

    public List getGroupVOList() throws SystemException, Bug {
        return this.getAllVOObjects(GroupImpl.class, "groupName");
    }

    public List getGroupVOList(Database db) throws SystemException, Bug {
        String cacheKey = "allGroupVO";
        logger.info((Object)("cacheKey in getGroupVOList:" + cacheKey));
        List groupVOList = (List)CacheController.getCachedObject("groupVOListCache", cacheKey);
        if (groupVOList != null) {
            logger.info((Object)("There was an cached list of GroupVO:" + groupVOList.size()));
        } else {
            groupVOList = this.getAllVOObjects(GroupImpl.class, "groupName", db);
            if (groupVOList != null) {
                CacheController.cacheObject("groupVOListCache", cacheKey, groupVOList);
            }
        }
        return groupVOList;
    }

    public GroupVO create(GroupVO groupVO) throws ConstraintException, SystemException {
        Group group = new GroupImpl();
        group.setValueObject(groupVO);
        group = (Group)GroupController.createEntity(group);
        return group.getValueObject();
    }

    public Group create(GroupVO groupVO, Database db) throws ConstraintException, SystemException, Exception {
        Group group = new GroupImpl();
        group.setValueObject(groupVO);
        group = (Group)GroupController.createEntity(group, db);
        return group;
    }

    public void delete(GroupVO groupVO) throws ConstraintException, SystemException {
        GroupController.deleteEntity(GroupImpl.class, groupVO.getGroupName());
    }

    public void delete(String groupName) throws ConstraintException, SystemException {
        GroupController.deleteEntity(GroupImpl.class, groupName);
    }

    public void delete(String groupName, Database db) throws ConstraintException, SystemException, Exception {
        GroupController.deleteEntity(GroupImpl.class, groupName, db);
    }

    public List getGroupSystemUserVOList(String userName, Database db) throws SystemException, Bug {
        Collection systemUsers = null;
        ArrayList<SystemUserVO> systemUsersVO = new ArrayList<SystemUserVO>();
        Group group = null;
        try {
            group = this.getGroupWithName(userName, db);
            systemUsers = group.getSystemUsers();
            for (SystemUser systemUser : systemUsers) {
                systemUsersVO.add(systemUser.getValueObject());
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of users in this group. Reason:" + e.getMessage(), e);
        }
        return systemUsersVO;
    }

    public List getGroupSystemUserVOList(String groupName) throws SystemException, Bug {
        List systemUsersVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            GroupController.beginTransaction(db);
            systemUsersVO = this.getGroupSystemUserVOList(groupName, db);
            GroupController.commitTransaction(db);
        }
        catch (Exception e) {
            GroupController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a list of users in this group. Reason:" + e.getMessage(), e);
        }
        return systemUsersVO;
    }

    public GroupVO update(GroupVO groupVO) throws ConstraintException, SystemException {
        return (GroupVO)GroupController.updateEntity(GroupImpl.class, groupVO);
    }

    public GroupVO update(GroupVO groupVO, Database db) throws ConstraintException, SystemException {
        return (GroupVO)GroupController.updateEntity(GroupImpl.class, groupVO, db);
    }

    public GroupVO update(GroupVO groupVO, String[] systemUsers) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Group group = null;
        GroupController.beginTransaction(db);
        try {
            group = this.update(groupVO, systemUsers, db);
            ceb.throwIfNotEmpty();
            GroupController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            GroupController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            GroupController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return group.getValueObject();
    }

    public Group update(GroupVO groupVO, String[] systemUsers, Database db) throws ConstraintException, SystemException {
        Group group = this.getGroupWithName(groupVO.getGroupName(), db);
        group.getSystemUsers().clear();
        if (systemUsers != null) {
            int i = 0;
            while (i < systemUsers.length) {
                SystemUser systemUser = SystemUserController.getController().getSystemUserWithName(systemUsers[i], db);
                group.getSystemUsers().add(systemUser);
                systemUser.getGroups().add(group);
                ++i;
            }
        }
        group.setValueObject(groupVO);
        return group;
    }

    public List getGroupVOList(String userName) throws SystemException, Bug {
        List groupVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            GroupController.beginTransaction(db);
            SystemUser systemUser = SystemUserController.getController().getSystemUserWithName(userName, db);
            groupVOList = GroupController.toVOList(systemUser.getGroups());
            GroupController.commitTransaction(db);
        }
        catch (Exception e) {
            GroupController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a list of users in this group. Reason:" + e.getMessage(), e);
        }
        return groupVOList;
    }

    public Collection getGroupList(String userName, Database db) throws SystemException, Bug {
        Collection groupList = null;
        SystemUser systemUser = SystemUserController.getController().getSystemUserWithName(userName, db);
        groupList = systemUser.getGroups();
        return groupList;
    }

    public BaseEntityVO getNewVO() {
        return new GroupVO();
    }
}

