/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.FormEntry;
import org.infoglue.cms.entities.management.FormEntryVO;
import org.infoglue.cms.entities.management.FormEntryValue;
import org.infoglue.cms.entities.management.FormEntryValueVO;
import org.infoglue.cms.entities.management.impl.simple.FormEntryImpl;
import org.infoglue.cms.entities.management.impl.simple.FormEntryValueImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormEntryController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)FormEntryController.class.getName());

    public static FormEntryController getController() {
        return new FormEntryController();
    }

    public FormEntryVO getFormEntryVOWithId(Integer formEntryId) throws SystemException, Bug {
        return (FormEntryVO)FormEntryController.getVOWithId(FormEntryImpl.class, formEntryId);
    }

    public FormEntry getFormEntryWithId(Integer formEntryId, Database db) throws SystemException, Bug {
        return (FormEntry)FormEntryController.getObjectWithId(FormEntryImpl.class, formEntryId, db);
    }

    public List getFormEntryVOList() throws SystemException, Bug {
        List redirectVOList = this.getAllVOObjects(FormEntryImpl.class, "formEntryId");
        return redirectVOList;
    }

    public List getFormEntryVOList(Database db) throws SystemException, Bug {
        List redirectVOList = this.getAllVOObjects(FormEntryImpl.class, "formEntryId", db);
        return redirectVOList;
    }

    public List getFormEntryVOList(Integer formContentId) throws SystemException, Bug {
        List formEntryVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            FormEntryController.beginTransaction(db);
            List formEntryList = this.getFormEntryList(formContentId, db);
            formEntryVOList = FormEntryController.toVOList(formEntryList);
            FormEntryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            FormEntryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return formEntryVOList;
    }

    public List getFormEntryValueVOList(Integer formEntryId) throws SystemException, Bug {
        List formEntryValueVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            FormEntryController.beginTransaction(db);
            FormEntry formEntry = this.getFormEntryWithId(formEntryId, db);
            formEntryValueVOList = FormEntryController.toVOList(formEntry.getFormEntryValues());
            FormEntryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            FormEntryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return formEntryValueVOList;
    }

    public List getFormEntryList(Integer formContentId, Database db) throws SystemException, Bug {
        ArrayList<Object> formEntryList = new ArrayList<Object>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.FormEntryImpl f WHERE f.formContentId = $1 order by formEntryId");
            oql.bind((Object)formContentId);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                formEntryList.add(results.next());
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of form entries. Reason:" + e.getMessage(), e);
        }
        return formEntryList;
    }

    public FormEntryVO create(FormEntryVO redirectVO) throws ConstraintException, SystemException {
        FormEntry formEntry = new FormEntryImpl();
        formEntry.setValueObject(redirectVO);
        formEntry = (FormEntry)FormEntryController.createEntity(formEntry);
        return formEntry.getValueObject();
    }

    public FormEntry create(FormEntryVO formEntryVO, List<FormEntryValueVO> formEntryValueVOList, Database db) throws ConstraintException, SystemException, Exception {
        FormEntry formEntry = new FormEntryImpl();
        formEntry.setValueObject(formEntryVO);
        formEntry = (FormEntry)FormEntryController.createEntity(formEntry, db);
        for (FormEntryValueVO formEntryValueVO : formEntryValueVOList) {
            FormEntryValue formEntryValue = new FormEntryValueImpl();
            formEntryValue.setFormEntry(formEntry);
            formEntry.getFormEntryValues().add(formEntryValue);
            formEntryValue.setValueObject(formEntryValueVO);
            formEntryValue = (FormEntryValue)FormEntryController.createEntity(formEntryValue, db);
        }
        return formEntry;
    }

    public void delete(FormEntryVO formEntryVO) throws ConstraintException, SystemException {
        FormEntryController.deleteEntity(FormEntryImpl.class, formEntryVO.getFormEntryId());
    }

    public FormEntryVO update(FormEntryVO formEntryVO) throws ConstraintException, SystemException {
        return (FormEntryVO)FormEntryController.updateEntity(FormEntryImpl.class, formEntryVO);
    }

    @Override
    public BaseEntityVO getNewVO() {
        return new ContentTypeDefinitionVO();
    }
}

