/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryConditions;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedSearchCriterias {
    public static final int NO_DATE_CRITERIA_TYPE = 0;
    public static final int FROM_DATE_CRITERIA_TYPE = 1;
    public static final int TO_DATE_CRITERIA_TYPE = 2;
    public static final int BOTH_DATE_CRITERIA_TYPE = 3;
    private Integer stateId;
    private Integer forcedOperatingMode = null;
    private String freetext;
    private List xmlAttributes;
    private LanguageVO languageVO;
    private List contentTypeDefinitionVOs;
    private CategoryConditions categories;
    private Timestamp fromDate;
    private Timestamp toDate;
    private List<Integer> repositoryIdList;

    public ExtendedSearchCriterias() {
        this(ContentVersionVO.WORKING_STATE);
    }

    public ExtendedSearchCriterias(int stateId) {
        this.stateId = new Integer(stateId);
    }

    public void setForcedOperatingMode(Integer forcedOperatingMode) {
        this.forcedOperatingMode = forcedOperatingMode;
    }

    public void setFreetext(String freetext, List xmlAttributes) {
        this.freetext = freetext;
        if (xmlAttributes != null) {
            this.xmlAttributes = new ArrayList(xmlAttributes);
        }
    }

    public void setLanguage(LanguageVO languageVO) {
        this.languageVO = languageVO;
    }

    public void setContentTypeDefinitions(ContentTypeDefinitionVO contentTypeDefinitionVO) {
        if (contentTypeDefinitionVO != null) {
            this.contentTypeDefinitionVOs = new ArrayList();
            this.contentTypeDefinitionVOs.add(contentTypeDefinitionVO);
        }
    }

    public void setContentTypeDefinitions(List contentTypeDefinitionVOs) {
        if (contentTypeDefinitionVOs != null) {
            this.contentTypeDefinitionVOs = new ArrayList(contentTypeDefinitionVOs);
        }
    }

    public void setCategoryConditions(CategoryConditions categories) {
        this.categories = categories;
    }

    public void setDates(Date from, Date to) {
        this.fromDate = from == null ? null : new Timestamp(from.getTime());
        this.toDate = to == null ? null : new Timestamp(to.getTime());
    }

    public void setRepositoryIdList(List<Integer> repositoryIdList) {
        this.repositoryIdList = repositoryIdList;
    }

    public boolean hasFreetextCritera() {
        return this.freetext != null && this.freetext.length() > 0 && this.xmlAttributes != null && !this.xmlAttributes.isEmpty();
    }

    public boolean hasLanguageCriteria() {
        return this.languageVO != null;
    }

    public boolean hasContentTypeDefinitionVOsCriteria() {
        return this.contentTypeDefinitionVOs != null && !this.contentTypeDefinitionVOs.isEmpty();
    }

    public boolean hasCategoryConditions() {
        return this.categories != null && this.categories.hasCondition();
    }

    public int getDateCriteriaType() {
        if (this.toDate == null && this.fromDate == null) {
            return 0;
        }
        if (this.toDate != null && this.fromDate == null) {
            return 0;
        }
        if (this.toDate == null && this.fromDate != null) {
            return 1;
        }
        return 3;
    }

    public Integer getStateId() {
        return this.stateId;
    }

    public Object getForcedOperatingMode() {
        return this.forcedOperatingMode;
    }

    public String getFreetext() {
        return this.freetext;
    }

    public List getXmlAttributes() {
        return this.xmlAttributes;
    }

    public LanguageVO getLanguage() {
        return this.languageVO;
    }

    public List getContentTypeDefinitions() {
        return this.contentTypeDefinitionVOs;
    }

    public CategoryConditions getCategories() {
        return this.categories;
    }

    public Timestamp getFromDate() {
        return this.fromDate;
    }

    public Timestamp getToDate() {
        return this.toDate;
    }

    public List<Integer> getRepositoryIdList() {
        return this.repositoryIdList;
    }
}

