/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryConditions;
import org.infoglue.cms.controllers.kernel.impl.simple.ExtendedSearchCriterias;
import org.infoglue.cms.controllers.kernel.impl.simple.SqlBuilder;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ExtendedSearchController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ExtendedSearchController.class.getName());
    private static final ExtendedSearchController instance = new ExtendedSearchController();
    private static Boolean useFull = null;
    private static Boolean useSQLServerDialect = null;

    private ExtendedSearchController() {
    }

    public static ExtendedSearchController getController() {
        return instance;
    }

    public Set search(Integer stateId, ContentTypeDefinitionVO contentTypeDefinitionVO, LanguageVO languageVO, CategoryConditions categories) throws SystemException {
        ExtendedSearchCriterias criterias = new ExtendedSearchCriterias(stateId);
        criterias.setContentTypeDefinitions(contentTypeDefinitionVO);
        criterias.setLanguage(languageVO);
        criterias.setCategoryConditions(categories);
        return this.search(criterias);
    }

    public Set search(Integer stateId, ContentTypeDefinitionVO contentTypeDefinitionVO, LanguageVO languageVO, CategoryConditions categories, Database db) throws SystemException {
        ExtendedSearchCriterias criterias = new ExtendedSearchCriterias(stateId);
        criterias.setContentTypeDefinitions(contentTypeDefinitionVO);
        criterias.setLanguage(languageVO);
        criterias.setCategoryConditions(categories);
        return this.search(criterias, db);
    }

    public Set search(Integer stateId, List contentTypeDefinitionVOs, LanguageVO languageVO, CategoryConditions categories) throws SystemException {
        ExtendedSearchCriterias criterias = new ExtendedSearchCriterias(stateId);
        criterias.setContentTypeDefinitions(contentTypeDefinitionVOs);
        criterias.setLanguage(languageVO);
        criterias.setCategoryConditions(categories);
        return this.search(criterias);
    }

    public Set search(Integer stateId, List contentTypeDefinitionVOs, LanguageVO languageVO, CategoryConditions categories, Database db) throws SystemException {
        ExtendedSearchCriterias criterias = new ExtendedSearchCriterias(stateId);
        criterias.setContentTypeDefinitions(contentTypeDefinitionVOs);
        criterias.setLanguage(languageVO);
        criterias.setCategoryConditions(categories);
        return this.search(criterias, db);
    }

    public Set search(Integer stateId, ContentTypeDefinitionVO contentTypeDefinitionVO, LanguageVO languageVO, CategoryConditions categories, List xmlAttributes, String freetext) throws SystemException {
        ExtendedSearchCriterias criterias = new ExtendedSearchCriterias(stateId);
        criterias.setContentTypeDefinitions(contentTypeDefinitionVO);
        criterias.setLanguage(languageVO);
        criterias.setCategoryConditions(categories);
        criterias.setFreetext(freetext, xmlAttributes);
        return this.search(criterias);
    }

    public Set search(ExtendedSearchCriterias criterias) throws SystemException {
        Database db = ExtendedSearchController.beginTransaction();
        try {
            Set result = this.search(criterias, db);
            ExtendedSearchController.commitTransaction(db);
            return result;
        }
        catch (Exception e) {
            ExtendedSearchController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public Set search(ExtendedSearchCriterias criterias, Database db) throws SystemException {
        if (criterias == null) {
            return new HashSet();
        }
        try {
            SqlBuilder sqlBuilder = new SqlBuilder(criterias);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sql:" + sqlBuilder.getSQL()));
            }
            OQLQuery oql = db.getOQLQuery(sqlBuilder.getSQL());
            for (Object o : sqlBuilder.getBindings()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("o:" + o.toString()));
                }
                oql.bind(o);
            }
            QueryResults results = oql.execute((short)0);
            Set matchingResults = this.createResults(results);
            results.close();
            oql.close();
            return matchingResults;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException(e.getMessage());
        }
    }

    private Set createResults(QueryResults qr) throws PersistenceException, SystemException {
        HashSet<Object> results = new HashSet<Object>();
        while (qr.hasMore()) {
            results.add(qr.next());
        }
        return results;
    }

    public static boolean useFull() {
        if (useFull == null) {
            String useShortTableNames = CmsPropertyHandler.getUseShortTableNames();
            useFull = useShortTableNames == null || !useShortTableNames.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
        }
        return useFull;
    }

    public static boolean useSQLServerDialect() {
        if (useSQLServerDialect == null) {
            String databaseEngine = CmsPropertyHandler.getDatabaseEngine();
            useSQLServerDialect = databaseEngine == null || !databaseEngine.equalsIgnoreCase("mssql") && !databaseEngine.equalsIgnoreCase("sql-server") && !databaseEngine.equalsIgnoreCase("SQL Server") ? new Boolean(false) : new Boolean(true);
        }
        return useSQLServerDialect;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

