/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.workflow.Event;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.entities.workflow.impl.simple.EventImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;

public class EventController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)EventController.class.getName());

    public static EventVO getEventVOWithId(Integer eventId) throws SystemException, Bug {
        return (EventVO)EventController.getVOWithId(EventImpl.class, eventId);
    }

    public static Event getEventWithId(Integer eventId, Database db) throws SystemException, Bug {
        return (Event)EventController.getObjectWithId(EventImpl.class, eventId, db);
    }

    public List getEventVOList() throws SystemException, Bug {
        return this.getAllVOObjects(EventImpl.class, "eventId");
    }

    public static EventVO create(EventVO eventVO, Integer repositoryId, InfoGluePrincipal infoGluePrincipal, Database db) throws SystemException {
        Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
        EventImpl event = new EventImpl();
        event.setValueObject(eventVO);
        event.setRepository((RepositoryImpl)repository);
        event.setCreator(infoGluePrincipal.getName());
        try {
            db.create((Object)event);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return event.getValueObject();
    }

    public static EventVO create(EventVO eventVO, Integer repositoryId, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        EventImpl event = null;
        Database db = CastorDatabaseService.getDatabase();
        EventController.beginTransaction(db);
        try {
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
            event = new EventImpl();
            event.setValueObject(eventVO);
            event.setRepository((RepositoryImpl)repository);
            event.setCreator(infoGluePrincipal.getName());
            db.create((Object)event);
            EventController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            EventController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return event.getValueObject();
    }

    public static void delete(EventVO eventVO) throws SystemException {
        EventController.deleteEntity(EventImpl.class, eventVO.getEventId());
    }

    public static void delete(Event event, Database db) throws SystemException {
        try {
            db.remove((Object)event);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public static EventVO update(EventVO eventVO) throws SystemException {
        return (EventVO)EventController.updateEntity(EventImpl.class, eventVO);
    }

    public static List getEventVOListForEntity(String entityClass, Integer entityId) throws SystemException, Bug {
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        Database db = CastorDatabaseService.getDatabase();
        EventController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT e FROM org.infoglue.cms.entities.workflow.impl.simple.EventImpl e WHERE e.entityClass = $1 AND e.entityId = $2");
            oql.bind((Object)entityClass);
            oql.bind((Object)entityId);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Event event = (Event)results.next();
                events.add(event.getValueObject());
            }
            results.close();
            oql.close();
            EventController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            EventController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return events;
    }

    public static List getPublicationEventVOListForRepository(Integer repositoryId) throws SystemException, Bug {
        return EventController.getPublicationEventVOListForRepository(repositoryId, null, null);
    }

    public static List getPublicationEventVOListForRepository(Integer repositoryId, InfoGluePrincipal principal, String filter) throws SystemException, Bug {
        ArrayList<EventVO> events = new ArrayList<EventVO>();
        Database db = CastorDatabaseService.getDatabase();
        EventController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT e FROM org.infoglue.cms.entities.workflow.impl.simple.EventImpl e WHERE (e.typeId = $1 OR e.typeId = $2) AND e.repository.repositoryId = $3 ORDER BY e.eventId desc");
            oql.bind((Object)EventVO.PUBLISH);
            oql.bind((Object)EventVO.UNPUBLISH_LATEST);
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                boolean isValid;
                boolean isBroken;
                Event event;
                block34: {
                    event = (Event)results.next();
                    isBroken = false;
                    isValid = true;
                    try {
                        InfoGluePrincipal versionModifierPrincipal;
                        String versionModifier;
                        List groups;
                        if (event.getEntityClass().equalsIgnoreCase(ContentVersion.class.getName())) {
                            InfoGluePrincipal versionModifierPrincipal2;
                            String versionModifier2;
                            ContentVersionVO contentVersionVO = null;
                            ContentVO contentVO = null;
                            try {
                                contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(event.getEntityId(), db);
                                if (contentVersionVO != null && contentVersionVO.getContentId() != null) {
                                    contentVO = ContentController.getContentController().getContentVOWithId(contentVersionVO.getContentId(), db);
                                }
                            }
                            catch (SystemException e) {
                                isBroken = true;
                                throw e;
                            }
                            if (contentVersionVO == null || contentVO == null) {
                                isBroken = true;
                                isValid = false;
                                try {
                                    ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(event.getEntityId(), db);
                                    ContentVersionController.getContentVersionController().delete(contentVersion, db);
                                }
                                catch (Exception e) {
                                    logger.error((Object)("Error deleting contentVersion which lacked content:" + e.getMessage()), (Throwable)e);
                                }
                            } else if (principal != null && filter != null && filter.equalsIgnoreCase("groupBased")) {
                                InfoGluePrincipal versionModifierPrincipal3;
                                versionModifier2 = contentVersionVO.getVersionModifier();
                                if (versionModifier2 != null && (versionModifierPrincipal3 = UserControllerProxy.getController(db).getUser(versionModifier2)) != null) {
                                    boolean hasGroup = false;
                                    groups = versionModifierPrincipal3.getGroups();
                                    for (InfoGlueGroup group : groups) {
                                        if (!principal.getGroups().contains(group)) continue;
                                        hasGroup = true;
                                    }
                                    if (!hasGroup) {
                                        isValid = false;
                                    }
                                }
                            } else if (principal != null && filter != null && filter.indexOf("groupNameBased_") > -1 && (versionModifier2 = contentVersionVO.getVersionModifier()) != null && (versionModifierPrincipal2 = UserControllerProxy.getController(db).getUser(versionModifier2)) != null) {
                                boolean hasGroup = false;
                                String groupName = filter.substring(filter.indexOf("_") + 1);
                                List groups2 = versionModifierPrincipal2.getGroups();
                                for (InfoGlueGroup group : groups2) {
                                    if (!groupName.equalsIgnoreCase(group.getName())) continue;
                                    hasGroup = true;
                                }
                                if (!hasGroup) {
                                    isValid = false;
                                }
                            }
                            break block34;
                        }
                        if (!event.getEntityClass().equalsIgnoreCase(SiteNodeVersion.class.getName())) break block34;
                        SiteNodeVersion siteNodeVersion = null;
                        try {
                            siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(event.getEntityId(), db);
                        }
                        catch (SystemException e) {
                            isBroken = true;
                            throw e;
                        }
                        if (siteNodeVersion == null || siteNodeVersion.getOwningSiteNode() == null) {
                            isBroken = true;
                            isValid = false;
                            SiteNodeVersionController.getController().delete(siteNodeVersion, db);
                        } else if (principal != null && filter != null && filter.equalsIgnoreCase("groupBased")) {
                            versionModifier = siteNodeVersion.getVersionModifier();
                            if (versionModifier != null && (versionModifierPrincipal = UserControllerProxy.getController(db).getUser(versionModifier)) != null) {
                                boolean hasGroup = false;
                                List groups3 = versionModifierPrincipal.getGroups();
                                for (InfoGlueGroup group : groups3) {
                                    if (!principal.getGroups().contains(group)) continue;
                                    hasGroup = true;
                                }
                                if (!hasGroup) {
                                    isValid = false;
                                }
                            }
                        } else if (principal != null && filter != null && filter.indexOf("groupNameBased_") > -1 && (versionModifier = siteNodeVersion.getVersionModifier()) != null && (versionModifierPrincipal = UserControllerProxy.getController(db).getUser(versionModifier)) != null) {
                            boolean hasGroup = false;
                            String groupName = filter.substring(filter.indexOf("_") + 1);
                            groups = versionModifierPrincipal.getGroups();
                            for (InfoGlueGroup group : groups) {
                                if (!groupName.equalsIgnoreCase(group.getName())) continue;
                                hasGroup = true;
                            }
                            if (!hasGroup) {
                                isValid = false;
                            }
                        }
                    }
                    catch (Exception e) {
                        isValid = false;
                    }
                }
                if (isValid && !isBroken) {
                    events.add(event.getValueObject());
                }
                if (!isBroken) continue;
                EventController.delete(event, db);
            }
            results.close();
            oql.close();
            EventController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            EventController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return events;
    }

    public BaseEntityVO getNewVO() {
        return new EventVO();
    }
}

