/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupPropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.RolePropertiesController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserPropertiesController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.content.impl.simple.DigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumDigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.GroupProperties;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RoleProperties;
import org.infoglue.cms.entities.management.UserProperties;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.graphics.ThumbnailGenerator;
import org.infoglue.deliver.controllers.kernel.impl.simple.LanguageDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.HttpHelper;

public class DigitalAssetController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)DigitalAssetController.class.getName());
    private static final String BROKENFILENAME = "brokenAsset.gif";
    private static final DigitalAssetController singelton = new DigitalAssetController();

    public static DigitalAssetController getController() {
        return singelton;
    }

    public static DigitalAssetVO getDigitalAssetVOWithId(Integer digitalAssetId) throws SystemException, Bug {
        return (DigitalAssetVO)DigitalAssetController.getVOWithId(DigitalAssetImpl.class, digitalAssetId);
    }

    public static DigitalAssetVO getDigitalAssetVOWithId(Integer digitalAssetId, Database db) throws SystemException, Bug {
        return (DigitalAssetVO)DigitalAssetController.getVOWithId(DigitalAssetImpl.class, digitalAssetId, db);
    }

    public static DigitalAsset getDigitalAssetWithId(Integer digitalAssetId, Database db) throws SystemException, Bug {
        return (DigitalAsset)DigitalAssetController.getObjectWithId(DigitalAssetImpl.class, digitalAssetId, db);
    }

    public static DigitalAsset getMediumDigitalAssetWithId(Integer digitalAssetId, Database db) throws SystemException, Bug {
        return (DigitalAsset)DigitalAssetController.getObjectWithIdAsReadOnly(MediumDigitalAssetImpl.class, digitalAssetId, db);
    }

    public static DigitalAssetVO getSmallDigitalAssetVOWithId(Integer digitalAssetId, Database db) throws SystemException, Bug {
        return (DigitalAssetVO)DigitalAssetController.getVOWithId(SmallDigitalAssetImpl.class, digitalAssetId, db);
    }

    public static DigitalAsset getSmallDigitalAssetWithId(Integer digitalAssetId, Database db) throws SystemException, Bug {
        return (DigitalAsset)DigitalAssetController.getObjectWithId(SmallDigitalAssetImpl.class, digitalAssetId, db);
    }

    public static DigitalAssetVO create(DigitalAssetVO digitalAssetVO, InputStream is, Integer contentVersionId, InfoGluePrincipal principal) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        DigitalAssetController.beginTransaction(db);
        try {
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().checkStateAndChangeIfNeeded(contentVersionId, principal, db);
            digitalAssetVO = DigitalAssetController.create(digitalAssetVO, is, contentVersion, db);
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVO;
    }

    public static DigitalAssetVO create(DigitalAssetVO digitalAssetVO, InputStream is, ContentVersion contentVersion, Database db) throws SystemException, Exception {
        DigitalAssetImpl digitalAsset = null;
        ArrayList<ContentVersion> contentVersions = new ArrayList<ContentVersion>();
        contentVersions.add(contentVersion);
        logger.info((Object)("Added contentVersion:" + contentVersion.getId()));
        digitalAsset = new DigitalAssetImpl();
        digitalAsset.setValueObject(digitalAssetVO.createCopy());
        if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
            digitalAsset.setAssetBlob(is);
        }
        digitalAsset.setContentVersions(contentVersions);
        db.create((Object)digitalAsset);
        contentVersion.getDigitalAssets().add(digitalAsset);
        return digitalAsset.getValueObject();
    }

    public static DigitalAssetVO create(DigitalAssetVO digitalAssetVO, InputStream is, String entity, Integer entityId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        DigitalAsset digitalAsset = null;
        DigitalAssetController.beginTransaction(db);
        try {
            if (entity.equalsIgnoreCase("ContentVersion")) {
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(entityId, db);
                ArrayList<ContentVersion> contentVersions = new ArrayList<ContentVersion>();
                contentVersions.add(contentVersion);
                logger.info((Object)("Added contentVersion:" + contentVersion.getId()));
                digitalAsset = new DigitalAssetImpl();
                digitalAsset.setValueObject(digitalAssetVO);
                if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                    digitalAsset.setAssetBlob(is);
                }
                digitalAsset.setContentVersions(contentVersions);
                db.create((Object)digitalAsset);
                contentVersion.getDigitalAssets().add(digitalAsset);
            } else if (entity.equalsIgnoreCase(UserProperties.class.getName())) {
                UserProperties userProperties = UserPropertiesController.getController().getUserPropertiesWithId(entityId, db);
                ArrayList<UserProperties> userPropertiesList = new ArrayList<UserProperties>();
                userPropertiesList.add(userProperties);
                logger.info((Object)("Added userProperties:" + userProperties.getId()));
                digitalAsset = new DigitalAssetImpl();
                digitalAsset.setValueObject(digitalAssetVO);
                if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                    digitalAsset.setAssetBlob(is);
                }
                digitalAsset.setUserProperties(userPropertiesList);
                db.create((Object)digitalAsset);
                userProperties.getDigitalAssets().add(digitalAsset);
            } else if (entity.equalsIgnoreCase(RoleProperties.class.getName())) {
                RoleProperties roleProperties = RolePropertiesController.getController().getRolePropertiesWithId(entityId, db);
                ArrayList<RoleProperties> rolePropertiesList = new ArrayList<RoleProperties>();
                rolePropertiesList.add(roleProperties);
                logger.info((Object)("Added roleProperties:" + roleProperties.getId()));
                digitalAsset = new DigitalAssetImpl();
                digitalAsset.setValueObject(digitalAssetVO);
                if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                    digitalAsset.setAssetBlob(is);
                }
                digitalAsset.setRoleProperties(rolePropertiesList);
                db.create((Object)digitalAsset);
                roleProperties.getDigitalAssets().add(digitalAsset);
            } else if (entity.equalsIgnoreCase(GroupProperties.class.getName())) {
                GroupProperties groupProperties = GroupPropertiesController.getController().getGroupPropertiesWithId(entityId, db);
                ArrayList<GroupProperties> groupPropertiesList = new ArrayList<GroupProperties>();
                groupPropertiesList.add(groupProperties);
                logger.info((Object)("Added groupProperties:" + groupProperties.getId()));
                digitalAsset = new DigitalAssetImpl();
                digitalAsset.setValueObject(digitalAssetVO);
                if (CmsPropertyHandler.getEnableDiskAssets().equals("false")) {
                    digitalAsset.setAssetBlob(is);
                }
                digitalAsset.setGroupProperties(groupPropertiesList);
                db.create((Object)digitalAsset);
                groupProperties.getDigitalAssets().add(digitalAsset);
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAsset.getValueObject();
    }

    public DigitalAsset create(Database db, DigitalAssetVO digitalAssetVO, InputStream is) throws SystemException, Exception {
        DigitalAssetImpl digitalAsset = new DigitalAssetImpl();
        digitalAsset.setValueObject(digitalAssetVO);
        digitalAsset.setAssetBlob(is);
        db.create((Object)digitalAsset);
        return digitalAsset;
    }

    public DigitalAssetVO createByCopy(Integer originalContentVersionId, String oldAssetKey, Integer newContentVersionId, String newAssetKey, Database db) throws ConstraintException, SystemException {
        logger.info((Object)"Creating by copying....");
        logger.info((Object)("originalContentVersionId:" + originalContentVersionId));
        logger.info((Object)("oldAssetKey:" + oldAssetKey));
        logger.info((Object)("newContentVersionId:" + newContentVersionId));
        logger.info((Object)("newAssetKey:" + newAssetKey));
        DigitalAsset oldDigitalAsset = this.getDigitalAsset(originalContentVersionId, oldAssetKey, db);
        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(newContentVersionId, db);
        ArrayList<ContentVersion> contentVersions = new ArrayList<ContentVersion>();
        contentVersions.add(contentVersion);
        logger.info((Object)("Added contentVersion:" + contentVersion.getId()));
        DigitalAssetVO digitalAssetVO = new DigitalAssetVO();
        digitalAssetVO.setAssetContentType(oldDigitalAsset.getAssetContentType());
        digitalAssetVO.setAssetFileName(oldDigitalAsset.getAssetFileName());
        digitalAssetVO.setAssetFilePath(oldDigitalAsset.getAssetFilePath());
        digitalAssetVO.setAssetFileSize(oldDigitalAsset.getAssetFileSize());
        digitalAssetVO.setAssetKey(newAssetKey);
        DigitalAssetImpl digitalAsset = new DigitalAssetImpl();
        digitalAsset.setValueObject(digitalAssetVO);
        digitalAsset.setAssetBlob(oldDigitalAsset.getAssetBlob());
        digitalAsset.setContentVersions(contentVersions);
        try {
            db.create((Object)digitalAsset);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return digitalAsset.getValueObject();
    }

    public DigitalAsset getDigitalAsset(Integer contentVersionId, String assetKey, Database db) throws SystemException {
        DigitalAsset digitalAsset = null;
        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, db);
        Collection digitalAssets = contentVersion.getDigitalAssets();
        for (DigitalAsset currentDigitalAsset : digitalAssets) {
            if (!currentDigitalAsset.getAssetKey().equals(assetKey)) continue;
            digitalAsset = currentDigitalAsset;
            break;
        }
        return digitalAsset;
    }

    public static void delete(Integer digitalAssetId) throws ConstraintException, SystemException {
        DigitalAssetController.deleteEntity(DigitalAssetImpl.class, digitalAssetId);
    }

    public void delete(Integer digitalAssetId, Database db) throws ConstraintException, SystemException {
        DigitalAssetController.deleteEntity(DigitalAssetImpl.class, digitalAssetId, db);
    }

    public void delete(Integer digitalAssetId, String entity, Integer entityId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        DigitalAssetController.beginTransaction(db);
        try {
            DigitalAsset digitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetId, db);
            if (entity.equalsIgnoreCase("ContentVersion")) {
                ContentVersionController.getContentVersionController().deleteDigitalAssetRelation(entityId, digitalAsset, db);
            } else if (entity.equalsIgnoreCase(UserProperties.class.getName())) {
                UserPropertiesController.getController().deleteDigitalAssetRelation(entityId, digitalAsset, db);
            } else if (entity.equalsIgnoreCase(RoleProperties.class.getName())) {
                RolePropertiesController.getController().deleteDigitalAssetRelation(entityId, digitalAsset, db);
            } else if (entity.equalsIgnoreCase(GroupProperties.class.getName())) {
                GroupPropertiesController.getController().deleteDigitalAssetRelation(entityId, digitalAsset, db);
            }
            logger.info((Object)("digitalAsset size after:" + digitalAsset.getContentVersions().size()));
            if (digitalAsset.getContentVersions().size() == 0) {
                db.remove((Object)digitalAsset);
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static File[] getCachedFiles() throws SystemException, Exception {
        String assetPath;
        File[] cachedAssets = (File[])CacheController.getCachedObjectFromAdvancedCache("cachedAssetFileList", "allAssets", 300);
        if (cachedAssets == null && (assetPath = CmsPropertyHandler.getDigitalAssetPath()) != null && !assetPath.equals("")) {
            File assetDirectory = new File(assetPath);
            if (assetDirectory.exists()) {
                cachedAssets = assetDirectory.listFiles();
            }
            CacheController.cacheObjectInAdvancedCache("cachedAssetFileList", "allAssets", cachedAssets);
        }
        return cachedAssets;
    }

    public static void deleteCachedDigitalAssets(Integer digitalAssetId) throws SystemException, Exception {
        try {
            File[] cachedFiles = DigitalAssetController.getCachedFiles();
            if (cachedFiles != null) {
                int i = 0;
                while (i < cachedFiles.length) {
                    File cachedFile = cachedFiles[i];
                    if (cachedFile.getName().startsWith("" + digitalAssetId)) {
                        cachedFile.delete();
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Could not delete the assets for the digitalAsset " + digitalAssetId + ":" + e.getMessage()), (Throwable)e);
        }
    }

    public static DigitalAssetVO update(DigitalAssetVO digitalAssetVO, InputStream is) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        DigitalAsset digitalAsset = null;
        DigitalAssetController.beginTransaction(db);
        try {
            digitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetVO.getId(), db);
            digitalAsset.setValueObject(digitalAssetVO);
            if (is != null) {
                digitalAsset.setAssetBlob(is);
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAsset.getValueObject();
    }

    public static List getDigitalAssetVOList(Integer contentVersionId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        List digitalAssetVOList = new ArrayList();
        DigitalAssetController.beginTransaction(db);
        try {
            digitalAssetVOList = DigitalAssetController.getDigitalAssetVOList(contentVersionId, db);
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to fetch the list of digitalAssets belonging to this contentVersion:" + e));
            e.printStackTrace();
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVOList;
    }

    public static List getDigitalAssetVOList(Integer contentVersionId, Database db) throws Exception {
        String cacheName = "digitalAssetCache";
        String key = "" + contentVersionId;
        ArrayList<DigitalAssetVO> digitalAssetVOList = (ArrayList<DigitalAssetVO>)CacheController.getCachedObject(cacheName, key);
        if (digitalAssetVOList != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached digitalAssetVOList:" + digitalAssetVOList));
            }
            return digitalAssetVOList;
        }
        digitalAssetVOList = new ArrayList<DigitalAssetVO>();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Making a sql call for assets on " + contentVersionId));
        }
        OQLQuery oql = db.getOQLQuery("CALL SQL SELECT c.digitalAssetId, c.assetFileName, c.assetKey, c.assetFilePath, c.assetContentType, c.assetFileSize FROM cmDigitalAsset c, cmContentVersionDigitalAsset cvda where cvda.digitalAssetId = c.digitalAssetId AND cvda.contentVersionId = $1 ORDER BY c.digitalAssetId AS org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl");
        if (CmsPropertyHandler.getUseShortTableNames() != null && CmsPropertyHandler.getUseShortTableNames().equalsIgnoreCase("true")) {
            oql = db.getOQLQuery("CALL SQL SELECT c.DigAssetId, c.assetFileName, c.assetKey, c.assetFilePath, c.assetContentType, c.assetFileSize FROM cmDigAsset c, cmContVerDigAsset cvda where cvda.DigAssetId = c.DigAssetId AND cvda.ContVerId = $1 ORDER BY c.DigAssetId AS org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl");
        }
        oql.bind((Object)contentVersionId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            SmallDigitalAssetImpl digitalAsset = (SmallDigitalAssetImpl)results.next();
            digitalAssetVOList.add(digitalAsset.getValueObject());
        }
        results.close();
        oql.close();
        if (digitalAssetVOList != null) {
            CacheController.cacheObject(cacheName, key, digitalAssetVOList);
        }
        return digitalAssetVOList;
    }

    public static List getDigitalAssetVOList(Integer contentId, Integer languageId, boolean useLanguageFallback) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        List digitalAssetVOList = null;
        DigitalAssetController.beginTransaction(db);
        try {
            digitalAssetVOList = DigitalAssetController.getDigitalAssetVOList(contentId, languageId, useLanguageFallback, db);
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred when we tried to cache and show the digital asset:" + e));
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVOList;
    }

    public static List getDigitalAssetVOList(Integer contentId, Integer languageId, boolean useLanguageFallback, Database db) throws SystemException, Bug, Exception {
        String cacheName = "digitalAssetCache";
        String key = contentId + "_" + languageId + "_" + useLanguageFallback;
        List digitalAssetVOList = (ArrayList)CacheController.getCachedObject(cacheName, key);
        if (digitalAssetVOList != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached digitalAssetVOList:" + digitalAssetVOList));
            }
            return digitalAssetVOList;
        }
        digitalAssetVOList = new ArrayList();
        Content content = ContentController.getContentController().getContentWithId(contentId, db);
        logger.info((Object)("content:" + content.getName()));
        logger.info((Object)("repositoryId:" + content.getRepository().getId()));
        logger.info((Object)("languageId:" + languageId));
        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentId, languageId, db);
        LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(content.getRepository().getRepositoryId(), db);
        logger.info((Object)("contentVersion:" + contentVersion));
        if (contentVersion != null) {
            digitalAssetVOList = DigitalAssetController.getDigitalAssetVOList(contentVersion.getId(), db);
            logger.info((Object)("digitalAssetVOList:" + digitalAssetVOList.size()));
            if (useLanguageFallback && languageId.intValue() != masterLanguageVO.getId().intValue()) {
                List masterDigitalAssetVOList = DigitalAssetController.getDigitalAssetVOList(contentId, masterLanguageVO.getId(), useLanguageFallback, db);
                for (DigitalAssetVO currentDigitalAssetVO : digitalAssetVOList) {
                    Iterator masterDigitalAssetVOListIterator = masterDigitalAssetVOList.iterator();
                    while (masterDigitalAssetVOListIterator.hasNext()) {
                        DigitalAssetVO masterCurrentDigitalAssetVO = (DigitalAssetVO)masterDigitalAssetVOListIterator.next();
                        if (!currentDigitalAssetVO.getAssetKey().equalsIgnoreCase(masterCurrentDigitalAssetVO.getAssetKey())) continue;
                        masterDigitalAssetVOListIterator.remove();
                    }
                }
                digitalAssetVOList.addAll(masterDigitalAssetVOList);
            }
        } else if (useLanguageFallback && languageId.intValue() != masterLanguageVO.getId().intValue()) {
            contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentId, masterLanguageVO.getId(), db);
            logger.info((Object)("contentVersion:" + contentVersion));
            if (contentVersion != null) {
                digitalAssetVOList = DigitalAssetController.getDigitalAssetVOList(contentVersion.getId(), db);
            }
        }
        if (digitalAssetVOList != null) {
            CacheController.cacheObject(cacheName, key, digitalAssetVOList);
        }
        return digitalAssetVOList;
    }

    public static String getDigitalAssetUrl(Integer digitalAssetId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetUrl = null;
        DigitalAssetController.beginTransaction(db);
        try {
            DigitalAsset digitalAsset = DigitalAssetController.getSmallDigitalAssetWithId(digitalAssetId, db);
            if (digitalAsset != null) {
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("folderName:" + folderName));
                    logger.info((Object)("Found a digital asset:" + digitalAsset.getAssetFileName()));
                }
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                boolean fileExists = DigitalAssetController.dumpDigitalAsset(digitalAsset.getValueObject(), fileName, filePath, db);
                assetUrl = !fileExists ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + BROKENFILENAME : String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + fileName;
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to cache and show the digital asset:" + e.getMessage()));
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetUrl;
    }

    public static String getDigitalAssetFilePath(Integer digitalAssetId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetPath = null;
        DigitalAssetController.beginTransaction(db);
        try {
            DigitalAsset digitalAsset = DigitalAssetController.getSmallDigitalAssetWithId(digitalAssetId, db);
            if (digitalAsset != null) {
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("folderName:" + folderName));
                    logger.info((Object)("Found a digital asset:" + digitalAsset.getAssetFileName()));
                }
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                DigitalAssetController.dumpDigitalAsset(digitalAsset.getValueObject(), fileName, filePath, db);
                assetPath = String.valueOf(filePath) + File.separator + fileName;
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to cache and show the digital asset:" + e.getMessage()));
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetPath;
    }

    public static String getDigitalAssetProtectedFilePath(Integer digitalAssetId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetPath = null;
        DigitalAssetController.beginTransaction(db);
        try {
            DigitalAsset digitalAsset = DigitalAssetController.getSmallDigitalAssetWithId(digitalAssetId, db);
            if (digitalAsset != null) {
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("folderName:" + folderName));
                    logger.info((Object)("Found a digital asset:" + digitalAsset.getAssetFileName()));
                }
                String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + "protected" + File.separator + folderName;
                DigitalAssetController.dumpDigitalAsset(digitalAsset.getValueObject(), fileName, filePath, db);
                assetPath = String.valueOf(filePath) + File.separator + fileName;
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to cache and show the digital asset:" + e.getMessage()));
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetPath;
    }

    public InputStream getAssetInputStream(DigitalAsset digitalAsset, boolean returnNullIfBroken) throws Exception {
        String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("folderName:" + folderName));
        }
        String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
        String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
        boolean ok = DigitalAssetController.dumpDigitalAsset(digitalAsset, fileName, filePath);
        File assetFile = new File(String.valueOf(filePath) + File.separator + fileName);
        if (ok && assetFile.exists()) {
            return new FileInputStream(assetFile);
        }
        if (returnNullIfBroken) {
            return null;
        }
        return new ByteArrayInputStream("archived".getBytes());
    }

    public String getDigitalAssetUrl(DigitalAssetVO digitalAssetVO, Database db) throws SystemException, Bug, Exception {
        String assetUrl = null;
        if (digitalAssetVO != null) {
            String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("folderName:" + folderName));
                logger.info((Object)("Found a digital asset:" + digitalAssetVO.getAssetFileName()));
            }
            String fileName = digitalAssetVO.getDigitalAssetId() + "_" + digitalAssetVO.getAssetFileName();
            String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
            DigitalAssetController.dumpDigitalAsset(digitalAssetVO, fileName, filePath, db);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("WebServerAddress:" + CmsPropertyHandler.getWebServerAddress()));
                logger.info((Object)("ServletContext:" + CmsPropertyHandler.getServletContext()));
            }
            assetUrl = CmsPropertyHandler.getWebServerAddress().indexOf(CmsPropertyHandler.getServletContext()) > -1 ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + fileName : String.valueOf(CmsPropertyHandler.getWebServerAddress()) + CmsPropertyHandler.getServletContext() + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + fileName;
        }
        return assetUrl;
    }

    public static String getDigitalAssetThumbnailUrl(Integer digitalAssetId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetUrl = null;
        DigitalAssetController.beginTransaction(db);
        try {
            DigitalAsset digitalAsset = DigitalAssetController.getSmallDigitalAssetWithId(digitalAssetId, db);
            if (digitalAsset != null) {
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("folderName:" + folderName));
                    logger.info((Object)("Found a digital asset:" + digitalAsset.getAssetFileName()));
                }
                String contentType = digitalAsset.getAssetContentType();
                String assetFilePath = digitalAsset.getAssetFilePath();
                if (assetFilePath.indexOf("IG_ARCHIVE:") > -1) {
                    assetUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/archivedAsset.gif";
                } else if (contentType.equalsIgnoreCase("image/gif") || contentType.equalsIgnoreCase("image/jpg") || contentType.equalsIgnoreCase("image/pjpeg") || contentType.equalsIgnoreCase("image/jpeg") || contentType.equalsIgnoreCase("image/png")) {
                    String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                    logger.info((Object)("fileName:" + fileName));
                    String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                    logger.info((Object)("filePath:" + filePath));
                    logger.info((Object)("Making thumb from:" + filePath + File.separator + fileName));
                    String thumbnailFileName = digitalAsset.getDigitalAssetId() + "_thumbnail_" + digitalAsset.getAssetFileName();
                    File thumbnailFile = new File(String.valueOf(filePath) + File.separator + thumbnailFileName);
                    File originalFile = new File(String.valueOf(filePath) + File.separator + fileName);
                    if (!originalFile.exists()) {
                        logger.warn((Object)("The original file " + filePath + File.separator + fileName + " was not found - missing from system."));
                        assetUrl = "images" + File.separator + BROKENFILENAME;
                    } else {
                        if (!thumbnailFile.exists() && originalFile.exists()) {
                            logger.info((Object)"transforming...");
                            ThumbnailGenerator tg = new ThumbnailGenerator();
                            tg.transform(String.valueOf(filePath) + File.separator + fileName, String.valueOf(filePath) + File.separator + thumbnailFileName, 75, 75, 100);
                            logger.info((Object)"transform done...");
                        }
                        assetUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + thumbnailFileName;
                        logger.info((Object)("assetUrl:" + assetUrl));
                    }
                } else {
                    String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                    String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                    File originalFile = new File(String.valueOf(filePath) + File.separator + fileName);
                    assetUrl = !originalFile.exists() ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + BROKENFILENAME : (contentType.equalsIgnoreCase("application/pdf") ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "pdf.gif" : (contentType.equalsIgnoreCase("application/msword") ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "msword.gif" : (contentType.equalsIgnoreCase("application/vnd.ms-excel") ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "msexcel.gif" : (contentType.equalsIgnoreCase("application/vnd.ms-powerpoint") ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "mspowerpoint.gif" : (contentType.equalsIgnoreCase("application/zip") ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "zipIcon.gif" : (contentType.equalsIgnoreCase("text/xml") ? String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "xmlIcon.gif" : String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getImagesBaseUrl() + "/" + "digitalAsset.gif"))))));
                }
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to cache and show the digital asset thumbnail:" + e));
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetUrl;
    }

    public static String getDigitalAssetUrl(Integer contentId, Integer languageId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetUrl = null;
        DigitalAssetController.beginTransaction(db);
        try {
            DigitalAssetVO digitalAssetVO;
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestContentVersion(contentId, languageId, db);
            if (contentVersion != null && (digitalAssetVO = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), db)) != null) {
                String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("folderName:" + folderName));
                    logger.info((Object)("Found a digital asset:" + digitalAssetVO.getAssetFileName()));
                }
                String fileName = digitalAssetVO.getDigitalAssetId() + "_" + digitalAssetVO.getAssetFileName();
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                DigitalAssetController.dumpDigitalAsset(digitalAssetVO, fileName, filePath, db);
                assetUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + fileName;
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to cache and show the digital asset:" + e));
            e.printStackTrace();
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetUrl;
    }

    public static String getDigitalAssetUrl(Integer contentId, Integer languageId, String assetKey, boolean useLanguageFallback) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetUrl = null;
        DigitalAssetController.beginTransaction(db);
        try {
            assetUrl = DigitalAssetController.getDigitalAssetUrl(contentId, languageId, assetKey, useLanguageFallback, db);
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to cache and show the digital asset:" + e));
            e.printStackTrace();
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetUrl;
    }

    public static String getDigitalAssetUrl(Integer contentId, Integer languageId, String assetKey, boolean useLanguageFallback, Database db) throws SystemException, Bug, Exception {
        String toEncoding;
        String fromEncoding;
        String assetUrl = null;
        Content content = ContentController.getContentController().getContentWithId(contentId, db);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("content:" + content.getName()));
            logger.info((Object)("repositoryId:" + content.getRepository().getId()));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("assetKey:" + assetKey));
        }
        if ((fromEncoding = CmsPropertyHandler.getAssetKeyFromEncoding()) == null) {
            fromEncoding = "iso-8859-1";
        }
        if ((toEncoding = CmsPropertyHandler.getAssetKeyToEncoding()) == null) {
            toEncoding = "utf-8";
        }
        assetKey = new String(assetKey.getBytes(fromEncoding), toEncoding);
        StringBuffer sb = new StringBuffer(256);
        String servletContext = CmsPropertyHandler.getServletContext();
        String digitalAssetPath = CmsPropertyHandler.getDigitalAssetBaseUrl();
        if (!digitalAssetPath.startsWith("/")) {
            digitalAssetPath = "/" + digitalAssetPath;
        }
        if (digitalAssetPath.indexOf(servletContext) == -1) {
            sb.append(servletContext);
        }
        sb.append(digitalAssetPath);
        if (!sb.toString().endsWith("/")) {
            sb.append("/");
        }
        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentId, languageId, db);
        LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(content.getRepository().getRepositoryId(), db);
        logger.info((Object)("contentVersion:" + contentVersion));
        if (contentVersion != null) {
            DigitalAssetVO digitalAssetVO = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getContentVersionId(), assetKey, db);
            logger.info((Object)("digitalAssetVO:" + digitalAssetVO));
            if (digitalAssetVO != null) {
                String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("folderName:" + folderName));
                    logger.info((Object)("digitalAsset:" + digitalAssetVO.getAssetKey()));
                    logger.info((Object)("Found a digital asset:" + digitalAssetVO.getAssetFileName()));
                }
                String fileName = digitalAssetVO.getDigitalAssetId() + "_" + digitalAssetVO.getAssetFileName();
                String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                DigitalAssetController.dumpDigitalAsset(digitalAssetVO, fileName, filePath, db);
                assetUrl = String.valueOf(sb.toString()) + folderName + "/" + fileName;
            } else if (useLanguageFallback && languageId.intValue() != masterLanguageVO.getId().intValue()) {
                return DigitalAssetController.getDigitalAssetUrl(contentId, masterLanguageVO.getId(), assetKey, useLanguageFallback, db);
            }
        } else if (useLanguageFallback && languageId.intValue() != masterLanguageVO.getId().intValue()) {
            contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentId, masterLanguageVO.getId(), db);
            logger.info((Object)("contentVersion:" + contentVersion));
            if (contentVersion != null) {
                DigitalAssetVO digitalAssetVO = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
                logger.info((Object)("digitalAssetVO:" + digitalAssetVO));
                if (digitalAssetVO != null) {
                    String folderName = "" + digitalAssetVO.getDigitalAssetId() / 1000;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("folderName:" + folderName));
                        logger.info((Object)("digitalAsset:" + digitalAssetVO.getAssetKey()));
                        logger.info((Object)("Found a digital asset:" + digitalAssetVO.getAssetFileName()));
                    }
                    String fileName = digitalAssetVO.getDigitalAssetId() + "_" + digitalAssetVO.getAssetFileName();
                    String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                    DigitalAssetController.dumpDigitalAsset(digitalAssetVO, fileName, filePath, db);
                    assetUrl = String.valueOf(sb.toString()) + folderName + "/" + fileName;
                }
            }
        }
        return assetUrl;
    }

    public static DigitalAssetVO getDigitalAssetVO(Integer contentId, Integer languageId, String assetKey, boolean useLanguageFallback) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        DigitalAssetVO digitalAssetVO = null;
        DigitalAssetController.beginTransaction(db);
        try {
            digitalAssetVO = DigitalAssetController.getDigitalAssetVO(contentId, languageId, assetKey, useLanguageFallback, db);
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to get a digitalAssetVO:" + e));
            e.printStackTrace();
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return digitalAssetVO;
    }

    public static DigitalAssetVO getDigitalAssetVO(Integer contentId, Integer languageId, String assetKey, boolean useLanguageFallback, Database db) throws SystemException, Bug, Exception {
        DigitalAssetVO digitalAssetVO = null;
        Content content = ContentController.getContentController().getContentWithId(contentId, db);
        ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentId, languageId, db);
        if (contentVersion != null) {
            DigitalAssetVO digitalAsset = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), assetKey, db);
            if (digitalAsset != null) {
                digitalAssetVO = digitalAsset;
            } else {
                LanguageVO masterLanguageVO = LanguageDeliveryController.getLanguageDeliveryController().getMasterLanguageForRepository(content.getRepository().getRepositoryId(), db);
                if (useLanguageFallback && languageId.intValue() != masterLanguageVO.getId().intValue()) {
                    return DigitalAssetController.getDigitalAssetVO(contentId, masterLanguageVO.getId(), assetKey, useLanguageFallback, db);
                }
            }
        }
        return digitalAssetVO;
    }

    public static String getDigitalAssetThumbnailUrl(Integer contentId, Integer languageId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        String assetUrl = null;
        DigitalAssetController.beginTransaction(db);
        try {
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestContentVersion(contentId, languageId, db);
            if (contentVersion != null) {
                DigitalAsset digitalAsset = DigitalAssetController.getSmallDigitalAssetWithId(contentVersion.getId(), db);
                if (digitalAsset != null) {
                    logger.info((Object)("Found a digital asset:" + digitalAsset.getAssetFileName()));
                    String contentType = digitalAsset.getAssetContentType();
                    String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                    logger.info((Object)("folderName:" + folderName));
                    if (contentType.equalsIgnoreCase("image/gif") || contentType.equalsIgnoreCase("image/jpg") || contentType.equalsIgnoreCase("image/png")) {
                        String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                        String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                        String thumbnailFileName = digitalAsset.getDigitalAssetId() + "_thumbnail_" + digitalAsset.getAssetFileName();
                        File thumbnailFile = new File(String.valueOf(filePath) + File.separator + thumbnailFileName);
                        if (!thumbnailFile.exists()) {
                            ThumbnailGenerator tg = new ThumbnailGenerator();
                            tg.transform(String.valueOf(filePath) + File.separator + fileName, String.valueOf(filePath) + File.separator + thumbnailFileName, 150, 150, 100);
                        }
                        assetUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + folderName + "/" + thumbnailFileName;
                    } else {
                        String fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                        String filePath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + folderName;
                        File originalFile = new File(String.valueOf(filePath) + File.separator + fileName);
                        assetUrl = !originalFile.exists() ? "images" + File.separator + BROKENFILENAME : (contentType.equalsIgnoreCase("application/pdf") ? "images/pdf.gif" : (contentType.equalsIgnoreCase("application/msword") ? "images/msword.gif" : (contentType.equalsIgnoreCase("application/vnd.ms-excel") ? "images/msexcel.gif" : (contentType.equalsIgnoreCase("application/vnd.ms-powerpoint") ? "images/mspowerpoint.gif" : (contentType.equalsIgnoreCase("application/zip") ? "images/zipIcon.gif" : (contentType.equalsIgnoreCase("text/xml") ? "images/xmlIcon.gif" : "images/digitalAsset.gif"))))));
                    }
                } else {
                    assetUrl = "images/notDefined.gif";
                }
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred when we tried to cache and show the digital asset thumbnail:" + e));
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetUrl;
    }

    private static DigitalAsset getLatestDigitalAsset(ContentVersion contentVersion) {
        Collection digitalAssets = contentVersion.getDigitalAssets();
        Iterator iterator = digitalAssets.iterator();
        DigitalAsset digitalAsset = null;
        while (iterator.hasNext()) {
            DigitalAsset currentDigitalAsset = (DigitalAsset)iterator.next();
            if (digitalAsset != null && currentDigitalAsset.getDigitalAssetId() <= digitalAsset.getDigitalAssetId()) continue;
            digitalAsset = currentDigitalAsset;
        }
        return digitalAsset;
    }

    private static DigitalAsset getLatestDigitalAsset(ContentVersion contentVersion, String assetKey) {
        Collection digitalAssets = contentVersion.getDigitalAssets();
        Iterator iterator = digitalAssets.iterator();
        DigitalAsset digitalAsset = null;
        while (iterator.hasNext()) {
            DigitalAsset currentDigitalAsset = (DigitalAsset)iterator.next();
            if (digitalAsset != null && currentDigitalAsset.getDigitalAssetId() <= digitalAsset.getDigitalAssetId() || !currentDigitalAsset.getAssetKey().equalsIgnoreCase(assetKey)) continue;
            digitalAsset = currentDigitalAsset;
        }
        return digitalAsset;
    }

    public static DigitalAssetVO getLatestDigitalAssetVO(Integer contentVersionId, Database db) throws Exception {
        String cacheName = "digitalAssetCache";
        String key = "" + contentVersionId;
        DigitalAssetVO digitalAssetVO = (DigitalAssetVO)CacheController.getCachedObject(cacheName, key);
        if (digitalAssetVO != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached digitalAssetVO:" + digitalAssetVO));
            }
            return digitalAssetVO;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Making a sql call for assets on " + contentVersionId));
        }
        OQLQuery oql = db.getOQLQuery("CALL SQL SELECT c.digitalAssetId, c.assetFileName, c.assetKey, c.assetFilePath, c.assetContentType, c.assetFileSize FROM cmDigitalAsset c, cmContentVersionDigitalAsset cvda where cvda.digitalAssetId = c.digitalAssetId AND cvda.contentVersionId = $1 ORDER BY c.digitalAssetId AS org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl");
        if (CmsPropertyHandler.getUseShortTableNames() != null && CmsPropertyHandler.getUseShortTableNames().equalsIgnoreCase("true")) {
            oql = db.getOQLQuery("CALL SQL SELECT c.DigAssetId, c.assetFileName, c.assetKey, c.assetFilePath, c.assetContentType, c.assetFileSize FROM cmDigAsset c, cmContVerDigAsset cvda where cvda.DigAssetId = c.DigAssetId AND cvda.ContVerId = $1 ORDER BY c.DigAssetId AS org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl");
        }
        oql.bind((Object)contentVersionId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            SmallDigitalAssetImpl digitalAsset = (SmallDigitalAssetImpl)results.next();
            digitalAssetVO = digitalAsset.getValueObject();
        }
        results.close();
        oql.close();
        if (digitalAssetVO != null) {
            CacheController.cacheObject(cacheName, key, digitalAssetVO);
        }
        return digitalAssetVO;
    }

    public static DigitalAssetVO getLatestDigitalAssetVO(Integer contentVersionId, String assetKey, Database db) throws Exception {
        String cacheName = "digitalAssetCache";
        String key = contentVersionId + "_" + assetKey;
        DigitalAssetVO digitalAssetVO = (DigitalAssetVO)CacheController.getCachedObject(cacheName, key);
        if (digitalAssetVO != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached digitalAssetVO:" + digitalAssetVO));
            }
            return digitalAssetVO;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Making an sql call for asset with key " + assetKey + " on contentVersionId " + contentVersionId));
        }
        OQLQuery oql = db.getOQLQuery("CALL SQL SELECT c.digitalAssetId, c.assetFileName, c.assetKey, c.assetFilePath, c.assetContentType, c.assetFileSize FROM cmDigitalAsset c, cmContentVersionDigitalAsset cvda where cvda.digitalAssetId = c.digitalAssetId AND cvda.contentVersionId = $1 AND c.assetKey = $2 ORDER BY c.digitalAssetId AS org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl");
        if (CmsPropertyHandler.getUseShortTableNames() != null && CmsPropertyHandler.getUseShortTableNames().equalsIgnoreCase("true")) {
            oql = db.getOQLQuery("CALL SQL SELECT c.DigAssetId, c.assetFileName, c.assetKey, c.assetFilePath, c.assetContentType, c.assetFileSize FROM cmDigAsset c, cmContVerDigAsset cvda where cvda.DigAssetId = c.DigAssetId AND cvda.ContVerId = $1 AND c.assetKey = $2 ORDER BY c.DigAssetId AS org.infoglue.cms.entities.content.impl.simple.SmallDigitalAssetImpl");
        }
        oql.bind((Object)contentVersionId);
        oql.bind((Object)assetKey);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            SmallDigitalAssetImpl digitalAsset = (SmallDigitalAssetImpl)results.next();
            digitalAssetVO = digitalAsset.getValueObject();
        }
        results.close();
        oql.close();
        if (digitalAssetVO != null) {
            CacheController.cacheObject(cacheName, key, digitalAssetVO);
        }
        return digitalAssetVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean dumpDigitalAsset(DigitalAssetVO digitalAssetVO, String fileName, String filePath, Database db) throws Exception {
        logger.info((Object)("fileName:" + fileName));
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        File tmpOutputFile = new File(String.valueOf(filePath) + File.separator + "tmp_" + Thread.currentThread().getId() + "_" + fileName);
        if (outputFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"The file allready exists so we don't need to dump it again..");
            }
            return true;
        }
        try {
            long timer = System.currentTimeMillis();
            File outputFileDir = new File(filePath);
            outputFileDir.mkdirs();
            DigitalAsset digitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetVO.getDigitalAssetId(), db);
            InputStream is = digitalAsset.getAssetBlob();
            if ((CmsPropertyHandler.getEnableDiskAssets().equals("false") || !tmpOutputFile.exists()) && is != null) {
                InputStream inputStream = is;
                synchronized (inputStream) {
                    int character;
                    FileOutputStream fis = new FileOutputStream(tmpOutputFile);
                    BufferedOutputStream bos = new BufferedOutputStream(fis);
                    BufferedInputStream bis = new BufferedInputStream(is);
                    while ((character = bis.read()) != -1) {
                        bos.write(character);
                    }
                    bos.flush();
                    bis.close();
                    fis.close();
                    bos.close();
                    logger.info((Object)("\n\nExists" + tmpOutputFile.getAbsolutePath() + "=" + tmpOutputFile.exists() + " OR " + outputFile.exists() + ":" + outputFile.length()));
                    if (tmpOutputFile.length() == 0L || tmpOutputFile.length() != (long)digitalAsset.getAssetFileSize().intValue() || outputFile.exists()) {
                        logger.info((Object)("outputFile:" + outputFile.getAbsolutePath()));
                        logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                        tmpOutputFile.delete();
                    } else if (tmpOutputFile.length() == (long)digitalAsset.getAssetFileSize().intValue()) {
                        logger.info((Object)("written file:" + tmpOutputFile.getAbsolutePath() + " - renaming it to " + outputFile.getAbsolutePath()));
                        tmpOutputFile.renameTo(outputFile);
                        logger.info((Object)("Renamed to" + outputFile.getAbsolutePath() + "=" + outputFile.exists()));
                    } else {
                        tmpOutputFile.delete();
                    }
                }
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Dumping from file - diskassets is on probably.");
                    logger.info((Object)"Inside the cms-app I think - we should take the file from disk");
                    logger.info((Object)("tmpOutputFile:" + tmpOutputFile.getAbsolutePath() + ":" + tmpOutputFile.exists()));
                    logger.info((Object)("outputFile:" + outputFile.getAbsolutePath() + ":" + outputFile.exists()));
                }
                if (tmpOutputFile.exists()) {
                    logger.info((Object)("\n\nExists" + tmpOutputFile.getAbsolutePath() + "=" + tmpOutputFile.exists() + " OR " + outputFile.exists() + ":" + outputFile.length()));
                    if (tmpOutputFile.length() == 0L || tmpOutputFile.length() == (long)digitalAsset.getAssetFileSize().intValue() || outputFile.exists()) {
                        logger.info((Object)("outputFile:" + outputFile.getAbsolutePath()));
                        logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                        tmpOutputFile.delete();
                    } else {
                        logger.info((Object)("written file:" + tmpOutputFile.getAbsolutePath() + " - renaming it to " + outputFile.getAbsolutePath()));
                        tmpOutputFile.renameTo(outputFile);
                        logger.info((Object)("Renamed to" + outputFile.getAbsolutePath() + "=" + outputFile.exists()));
                    }
                } else if (CmsPropertyHandler.getApplicationName().equalsIgnoreCase("deliver")) {
                    logger.info((Object)("Was a deliver request and no asset was found on " + tmpOutputFile.getName() + " so let's get it from the cms."));
                    String cmsBaseUrl = CmsPropertyHandler.getCmsFullBaseUrl();
                    if (CmsPropertyHandler.getEnableDiskAssets().equals("true")) {
                        HttpHelper httpHelper = new HttpHelper();
                        httpHelper.downloadFile(cmsBaseUrl + "/DownloadProtectedAsset.action?digitalAssetId=" + digitalAssetVO.getId(), outputFile);
                    }
                }
            }
            logger.info((Object)"end");
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Time for dumping file " + fileName + ":" + (System.currentTimeMillis() - timer)));
                logger.info((Object)("assetPath in dump:" + filePath + File.separator + fileName));
                logger.info((Object)("Time for dumping file " + fileName + ":" + (System.currentTimeMillis() - timer)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputFile.exists();
    }

    public static boolean dumpDigitalAsset(DigitalAsset digitalAsset, String fileName, String filePath) throws Exception {
        if (digitalAsset.getAssetFileSize() == -1) {
            return false;
        }
        long timer = System.currentTimeMillis();
        File outputFile = new File(String.valueOf(filePath) + File.separator + fileName);
        File tmpOutputFile = new File(String.valueOf(filePath) + File.separator + "tmp_" + Thread.currentThread().getId() + "_" + fileName);
        if (outputFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"The file allready exists so we don't need to dump it again..");
            }
            return true;
        }
        InputStream is = digitalAsset.getAssetBlob();
        if (is != null) {
            int character;
            new File(filePath).mkdirs();
            FileOutputStream fis = new FileOutputStream(tmpOutputFile);
            BufferedOutputStream bos = new BufferedOutputStream(fis);
            BufferedInputStream bis = new BufferedInputStream(is);
            while ((character = bis.read()) != -1) {
                bos.write(character);
            }
            bos.flush();
            bis.close();
            fis.close();
            bos.close();
            logger.info((Object)("\n\nExists" + tmpOutputFile.getAbsolutePath() + "=" + tmpOutputFile.exists() + " OR " + outputFile.exists() + ":" + outputFile.length()));
            if (tmpOutputFile.length() == 0L || tmpOutputFile.length() == (long)digitalAsset.getAssetFileSize().intValue() || outputFile.exists()) {
                logger.info((Object)("outputFile:" + outputFile.getAbsolutePath()));
                logger.info((Object)("written file:" + tmpOutputFile.length() + " - removing temp and not renaming it..."));
                tmpOutputFile.delete();
            } else if (tmpOutputFile.length() == (long)digitalAsset.getAssetFileSize().intValue()) {
                logger.info((Object)("written file:" + tmpOutputFile.getAbsolutePath() + " - renaming it to " + outputFile.getAbsolutePath()));
                tmpOutputFile.renameTo(outputFile);
                logger.info((Object)("Renamed to" + outputFile.getAbsolutePath() + "=" + outputFile.exists()));
            } else {
                tmpOutputFile.delete();
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Time for dumping file " + fileName + ":" + (System.currentTimeMillis() - timer)));
            }
            return true;
        }
        return false;
    }

    public BaseEntityVO getNewVO() {
        return new DigitalAssetVO();
    }

    public String archiveDigitalAssets(String[] digitalAssetIdStrings, StringBuffer archiveFileSize, boolean nullBlob) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        String assetUrl = null;
        ArrayList<Integer> assetIdList = new ArrayList<Integer>();
        DigitalAssetController.beginTransaction(db);
        try {
            String fileName;
            String filePath = CmsPropertyHandler.getDigitalAssetPath();
            String archiveFileName = "assetArchive" + new VisualFormatter().formatDate(new Date(), "yyyy-MM-dd_HH-mm") + ".zip";
            File outputFile = new File(String.valueOf(filePath) + File.separator + archiveFileName);
            String[] filenames = new String[digitalAssetIdStrings.length];
            HashMap<String, String> names = new HashMap<String, String>();
            int i = 0;
            while (i < digitalAssetIdStrings.length) {
                Integer digitalAssetId = new Integer(digitalAssetIdStrings[i]);
                DigitalAsset digitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetId, db);
                String folderName = "" + digitalAsset.getDigitalAssetId() / 1000;
                logger.info((Object)("folderName:" + folderName));
                fileName = digitalAsset.getDigitalAssetId() + "_" + digitalAsset.getAssetFileName();
                if (!outputFile.exists() || outputFile.length() == (long)digitalAsset.getAssetFileSize().intValue()) {
                    DigitalAssetController.dumpDigitalAsset(digitalAsset.getValueObject(), fileName, String.valueOf(filePath) + File.separator + folderName, db);
                }
                filenames[i] = filePath + File.separator + folderName + File.separator + fileName;
                names.put(filenames[i], fileName);
                digitalAsset.setAssetFilePath("IG_ARCHIVE:" + archiveFileName + ":" + fileName);
                digitalAsset.setAssetFileSize(new Integer(-1));
                if (nullBlob) {
                    digitalAsset.setAssetBlob(null);
                } else {
                    digitalAsset.setAssetBlob(new ByteArrayInputStream("archived".getBytes()));
                }
                assetIdList.add(digitalAsset.getId());
                ++i;
            }
            byte[] buf = new byte[1024];
            try {
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));
                int i2 = 0;
                while (i2 < filenames.length) {
                    int len;
                    FileInputStream in = new FileInputStream(filenames[i2]);
                    fileName = filenames[i2];
                    String fileShortName = (String)names.get(fileName);
                    out.putNextEntry(new ZipEntry(fileShortName));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                    ++i2;
                }
                out.close();
                archiveFileSize.append(outputFile.length() / 1000000L);
                assetUrl = String.valueOf(CmsPropertyHandler.getWebServerAddress()) + "/" + CmsPropertyHandler.getDigitalAssetBaseUrl() + "/" + archiveFileName;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DigitalAssetController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to archive the digitalAssets:" + e), (Throwable)e);
            DigitalAssetController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assetUrl;
    }

    public synchronized void restoreAssetArchive(File archiveFile) throws SystemException {
        try {
            String tempAssetsPath = String.valueOf(CmsPropertyHandler.getDigitalAssetPath()) + File.separator + "temp_" + archiveFile.hashCode();
            File tempAssetsFile = new File(tempAssetsPath);
            if (tempAssetsFile.exists()) {
                tempAssetsFile.delete();
            }
            tempAssetsFile.mkdir();
            this.unzipFile(archiveFile, tempAssetsPath);
            String[] fileNames = tempAssetsFile.list();
            int i = 0;
            while (i < fileNames.length) {
                Database db = CastorDatabaseService.getDatabase();
                DigitalAssetController.beginTransaction(db);
                try {
                    String zipEntryName = fileNames[i];
                    File assetFile = new File(String.valueOf(tempAssetsPath) + File.separator + zipEntryName);
                    FileInputStream is = new FileInputStream(assetFile);
                    String assetId = zipEntryName.substring(0, zipEntryName.indexOf("_"));
                    DigitalAsset digitalAsset = DigitalAssetController.getDigitalAssetWithId(new Integer(assetId), db);
                    digitalAsset.setAssetFilePath(zipEntryName);
                    digitalAsset.setAssetFileSize(new Integer((int)assetFile.length()));
                    digitalAsset.setAssetBlob(is);
                    DigitalAssetController.commitTransaction(db);
                    is.close();
                }
                catch (Exception e) {
                    DigitalAssetController.rollbackTransaction(db);
                    logger.error((Object)("An error occurred when we tried to cache and show the digital asset thumbnail:" + e));
                    throw new SystemException(e.getMessage());
                }
                ++i;
            }
            if (tempAssetsFile.exists()) {
                tempAssetsFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("An error occurred when we tried to cache and show the digital asset thumbnail:" + e));
            throw new SystemException(e.getMessage());
        }
    }

    protected void unzipFile(File file, String targetFolder) throws Exception {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                new File(String.valueOf(targetFolder) + File.separator + entry.getName()).mkdir();
                continue;
            }
            this.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(String.valueOf(targetFolder) + File.separator + entry.getName())));
        }
        zipFile.close();
    }

    protected void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

