/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.infoglue.cms.io.FileHelper;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DatabaseDefinitionsController {
    private static final Logger logger = Logger.getLogger((String)DatabaseDefinitionsController.class.getName());

    public static DatabaseDefinitionsController getController() {
        return new DatabaseDefinitionsController();
    }

    private Document getDatabaseDefinitionsDocument() {
        Document document = null;
        try {
            String databaseDefinitions = String.valueOf(CmsPropertyHandler.getContextRootPath()) + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "databaseDefinitions.xml";
            File file = new File(databaseDefinitions);
            if (file != null && file.exists()) {
                InputSource xmlSource = new InputSource(new FileInputStream(file));
                DOMParser parser = new DOMParser();
                parser.parse(xmlSource);
                document = parser.getDocument();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when trying to fetch the asset keys:" + e.getMessage()), (Throwable)e);
        }
        return document;
    }

    public Map getDatabaseDefinitions() {
        HashMap databases = new HashMap();
        Document document = this.getDatabaseDefinitionsDocument();
        if (document != null) {
            NodeList databaseNodeList = document.getDocumentElement().getElementsByTagName("database");
            int i = 0;
            while (i < databaseNodeList.getLength()) {
                Element databaseElement = (Element)databaseNodeList.item(i);
                String id = databaseElement.getAttribute("id");
                NodeList propertyNodeList = databaseElement.getElementsByTagName("property");
                HashMap<String, String> database = new HashMap<String, String>();
                database.put("id", id);
                int j = 0;
                while (j < propertyNodeList.getLength()) {
                    Element propertyElement = (Element)propertyNodeList.item(j);
                    String name = propertyElement.getAttribute("name");
                    String value = propertyElement.getAttribute("value");
                    database.put(name, value);
                    ++j;
                }
                databases.put(id, database);
                ++i;
            }
        }
        return databases;
    }

    public Map getDatabaseDefinition(String id) {
        Map definitions = this.getDatabaseDefinitions();
        return (Map)definitions.get(id);
    }

    public File getCastorDatabaseDefinitionFile(String id) {
        Map databaseDefinition = DatabaseDefinitionsController.getController().getDatabaseDefinition("default");
        String engine = (String)databaseDefinition.get("driverEngine");
        String driverClass = (String)databaseDefinition.get("driverClass");
        String url = (String)databaseDefinition.get("url");
        String user = (String)databaseDefinition.get("user");
        String password = (String)databaseDefinition.get("password");
        String useUnicode = (String)databaseDefinition.get("useUnicode");
        String encoding = (String)databaseDefinition.get("encoding");
        String maxConnections = (String)databaseDefinition.get("maxConnections");
        String mapping = (String)databaseDefinition.get("mapping");
        url = url.replaceAll("&", "&amp;");
        StringBuffer sb = new StringBuffer();
        sb.append("<jdo-conf>");
        sb.append("\t<database name=\"INFOGLUE_CMS\" engine=\"" + engine + "\">");
        sb.append("\t\t<data-source class-name=\"org.apache.commons.dbcp.BasicDataSource\">");
        sb.append("\t\t\t<param name=\"driver-class-name\" value=\"" + driverClass + "\"/>");
        sb.append("\t\t\t<param name=\"username\" value=\"" + user + "\"/>");
        sb.append("\t\t\t<param name=\"password\" value=\"" + password + "\"/>");
        sb.append("\t\t\t<param name=\"url\" value=\"" + url + "\"/>");
        sb.append("\t\t\t<param name=\"max-active\" value=\"" + maxConnections + "\"/>");
        sb.append("\t\t\t<param name=\"connection-properties\" value=\"useUnicode=" + useUnicode + ";characterEncoding=" + encoding + "\"/>");
        sb.append("\t\t</data-source>");
        sb.append("\t\t<mapping href=\"classes/" + mapping + "\"/>");
        sb.append("\t</database>");
        sb.append(" <transaction-demarcation mode=\"local\"/>");
        sb.append("</jdo-conf>");
        String xml = sb.toString();
        String databaseDefinitions = String.valueOf(CmsPropertyHandler.getContextRootPath()) + File.separator + "WEB-INF" + File.separator + "classes" + File.separator + "currentDatabase.xml";
        File file = new File(databaseDefinitions);
        try {
            FileHelper.writeToFile(file, xml, false);
        }
        catch (Exception e) {
            logger.error((Object)("Could not write currentDatabase.xml:" + e.getMessage()), (Throwable)e);
        }
        return file;
    }
}

