/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;

public class ContentVersionControllerProxy
extends ContentVersionController {
    private static final Logger logger = Logger.getLogger((String)ContentVersionControllerProxy.class.getName());
    protected static final Integer NO = new Integer(0);
    protected static final Integer YES = new Integer(1);
    protected static final Integer INHERITED = new Integer(2);
    private static List interceptors = new ArrayList();

    public static ContentVersionControllerProxy getController() {
        return new ContentVersionControllerProxy();
    }

    public ContentVersionVO getACContentVersionVOWithId(InfoGluePrincipal infogluePrincipal, Integer contentVersionId) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentVersionId", contentVersionId);
        this.intercept(hashMap, "ContentVersion.Read", infogluePrincipal);
        return this.getContentVersionVOWithId(contentVersionId);
    }

    public ContentVersionVO getACLatestActiveContentVersionVO(InfoGluePrincipal infogluePrincipal, Integer contentId, Integer languageId) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentId);
        this.intercept(hashMap, "Content.Read", infogluePrincipal);
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId);
        hashMap = new HashMap();
        hashMap.put("contentVersionId", contentVersionVO.getId());
        this.intercept(hashMap, "ContentVersion.Read", infogluePrincipal);
        return contentVersionVO;
    }

    public ContentVersionVO acCreate(InfoGluePrincipal infogluePrincipal, Integer contentId, Integer languageId, ContentVersionVO contentVersionVO) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentId);
        this.intercept(hashMap, "Content.CreateVersion", infogluePrincipal);
        return ContentVersionController.getContentVersionController().create(contentId, languageId, contentVersionVO, null);
    }

    public ContentVersionVO acUpdate(InfoGluePrincipal infogluePrincipal, Integer contentId, Integer languageId, ContentVersionVO contentVersionVO) throws ConstraintException, SystemException, Bug, Exception {
        logger.info((Object)("contentId:" + contentId));
        logger.info((Object)("languageId:" + languageId));
        logger.info((Object)("contentVersionId:" + contentVersionVO.getId()));
        if (contentVersionVO.getId() != null) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("contentVersionId", contentVersionVO.getId());
            this.intercept(hashMap, "ContentVersion.Write", infogluePrincipal);
        } else {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            hashMap.put("contentId", contentId);
            this.intercept(hashMap, "Content.CreateVersion", infogluePrincipal);
        }
        return ContentVersionController.getContentVersionController().update(contentId, languageId, contentVersionVO, infogluePrincipal);
    }

    public void acDelete(InfoGluePrincipal infogluePrincipal, ContentVersionVO contentVersionVO) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentVersionId", contentVersionVO.getId());
        this.intercept(hashMap, "ContentVersion.Delete", infogluePrincipal);
        ContentVersionController.getContentVersionController().delete(contentVersionVO);
    }

    public boolean getIsContentProtected(Integer contentId, boolean inherit) {
        boolean isContentProtected = false;
        logger.info((Object)("getIsContentProtected contentId:" + contentId));
        try {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
            if (contentVO.getIsProtected() != null) {
                ContentVO parentContentVO;
                if (contentVO.getIsProtected().intValue() == NO.intValue()) {
                    isContentProtected = false;
                } else if (contentVO.getIsProtected().intValue() == YES.intValue()) {
                    isContentProtected = true;
                } else if (contentVO.getIsProtected().intValue() == INHERITED.intValue() && inherit && (parentContentVO = ContentController.getParentContent(contentId)) != null) {
                    isContentProtected = this.getIsContentProtected(parentContentVO.getId(), inherit);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the content was protected:" + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)("isContentProtected:" + isContentProtected));
        return isContentProtected;
    }
}

