/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.applications.databeans.OptimizationBeanList;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentStateController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAsset;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumDigitalAssetImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallContentVersionImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallestContentVersionImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.IBaseEntity;
import org.infoglue.cms.entities.management.Language;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.RegistryVO;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.LanguageImpl;
import org.infoglue.cms.entities.publishing.PublicationVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.DateHelper;
import org.infoglue.cms.util.XMLHelper;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentVersionController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ContentVersionController.class.getName());
    private static final ContentCategoryController contentCategoryController = ContentCategoryController.getController();
    private static final ContentVersionController contentVersionController = new ContentVersionController();
    private static final RegistryController registryController = RegistryController.getController();
    private static Map<Integer, Integer> contentMap = new ConcurrentHashMap<Integer, Integer>();

    public static ContentVersionController getContentVersionController() {
        return contentVersionController;
    }

    public Integer getContentIdForContentVersion(Integer contentVersionId) throws SystemException, Bug {
        Integer contentId = contentMap.get(contentVersionId);
        if (contentId == null) {
            ContentVersionVO ContentVersionVO2 = this.getContentVersionVOWithId(contentVersionId);
            contentId = ContentVersionVO2.getContentId();
            contentMap.put(contentVersionId, contentId);
        }
        return contentId;
    }

    public Integer getContentIdForContentVersion(Integer contentVersionId, Database db) throws SystemException, Bug {
        Integer contentId = contentMap.get(contentVersionId);
        if (contentId == null) {
            ContentVersionVO ContentVersionVO2 = this.getContentVersionVOWithId(contentVersionId, db);
            contentId = ContentVersionVO2.getContentId();
            contentMap.put(contentVersionId, contentId);
        }
        return contentId;
    }

    public ContentVersionVO getFullContentVersionVOWithId(Integer contentVersionId) throws SystemException, Bug {
        return (ContentVersionVO)ContentVersionController.getVOWithId(ContentVersionImpl.class, contentVersionId);
    }

    public ContentVersionVO getContentVersionVOWithId(Integer contentVersionId) throws SystemException, Bug {
        return (ContentVersionVO)ContentVersionController.getVOWithId(SmallContentVersionImpl.class, contentVersionId);
    }

    public ContentVersionVO getContentVersionVOWithId(Integer contentVersionId, Database db) throws SystemException, Bug {
        return (ContentVersionVO)ContentVersionController.getVOWithId(SmallContentVersionImpl.class, contentVersionId, db);
    }

    public ContentVersion getContentVersionWithId(Integer contentVersionId, Database db) throws SystemException, Bug {
        return (ContentVersion)ContentVersionController.getObjectWithId(ContentVersionImpl.class, contentVersionId, db);
    }

    public ContentVersion getReadOnlyContentVersionWithId(Integer contentVersionId, Database db) throws SystemException, Bug {
        return (ContentVersion)ContentVersionController.getObjectWithIdAsReadOnly(ContentVersionImpl.class, contentVersionId, db);
    }

    public List getContentVersionVOList() throws SystemException, Bug {
        return this.getAllVOObjects(SmallContentVersionImpl.class, "contentVersionId");
    }

    public List getContentVersionVOWithParentRecursive(Integer contentId, Integer stateId, boolean mustBeFirst) throws ConstraintException, SystemException {
        return this.getContentVersionVOWithParentRecursive(contentId, stateId, new ArrayList(), mustBeFirst);
    }

    private List getContentVersionVOWithParentRecursive(Integer contentId, Integer stateId, List resultList, boolean mustBeFirst) throws ConstraintException, SystemException {
        resultList.addAll(this.getLatestContentVersionVOWithParent(contentId, stateId, mustBeFirst));
        List childContentList = ContentController.getContentController().getContentChildrenVOList(contentId);
        for (ContentVO contentVO : childContentList) {
            this.getContentVersionVOWithParentRecursive(contentVO.getId(), stateId, resultList, mustBeFirst);
        }
        return resultList;
    }

    public List getContentVersionVOWithParentRecursiveAndRelated(Integer contentId, Integer stateId, boolean mustBeFirst) throws ConstraintException, SystemException {
        List contentVersionVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            List contentVersionList = this.getContentVersionWithParentRecursiveAndRelated(contentId, stateId, new ArrayList(), new ArrayList(), db, mustBeFirst);
            contentVersionVOList = ContentVersionController.toVOList(contentVersionList);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionVOList;
    }

    private List getContentVersionWithParentRecursiveAndRelated(Integer contentId, Integer stateId, List resultList, List checkedContents, Database db, boolean mustBeFirst) throws ConstraintException, SystemException, Exception {
        checkedContents.add(contentId);
        List contentVersions = this.getLatestContentVersionWithParent(contentId, stateId, db, mustBeFirst);
        resultList.addAll(contentVersions);
        for (ContentVersion contentVersion : contentVersions) {
            List relatedEntities = RegistryController.getController().getMatchingRegistryVOListForReferencingEntity(ContentVersion.class.getName(), contentVersion.getId().toString(), db);
            for (RegistryVO registryVO : relatedEntities) {
                logger.info((Object)("registryVO:" + registryVO.getEntityName() + ":" + registryVO.getEntityId()));
                if (!registryVO.getEntityName().equals(Content.class.getName()) || checkedContents.contains(new Integer(registryVO.getEntityId()))) continue;
                List relatedContentVersions = this.getLatestContentVersionWithParent(new Integer(registryVO.getEntityId()), stateId, db, mustBeFirst);
                resultList.addAll(relatedContentVersions);
                checkedContents.add(new Integer(registryVO.getEntityId()));
            }
        }
        List childContentList = ContentController.getContentController().getContentChildrenVOList(contentId);
        for (ContentVO contentVO : childContentList) {
            this.getContentVersionWithParentRecursiveAndRelated(contentVO.getId(), stateId, resultList, checkedContents, db, mustBeFirst);
        }
        return resultList;
    }

    public List getContentVersionVOWithParent(Integer contentId) throws SystemException, Bug {
        List resultList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        Object contentVersionVO = null;
        ContentVersionController.beginTransaction(db);
        try {
            List contentVersions = this.getContentVersionWithParent(contentId, db);
            resultList = ContentVersionController.toVOList(contentVersions);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return resultList;
    }

    public List getContentVersionWithParent(Integer contentId, Database db) throws SystemException, Bug, Exception {
        ArrayList<ContentVersion> resultList = new ArrayList<ContentVersion>();
        Object contentVersionVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            resultList.add(contentVersion);
        }
        results.close();
        oql.close();
        return resultList;
    }

    public List getLatestContentVersionVOWithParent(Integer contentId, Integer stateId, boolean mustBeFirst) throws SystemException, Bug {
        List resultList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            resultList = this.getLatestContentVersionWithParent(contentId, stateId, db, mustBeFirst);
            resultList = ContentVersionController.toVOList(resultList);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return resultList;
    }

    public List getLatestContentVersionWithParent(Integer contentId, Integer stateId, Database db, boolean mustBeFirst) throws SystemException, Bug, Exception {
        ArrayList<ContentVersion> resultList = new ArrayList<ContentVersion>();
        ArrayList<Integer> langCheck = new ArrayList<Integer>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            if (!contentVersion.getIsActive().booleanValue()) continue;
            if (contentVersion.getStateId().compareTo(stateId) == 0 && !langCheck.contains(contentVersion.getLanguage().getLanguageId())) {
                resultList.add(contentVersion);
                langCheck.add(contentVersion.getLanguage().getLanguageId());
            }
            if (!mustBeFirst) continue;
            langCheck.add(contentVersion.getLanguage().getLanguageId());
        }
        results.close();
        oql.close();
        logger.info((Object)"getLatestContentVersionWithParent done...");
        return resultList;
    }

    public List getLatestActiveContentVersionIfInState(Content content, Integer stateId, Database db) throws SystemException, Exception {
        ArrayList<ContentVersion> resultList = new ArrayList<ContentVersion>();
        HashMap<Integer, ContentVersion> lastLanguageVersions = new HashMap<Integer, ContentVersion>();
        HashMap<Integer, ContentVersion> languageVersions = new HashMap<Integer, ContentVersion>();
        Collection contentVersions = content.getContentVersions();
        for (ContentVersion contentVersionCandidate : contentVersions) {
            ContentVersion versionInThatLanguage;
            ContentVersion lastVersionInThatLanguage = (ContentVersion)lastLanguageVersions.get(contentVersionCandidate.getLanguage().getId());
            if (lastVersionInThatLanguage == null || lastVersionInThatLanguage.getId() < contentVersionCandidate.getId() && contentVersionCandidate.getIsActive().booleanValue()) {
                lastLanguageVersions.put(contentVersionCandidate.getLanguage().getId(), contentVersionCandidate);
            }
            if (!contentVersionCandidate.getIsActive().booleanValue() || contentVersionCandidate.getStateId().intValue() != stateId.intValue() || contentVersionCandidate.getOwningContent().getContentId().intValue() != content.getId().intValue() || (versionInThatLanguage = (ContentVersion)languageVersions.get(contentVersionCandidate.getLanguage().getId())) != null && versionInThatLanguage.getContentVersionId() >= contentVersionCandidate.getId()) continue;
            languageVersions.put(contentVersionCandidate.getLanguage().getId(), contentVersionCandidate);
        }
        logger.info((Object)("Found languageVersions:" + languageVersions.size()));
        logger.info((Object)("Found lastLanguageVersions:" + lastLanguageVersions.size()));
        for (ContentVersion contentVersion : languageVersions.values()) {
            ContentVersion lastVersionInThatLanguage = (ContentVersion)lastLanguageVersions.get(contentVersion.getLanguage().getId());
            logger.info((Object)("contentVersion:" + contentVersion.getId()));
            logger.info((Object)("lastVersionInThatLanguage:" + lastVersionInThatLanguage.getId()));
            if (contentVersion != lastVersionInThatLanguage) continue;
            resultList.add(contentVersion);
        }
        return resultList;
    }

    public ContentVersionVO getLatestActiveContentVersionVO(Integer contentId, Integer languageId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionVO contentVersionVO = null;
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = null;
            contentVersion = this.getLatestActiveContentVersion(contentId, languageId, db);
            if (contentVersion != null) {
                contentVersionVO = contentVersion.getValueObject();
            }
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionVO;
    }

    public ContentVersionVO getLatestActiveContentVersionVO(Integer contentId, Integer languageId, Database db) throws SystemException, Bug {
        ContentVersionVO contentVersionVO = null;
        ContentVersion contentVersion = this.getLatestActiveContentVersionReadOnly(contentId, languageId, db);
        if (contentVersion != null) {
            contentVersionVO = contentVersion.getValueObject();
        }
        return contentVersionVO;
    }

    public ContentVersion getLatestActiveContentVersion(Integer contentId, Integer languageId, Database db) throws SystemException, Bug, Exception {
        IBaseEntity contentVersion = null;
        Content content = ContentController.getContentController().getContentWithId(contentId, db);
        Collection contentVersions = content.getContentVersions();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contentId:" + contentId));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("content:" + content.getName()));
            logger.info((Object)("contentVersions:" + contentVersions.size()));
        }
        for (ContentVersion currentContentVersion : contentVersions) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("found one candidate:" + currentContentVersion.getValueObject()));
            }
            if (contentVersion != null && currentContentVersion.getId() <= contentVersion.getId()) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("currentContentVersion:" + currentContentVersion.getIsActive()));
                logger.info((Object)("currentContentVersion:" + currentContentVersion.getLanguage().getId()));
            }
            if (!currentContentVersion.getIsActive().booleanValue() || currentContentVersion.getLanguage().getId().intValue() != languageId.intValue()) continue;
            contentVersion = currentContentVersion;
        }
        return contentVersion;
    }

    public ContentVersion getLatestActiveContentVersionReadOnly(Integer contentId, Integer languageId, Database db) throws SystemException, Bug {
        IBaseEntity contentVersion = null;
        Content content = ContentController.getContentController().getReadOnlyContentWithId(contentId, db);
        Collection contentVersions = content.getContentVersions();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("contentId:" + contentId));
            logger.info((Object)("languageId:" + languageId));
            logger.info((Object)("content:" + content.getName()));
            logger.info((Object)("contentVersions:" + contentVersions.size()));
        }
        for (ContentVersion currentContentVersion : contentVersions) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("found one candidate:" + currentContentVersion.getValueObject()));
            }
            if (contentVersion != null && currentContentVersion.getId() <= contentVersion.getId()) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)("currentContentVersion:" + currentContentVersion.getIsActive()));
                logger.info((Object)("currentContentVersion:" + currentContentVersion.getLanguage().getId()));
            }
            if (!currentContentVersion.getIsActive().booleanValue() || currentContentVersion.getLanguage().getId().intValue() != languageId.intValue()) continue;
            contentVersion = currentContentVersion;
        }
        return contentVersion;
    }

    public ContentVersionVO getLatestContentVersionVO(Integer contentId, Integer languageId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionVO contentVersionVO = null;
        ContentVersionController.beginTransaction(db);
        try {
            contentVersionVO = this.getLatestContentVersionVO(contentId, languageId, db);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionVO;
    }

    public ContentVersionVO getLatestContentVersionVO(Integer contentId, Integer languageId, Database db) throws SystemException, Bug, Exception {
        ContentVersionVO contentVersionVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.SmallContentVersionImpl cv WHERE cv.contentId = $1 AND cv.languageId = $2 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)languageId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            contentVersionVO = contentVersion.getValueObject();
        }
        results.close();
        oql.close();
        return contentVersionVO;
    }

    public ContentVersion getContentVersionWithId(Integer contentVersionId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersion contentVersion = null;
        ContentVersionController.beginTransaction(db);
        try {
            contentVersion = this.getContentVersionWithId(contentVersionId, db);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersion;
    }

    public ContentVersion getLatestContentVersion(Integer contentId, Integer languageId, Database db) throws SystemException, Bug, Exception {
        ContentVersion contentVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.language.languageId = $2 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)languageId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            contentVersion = (ContentVersion)results.next();
        }
        results.close();
        oql.close();
        return contentVersion;
    }

    public ContentVersionVO create(Integer contentId, Integer languageId, ContentVersionVO contentVersionVO, Integer oldContentVersionId) throws ConstraintException, SystemException {
        return this.create(contentId, languageId, contentVersionVO, oldContentVersionId, true, true);
    }

    public ContentVersionVO create(Integer contentId, Integer languageId, ContentVersionVO contentVersionVO, Integer oldContentVersionId, boolean allowBrokenAssets, boolean duplicateAssets) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersion contentVersion = null;
        ContentVersionController.beginTransaction(db);
        try {
            contentVersion = this.create(contentId, languageId, contentVersionVO, oldContentVersionId, allowBrokenAssets, duplicateAssets, db);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersion.getValueObject();
    }

    public ContentVersion create(Integer contentId, Integer languageId, ContentVersionVO contentVersionVO, Integer oldContentVersionId, Database db) throws ConstraintException, SystemException, Exception {
        return this.create(contentId, languageId, contentVersionVO, oldContentVersionId, true, true, db);
    }

    public ContentVersion create(Integer contentId, Integer languageId, ContentVersionVO contentVersionVO, Integer oldContentVersionId, boolean allowBrokenAssets, boolean duplicateAssets, Database db) throws ConstraintException, SystemException, Exception {
        Content content = ContentController.getContentController().getContentWithId(contentId, db);
        Language language = LanguageController.getController().getLanguageWithId(languageId, db);
        return this.create(content, language, contentVersionVO, oldContentVersionId, allowBrokenAssets, duplicateAssets, db);
    }

    public ContentVersion create(Content content, Language language, ContentVersionVO contentVersionVO, Integer oldContentVersionId, boolean allowBrokenAssets, boolean duplicateAssets, Database db) throws ConstraintException, SystemException, Exception {
        ContentVersionImpl contentVersion = new ContentVersionImpl();
        contentVersion.setValueObject(contentVersionVO);
        contentVersion.setLanguage((LanguageImpl)language);
        logger.info((Object)("Content:" + content.getContentId() + ":" + db.isPersistent((Object)content)));
        contentVersion.setOwningContent((ContentImpl)content);
        db.create((Object)contentVersion);
        content.getContentVersions().add(contentVersion);
        if (oldContentVersionId != null && oldContentVersionId != -1) {
            this.copyDigitalAssets(this.getContentVersionWithId(oldContentVersionId, db), contentVersion, allowBrokenAssets, duplicateAssets, db);
        }
        return contentVersion;
    }

    public void delete(ContentVersionVO contentVersionVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            this.delete(contentVersionVO, db);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(ContentVersionVO contentVersionVO, Database db) throws ConstraintException, SystemException, Exception {
        ContentVersion contentVersion = this.getContentVersionWithId(contentVersionVO.getContentVersionId(), db);
        this.delete(contentVersion, db, false);
    }

    public void delete(ContentVersion contentVersion, Database db) throws ConstraintException, SystemException, Exception {
        this.delete(contentVersion, db, false);
    }

    public void delete(ContentVersion contentVersion, Database db, boolean forceDelete) throws ConstraintException, SystemException, Exception {
        if (!forceDelete && contentVersion.getStateId().intValue() == ContentVersionVO.PUBLISHED_STATE.intValue() && contentVersion.getIsActive().booleanValue()) {
            throw new ConstraintException("ContentVersion.stateId", "3300", contentVersion.getOwningContent().getName());
        }
        contentCategoryController.deleteByContentVersion(contentVersion, db);
        ContentImpl content = contentVersion.getOwningContent();
        if (content != null) {
            content.getContentVersions().remove(contentVersion);
        }
        db.remove((Object)contentVersion);
    }

    public void deleteVersionsForContent(Content content, Database db, InfoGluePrincipal principal) throws ConstraintException, SystemException, Bug, Exception {
        this.deleteVersionsForContent(content, db, false, principal);
    }

    public void deleteVersionsForContent(Content content, Database db, boolean forceDelete, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException, Bug, Exception {
        if (forceDelete) {
            List contentVersionsVOList = ContentVersionController.getContentVersionController().getPublishedActiveContentVersionVOList(content.getContentId(), db);
            ArrayList<EventVO> events = new ArrayList<EventVO>();
            for (ContentVersionVO contentVersionVO : contentVersionsVOList) {
                EventVO eventVO = new EventVO();
                eventVO.setDescription("Unpublished before forced deletion");
                eventVO.setEntityClass(ContentVersion.class.getName());
                eventVO.setEntityId(contentVersionVO.getContentVersionId());
                eventVO.setName(String.valueOf(contentVersionVO.getContentName()) + "(" + contentVersionVO.getLanguageName() + ")");
                eventVO.setTypeId(EventVO.UNPUBLISH_LATEST);
                eventVO = EventController.create(eventVO, content.getRepositoryId(), infogluePrincipal);
                events.add(eventVO);
            }
            PublicationVO publicationVO = new PublicationVO();
            publicationVO.setName("Direct publication by " + infogluePrincipal.getName());
            publicationVO.setDescription("Unpublished all versions before forced deletion");
            publicationVO.setRepositoryId(content.getRepositoryId());
            publicationVO = PublicationController.getController().createAndPublish(publicationVO, events, true, infogluePrincipal, db);
        }
        Collection contentVersions = Collections.synchronizedCollection(content.getContentVersions());
        Iterator contentVersionIterator = contentVersions.iterator();
        while (contentVersionIterator.hasNext()) {
            ContentVersion contentVersion = (ContentVersion)contentVersionIterator.next();
            Collection digitalAssetList = contentVersion.getDigitalAssets();
            Iterator assets = digitalAssetList.iterator();
            while (assets.hasNext()) {
                DigitalAsset digitalAsset = (DigitalAsset)assets.next();
                assets.remove();
                db.remove((Object)digitalAsset);
            }
            logger.info((Object)("Deleting contentVersion:" + contentVersion.getContentVersionId()));
            contentVersionIterator.remove();
            this.delete(contentVersion, db, forceDelete);
        }
        content.setContentVersions(new ArrayList());
    }

    public void deleteDigitalAsset(Integer contentId, Integer languageId, String assetKey) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = this.getLatestActiveContentVersion(contentId, languageId, db);
            Collection digitalAssets = contentVersion.getDigitalAssets();
            Iterator assetIterator = digitalAssets.iterator();
            while (assetIterator.hasNext()) {
                DigitalAsset currentDigitalAsset = (DigitalAsset)assetIterator.next();
                if (!currentDigitalAsset.getAssetKey().equals(assetKey)) continue;
                assetIterator.remove();
                db.remove((Object)currentDigitalAsset);
                break;
            }
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public ContentVersionVO update(Integer contentId, Integer languageId, ContentVersionVO contentVersionVO) throws ConstraintException, SystemException {
        return this.update(contentId, languageId, contentVersionVO, null);
    }

    public ContentVersionVO update(Integer contentId, Integer languageId, ContentVersionVO contentVersionVO, InfoGluePrincipal principal) throws ConstraintException, SystemException {
        ContentVersionVO updatedContentVersionVO;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            SiteNode siteNode;
            Content content = ContentController.getContentController().getContentWithId(contentId, db);
            ContentTypeDefinitionImpl contentTypeDefinition = content.getContentTypeDefinition();
            ConstraintExceptionBuffer ceb = contentVersionVO.validateAdvanced(contentTypeDefinition.getValueObject());
            ceb.throwIfNotEmpty();
            ContentVersion contentVersion = null;
            if (contentVersionVO.getId() == null) {
                logger.info((Object)("Creating the entity because there was no version at all for: " + contentId + " " + languageId));
                contentVersion = this.create(contentId, languageId, contentVersionVO, null, db);
            } else if (!contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                ContentVersionVO oldContentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(contentVersionVO.getId(), db);
                ArrayList events = new ArrayList();
                contentVersion = ContentStateController.changeState(oldContentVersionVO.getId(), ContentVersionVO.WORKING_STATE, "new working version", false, null, principal, oldContentVersionVO.getContentId(), db, events);
                contentVersion.setVersionValue(contentVersionVO.getVersionValue());
            } else {
                contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionVO.getId(), db);
                contentVersion.setValueObject(contentVersionVO);
            }
            if (principal != null && contentTypeDefinition.getName().equalsIgnoreCase("Meta info") && (siteNode = SiteNodeController.getController().getSiteNodeWithMetaInfoContentId(db, contentId)).getMetaInfoContentId() != null && siteNode.getMetaInfoContentId().equals(contentId)) {
                SiteNodeVersion latestSiteNodeVersion = SiteNodeVersionController.getController().getLatestSiteNodeVersion(db, siteNode.getId(), false);
                latestSiteNodeVersion.setVersionModifier(contentVersionVO.getVersionModifier());
                latestSiteNodeVersion.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().acUpdate(principal, latestSiteNodeVersion.getValueObject(), db);
            }
            registryController.updateContentVersion(contentVersion, db);
            updatedContentVersionVO = contentVersion.getValueObject();
            ContentVersionController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("Validation error:" + ce), (Throwable)ce);
            ContentVersionController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return updatedContentVersionVO;
    }

    public ContentVersionVO update(Integer contentVersionId, ContentVersionVO contentVersionVO) throws ConstraintException, SystemException {
        return this.update(contentVersionId, contentVersionVO, null);
    }

    public ContentVersionVO update(Integer contentVersionId, ContentVersionVO contentVersionVO, InfoGluePrincipal principal) throws ConstraintException, SystemException {
        ContentVersionVO updatedContentVersionVO;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            SiteNode siteNode;
            ContentVersion contentVersion = this.getContentVersionWithId(contentVersionId, db);
            contentVersion.setValueObject(contentVersionVO);
            ContentTypeDefinitionImpl contentTypeDefinition = contentVersion.getOwningContent().getContentTypeDefinition();
            if (principal != null && contentTypeDefinition.getName().equalsIgnoreCase("Meta info") && (siteNode = SiteNodeController.getController().getSiteNodeWithMetaInfoContentId(db, contentVersion.getValueObject().getContentId())).getMetaInfoContentId() != null && siteNode.getMetaInfoContentId().equals(contentVersion.getValueObject().getContentId())) {
                SiteNodeVersion latestSiteNodeVersion = SiteNodeVersionController.getController().getLatestSiteNodeVersion(db, siteNode.getId(), false);
                latestSiteNodeVersion.setVersionModifier(contentVersionVO.getVersionModifier());
                latestSiteNodeVersion.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().acUpdate(principal, latestSiteNodeVersion.getValueObject(), db);
            }
            registryController.updateContentVersion(contentVersion, db);
            updatedContentVersionVO = contentVersion.getValueObject();
            ContentVersionController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("Validation error:" + ce), (Throwable)ce);
            ContentVersionController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return updatedContentVersionVO;
    }

    public List getPublishedActiveContentVersionVOList(Integer contentId) throws SystemException, Bug, Exception {
        ArrayList<ContentVersionVO> contentVersionVOList = new ArrayList<ContentVersionVO>();
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.contentVersionId desc");
            oql.bind((Object)contentId);
            oql.bind((Object)ContentVersionVO.PUBLISHED_STATE);
            oql.bind(true);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                ContentVersion contentVersion = (ContentVersion)results.next();
                contentVersionVOList.add(contentVersion.getValueObject());
            }
            results.close();
            oql.close();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionVOList;
    }

    public List getPublishedActiveContentVersionVOList(Integer contentId, Database db) throws SystemException, Bug, Exception {
        ArrayList<ContentVersionVO> contentVersionVOList = new ArrayList<ContentVersionVO>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)ContentVersionVO.PUBLISHED_STATE);
        oql.bind(true);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            contentVersionVOList.add(contentVersion.getValueObject());
        }
        results.close();
        oql.close();
        return contentVersionVOList;
    }

    public ContentVersion getLatestPublishedContentVersion(Integer contentId) throws SystemException, Bug, Exception {
        ContentVersion contentVersion = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.stateId = $2 AND cv.isActive = $3 ORDER BY cv.contentVersionId desc");
            oql.bind((Object)contentId);
            oql.bind((Object)ContentVersionVO.PUBLISHED_STATE);
            oql.bind(true);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                contentVersion = (ContentVersion)results.next();
            }
            results.close();
            oql.close();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersion;
    }

    public ContentVersion getLatestPublishedContentVersion(Integer contentId, Integer languageId) throws SystemException, Bug, Exception {
        ContentVersion contentVersion = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.language.languageId = $2 AND cv.stateId = $3 AND cv.isActive = $4 ORDER BY cv.contentVersionId desc");
            oql.bind((Object)contentId);
            oql.bind((Object)languageId);
            oql.bind((Object)ContentVersionVO.PUBLISHED_STATE);
            oql.bind(true);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                contentVersion = (ContentVersion)results.next();
            }
            results.close();
            oql.close();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersion;
    }

    public ContentVersion getLatestPublishedContentVersion(Integer contentId, Integer languageId, Database db) throws SystemException, Bug, Exception {
        ContentVersion contentVersion = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.language.languageId = $2 AND cv.stateId = $3 AND cv.isActive = $4 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)languageId);
        oql.bind((Object)ContentVersionVO.PUBLISHED_STATE);
        oql.bind(true);
        QueryResults results = oql.execute();
        logger.info((Object)"Fetching entity in read/write mode");
        if (results.hasMore()) {
            contentVersion = (ContentVersion)results.next();
        }
        results.close();
        oql.close();
        return contentVersion;
    }

    public ContentVersionVO getPreviousContentVersionVO(Integer contentId, Integer languageId, Integer contentVersionId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionVO contentVersionVO = null;
        ContentVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.language.languageId = $2 AND cv.contentVersionId < $3 ORDER BY cv.contentVersionId desc");
            oql.bind((Object)contentId);
            oql.bind((Object)languageId);
            oql.bind((Object)contentVersionId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                ContentVersion contentVersion = (ContentVersion)results.next();
                logger.info((Object)("found one:" + contentVersion.getValueObject()));
                contentVersionVO = contentVersion.getValueObject();
            }
            results.close();
            oql.close();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionVO;
    }

    public ContentVersionVO getPreviousActiveContentVersionVO(Integer contentId, Integer languageId, Integer contentVersionId, Database db) throws SystemException, Bug, Exception {
        ContentVersionVO contentVersionVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.language.languageId = $2 AND cv.isActive = $3 AND cv.contentVersionId < $4 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)languageId);
        oql.bind((Object)new Boolean(true));
        oql.bind((Object)contentVersionId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            logger.info((Object)("found one:" + contentVersion.getValueObject()));
            contentVersionVO = contentVersion.getValueObject();
        }
        results.close();
        oql.close();
        return contentVersionVO;
    }

    public ContentVersionVO deleteDigitalAssetRelation(Integer contentVersionId, Integer digitalAssetId, InfoGluePrincipal principal) throws SystemException, Bug {
        ContentVersionVO editedContentVersionVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = null;
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(contentVersionId, db);
            DigitalAssetController.getController();
            DigitalAssetVO digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(digitalAssetId, db);
            if (!contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                ArrayList events = new ArrayList();
                contentVersion = ContentStateController.changeState(contentVersionVO.getId(), ContentVersionVO.WORKING_STATE, "new working version", false, null, principal, contentVersionVO.getContentId(), db, events);
                DigitalAssetController.getController();
                digitalAssetVO = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), digitalAssetVO.getAssetKey(), db);
            } else {
                contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionVO.getId(), db);
            }
            editedContentVersionVO = contentVersion.getValueObject();
            DigitalAsset digitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetVO.getId(), db);
            contentVersion.getDigitalAssets().remove(digitalAsset);
            digitalAsset.getContentVersions().remove(contentVersion);
            logger.info((Object)("digitalAsset size after:" + digitalAsset.getContentVersions().size()));
            if (digitalAsset.getContentVersions().size() == 0) {
                db.remove((Object)digitalAsset);
            }
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return editedContentVersionVO;
    }

    public void deleteDigitalAssetRelation(Integer contentVersionId, DigitalAsset digitalAsset, Database db) throws SystemException, Bug {
        ContentVersion contentVersion = this.getContentVersionWithId(contentVersionId, db);
        contentVersion.getDigitalAssets().remove(digitalAsset);
        digitalAsset.getContentVersions().remove(contentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyDigitalAssets(ContentVersion originalContentVersion, ContentVersion newContentVersion, boolean allowBrokenAssets, boolean duplicateAssets, Database db) throws ConstraintException, SystemException, Exception {
        Collection digitalAssets = originalContentVersion.getDigitalAssets();
        if (!duplicateAssets) {
            for (DigitalAsset digitalAsset : digitalAssets) {
                logger.info((Object)("Make copy of reference to digitalAssets " + digitalAsset.getAssetKey()));
                newContentVersion.getDigitalAssets().add(digitalAsset);
                digitalAsset.getContentVersions().add(newContentVersion);
            }
        } else {
            for (DigitalAsset digitalAsset : digitalAssets) {
                block16: {
                    logger.info((Object)("Copying digitalAssets " + digitalAsset.getAssetKey()));
                    DigitalAssetVO digitalAssetVO = digitalAsset.getValueObject();
                    InputStream is = DigitalAssetController.getController().getAssetInputStream(digitalAsset, true);
                    if (is == null && !allowBrokenAssets) {
                        throw new ConstraintException("DigitalAsset.assetBlob", "3308", "Broken asset found on content '" + originalContentVersion.getValueObject().getContentName() + "' with id " + originalContentVersion.getValueObject().getContentId());
                    }
                    try {
                        try {
                            InputStream inputStream = is;
                            synchronized (inputStream) {
                                DigitalAssetController.create(digitalAssetVO, is, newContentVersion, db);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (is != null) {
                                is.close();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            is.close();
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                logger.info((Object)("digitalAssets:" + digitalAssets.size()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DigitalAssetVO copyDigitalAssetAndRemoveOldReference(ContentVersion contentVersion, DigitalAsset digitalAsset, boolean allowBrokenAssets, Database db) throws ConstraintException, SystemException, Exception {
        DigitalAssetVO digitalAssetVO;
        block12: {
            logger.info((Object)("Copying digitalAsset " + digitalAsset.getAssetKey()));
            digitalAssetVO = digitalAsset.getValueObject();
            InputStream is = DigitalAssetController.getController().getAssetInputStream(digitalAsset, true);
            if (is == null && !allowBrokenAssets) {
                throw new ConstraintException("DigitalAsset.assetBlob", "3308", "Broken asset found on content '" + contentVersion.getValueObject().getContentName() + "' with id " + contentVersion.getValueObject().getContentId());
            }
            try {
                try {
                    InputStream inputStream = is;
                    synchronized (inputStream) {
                        digitalAssetVO = DigitalAssetController.create(digitalAssetVO, is, contentVersion, db);
                        contentVersion.getDigitalAssets().remove(digitalAsset);
                        digitalAsset.getContentVersions().remove(contentVersion);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (is != null) {
                        is.close();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    is.close();
                }
                throw throwable;
            }
            if (is != null) {
                is.close();
            }
        }
        logger.info((Object)("digitalAssetVO:" + digitalAssetVO));
        return digitalAssetVO;
    }

    public String getAttributeValue(Integer contentVersionId, String attributeName, boolean escapeHTML) throws SystemException {
        String value = "";
        ContentVersionVO contentVersionVO = this.getContentVersionVOWithId(contentVersionId);
        if (contentVersionVO != null) {
            try {
                logger.info((Object)("attributeName:" + attributeName));
                logger.info((Object)("VersionValue:" + contentVersionVO.getVersionValue()));
                value = this.getAttributeValue(contentVersionVO, attributeName, escapeHTML);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public String getAttributeValue(ContentVersionVO contentVersionVO, String attributeName, boolean escapeHTML) {
        String value = "";
        String xml = contentVersionVO.getVersionValue();
        int startTagIndex = xml.indexOf("<" + attributeName + ">");
        int endTagIndex = xml.indexOf("]]></" + attributeName + ">");
        if (startTagIndex > 0 && startTagIndex < xml.length() && endTagIndex > startTagIndex && endTagIndex < xml.length()) {
            value = xml.substring(startTagIndex + attributeName.length() + 11, endTagIndex);
            if (escapeHTML) {
                value = new VisualFormatter().escapeHTML(value);
            }
        }
        return value;
    }

    public void updateAttributeValue(Integer contentVersionId, String attributeName, String attributeValue, InfoGluePrincipal infogluePrincipal) throws SystemException, Bug {
        ContentVersionVO contentVersionVO = this.getContentVersionVOWithId(contentVersionId);
        if (contentVersionVO != null) {
            try {
                logger.info((Object)("attributeName:" + attributeName));
                logger.info((Object)("versionValue:" + contentVersionVO.getVersionValue()));
                logger.info((Object)("attributeValue:" + attributeValue));
                InputSource inputSource = new InputSource(new StringReader(contentVersionVO.getVersionValue()));
                DOMParser parser = new DOMParser();
                parser.parse(inputSource);
                Document document = parser.getDocument();
                NodeList nl = document.getDocumentElement().getChildNodes();
                Node attributesNode = nl.item(0);
                boolean existed = false;
                nl = attributesNode.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Node n = nl.item(i);
                    if (n.getNodeName().equalsIgnoreCase(attributeName)) {
                        if (n.getFirstChild() != null && n.getFirstChild().getNodeValue() != null) {
                            n.getFirstChild().setNodeValue(attributeValue);
                            existed = true;
                            break;
                        }
                        CDATASection cdata = document.createCDATASection(attributeValue);
                        n.appendChild(cdata);
                        existed = true;
                        break;
                    }
                    ++i;
                }
                if (!existed) {
                    Element attributeElement = document.createElement(attributeName);
                    attributesNode.appendChild(attributeElement);
                    CDATASection cdata = document.createCDATASection(attributeValue);
                    attributeElement.appendChild(cdata);
                }
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(document.getDocumentElement(), sb);
                logger.info((Object)("sb:" + sb));
                contentVersionVO.setVersionValue(sb.toString());
                contentVersionVO.setVersionModifier(infogluePrincipal.getName());
                this.update(contentVersionVO.getContentId(), contentVersionVO.getLanguageId(), contentVersionVO, infogluePrincipal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BaseEntityVO getNewVO() {
        return new ContentVersionVO();
    }

    public void getContentAndAffectedItemsRecursive(Integer contentId, Integer stateId, List siteNodeVersionVOList, List contenteVersionVOList, boolean mustBeFirst, boolean includeMetaInfo) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            Content content = ContentController.getContentController().getContentWithId(contentId, db);
            this.getContentAndAffectedItemsRecursive(content, stateId, new ArrayList(), new ArrayList(), db, siteNodeVersionVOList, contenteVersionVOList, mustBeFirst, includeMetaInfo);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    private void getContentAndAffectedItemsRecursive(Content content, Integer stateId, List checkedSiteNodes, List checkedContents, Database db, List siteNodeVersionVOList, List contentVersionVOList, boolean mustBeFirst, boolean includeMetaInfo) throws ConstraintException, SystemException, Exception {
        checkedSiteNodes.add(content.getId());
        List contentVersions = this.getLatestContentVersionWithParent(content.getId(), stateId, db, mustBeFirst);
        for (ContentVersion contentVersion : contentVersions) {
            contentVersionVOList.add(contentVersion.getValueObject());
            List relatedEntities = RegistryController.getController().getMatchingRegistryVOListForReferencingEntity(ContentVersion.class.getName(), contentVersion.getId().toString(), db);
            logger.info((Object)("relatedEntities:" + relatedEntities));
            for (RegistryVO registryVO : relatedEntities) {
                logger.info((Object)("registryVO:" + registryVO.getEntityName() + ":" + registryVO.getEntityId()));
                if (registryVO.getEntityName().equals(SiteNode.class.getName()) && !checkedSiteNodes.contains(new Integer(registryVO.getEntityId()))) {
                    try {
                        SiteNode relatedSiteNode = SiteNodeController.getController().getSiteNodeWithId(new Integer(registryVO.getEntityId()), db);
                        SiteNodeVersion relatedSiteNodeVersion = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersionIfInState(relatedSiteNode, stateId, db);
                        if (relatedSiteNodeVersion != null && content.getRepository().getId().intValue() == relatedSiteNodeVersion.getOwningSiteNode().getRepository().getId().intValue()) {
                            siteNodeVersionVOList.add(relatedSiteNodeVersion.getValueObject());
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("The related siteNode with id:" + registryVO.getEntityId() + " could not be loaded."), (Throwable)e);
                    }
                    checkedSiteNodes.add(new Integer(registryVO.getEntityId()));
                    continue;
                }
                if (!registryVO.getEntityName().equals(Content.class.getName()) || checkedContents.contains(new Integer(registryVO.getEntityId()))) continue;
                try {
                    Content relatedContent = ContentController.getContentController().getContentWithId(new Integer(registryVO.getEntityId()), db);
                    if (includeMetaInfo || !includeMetaInfo && (relatedContent.getContentTypeDefinition() == null || !relatedContent.getContentTypeDefinition().getName().equalsIgnoreCase("Meta info"))) {
                        List relatedContentVersions = ContentVersionController.getContentVersionController().getLatestActiveContentVersionIfInState(relatedContent, stateId, db);
                        logger.info((Object)("relatedContentVersions:" + relatedContentVersions.size()));
                        for (ContentVersion relatedContentVersion : relatedContentVersions) {
                            if (relatedContentVersion == null || content.getRepository().getId().intValue() != relatedContentVersion.getOwningContent().getRepository().getId().intValue()) continue;
                            contentVersionVOList.add(relatedContentVersion.getValueObject());
                            logger.info((Object)("Added:" + relatedContentVersion.getId()));
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("The related content with id:" + registryVO.getEntityId() + " could not be loaded."), (Throwable)e);
                }
                checkedContents.add(new Integer(registryVO.getEntityId()));
            }
        }
        Collection childContentList = content.getChildren();
        for (Content citContent : childContentList) {
            this.getContentAndAffectedItemsRecursive(citContent, stateId, checkedSiteNodes, checkedContents, db, siteNodeVersionVOList, contentVersionVOList, mustBeFirst, includeMetaInfo);
        }
    }

    public void cleanContentVersions(int numberOfVersionsToKeep, boolean keepOnlyOldPublishedVersions) throws SystemException {
        int batchLimit = 200;
        List languageVOList = LanguageController.getController().getLanguageVOList();
        for (LanguageVO languageVO : languageVOList) {
            List<ContentVersionVO> contentVersionVOList = this.getContentVersionVOList(languageVO.getId(), numberOfVersionsToKeep, keepOnlyOldPublishedVersions);
            logger.info((Object)("Deleting " + contentVersionVOList.size() + " versions for language " + languageVO.getName()));
            int maxIndex = contentVersionVOList.size() > batchLimit ? batchLimit : contentVersionVOList.size();
            List<ContentVersionVO> partList = contentVersionVOList.subList(0, maxIndex);
            while (partList.size() > 0) {
                this.cleanVersions(numberOfVersionsToKeep, partList);
                partList.clear();
                maxIndex = contentVersionVOList.size() > batchLimit ? batchLimit : contentVersionVOList.size();
                partList = contentVersionVOList.subList(0, maxIndex);
            }
        }
    }

    private void cleanVersions(int numberOfVersionsToKeep, List contentVersionVOList) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            try {
                for (ContentVersionVO contentVersionVO : contentVersionVOList) {
                    ContentVersion contentVersion = this.getContentVersionWithId(contentVersionVO.getContentVersionId(), db);
                    logger.info((Object)("Deleting the contentVersion " + contentVersion.getId() + " on content " + contentVersion.getOwningContent().getName()));
                    this.delete(contentVersion, db, true);
                }
                ContentVersionController.commitTransaction(db);
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
                ContentVersionController.rollbackTransaction(db);
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            ContentVersionController.closeDatabase(db);
        }
    }

    public List<ContentVersionVO> getContentVersionVOList(Integer languageId, int numberOfVersionsToKeep, boolean keepOnlyOldPublishedVersions) throws SystemException {
        logger.info((Object)("numberOfVersionsToKeep:" + numberOfVersionsToKeep));
        Database db = CastorDatabaseService.getDatabase();
        ArrayList<ContentVersionVO> contentVersionsIdList = new ArrayList<ContentVersionVO>();
        ContentVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.SmallestContentVersionImpl cv WHERE cv.languageId = $1 ORDER BY cv.contentId, cv.contentVersionId desc");
            oql.bind((Object)languageId);
            QueryResults results = oql.execute((short)0);
            int numberOfLaterVersions = 0;
            Integer previousContentId = null;
            while (results.hasMore()) {
                SmallestContentVersionImpl version = (SmallestContentVersionImpl)results.next();
                if (previousContentId != null && previousContentId.intValue() != version.getContentId().intValue()) {
                    numberOfLaterVersions = 0;
                }
                if (numberOfLaterVersions > numberOfVersionsToKeep || keepOnlyOldPublishedVersions && numberOfLaterVersions > 0 && !version.getStateId().equals(ContentVersionVO.PUBLISHED_STATE)) {
                    contentVersionsIdList.add(version.getValueObject());
                }
                previousContentId = version.getContentId();
                ++numberOfLaterVersions;
            }
            results.close();
            oql.close();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVersionsIdList;
    }

    public OptimizationBeanList getHeavyContentVersions(int numberOfVersionsToKeep, int assetSizeLimit, int assetNumberLimit) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        OptimizationBeanList optimizationBeanList = new OptimizationBeanList();
        ContentVersionController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT da FROM org.infoglue.cms.entities.content.impl.simple.MediumDigitalAssetImpl da WHERE da.assetFileSize >= $1 ORDER BY da.digitalAssetId asc");
            oql.bind(assetSizeLimit);
            QueryResults results = oql.execute((short)0);
            int i = 0;
            while (results.hasMore() && i < assetNumberLimit) {
                boolean keep = true;
                MediumDigitalAssetImpl digitalAsset = (MediumDigitalAssetImpl)results.next();
                if (digitalAsset.getAssetKey().equals("portletentityregistry.xml")) {
                    keep = false;
                }
                Collection contentVersions = digitalAsset.getContentVersions();
                Iterator contentVersionsIterator = contentVersions.iterator();
                ContentVersion contentVersion = null;
                while (contentVersionsIterator.hasNext()) {
                    contentVersion = (ContentVersion)contentVersionsIterator.next();
                    if (this.isOldVersion(contentVersion, numberOfVersionsToKeep)) continue;
                    keep = false;
                }
                if (contentVersion == null || !keep) continue;
                if (contentVersion.getOwningContent() != null) {
                    String contentPath = ContentController.getContentController().getContentPath(contentVersion.getOwningContent().getId(), true, true);
                    optimizationBeanList.addDigitalAsset(digitalAsset);
                    optimizationBeanList.addEventVersions(ContentVersionController.toVOList(contentVersions));
                    optimizationBeanList.setContentPath(digitalAsset.getId(), contentPath);
                    ++i;
                    continue;
                }
                logger.error((Object)("ContentVersion with id:" + contentVersion.getId() + " had no ownningcontent"));
            }
            results.close();
            oql.close();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return optimizationBeanList;
    }

    private boolean isOldVersion(ContentVersion contentVersion, int minNewerVersions) {
        Integer contentVersionId = contentVersion.getValueObject().getId();
        Integer language = contentVersion.getValueObject().getLanguageId();
        boolean isOldVersion = false;
        int numberOfNewerVersions = 0;
        ContentImpl content = contentVersion.getOwningContent();
        Collection contentVersions = content.getContentVersions();
        for (ContentVersion currentContentVersion : contentVersions) {
            if (currentContentVersion.getValueObject().getLanguageId().intValue() != language.intValue() || currentContentVersion.getValueObject().getId() <= contentVersionId) continue;
            ++numberOfNewerVersions;
        }
        return numberOfNewerVersions >= minNewerVersions;
    }

    public void changeVersionLanguage(Integer contentVersionId, Integer languageId) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = this.getContentVersionWithId(contentVersionId, db);
            Language language = LanguageController.getController().getLanguageWithId(languageId, db);
            contentVersion.setLanguage((LanguageImpl)language);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public List<ContentVersionVO> getContentVersionsWithParentAndLanguage(Integer contentId, Integer languageId, Database db) throws SystemException, Bug, Exception {
        ArrayList<ContentVersion> resultList = new ArrayList<ContentVersion>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 and cv.language.languageId = $2 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)languageId);
        QueryResults results = oql.execute();
        while (results.hasMore()) {
            ContentVersion contentVersion = (ContentVersion)results.next();
            resultList.add(contentVersion);
        }
        results.close();
        oql.close();
        return ContentVersionController.toVOList(resultList);
    }

    public List<ContentVersionVO> getLatestActiveContentVersionsForHitSize(Integer contentId, Integer languageId, int hitSize, Database db) throws Exception {
        if (hitSize == 0) {
            throw new SystemException("Illegal argument supplied, argument <hitSize> must be greater then zero.");
        }
        ArrayList<ContentVersion> contentVersionList = new ArrayList<ContentVersion>();
        OQLQuery oql = db.getOQLQuery("SELECT cv FROM org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl cv WHERE cv.owningContent.contentId = $1 AND cv.language.languageId = $2 AND cv.isActive = $3 ORDER BY cv.contentVersionId desc");
        oql.bind((Object)contentId);
        oql.bind((Object)languageId);
        oql.bind(true);
        QueryResults results = oql.execute((short)0);
        int cnt = 0;
        while (results.hasMore() && ++cnt <= hitSize) {
            contentVersionList.add((ContentVersion)results.next());
        }
        results.close();
        oql.close();
        return ContentVersionController.toVOList(contentVersionList);
    }

    public void forceDelete(ContentVersionVO contentVersionVO) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = this.getContentVersionWithId(contentVersionVO.getContentVersionId(), db);
            contentCategoryController.deleteByContentVersion(contentVersion, db);
            ContentImpl content = contentVersion.getOwningContent();
            if (content != null) {
                content.getContentVersions().remove(contentVersion);
            }
            db.remove((Object)contentVersion);
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public ContentVersionVO checkStateAndChangeIfNeeded(Integer contentVersionId, InfoGluePrincipal principal) throws SystemException, Bug {
        ContentVersionVO resultingContentVersionVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = this.checkStateAndChangeIfNeeded(contentVersionId, principal, db);
            resultingContentVersionVO = contentVersion.getValueObject();
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return resultingContentVersionVO;
    }

    public ContentVersion checkStateAndChangeIfNeeded(Integer contentVersionId, InfoGluePrincipal principal, Database db) throws ConstraintException, SystemException, Bug {
        ContentVersion contentVersion = null;
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(contentVersionId, db);
        if (!contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
            ArrayList events = new ArrayList();
            contentVersion = ContentStateController.changeState(contentVersionVO.getId(), ContentVersionVO.WORKING_STATE, "new working version", false, null, principal, contentVersionVO.getContentId(), db, events);
        } else {
            contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionVO.getId(), db);
        }
        return contentVersion;
    }

    public DigitalAssetVO checkStateAndChangeIfNeeded(Integer contentVersionId, Integer digitalAssetId, InfoGluePrincipal principal) throws SystemException, Bug {
        DigitalAssetVO resultingDigitalAssetVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentVersionController.beginTransaction(db);
        try {
            ContentVersion contentVersion = null;
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(contentVersionId, db);
            DigitalAssetController.getController();
            DigitalAssetVO digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(digitalAssetId, db);
            if (!contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
                ArrayList events = new ArrayList();
                contentVersion = ContentStateController.changeState(contentVersionVO.getId(), ContentVersionVO.WORKING_STATE, "new working version", false, null, principal, contentVersionVO.getContentId(), db, events);
                DigitalAssetController.getController();
                digitalAssetVO = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), digitalAssetVO.getAssetKey(), db);
            }
            boolean duplicateAssetsBetweenVersions = CmsPropertyHandler.getDuplicateAssetsBetweenVersions();
            System.out.println("duplicateAssetsBetweenVersions:" + duplicateAssetsBetweenVersions);
            if (!duplicateAssetsBetweenVersions) {
                DigitalAssetController.getController();
                DigitalAsset oldDigitalAsset = DigitalAssetController.getDigitalAssetWithId(digitalAssetId, db);
                System.out.println("oldDigitalAsset:" + oldDigitalAsset.getContentVersions().size());
                if (oldDigitalAsset.getContentVersions().size() > 1) {
                    System.out.println("Creating new duplicate of this asset as there are other assets using this one:" + oldDigitalAsset.getId());
                    System.out.println("contentVersion:" + contentVersion);
                    System.out.println("oldDigitalAsset:" + oldDigitalAsset.getId());
                    if (contentVersion == null) {
                        contentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(contentVersionId, db);
                    }
                    digitalAssetVO = this.copyDigitalAssetAndRemoveOldReference(contentVersion, oldDigitalAsset, false, db);
                    System.out.println("new digitalAssetVO:" + digitalAssetVO.getId());
                }
            }
            resultingDigitalAssetVO = digitalAssetVO;
            ContentVersionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not completes the transaction:" + e), (Throwable)e);
            ContentVersionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        System.out.println("resultingDigitalAssetVO:" + resultingDigitalAssetVO.getId());
        return resultingDigitalAssetVO;
    }

    public DigitalAssetVO checkStateAndChangeIfNeeded(Integer contentVersionId, Integer digitalAssetId, InfoGluePrincipal principal, Database db) throws ConstraintException, SystemException, Bug, Exception {
        ContentVersion contentVersion = null;
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getContentVersionVOWithId(contentVersionId, db);
        DigitalAssetController.getController();
        DigitalAssetVO digitalAssetVO = DigitalAssetController.getDigitalAssetVOWithId(digitalAssetId, db);
        if (!contentVersionVO.getStateId().equals(ContentVersionVO.WORKING_STATE)) {
            ArrayList events = new ArrayList();
            contentVersion = ContentStateController.changeState(contentVersionVO.getId(), ContentVersionVO.WORKING_STATE, "new working version", false, null, principal, contentVersionVO.getContentId(), db, events);
            DigitalAssetController.getController();
            digitalAssetVO = DigitalAssetController.getLatestDigitalAssetVO(contentVersion.getId(), digitalAssetVO.getAssetKey(), db);
        }
        return digitalAssetVO;
    }
}

