/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.databeans.AssetKeyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.CategoryAttribute;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeAttributeParameter;
import org.infoglue.cms.entities.management.ContentTypeAttributeParameterValue;
import org.infoglue.cms.entities.management.ContentTypeAttributeValidator;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.XMLHelper;
import org.infoglue.cms.util.sorters.ReflectionComparator;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ContentTypeDefinitionController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ContentTypeDefinitionController.class.getName());
    public static final String ASSET_KEYS = "assetKeys";
    public static final String CATEGORY_KEYS = "categoryKeys";
    private static final NodeList EMPTY_NODELIST = new NodeList(){

        public int getLength() {
            return 0;
        }

        public Node item(int i) {
            return null;
        }
    };

    public static ContentTypeDefinitionController getController() {
        return new ContentTypeDefinitionController();
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVOWithId(Integer contentTypeDefinitionId) throws SystemException, Bug {
        return (ContentTypeDefinitionVO)ContentTypeDefinitionController.getVOWithId(ContentTypeDefinitionImpl.class, contentTypeDefinitionId);
    }

    public ContentTypeDefinition getContentTypeDefinitionWithId(Integer contentTypeDefinitionId, Database db) throws SystemException, Bug {
        return (ContentTypeDefinition)ContentTypeDefinitionController.getObjectWithId(ContentTypeDefinitionImpl.class, contentTypeDefinitionId, db);
    }

    public List getContentTypeDefinitionVOList() throws SystemException, Bug {
        String key = "contentTypeDefinitionVOList";
        logger.info((Object)("key:" + key));
        List cachedContentTypeDefinitionVOList = (List)CacheController.getCachedObject("contentTypeDefinitionCache", key);
        if (cachedContentTypeDefinitionVOList != null) {
            logger.info((Object)("There was an cached contentTypeDefinitionVOList:" + cachedContentTypeDefinitionVOList.size()));
            return cachedContentTypeDefinitionVOList;
        }
        List contentTypeDefinitionVOList = this.getAllVOObjects(ContentTypeDefinitionImpl.class, "contentTypeDefinitionId");
        CacheController.cacheObject("contentTypeDefinitionCache", key, contentTypeDefinitionVOList);
        return contentTypeDefinitionVOList;
    }

    public List getContentTypeDefinitionVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(ContentTypeDefinitionImpl.class, "contentTypeDefinitionId", db);
    }

    public List getContentTypeDefinitionList(Database db) throws SystemException, Bug {
        return this.getAllObjects(ContentTypeDefinitionImpl.class, "contentTypeDefinitionId", db);
    }

    public List getAuthorizedContentTypeDefinitionVOList(InfoGluePrincipal infoGluePrincipal) throws ConstraintException, SystemException, Bug {
        ArrayList<ContentTypeDefinitionVO> accessableContentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
        List allContentTypeDefinitionVOList = this.getContentTypeDefinitionVOList();
        for (ContentTypeDefinitionVO contentTypeDefinitionVO : allContentTypeDefinitionVOList) {
            if (!this.getIsAccessApproved(contentTypeDefinitionVO.getId(), infoGluePrincipal)) continue;
            accessableContentTypeDefinitionVOList.add(contentTypeDefinitionVO);
        }
        return accessableContentTypeDefinitionVOList;
    }

    public List getSortedAuthorizedContentTypeDefinitionVOList(InfoGluePrincipal infoGluePrincipal, Database db) throws ConstraintException, SystemException, Bug {
        List authorizedContentTypeDefinitionVOList = this.getAuthorizedContentTypeDefinitionVOList(infoGluePrincipal, db);
        Collections.sort(authorizedContentTypeDefinitionVOList, new ReflectionComparator("name"));
        return authorizedContentTypeDefinitionVOList;
    }

    public List getAuthorizedContentTypeDefinitionVOList(InfoGluePrincipal infoGluePrincipal, Database db) throws ConstraintException, SystemException, Bug {
        ArrayList<ContentTypeDefinitionVO> accessableContentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
        List allContentTypeDefinitionVOList = this.getContentTypeDefinitionVOList(db);
        String protectContentTypes = CmsPropertyHandler.getProtectContentTypes();
        if (protectContentTypes != null && protectContentTypes.equalsIgnoreCase("true")) {
            for (ContentTypeDefinitionVO contentTypeDefinitionVO : allContentTypeDefinitionVOList) {
                if (!this.getIsAccessApproved(contentTypeDefinitionVO.getId(), infoGluePrincipal, db)) continue;
                accessableContentTypeDefinitionVOList.add(contentTypeDefinitionVO);
            }
        } else {
            accessableContentTypeDefinitionVOList.addAll(allContentTypeDefinitionVOList);
        }
        return accessableContentTypeDefinitionVOList;
    }

    public boolean getIsAccessApproved(Integer contentTypeDefinitionId, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        logger.info((Object)("getIsAccessApproved for " + contentTypeDefinitionId + " AND " + infoGluePrincipal));
        boolean hasAccess = false;
        Database db = CastorDatabaseService.getDatabase();
        ContentTypeDefinitionController.beginTransaction(db);
        try {
            hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "ContentTypeDefinition.Read", contentTypeDefinitionId.toString());
            ContentTypeDefinitionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentTypeDefinitionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return hasAccess;
    }

    public boolean getIsAccessApproved(Integer contentTypeDefinitionId, InfoGluePrincipal infoGluePrincipal, Database db) throws SystemException {
        logger.info((Object)("getIsAccessApproved for " + contentTypeDefinitionId + " AND " + infoGluePrincipal));
        boolean hasAccess = false;
        hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "ContentTypeDefinition.Read", contentTypeDefinitionId.toString());
        return hasAccess;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVOWithName(String name) throws SystemException, Bug {
        ContentTypeDefinitionVO contentTypeDefinitionVO = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            ContentTypeDefinitionController.beginTransaction(db);
            ContentTypeDefinition contentTypeDefinition = this.getContentTypeDefinitionWithName(name, db);
            if (contentTypeDefinition != null) {
                contentTypeDefinitionVO = contentTypeDefinition.getValueObject();
            }
            ContentTypeDefinitionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            ContentTypeDefinitionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentTypeDefinitionVO;
    }

    public ContentTypeDefinition getContentTypeDefinitionWithName(String name, Database db) throws SystemException, Bug {
        ContentTypeDefinition contentTypeDefinition = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl f WHERE f.name = $1");
            oql.bind((Object)name);
            logger.info((Object)("Fetching entity in read/write mode" + name));
            QueryResults results = oql.execute();
            if (results.hasMore()) {
                contentTypeDefinition = (ContentTypeDefinition)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a named ContentTypeDefinition. Reason:" + e.getMessage(), e);
        }
        return contentTypeDefinition;
    }

    public ContentTypeDefinitionVO getContentTypeDefinitionVOWithName(String name, Database db) throws SystemException, Bug {
        String key = name;
        logger.info((Object)("key:" + key));
        ContentTypeDefinitionVO contentTypeDefinitionVO = (ContentTypeDefinitionVO)CacheController.getCachedObject("contentTypeDefinitionCache", key);
        if (contentTypeDefinitionVO != null) {
            logger.info((Object)("There was an cached contentTypeDefinitionVO:" + contentTypeDefinitionVO));
        } else {
            logger.info((Object)("Refetching contentTypeDefinitionVO:" + contentTypeDefinitionVO));
            try {
                OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl f WHERE f.name = $1");
                oql.bind((Object)name);
                QueryResults results = oql.execute((short)0);
                if (results.hasMore()) {
                    ContentTypeDefinition contentTypeDefinition = (ContentTypeDefinition)results.next();
                    contentTypeDefinitionVO = contentTypeDefinition.getValueObject();
                    CacheController.cacheObject("contentTypeDefinitionCache", key, contentTypeDefinitionVO);
                }
                results.close();
                oql.close();
            }
            catch (Exception e) {
                throw new SystemException("An error occurred when we tried to fetch a named ContentTypeDefinition. Reason:" + e.getMessage(), e);
            }
        }
        return contentTypeDefinitionVO;
    }

    public List getContentTypeDefinitionVOList(Integer type) throws SystemException, Bug {
        List contentTypeDefinitionVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            ContentTypeDefinitionController.beginTransaction(db);
            contentTypeDefinitionVOList = this.getContentTypeDefinitionVOList(type, db);
            ContentTypeDefinitionController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            ContentTypeDefinitionController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentTypeDefinitionVOList;
    }

    public List getContentTypeDefinitionVOList(Integer type, Database db) throws SystemException, Bug {
        ArrayList<ContentTypeDefinitionVO> contentTypeDefinitionVOList = new ArrayList<ContentTypeDefinitionVO>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl f WHERE f.type = $1");
            oql.bind((Object)type);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                ContentTypeDefinition contentTypeDefinition = (ContentTypeDefinition)results.next();
                contentTypeDefinitionVOList.add(contentTypeDefinition.getValueObject());
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Function. Reason:" + e.getMessage(), e);
        }
        return contentTypeDefinitionVOList;
    }

    public ContentTypeDefinitionVO create(ContentTypeDefinitionVO contentTypeDefinitionVO) throws ConstraintException, SystemException {
        ContentTypeDefinition contentTypeDefinition = new ContentTypeDefinitionImpl();
        contentTypeDefinition.setValueObject(contentTypeDefinitionVO);
        contentTypeDefinition = (ContentTypeDefinition)ContentTypeDefinitionController.createEntity(contentTypeDefinition);
        return contentTypeDefinition.getValueObject();
    }

    public void delete(ContentTypeDefinitionVO contentTypeDefinitionVO) throws ConstraintException, SystemException {
        ContentTypeDefinitionController.deleteEntity(ContentTypeDefinitionImpl.class, contentTypeDefinitionVO.getContentTypeDefinitionId());
    }

    public ContentTypeDefinitionVO update(ContentTypeDefinitionVO contentTypeDefinitionVO) throws ConstraintException, SystemException {
        return (ContentTypeDefinitionVO)ContentTypeDefinitionController.updateEntity(ContentTypeDefinitionImpl.class, contentTypeDefinitionVO);
    }

    public AssetKeyDefinition getDefinedAssetKey(String contentTypeDefinitionString, String assetKey) {
        AssetKeyDefinition assetKeyDefinition = null;
        List definedAssetKeys = this.getDefinedAssetKeys(contentTypeDefinitionString);
        for (AssetKeyDefinition currentAssetKeyDefinition : definedAssetKeys) {
            if (!currentAssetKeyDefinition.getAssetKey().equals(assetKey)) continue;
            assetKeyDefinition = currentAssetKeyDefinition;
            break;
        }
        return assetKeyDefinition;
    }

    public List getDefinedAssetKeys(String contentTypeDefinitionString) {
        NodeList nodes = this.getEnumerationNodeList(contentTypeDefinitionString, ASSET_KEYS);
        return this.getEnumValues(nodes);
    }

    public List getDefinedCategoryKeys(String contentTypeDefinitionString) {
        NodeList nodes = this.getEnumerationNodeList(contentTypeDefinitionString, CATEGORY_KEYS);
        return this.getCategoryInfo(nodes);
    }

    protected List getEnumValues(NodeList nodes) {
        ArrayList<AssetKeyDefinition> keys = new ArrayList<AssetKeyDefinition>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node ichild = nodes.item(i);
            logger.info((Object)("ichild:" + ichild.getNodeName() + ":" + ichild.getNodeValue()));
            try {
                Node assetKeyValue = ichild.getAttributes().getNamedItem("value");
                Element params = (Element)XPathAPI.selectSingleNode((Node)ichild, (String)"xs:annotation/xs:appinfo/params");
                String isMandatoryValue = "false";
                String descriptionValue = "";
                String maximumSizeValue = "1000000";
                String allowedContentTypesValue = "*";
                String imageWidthValue = "*";
                String imageHeightValue = "*";
                String assetUploadTransformationsSettingsValue = "";
                if (params != null) {
                    isMandatoryValue = this.getElementValue(params, "isMandatory");
                    if (isMandatoryValue == null) {
                        isMandatoryValue = "false";
                    }
                    descriptionValue = this.getElementValue(params, "description");
                    maximumSizeValue = this.getElementValue(params, "maximumSize");
                    allowedContentTypesValue = this.getElementValue(params, "allowedContentTypes");
                    imageWidthValue = this.getElementValue(params, "imageWidth");
                    imageHeightValue = this.getElementValue(params, "imageHeight");
                    assetUploadTransformationsSettingsValue = this.getElementValue(params, "assetUploadTransformationsSettings");
                }
                AssetKeyDefinition assetKeyDefinition = new AssetKeyDefinition();
                assetKeyDefinition.setAssetKey(assetKeyValue.getNodeValue());
                assetKeyDefinition.setIsMandatory(new Boolean(isMandatoryValue));
                assetKeyDefinition.setDescription(descriptionValue);
                assetKeyDefinition.setMaximumSize(new Integer(maximumSizeValue));
                assetKeyDefinition.setAllowedContentTypes(allowedContentTypesValue);
                assetKeyDefinition.setImageWidth(imageWidthValue);
                assetKeyDefinition.setImageHeight(imageHeightValue);
                assetKeyDefinition.setAssetUploadTransformationsSettings(assetUploadTransformationsSettingsValue);
                logger.info((Object)("Adding assetKeyDefinition " + assetKeyDefinition.getAssetKey()));
                keys.add(assetKeyDefinition);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        logger.info((Object)("keys:" + keys.size()));
        return keys;
    }

    protected List getCategoryInfo(NodeList nodes) {
        String attributesXPath = "xs:annotation/xs:appinfo/params";
        ArrayList<CategoryAttribute> keys = new ArrayList<CategoryAttribute>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node enumeration = nodes.item(i);
            String value = enumeration.getAttributes().getNamedItem("value").getNodeValue();
            try {
                CategoryAttribute category = new CategoryAttribute(value);
                keys.add(category);
                Element params = (Element)XPathAPI.selectSingleNode((Node)enumeration, (String)attributesXPath);
                if (params != null) {
                    category.setTitle(this.getElementValue(params, "title"));
                    category.setDescription(this.getElementValue(params, "description"));
                    category.setCategoryId(this.getElementValue(params, "categoryId"));
                }
            }
            catch (TransformerException e) {
                keys.add(new CategoryAttribute(value));
            }
            ++i;
        }
        return keys;
    }

    protected NodeList getEnumerationNodeList(String contentTypeDefinitionString, String keyType) {
        try {
            if (contentTypeDefinitionString != null) {
                InputSource xmlSource = new InputSource(new StringReader(contentTypeDefinitionString));
                DOMParser parser = new DOMParser();
                parser.parse(xmlSource);
                Document document = parser.getDocument();
                String attributesXPath = "/xs:schema/xs:simpleType[@name = '" + keyType + "']/xs:restriction/xs:enumeration";
                return XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when trying to fetch the asset keys:" + e.getMessage()), (Throwable)e);
        }
        return EMPTY_NODELIST;
    }

    protected String getElementValue(Element root, String tagName) {
        NodeList nodes = root.getElementsByTagName(tagName);
        if (nodes.getLength() > 0) {
            Node cdata = nodes.item(0).getFirstChild();
            return cdata != null ? cdata.getNodeValue() : null;
        }
        return null;
    }

    public List getContentTypeAttributes(String schemaValue) {
        String key = "schemaValue_" + schemaValue.hashCode();
        Object attributesCandidate = CacheController.getCachedObject("contentTypeDefinitionCache", key);
        List attributes = new ArrayList();
        if (attributesCandidate != null) {
            attributes = attributesCandidate instanceof NullObject ? new ArrayList() : (List)attributesCandidate;
        } else {
            try {
                InputSource xmlSource = new InputSource(new StringReader(schemaValue));
                DOMParser parser = new DOMParser();
                parser.parse(xmlSource);
                Document document = parser.getDocument();
                String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
                int i = 0;
                while (i < anl.getLength()) {
                    Element child = (Element)anl.item(i);
                    String attributeName = child.getAttribute("name");
                    String attributeType = child.getAttribute("type");
                    ContentTypeAttribute contentTypeAttribute = new ContentTypeAttribute();
                    contentTypeAttribute.setPosition(i);
                    contentTypeAttribute.setName(attributeName);
                    contentTypeAttribute.setInputType(attributeType);
                    String validatorsXPath = "/xs:schema/xs:complexType[@name = 'Validation']/xs:annotation/xs:appinfo/form-validation/formset/form/field[@property = '" + attributeName + "']";
                    NodeList validatorNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)validatorsXPath);
                    int j = 0;
                    while (j < validatorNodeList.getLength()) {
                        Element validatorNode = (Element)validatorNodeList.item(j);
                        if (validatorNode != null) {
                            HashMap<String, String> arguments = new HashMap<String, String>();
                            NodeList varNodeList = validatorNode.getElementsByTagName("var");
                            int k = 0;
                            while (k < varNodeList.getLength()) {
                                Element varNode = (Element)varNodeList.item(k);
                                String varName = this.getElementValue(varNode, "var-name");
                                String varValue = this.getElementValue(varNode, "var-value");
                                arguments.put(varName, varValue);
                                ++k;
                            }
                            String attribute = validatorNode.getAttribute("depends");
                            String[] depends = attribute.split(",");
                            int dependsIndex = 0;
                            while (dependsIndex < depends.length) {
                                String name = depends[dependsIndex];
                                ContentTypeAttributeValidator contentTypeAttributeValidator = new ContentTypeAttributeValidator();
                                contentTypeAttributeValidator.setName(name);
                                contentTypeAttributeValidator.setArguments(arguments);
                                contentTypeAttribute.getValidators().add(contentTypeAttributeValidator);
                                ++dependsIndex;
                            }
                        }
                        ++j;
                    }
                    Node paramsNode = XPathAPI.selectSingleNode((Node)child, (String)"xs:annotation/xs:appinfo/params");
                    if (paramsNode != null) {
                        NodeList childnl = ((Element)paramsNode).getElementsByTagName("param");
                        int ci = 0;
                        while (ci < childnl.getLength()) {
                            Element param = (Element)childnl.item(ci);
                            String paramId = param.getAttribute("id");
                            String paramInputTypeId = param.getAttribute("inputTypeId");
                            ContentTypeAttributeParameter contentTypeAttributeParameter = new ContentTypeAttributeParameter();
                            contentTypeAttributeParameter.setId(paramId);
                            if (paramInputTypeId != null && paramInputTypeId.length() > 0) {
                                contentTypeAttributeParameter.setType(Integer.parseInt(paramInputTypeId));
                            }
                            contentTypeAttribute.putContentTypeAttributeParameter(paramId, contentTypeAttributeParameter);
                            NodeList valuesNodeList = param.getElementsByTagName("values");
                            int vsnli = 0;
                            while (vsnli < valuesNodeList.getLength()) {
                                NodeList valueNodeList = param.getElementsByTagName("value");
                                int vnli = 0;
                                while (vnli < valueNodeList.getLength()) {
                                    Element value = (Element)valueNodeList.item(vnli);
                                    String valueId = value.getAttribute("id");
                                    ContentTypeAttributeParameterValue contentTypeAttributeParameterValue = new ContentTypeAttributeParameterValue();
                                    contentTypeAttributeParameterValue.setId(valueId);
                                    NamedNodeMap nodeMap = value.getAttributes();
                                    int nmi = 0;
                                    while (nmi < nodeMap.getLength()) {
                                        Node attribute = nodeMap.item(nmi);
                                        String valueAttributeName = attribute.getNodeName();
                                        String valueAttributeValue = attribute.getNodeValue();
                                        contentTypeAttributeParameterValue.addAttribute(valueAttributeName, valueAttributeValue);
                                        ++nmi;
                                    }
                                    contentTypeAttributeParameter.addContentTypeAttributeParameterValue(valueId, contentTypeAttributeParameterValue);
                                    ++vnli;
                                }
                                ++vsnli;
                            }
                            ++ci;
                        }
                    }
                    attributes.add(contentTypeAttribute);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred when we tried to get the attributes of the content type: " + e.getMessage()), (Throwable)e);
            }
        }
        if (attributes != null) {
            CacheController.cacheObject("contentTypeDefinitionCache", key, attributes);
        } else {
            CacheController.cacheObject("contentTypeDefinitionCache", key, new NullObject());
        }
        return attributes;
    }

    public String insertContentTypeAttribute(String schemaValue, String inputTypeId, List activatedName) {
        String newSchemaValue = schemaValue;
        try {
            InputSource xmlSource = new InputSource(new StringReader(schemaValue));
            DOMParser parser = new DOMParser();
            parser.parse(xmlSource);
            Document document = parser.getDocument();
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all";
            NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
            int i = 0;
            while (i < anl.getLength()) {
                Node child = anl.item(i);
                Element childElement = (Element)child;
                Element newAttribute = document.createElement("xs:element");
                String name = "newAttributeName" + (int)(Math.random() * 100.0);
                activatedName.add(name);
                newAttribute.setAttribute("name", name);
                newAttribute.setAttribute("type", inputTypeId);
                childElement.appendChild(newAttribute);
                Element annotation = document.createElement("xs:annotation");
                Element appInfo = document.createElement("xs:appinfo");
                Element params = document.createElement("params");
                this.addParameterElement(params, "title", "0");
                this.addParameterElement(params, "description", "0");
                this.addParameterElement(params, "initialData", "");
                this.addParameterElement(params, "class", "0");
                newAttribute.appendChild(annotation);
                annotation.appendChild(appInfo);
                appInfo.appendChild(params);
                if (inputTypeId.equalsIgnoreCase("checkbox") || inputTypeId.equalsIgnoreCase("select") || inputTypeId.equalsIgnoreCase("radiobutton")) {
                    this.addParameterElement(params, "values", "1");
                }
                if (inputTypeId.equalsIgnoreCase("textarea")) {
                    this.addParameterElement(params, "width", "0", "700");
                    this.addParameterElement(params, "height", "0", "150");
                    this.addParameterElement(params, "enableWYSIWYG", "0", "false");
                    this.addParameterElement(params, "WYSIWYGToolbar", "0", "Default");
                    this.addParameterElement(params, "WYSIWYGExtraConfig", "0", "");
                    this.addParameterElement(params, "enableTemplateEditor", "0", "false");
                    this.addParameterElement(params, "enableFormEditor", "0", "false");
                    this.addParameterElement(params, "enableContentRelationEditor", "0", "false");
                    this.addParameterElement(params, "enableStructureRelationEditor", "0", "false");
                    this.addParameterElement(params, "enableComponentPropertiesEditor", "0", "false");
                    this.addParameterElement(params, "activateExtendedEditorOnLoad", "0", "false");
                }
                if (inputTypeId.equalsIgnoreCase("customfield")) {
                    this.addParameterElement(params, "Markup", "2", "");
                }
                ++i;
            }
            StringBuffer sb = new StringBuffer();
            XMLHelper.serializeDom(document.getDocumentElement(), sb);
            newSchemaValue = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newSchemaValue;
    }

    private void addParameterElement(Element parent, String id, String inputTypeId) {
        Element parameter = parent.getOwnerDocument().createElement("param");
        parameter.setAttribute("id", id);
        parameter.setAttribute("inputTypeId", inputTypeId);
        Element parameterValuesValues = parent.getOwnerDocument().createElement("values");
        Element parameterValuesValue = parent.getOwnerDocument().createElement("value");
        parameterValuesValue.setAttribute("id", "undefined" + (int)(Math.random() * 100.0));
        parameterValuesValue.setAttribute("label", "undefined" + (int)(Math.random() * 100.0));
        parameterValuesValues.appendChild(parameterValuesValue);
        parameter.appendChild(parameterValuesValues);
        parent.appendChild(parameter);
    }

    private void addParameterElement(Element parent, String id, String inputTypeId, String defaultValue) {
        Element parameter = parent.getOwnerDocument().createElement("param");
        parameter.setAttribute("id", id);
        parameter.setAttribute("inputTypeId", inputTypeId);
        Element parameterValuesValues = parent.getOwnerDocument().createElement("values");
        Element parameterValuesValue = parent.getOwnerDocument().createElement("value");
        parameterValuesValue.setAttribute("id", id);
        parameterValuesValue.setAttribute("label", defaultValue);
        parameterValuesValues.appendChild(parameterValuesValue);
        parameter.appendChild(parameterValuesValues);
        parent.appendChild(parameter);
    }

    private void addParameterElementIfNotExists(Element parent, String id, String inputTypeId, String defaultValue) throws Exception {
        String parameterXPath = "param[@id='" + id + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)parent, (String)parameterXPath);
        if (anl.getLength() == 0) {
            Element parameter = parent.getOwnerDocument().createElement("param");
            parameter.setAttribute("id", id);
            parameter.setAttribute("inputTypeId", inputTypeId);
            Element parameterValuesValues = parent.getOwnerDocument().createElement("values");
            Element parameterValuesValue = parent.getOwnerDocument().createElement("value");
            parameterValuesValue.setAttribute("id", id);
            parameterValuesValue.setAttribute("label", defaultValue);
            parameterValuesValues.appendChild(parameterValuesValue);
            parameter.appendChild(parameterValuesValues);
            parent.appendChild(parameter);
        }
    }

    public ContentTypeDefinitionVO validateAndUpdateContentType(ContentTypeDefinitionVO contentTypeDefinitionVO) {
        try {
            boolean isModified = false;
            InputSource xmlSource = new InputSource(new StringReader(contentTypeDefinitionVO.getSchemaValue()));
            DOMParser parser = new DOMParser();
            parser.parse(xmlSource);
            Document document = parser.getDocument();
            String rootXPath = "/xs:schema";
            NodeList schemaList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)rootXPath);
            int i = 0;
            while (i < schemaList.getLength()) {
                Element paramsElement;
                NodeList paramsNodeList;
                NodeList appinfoNodeList;
                NodeList annotationNodeList;
                String inputTypeId;
                NodeList anl;
                String attributesXPath;
                Element childElement;
                Element schemaElement = (Element)schemaList.item(i);
                if (schemaElement.getAttribute("version") == null || schemaElement.getAttribute("version").equalsIgnoreCase("")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.0");
                    String definitionsXPath = "/xs:schema/xs:simpleType";
                    NodeList definitionList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)definitionsXPath);
                    int j = 0;
                    while (j < definitionList.getLength()) {
                        childElement = (Element)definitionList.item(j);
                        if (!childElement.getAttribute("name").equalsIgnoreCase(ASSET_KEYS)) {
                            childElement.getParentNode().removeChild(childElement);
                        }
                        ++j;
                    }
                    Element textFieldDefinition = document.createElement("xs:simpleType");
                    textFieldDefinition.setAttribute("name", "textfield");
                    Element restriction = document.createElement("xs:restriction");
                    restriction.setAttribute("base", "xs:string");
                    Element maxLength = document.createElement("xs:maxLength");
                    maxLength.setAttribute("value", "100");
                    restriction.appendChild(maxLength);
                    textFieldDefinition.appendChild(restriction);
                    schemaElement.insertBefore(textFieldDefinition, schemaElement.getFirstChild());
                    Element selectDefinition = document.createElement("xs:simpleType");
                    selectDefinition.setAttribute("name", "select");
                    restriction = document.createElement("xs:restriction");
                    restriction.setAttribute("base", "xs:string");
                    maxLength = document.createElement("xs:maxLength");
                    maxLength.setAttribute("value", "100");
                    restriction.appendChild(maxLength);
                    selectDefinition.appendChild(restriction);
                    schemaElement.insertBefore(selectDefinition, schemaElement.getFirstChild());
                    Element checkboxDefinition = document.createElement("xs:simpleType");
                    checkboxDefinition.setAttribute("name", "checkbox");
                    restriction = document.createElement("xs:restriction");
                    restriction.setAttribute("base", "xs:string");
                    maxLength = document.createElement("xs:maxLength");
                    maxLength.setAttribute("value", "100");
                    restriction.appendChild(maxLength);
                    checkboxDefinition.appendChild(restriction);
                    schemaElement.insertBefore(checkboxDefinition, schemaElement.getFirstChild());
                    Element radiobuttonDefinition = document.createElement("xs:simpleType");
                    radiobuttonDefinition.setAttribute("name", "radiobutton");
                    restriction = document.createElement("xs:restriction");
                    restriction.setAttribute("base", "xs:string");
                    maxLength = document.createElement("xs:maxLength");
                    maxLength.setAttribute("value", "100");
                    restriction.appendChild(maxLength);
                    radiobuttonDefinition.appendChild(restriction);
                    schemaElement.insertBefore(radiobuttonDefinition, schemaElement.getFirstChild());
                    Element textareaDefinition = document.createElement("xs:simpleType");
                    textareaDefinition.setAttribute("name", "textarea");
                    restriction = document.createElement("xs:restriction");
                    restriction.setAttribute("base", "xs:string");
                    maxLength = document.createElement("xs:maxLength");
                    maxLength.setAttribute("value", "100");
                    restriction.appendChild(maxLength);
                    textareaDefinition.appendChild(restriction);
                    schemaElement.insertBefore(textareaDefinition, schemaElement.getFirstChild());
                    String attributesXPath2 = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                    NodeList anl2 = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath2);
                    int k = 0;
                    while (k < anl2.getLength()) {
                        Element childElement2 = (Element)anl2.item(k);
                        if (childElement2.getAttribute("type").equals("shortString")) {
                            childElement2.setAttribute("type", "textfield");
                            isModified = true;
                        } else if (childElement2.getAttribute("type").equals("shortText")) {
                            childElement2.setAttribute("type", "textarea");
                            isModified = true;
                        } else if (childElement2.getAttribute("type").equals("fullText")) {
                            childElement2.setAttribute("type", "textarea");
                            isModified = true;
                        } else if (childElement2.getAttribute("type").equals("hugeText")) {
                            childElement2.setAttribute("type", "textarea");
                            isModified = true;
                        }
                        String inputTypeId2 = childElement2.getAttribute("type");
                        NodeList annotationNodeList2 = childElement2.getElementsByTagName("xs:annotation");
                        if (annotationNodeList2 != null && annotationNodeList2.getLength() > 0) {
                            Element annotationElement = (Element)annotationNodeList2.item(0);
                            NodeList appinfoNodeList2 = childElement2.getElementsByTagName("xs:appinfo");
                            if (appinfoNodeList2 != null && appinfoNodeList2.getLength() > 0) {
                                Element paramsElement2;
                                Element appinfoElement = (Element)appinfoNodeList2.item(0);
                                NodeList paramsNodeList2 = childElement2.getElementsByTagName("params");
                                if (paramsNodeList2 != null && paramsNodeList2.getLength() > 0) {
                                    paramsElement2 = (Element)paramsNodeList2.item(0);
                                    this.addParameterElement(paramsElement2, "title", "0");
                                    this.addParameterElement(paramsElement2, "description", "0");
                                    this.addParameterElement(paramsElement2, "class", "0");
                                    if (inputTypeId2.equalsIgnoreCase("checkbox") || inputTypeId2.equalsIgnoreCase("select") || inputTypeId2.equalsIgnoreCase("radiobutton")) {
                                        this.addParameterElement(paramsElement2, "values", "1");
                                    }
                                    if (inputTypeId2.equalsIgnoreCase("textarea")) {
                                        this.addParameterElement(paramsElement2, "width", "0", "700");
                                        this.addParameterElement(paramsElement2, "height", "0", "150");
                                        this.addParameterElement(paramsElement2, "enableWYSIWYG", "0", "false");
                                        this.addParameterElement(paramsElement2, "WYSIWYGToolbar", "0", "Default");
                                        this.addParameterElement(paramsElement2, "WYSIWYGExtraConfig", "0", "");
                                        this.addParameterElement(paramsElement2, "enableTemplateEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "enableFormEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "enableContentRelationEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "enableStructureRelationEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "activateExtendedEditorOnLoad", "0", "false");
                                    }
                                } else {
                                    paramsElement2 = document.createElement("params");
                                    this.addParameterElement(paramsElement2, "title", "0");
                                    this.addParameterElement(paramsElement2, "description", "0");
                                    this.addParameterElement(paramsElement2, "class", "0");
                                    if (inputTypeId2.equalsIgnoreCase("checkbox") || inputTypeId2.equalsIgnoreCase("select") || inputTypeId2.equalsIgnoreCase("radiobutton")) {
                                        this.addParameterElement(paramsElement2, "values", "1");
                                    }
                                    if (inputTypeId2.equalsIgnoreCase("textarea")) {
                                        this.addParameterElement(paramsElement2, "width", "0", "700");
                                        this.addParameterElement(paramsElement2, "height", "0", "150");
                                        this.addParameterElement(paramsElement2, "enableWYSIWYG", "0", "false");
                                        this.addParameterElement(paramsElement2, "WYSIWYGToolbar", "0", "Default");
                                        this.addParameterElement(paramsElement2, "WYSIWYGExtraConfig", "0", "");
                                        this.addParameterElement(paramsElement2, "enableTemplateEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "enableFormEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "enableContentRelationEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "enableStructureRelationEditor", "0", "false");
                                        this.addParameterElement(paramsElement2, "activateExtendedEditorOnLoad", "0", "false");
                                    }
                                    appinfoElement.appendChild(paramsElement2);
                                    isModified = true;
                                }
                            } else {
                                Element appInfo = document.createElement("xs:appinfo");
                                Element paramsElement3 = document.createElement("params");
                                this.addParameterElement(paramsElement3, "title", "0");
                                this.addParameterElement(paramsElement3, "description", "0");
                                this.addParameterElement(paramsElement3, "class", "0");
                                if (inputTypeId2.equalsIgnoreCase("checkbox") || inputTypeId2.equalsIgnoreCase("select") || inputTypeId2.equalsIgnoreCase("radiobutton")) {
                                    this.addParameterElement(paramsElement3, "values", "1");
                                }
                                if (inputTypeId2.equalsIgnoreCase("textarea")) {
                                    this.addParameterElement(paramsElement3, "width", "0", "700");
                                    this.addParameterElement(paramsElement3, "height", "0", "150");
                                    this.addParameterElement(paramsElement3, "enableWYSIWYG", "0", "false");
                                    this.addParameterElement(paramsElement3, "WYSIWYGToolbar", "0", "Default");
                                    this.addParameterElement(paramsElement3, "WYSIWYGExtraConfig", "0", "");
                                    this.addParameterElement(paramsElement3, "enableTemplateEditor", "0", "false");
                                    this.addParameterElement(paramsElement3, "enableFormEditor", "0", "false");
                                    this.addParameterElement(paramsElement3, "enableContentRelationEditor", "0", "false");
                                    this.addParameterElement(paramsElement3, "enableStructureRelationEditor", "0", "false");
                                    this.addParameterElement(paramsElement3, "activateExtendedEditorOnLoad", "0", "false");
                                }
                                annotationElement.appendChild(appInfo);
                                appInfo.appendChild(paramsElement3);
                                isModified = true;
                            }
                        } else {
                            Element annotation = document.createElement("xs:annotation");
                            Element appInfo = document.createElement("xs:appinfo");
                            Element paramsElement4 = document.createElement("params");
                            this.addParameterElement(paramsElement4, "title", "0");
                            this.addParameterElement(paramsElement4, "description", "0");
                            this.addParameterElement(paramsElement4, "class", "0");
                            if (inputTypeId2.equalsIgnoreCase("checkbox") || inputTypeId2.equalsIgnoreCase("select") || inputTypeId2.equalsIgnoreCase("radiobutton")) {
                                this.addParameterElement(paramsElement4, "values", "1");
                            }
                            if (inputTypeId2.equalsIgnoreCase("textarea")) {
                                this.addParameterElement(paramsElement4, "width", "0", "700");
                                this.addParameterElement(paramsElement4, "height", "0", "150");
                                this.addParameterElement(paramsElement4, "enableWYSIWYG", "0", "false");
                                this.addParameterElement(paramsElement4, "WYSIWYGToolbar", "0", "Default");
                                this.addParameterElement(paramsElement4, "WYSIWYGExtraConfig", "0", "");
                                this.addParameterElement(paramsElement4, "enableTemplateEditor", "0", "false");
                                this.addParameterElement(paramsElement4, "enableFormEditor", "0", "false");
                                this.addParameterElement(paramsElement4, "enableContentRelationEditor", "0", "false");
                                this.addParameterElement(paramsElement4, "enableStructureRelationEditor", "0", "false");
                                this.addParameterElement(paramsElement4, "activateExtendedEditorOnLoad", "0", "false");
                            }
                            childElement2.appendChild(annotation);
                            annotation.appendChild(appInfo);
                            appInfo.appendChild(paramsElement4);
                            isModified = true;
                        }
                        ++k;
                    }
                } else if (schemaElement.getAttribute("version") != null && schemaElement.getAttribute("version").equalsIgnoreCase("2.0")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.1");
                    attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                    anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
                    int k = 0;
                    while (k < anl.getLength()) {
                        childElement = (Element)anl.item(k);
                        inputTypeId = childElement.getAttribute("type");
                        annotationNodeList = childElement.getElementsByTagName("xs:annotation");
                        if (annotationNodeList != null && annotationNodeList.getLength() > 0 && (appinfoNodeList = childElement.getElementsByTagName("xs:appinfo")) != null && appinfoNodeList.getLength() > 0 && (paramsNodeList = childElement.getElementsByTagName("params")) != null && paramsNodeList.getLength() > 0) {
                            paramsElement = (Element)paramsNodeList.item(0);
                            if (inputTypeId.equalsIgnoreCase("textarea")) {
                                this.addParameterElementIfNotExists(paramsElement, "width", "0", "700");
                                this.addParameterElementIfNotExists(paramsElement, "height", "0", "150");
                                this.addParameterElementIfNotExists(paramsElement, "enableWYSIWYG", "0", "false");
                                this.addParameterElementIfNotExists(paramsElement, "WYSIWYGToolbar", "0", "Default");
                                this.addParameterElementIfNotExists(paramsElement, "WYSIWYGExtraConfig", "0", "");
                                this.addParameterElementIfNotExists(paramsElement, "enableTemplateEditor", "0", "false");
                                this.addParameterElementIfNotExists(paramsElement, "enableFormEditor", "0", "false");
                                this.addParameterElementIfNotExists(paramsElement, "enableContentRelationEditor", "0", "false");
                                this.addParameterElementIfNotExists(paramsElement, "enableStructureRelationEditor", "0", "false");
                                this.addParameterElementIfNotExists(paramsElement, "activateExtendedEditorOnLoad", "0", "false");
                                isModified = true;
                            }
                        }
                        ++k;
                    }
                } else if (schemaElement.getAttribute("version") != null && schemaElement.getAttribute("version").equalsIgnoreCase("2.1")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.2");
                    String validatorsXPath = "/xs:schema/xs:complexType[@name = 'Validation']";
                    Node formNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)validatorsXPath);
                    if (formNode == null) {
                        String schemaXPath = "/xs:schema";
                        Node schemaNode = XPathAPI.selectSingleNode((Node)document.getDocumentElement(), (String)schemaXPath);
                        Element element = (Element)schemaNode;
                        String validationXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:complexType name=\"Validation\" xmlns:xi=\"http://www.w3.org/2001/XInclude\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"><xs:annotation><xs:appinfo><form-validation><global><validator name=\"required\" classname=\"org.infoglue.cms.util.validators.CommonsValidator\" method=\"validateRequired\" methodParams=\"java.lang.Object,org.apache.commons.validator.Field\" msg=\"300\"/><validator name=\"requiredif\" classname=\"org.infoglue.cms.util.validators.CommonsValidator\" method=\"validateRequiredIf\" methodParams=\"java.lang.Object,org.apache.commons.validator.Field,org.apache.commons.validator.Validator\" msg=\"315\"/><validator name=\"matchRegexp\" classname=\"org.infoglue.cms.util.validators.CommonsValidator\" method=\"validateRegexp\" methodParams=\"java.lang.Object,org.apache.commons.validator.Field\" msg=\"300\"/></global><formset><form name=\"requiredForm\"></form></formset></form-validation></xs:appinfo></xs:annotation></xs:complexType>";
                        InputSource validationXMLSource = new InputSource(new StringReader(validationXML));
                        DOMParser parser2 = new DOMParser();
                        parser2.parse(validationXMLSource);
                        Document document2 = parser2.getDocument();
                        Node node = document.importNode(document2.getDocumentElement(), true);
                        element.appendChild(node);
                    }
                } else if (schemaElement.getAttribute("version") != null && schemaElement.getAttribute("version").equalsIgnoreCase("2.2")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.3");
                    attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                    anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
                    int k = 0;
                    while (k < anl.getLength()) {
                        childElement = (Element)anl.item(k);
                        inputTypeId = childElement.getAttribute("type");
                        annotationNodeList = childElement.getElementsByTagName("xs:annotation");
                        if (annotationNodeList != null && annotationNodeList.getLength() > 0 && (appinfoNodeList = childElement.getElementsByTagName("xs:appinfo")) != null && appinfoNodeList.getLength() > 0 && (paramsNodeList = childElement.getElementsByTagName("params")) != null && paramsNodeList.getLength() > 0) {
                            paramsElement = (Element)paramsNodeList.item(0);
                            this.addParameterElementIfNotExists(paramsElement, "initialData", "0", "");
                            isModified = true;
                        }
                        ++k;
                    }
                } else if (schemaElement.getAttribute("version") != null && schemaElement.getAttribute("version").equalsIgnoreCase("2.3")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.4");
                    attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                    anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
                    int k = 0;
                    while (k < anl.getLength()) {
                        childElement = (Element)anl.item(k);
                        inputTypeId = childElement.getAttribute("type");
                        annotationNodeList = childElement.getElementsByTagName("xs:annotation");
                        if (annotationNodeList != null && annotationNodeList.getLength() > 0 && (appinfoNodeList = childElement.getElementsByTagName("xs:appinfo")) != null && appinfoNodeList.getLength() > 0 && (paramsNodeList = childElement.getElementsByTagName("params")) != null && paramsNodeList.getLength() > 0) {
                            paramsElement = (Element)paramsNodeList.item(0);
                            this.addParameterElementIfNotExists(paramsElement, "enableComponentPropertiesEditor", "0", "false");
                            isModified = true;
                        }
                        ++k;
                    }
                } else if (schemaElement.getAttribute("version") != null && schemaElement.getAttribute("version").equalsIgnoreCase("2.4")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.5");
                    attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                    anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
                    int k = 0;
                    while (k < anl.getLength()) {
                        childElement = (Element)anl.item(k);
                        inputTypeId = childElement.getAttribute("type");
                        annotationNodeList = childElement.getElementsByTagName("xs:annotation");
                        if (annotationNodeList != null && annotationNodeList.getLength() > 0 && (appinfoNodeList = childElement.getElementsByTagName("xs:appinfo")) != null && appinfoNodeList.getLength() > 0 && (paramsNodeList = childElement.getElementsByTagName("params")) != null && paramsNodeList.getLength() > 0) {
                            paramsElement = (Element)paramsNodeList.item(0);
                            this.addParameterElementIfNotExists(paramsElement, "WYSIWYGToolbar", "0", "Default");
                            this.addParameterElementIfNotExists(paramsElement, "WYSIWYGExtraConfig", "0", "");
                            isModified = true;
                        }
                        ++k;
                    }
                } else if (schemaElement.getAttribute("version") != null && schemaElement.getAttribute("version").equalsIgnoreCase("2.5")) {
                    isModified = true;
                    schemaElement.setAttribute("version", "2.5.1");
                    attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element";
                    anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)attributesXPath);
                    int k = 0;
                    while (k < anl.getLength()) {
                        childElement = (Element)anl.item(k);
                        inputTypeId = childElement.getAttribute("type");
                        annotationNodeList = childElement.getElementsByTagName("xs:annotation");
                        if (annotationNodeList != null && annotationNodeList.getLength() > 0 && (appinfoNodeList = childElement.getElementsByTagName("xs:appinfo")) != null && appinfoNodeList.getLength() > 0 && (paramsNodeList = childElement.getElementsByTagName("params")) != null && paramsNodeList.getLength() > 0) {
                            paramsElement = (Element)paramsNodeList.item(0);
                            this.addParameterElementIfNotExists(paramsElement, "WYSIWYGExtraConfig", "0", "");
                            isModified = true;
                        }
                        ++k;
                    }
                }
                ++i;
            }
            if (isModified) {
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(document.getDocumentElement(), sb);
                contentTypeDefinitionVO.setSchemaValue(sb.toString());
                this.update(contentTypeDefinitionVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contentTypeDefinitionVO;
    }

    private boolean addParameterElement(Element parent, String name, String inputTypeId, String value, boolean isAllreadyModified) {
        boolean isModified = isAllreadyModified;
        NodeList titleNodeList = parent.getElementsByTagName(name);
        if (titleNodeList != null && titleNodeList.getLength() > 0) {
            Element titleElement = (Element)titleNodeList.item(0);
            if (!titleElement.hasChildNodes()) {
                titleElement.appendChild(parent.getOwnerDocument().createTextNode(value));
                isModified = true;
            }
        } else {
            Element title = parent.getOwnerDocument().createElement(name);
            title.appendChild(parent.getOwnerDocument().createTextNode(value));
            parent.appendChild(title);
            isModified = true;
        }
        return isModified;
    }

    public Element createNewEnumerationKey(Document document, String keyType) throws TransformerException {
        Element enumeration = null;
        String assetKeysXPath = "/xs:schema/xs:simpleType[@name = '" + keyType + "']/xs:restriction";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)assetKeysXPath);
        Element keyRestriction = null;
        if (anl != null && anl.getLength() > 0) {
            keyRestriction = (Element)anl.item(0);
        } else {
            String schemaXPath = "/xs:schema";
            NodeList schemaNL = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)schemaXPath);
            if (schemaNL != null && schemaNL.getLength() > 0) {
                Element schemaElement = (Element)schemaNL.item(0);
                Element keySimpleType = document.createElement("xs:simpleType");
                keySimpleType.setAttribute("name", keyType);
                keyRestriction = document.createElement("xs:restriction");
                keyRestriction.setAttribute("base", "xs:string");
                keySimpleType.appendChild(keyRestriction);
                schemaElement.appendChild(keySimpleType);
            }
        }
        enumeration = document.createElement("xs:enumeration");
        enumeration.setAttribute("value", this.getRandomName());
        keyRestriction.appendChild(enumeration);
        return enumeration;
    }

    private String getRandomName() {
        return "undefined" + (int)(Math.random() * 100.0);
    }

    public String copyAttribute(String remoteSchemaValue, String localSchemaValue, String contentTypeAttributeName) {
        String newSchemaValue = localSchemaValue;
        try {
            Document remoteDocument = this.createDocumentFromDefinition(remoteSchemaValue);
            Document localDocument = this.createDocumentFromDefinition(localSchemaValue);
            String attributeXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all/xs:element[@name='" + contentTypeAttributeName + "']";
            Node attributeNode = XPathAPI.selectSingleNode((Node)remoteDocument.getDocumentElement(), (String)attributeXPath);
            String attributesXPath = "/xs:schema/xs:complexType/xs:all/xs:element/xs:complexType/xs:all";
            Node attributesNode = XPathAPI.selectSingleNode((Node)localDocument.getDocumentElement(), (String)attributesXPath);
            logger.info((Object)("attributesNode:" + attributesNode));
            if (attributesNode != null && localDocument != null && attributeNode != null) {
                Node node = localDocument.importNode(attributeNode, true);
                attributesNode.appendChild(node);
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(localDocument.getDocumentElement(), sb);
                newSchemaValue = sb.toString();
            } else {
                logger.error((Object)("Problem:" + attributesNode + " - " + localDocument + " - " + attributeNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newSchemaValue;
    }

    public String copyCategory(String remoteSchemaValue, String localSchemaValue, String categoryName) {
        String newSchemaValue = localSchemaValue;
        try {
            Document remoteDocument = this.createDocumentFromDefinition(remoteSchemaValue);
            Document localDocument = this.createDocumentFromDefinition(localSchemaValue);
            String attributeXPath = "/xs:schema/xs:simpleType[@name='categoryKeys']/xs:restriction/xs:enumeration[@value='" + categoryName + "']";
            Node attributeNode = XPathAPI.selectSingleNode((Node)remoteDocument.getDocumentElement(), (String)attributeXPath);
            String attributesXPath = "/xs:schema/xs:simpleType[@name='categoryKeys']/xs:restriction";
            Node attributesNode = XPathAPI.selectSingleNode((Node)localDocument.getDocumentElement(), (String)attributesXPath);
            if (attributesNode == null) {
                attributesNode = ContentTypeDefinitionController.getController().createNewEnumerationKey(localDocument, CATEGORY_KEYS);
            }
            if (attributesNode != null && localDocument != null && attributeNode != null) {
                Node node = localDocument.importNode(attributeNode, true);
                attributesNode.appendChild(node);
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(localDocument.getDocumentElement(), sb);
                newSchemaValue = sb.toString();
            } else {
                logger.error((Object)("Problem:" + attributesNode + " - " + localDocument + " - " + attributeNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newSchemaValue;
    }

    public String copyAssetKey(String remoteSchemaValue, String localSchemaValue, String assetKey) {
        String newSchemaValue = localSchemaValue;
        try {
            Document remoteDocument = this.createDocumentFromDefinition(remoteSchemaValue);
            Document localDocument = this.createDocumentFromDefinition(localSchemaValue);
            String attributeXPath = "/xs:schema/xs:simpleType[@name='assetKeys']/xs:restriction/xs:enumeration[@value='" + assetKey + "']";
            Node attributeNode = XPathAPI.selectSingleNode((Node)remoteDocument.getDocumentElement(), (String)attributeXPath);
            String attributesXPath = "/xs:schema/xs:simpleType[@name='assetKeys']/xs:restriction";
            Node attributesNode = XPathAPI.selectSingleNode((Node)localDocument.getDocumentElement(), (String)attributesXPath);
            if (attributesNode == null) {
                attributesNode = ContentTypeDefinitionController.getController().createNewEnumerationKey(localDocument, ASSET_KEYS);
            }
            if (attributesNode != null && localDocument != null && attributeNode != null) {
                Node node = localDocument.importNode(attributeNode, true);
                attributesNode.appendChild(node);
                StringBuffer sb = new StringBuffer();
                XMLHelper.serializeDom(localDocument.getDocumentElement(), sb);
                newSchemaValue = sb.toString();
            } else {
                logger.error((Object)("Problem:" + attributesNode + " - " + localDocument + " - " + attributeNode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newSchemaValue;
    }

    private Document createDocumentFromDefinition(String schemaValue) throws SAXException, IOException {
        InputSource xmlSource = new InputSource(new StringReader(schemaValue));
        DOMParser parser = new DOMParser();
        parser.parse(xmlSource);
        return parser.getDocument();
    }

    public BaseEntityVO getNewVO() {
        return new ContentTypeDefinitionVO();
    }
}

