/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.EventController;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.PublicationController;
import org.infoglue.cms.entities.content.ContentCategory;
import org.infoglue.cms.entities.content.ContentCategoryVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.AccessRightVO;
import org.infoglue.cms.entities.management.InterceptionPoint;
import org.infoglue.cms.entities.workflow.EventVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.DateHelper;

public class ContentStateController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ContentStateController.class.getName());
    public static final ContentCategoryController contentCategoryController = ContentCategoryController.getController();
    public static final int OVERIDE_WORKING = 1;
    public static final int LEAVE_WORKING = 2;

    public static ContentVersion changeState(Integer oldContentVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, Integer contentId, List resultingEvents) throws ConstraintException, SystemException {
        return ContentStateController.changeState(oldContentVersionId, stateId, versionComment, overrideVersionModifyer, null, infoGluePrincipal, contentId, resultingEvents);
    }

    public static ContentVersion changeState(Integer oldContentVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, String recipientFilter, InfoGluePrincipal infoGluePrincipal, Integer contentId, List resultingEvents) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ContentVersion newContentVersion = null;
        ContentStateController.beginTransaction(db);
        try {
            newContentVersion = ContentStateController.changeState(oldContentVersionId, stateId, versionComment, overrideVersionModifyer, recipientFilter, infoGluePrincipal, contentId, db, resultingEvents);
            ContentStateController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + ce.getMessage()));
            ContentStateController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentStateController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return newContentVersion;
    }

    public static ContentVersion changeState(Integer oldContentVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, InfoGluePrincipal infoGluePrincipal, Integer contentId, Database db, List resultingEvents) throws SystemException, ConstraintException {
        return ContentStateController.changeState(oldContentVersionId, stateId, versionComment, overrideVersionModifyer, null, infoGluePrincipal, contentId, db, resultingEvents);
    }

    public static ContentVersion changeState(Integer oldContentVersionId, Integer stateId, String versionComment, boolean overrideVersionModifyer, String recipientFilter, InfoGluePrincipal infoGluePrincipal, Integer contentId, Database db, List resultingEvents) throws SystemException, ConstraintException {
        ContentVersion newContentVersion = null;
        try {
            EventVO eventVO;
            ContentVersionVO newContentVersionVO;
            ContentVersion oldContentVersion = ContentVersionController.getContentVersionController().getContentVersionWithId(oldContentVersionId, db);
            if (contentId == null) {
                contentId = new Integer(oldContentVersion.getOwningContent().getContentId());
            }
            boolean duplicateAssets = CmsPropertyHandler.getDuplicateAssetsBetweenVersions();
            if (stateId.intValue() == ContentVersionVO.WORKING_STATE.intValue()) {
                logger.info((Object)"About to create a new working version");
                newContentVersionVO = new ContentVersionVO();
                newContentVersionVO.setStateId(stateId);
                if (versionComment != null && !versionComment.equals("")) {
                    newContentVersionVO.setVersionComment(versionComment);
                } else {
                    newContentVersionVO.setVersionComment("New working version");
                }
                newContentVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                if (overrideVersionModifyer) {
                    newContentVersionVO.setVersionModifier(infoGluePrincipal.getName());
                } else {
                    newContentVersionVO.setVersionModifier(oldContentVersion.getVersionModifier());
                }
                newContentVersionVO.setVersionValue(oldContentVersion.getVersionValue());
                newContentVersion = ContentVersionController.getContentVersionController().create(contentId, oldContentVersion.getLanguage().getLanguageId(), newContentVersionVO, oldContentVersion.getContentVersionId(), true, duplicateAssets, db);
                ContentStateController.copyAccessRights(oldContentVersion, newContentVersion, db);
                ContentStateController.copyContentCategories(oldContentVersion, newContentVersion, db);
            }
            if (stateId.intValue() == ContentVersionVO.PUBLISH_STATE.intValue()) {
                logger.info((Object)"About to copy the working copy to a publish-one");
                oldContentVersion.setVersionComment(versionComment);
                newContentVersionVO = new ContentVersionVO();
                newContentVersionVO.setStateId(stateId);
                newContentVersionVO.setVersionComment(versionComment);
                newContentVersionVO.setModifiedDateTime(DateHelper.getSecondPreciseDate());
                if (overrideVersionModifyer) {
                    newContentVersionVO.setVersionModifier(infoGluePrincipal.getName());
                } else {
                    newContentVersionVO.setVersionModifier(oldContentVersion.getVersionModifier());
                }
                newContentVersionVO.setVersionValue(oldContentVersion.getVersionValue());
                newContentVersion = ContentVersionController.getContentVersionController().create(contentId, oldContentVersion.getLanguage().getLanguageId(), newContentVersionVO, oldContentVersion.getContentVersionId(), false, duplicateAssets, db);
                ContentStateController.copyAccessRights(oldContentVersion, newContentVersion, db);
                ContentStateController.copyContentCategories(oldContentVersion, newContentVersion, db);
                if (newContentVersion.getOwningContent().getContentTypeDefinition() != null && !newContentVersion.getOwningContent().getContentTypeDefinition().getName().equalsIgnoreCase("Meta info")) {
                    eventVO = new EventVO();
                    eventVO.setDescription(newContentVersion.getVersionComment());
                    eventVO.setEntityClass(ContentVersion.class.getName());
                    eventVO.setEntityId(new Integer(newContentVersion.getId()));
                    eventVO.setName(newContentVersion.getOwningContent().getName());
                    eventVO.setTypeId(EventVO.PUBLISH);
                    eventVO = EventController.create(eventVO, newContentVersion.getOwningContent().getRepository().getId(), infoGluePrincipal, db);
                    resultingEvents.add(eventVO);
                }
                if (recipientFilter != null && !recipientFilter.equals("")) {
                    PublicationController.mailPublishNotification(resultingEvents, newContentVersion.getOwningContent().getRepository().getId(), infoGluePrincipal, recipientFilter, db);
                }
            }
            if (stateId.intValue() == ContentVersionVO.PUBLISHED_STATE.intValue()) {
                logger.info((Object)"About to publish an existing version");
                Integer oldContentVersionStateId = oldContentVersion.getStateId();
                oldContentVersion.setStateId(stateId);
                oldContentVersion.setIsActive(new Boolean(true));
                ContentStateController.insertIGMetaDataAttributes(oldContentVersion, infoGluePrincipal);
                newContentVersion = oldContentVersion;
                if (oldContentVersionStateId.intValue() == ContentVersionVO.WORKING_STATE.intValue() && oldContentVersion.getOwningContent().getContentTypeDefinition() != null && !newContentVersion.getOwningContent().getContentTypeDefinition().getName().equalsIgnoreCase("Meta info")) {
                    eventVO = new EventVO();
                    eventVO.setDescription(newContentVersion.getVersionComment());
                    eventVO.setEntityClass(ContentVersion.class.getName());
                    eventVO.setEntityId(new Integer(newContentVersion.getId()));
                    eventVO.setName(newContentVersion.getOwningContent().getName());
                    eventVO.setTypeId(EventVO.PUBLISH);
                    eventVO = EventController.create(eventVO, newContentVersion.getOwningContent().getRepository().getId(), infoGluePrincipal, db);
                    resultingEvents.add(eventVO);
                }
            }
        }
        catch (ConstraintException ce) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + ce.getMessage()));
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        return newContentVersion;
    }

    private static void copyAccessRights(ContentVersion originalContentVersion, ContentVersion newContentVersion, Database db) throws ConstraintException, SystemException, Exception {
        List interceptionPointList = InterceptionPointController.getController().getInterceptionPointList("ContentVersion", db);
        logger.info((Object)("interceptionPointList:" + interceptionPointList.size()));
        for (InterceptionPoint interceptionPoint : interceptionPointList) {
            List accessRightList = AccessRightController.getController().getAccessRightListForEntity(interceptionPoint.getId(), originalContentVersion.getId().toString(), db);
            logger.info((Object)("accessRightList:" + accessRightList.size()));
            for (AccessRight accessRight : accessRightList) {
                logger.info((Object)("accessRight:" + accessRight.getId()));
                AccessRightVO copiedAccessRight = accessRight.getValueObject().createCopy();
                copiedAccessRight.setParameters(newContentVersion.getId().toString());
                AccessRightController.getController().create(copiedAccessRight, interceptionPoint, db);
            }
        }
    }

    private static void copyContentCategories(ContentVersion originalContentVersion, ContentVersion newContentVersion, Database db) throws SystemException, PersistenceException {
        List orignals = contentCategoryController.findByContentVersion(originalContentVersion.getId(), db);
        for (ContentCategory contentCategory : orignals) {
            ContentCategoryVO vo = new ContentCategoryVO();
            vo.setAttributeName(contentCategory.getAttributeName());
            vo.setCategory(contentCategory.getCategory().getValueObject());
            vo.setContentVersionId(newContentVersion.getId());
            ContentCategory contentCategory2 = contentCategoryController.createWithDatabase(vo, db);
        }
    }

    private static void insertIGMetaDataAttributes(ContentVersion version, InfoGluePrincipal infoGluePrincipal) {
        String authorXML = "<IGAuthorFullName><![CDATA[" + infoGluePrincipal.getFirstName() + " " + infoGluePrincipal.getLastName() + "]]></IGAuthorFullName><IGAuthorEmail><![CDATA[" + infoGluePrincipal.getEmail() + "]]></IGAuthorEmail>";
        String oldVersionValue = version.getVersionValue();
        oldVersionValue = oldVersionValue.indexOf("<IGAuthorFullName>") > -1 ? oldVersionValue.replaceAll("<IGAuthorFullName>.*?</IGAuthorEmail>", authorXML) : oldVersionValue.replaceAll("</attributes>", String.valueOf(authorXML) + "</attributes>");
        version.setVersionValue(oldVersionValue);
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

