/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardInfoBean;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;

public class ContentControllerProxy
extends ContentController {
    private static final Logger logger = Logger.getLogger((String)ContentControllerProxy.class.getName());
    protected static final Integer NO = new Integer(0);
    protected static final Integer YES = new Integer(1);
    protected static final Integer INHERITED = new Integer(2);
    private static List interceptors = new ArrayList();

    public static ContentControllerProxy getController() {
        return new ContentControllerProxy();
    }

    public ContentVO getACContentVOWithId(InfoGluePrincipal infogluePrincipal, Integer contentId, Database db) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentId);
        this.intercept(hashMap, "Content.Read", infogluePrincipal);
        return this.getSmallContentVOWithId(contentId, db);
    }

    public ContentVO getACContentVOWithId(InfoGluePrincipal infogluePrincipal, Integer contentId) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentId);
        this.intercept(hashMap, "Content.Read", infogluePrincipal);
        return this.getContentVOWithId(contentId);
    }

    public List getACContentVOList(InfoGluePrincipal infoGluePrincipal, HashMap argumentHashMap, Database db) throws SystemException, Bug, Exception {
        List<ContentVO> contents;
        block7: {
            String method;
            block6: {
                contents = null;
                method = (String)argumentHashMap.get("method");
                logger.info((Object)("method:" + method));
                if (!method.equalsIgnoreCase("selectContentListOnIdList")) break block6;
                contents = new ArrayList();
                List arguments = (List)argumentHashMap.get("arguments");
                logger.info((Object)("Arguments:" + arguments.size()));
                for (HashMap argument : arguments) {
                    Integer contentId = new Integer((String)argument.get("contentId"));
                    logger.info((Object)("Getting the content with Id:" + contentId));
                    try {
                        contents.add(this.getACContentVOWithId(infoGluePrincipal, contentId, db));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block7;
            }
            if (!method.equalsIgnoreCase("selectListOnContentTypeName")) break block7;
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            contents = this.getContentVOListByContentTypeNames(arguments, db);
            Iterator contentIterator = contents.iterator();
            while (contentIterator.hasNext()) {
                ContentVO candidateContentVO = (ContentVO)contentIterator.next();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put("contentId", candidateContentVO.getContentId());
                try {
                    this.intercept(hashMap, "Content.Read", infoGluePrincipal, false, db);
                }
                catch (Exception e) {
                    logger.info((Object)"Was not authorized to look at task...");
                    contentIterator.remove();
                }
            }
        }
        return contents;
    }

    public List getACContentVOList(InfoGluePrincipal infoGluePrincipal, HashMap argumentHashMap) throws SystemException, Bug {
        List<ContentVO> contents;
        block7: {
            String method;
            block6: {
                contents = null;
                method = (String)argumentHashMap.get("method");
                logger.info((Object)("method:" + method));
                if (!method.equalsIgnoreCase("selectContentListOnIdList")) break block6;
                contents = new ArrayList();
                List arguments = (List)argumentHashMap.get("arguments");
                logger.info((Object)("Arguments:" + arguments.size()));
                for (HashMap argument : arguments) {
                    Integer contentId = new Integer((String)argument.get("contentId"));
                    try {
                        contents.add(this.getACContentVOWithId(infoGluePrincipal, contentId));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block7;
            }
            if (!method.equalsIgnoreCase("selectListOnContentTypeName")) break block7;
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            contents = this.getContentVOListByContentTypeNames(arguments);
            Iterator contentIterator = contents.iterator();
            while (contentIterator.hasNext()) {
                ContentVO candidateContentVO = (ContentVO)contentIterator.next();
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put("contentId", candidateContentVO.getContentId());
                try {
                    this.intercept(hashMap, "Content.Read", infoGluePrincipal, false);
                }
                catch (Exception e) {
                    logger.info((Object)"Was not authorized to look at task...");
                    contentIterator.remove();
                }
            }
        }
        return contents;
    }

    public ContentVO acCreate(InfoGluePrincipal infogluePrincipal, CreateContentWizardInfoBean createContentWizardInfoBean) throws ConstraintException, SystemException, Bug, Exception {
        return ContentController.getContentController().create(createContentWizardInfoBean);
    }

    public ContentVO acCreate(InfoGluePrincipal infogluePrincipal, Integer parentContentId, Integer contentTypeDefinitionId, Integer repositoryId, ContentVO contentVO) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", parentContentId);
        this.intercept(hashMap, "Content.Create", infogluePrincipal);
        return ContentController.getContentController().create(parentContentId, contentTypeDefinitionId, repositoryId, contentVO);
    }

    public ContentVO acUpdate(InfoGluePrincipal infogluePrincipal, ContentVO contentVO, Integer contentTypeDefinitionId) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentVO.getId());
        this.intercept(hashMap, "Content.Write", infogluePrincipal);
        return this.update(contentVO, contentTypeDefinitionId);
    }

    public void acDelete(InfoGluePrincipal infogluePrincipal, ContentVO contentVO) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentVO.getId());
        this.intercept(hashMap, "Content.Delete", infogluePrincipal);
        this.delete(contentVO, infogluePrincipal);
    }

    public void acMoveContent(InfoGluePrincipal infogluePrincipal, ContentVO contentVO, Integer newParentContentId) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentVO.getId());
        this.intercept(hashMap, "Content.Move", infogluePrincipal);
        hashMap = new HashMap();
        hashMap.put("contentId", newParentContentId);
        this.intercept(hashMap, "Content.Create", infogluePrincipal);
        this.moveContent(contentVO, newParentContentId);
    }

    public void acMoveContent(InfoGluePrincipal infogluePrincipal, ContentVO contentVO, Integer newParentContentId, Database db) throws ConstraintException, SystemException, Bug, Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("contentId", contentVO.getId());
        this.intercept(hashMap, "Content.Move", infogluePrincipal);
        hashMap = new HashMap();
        hashMap.put("contentId", newParentContentId);
        this.intercept(hashMap, "Content.Create", infogluePrincipal);
        this.moveContent(contentVO, newParentContentId, db);
    }

    public Integer getProtectedContentId(Integer contentId) {
        Integer protectedContentId = null;
        boolean isContentProtected = false;
        try {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
            if (contentVO.getIsProtected() != null) {
                ContentVO parentContentVO;
                if (contentVO.getIsProtected().intValue() == NO.intValue()) {
                    protectedContentId = null;
                } else if (contentVO.getIsProtected().intValue() == YES.intValue()) {
                    protectedContentId = contentVO.getId();
                } else if (contentVO.getIsProtected().intValue() == INHERITED.intValue() && (parentContentVO = ContentController.getParentContent(contentId)) != null) {
                    protectedContentId = this.getProtectedContentId(parentContentVO.getId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return protectedContentId;
    }

    public Integer getProtectedContentId(Integer contentId, Database db) {
        Integer protectedContentId = null;
        boolean isContentProtected = false;
        try {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId, db);
            if (contentVO.getIsProtected() != null) {
                ContentVO parentContentVO;
                if (contentVO.getIsProtected().intValue() == NO.intValue()) {
                    protectedContentId = null;
                } else if (contentVO.getIsProtected().intValue() == YES.intValue()) {
                    protectedContentId = contentVO.getId();
                } else if (contentVO.getIsProtected().intValue() == INHERITED.intValue() && (parentContentVO = ContentController.getParentContent(contentId, db)) != null) {
                    protectedContentId = this.getProtectedContentId(parentContentVO.getId(), db);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return protectedContentId;
    }

    public boolean getIsContentProtected(Integer contentId) {
        boolean isContentProtected = false;
        try {
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
            if (contentVO.getIsProtected() != null) {
                ContentVO parentContentVO;
                if (contentVO.getIsProtected().intValue() == NO.intValue()) {
                    isContentProtected = false;
                } else if (contentVO.getIsProtected().intValue() == YES.intValue()) {
                    isContentProtected = true;
                } else if (contentVO.getIsProtected().intValue() == INHERITED.intValue() && (parentContentVO = ContentController.getParentContent(contentId)) != null) {
                    isContentProtected = this.getIsContentProtected(parentContentVO.getId());
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get if the siteNodeVersion has disabled pageCache:" + e.getMessage()), (Throwable)e);
        }
        return isContentProtected;
    }
}

