/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.contenttool.wizards.actions.CreateContentWizardInfoBean;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.RegistryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryController;
import org.infoglue.cms.controllers.kernel.impl.simple.RepositoryLanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceBindingController;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.impl.simple.ContentImpl;
import org.infoglue.cms.entities.content.impl.simple.MediumContentImpl;
import org.infoglue.cms.entities.content.impl.simple.SmallContentImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeDefinition;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.management.Repository;
import org.infoglue.cms.entities.management.RepositoryLanguage;
import org.infoglue.cms.entities.management.RepositoryVO;
import org.infoglue.cms.entities.management.impl.simple.ContentTypeDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.RepositoryImpl;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.entities.structure.Qualifyer;
import org.infoglue.cms.entities.structure.ServiceBinding;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.services.BaseService;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.util.CacheController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ContentController.class.getName());

    public static ContentController getContentController() {
        return new ContentController();
    }

    public ContentVO getContentVOWithId(Integer contentId) throws SystemException, Bug {
        return (ContentVO)ContentController.getVOWithId(SmallContentImpl.class, contentId);
    }

    public ContentVO getContentVOWithId(Integer contentId, Database db) throws SystemException, Bug {
        return (ContentVO)ContentController.getVOWithId(SmallContentImpl.class, contentId, db);
    }

    public ContentVO getSmallContentVOWithId(Integer contentId, Database db) throws SystemException, Bug {
        return (ContentVO)ContentController.getVOWithId(SmallContentImpl.class, contentId, db);
    }

    public Content getContentWithId(Integer contentId, Database db) throws SystemException, Bug {
        return (Content)ContentController.getObjectWithId(ContentImpl.class, contentId, db);
    }

    public Content getReadOnlyContentWithId(Integer contentId, Database db) throws SystemException, Bug {
        return (Content)ContentController.getObjectWithIdAsReadOnly(ContentImpl.class, contentId, db);
    }

    public Content getReadOnlyMediumContentWithId(Integer contentId, Database db) throws SystemException, Bug {
        return (Content)ContentController.getObjectWithIdAsReadOnly(MediumContentImpl.class, contentId, db);
    }

    public List getContentVOList() throws SystemException, Bug {
        return this.getAllVOObjects(ContentImpl.class, "contentId");
    }

    public ContentVO create(CreateContentWizardInfoBean createContentWizardInfoBean) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Content content = null;
        ContentController.beginTransaction(db);
        try {
            content = this.create(db, createContentWizardInfoBean.getParentContentId(), createContentWizardInfoBean.getContentTypeDefinitionId(), createContentWizardInfoBean.getRepositoryId(), createContentWizardInfoBean.getContent().getValueObject());
            for (Integer languageId : createContentWizardInfoBean.getContentVersions().keySet()) {
                logger.info((Object)("languageId:" + languageId));
                ContentVersionVO contentVersionVO = (ContentVersionVO)createContentWizardInfoBean.getContentVersions().get(languageId);
                contentVersionVO = ContentVersionController.getContentVersionController().create(content.getContentId(), languageId, contentVersionVO, null, db).getValueObject();
            }
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return content.getValueObject();
    }

    public ContentVO create(Integer parentContentId, Integer contentTypeDefinitionId, Integer repositoryId, ContentVO contentVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Content content = null;
        ContentController.beginTransaction(db);
        try {
            content = this.create(db, parentContentId, contentTypeDefinitionId, repositoryId, contentVO);
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return content.getValueObject();
    }

    public Content create(Database db, Integer parentContentId, Integer contentTypeDefinitionId, Integer repositoryId, ContentVO contentVO) throws ConstraintException, SystemException, Exception {
        ContentImpl content = null;
        try {
            Content parentContent = null;
            ContentTypeDefinition contentTypeDefinition = null;
            if (parentContentId != null) {
                parentContent = this.getContentWithId(parentContentId, db);
                if (repositoryId == null) {
                    repositoryId = parentContent.getRepository().getRepositoryId();
                }
            }
            if (contentTypeDefinitionId != null) {
                contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
            }
            Repository repository = RepositoryController.getController().getRepositoryWithId(repositoryId, db);
            content = new ContentImpl();
            content.setValueObject(contentVO);
            content.setParentContent((ContentImpl)parentContent);
            content.setRepository((RepositoryImpl)repository);
            content.setContentTypeDefinition((ContentTypeDefinitionImpl)contentTypeDefinition);
            db.create((Object)content);
            if (parentContent != null) {
                parentContent.getChildren().add(content);
                parentContent.setIsBranch(new Boolean(true));
            }
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
        return content;
    }

    public void delete(ContentVO contentVO, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException {
        this.delete(contentVO, infogluePrincipal, false);
    }

    public void delete(ContentVO contentVO, InfoGluePrincipal infogluePrincipal, boolean forceDelete) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentController.beginTransaction(db);
        try {
            this.delete(contentVO, db, false, false, forceDelete, infogluePrincipal);
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(ContentVO contentVO, InfoGluePrincipal infogluePrincipal, Database db) throws ConstraintException, SystemException, Exception {
        this.delete(contentVO, db, false, false, false, infogluePrincipal);
    }

    public void delete(ContentVO contentVO, Database db, boolean skipRelationCheck, boolean skipServiceBindings, boolean forceDelete, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException, Exception {
        Content content = null;
        try {
            content = this.getContentWithId(contentVO.getContentId(), db);
        }
        catch (SystemException e) {
            return;
        }
        ContentImpl parent = content.getParentContent();
        if (parent != null) {
            Iterator childContentIterator = parent.getChildren().iterator();
            while (childContentIterator.hasNext()) {
                Content candidate = (Content)childContentIterator.next();
                if (!candidate.getId().equals(contentVO.getContentId())) continue;
                ContentController.deleteRecursive(content, childContentIterator, db, skipRelationCheck, skipServiceBindings, forceDelete, infogluePrincipal);
            }
        } else {
            ContentController.deleteRecursive(content, null, db, skipRelationCheck, skipServiceBindings, forceDelete, infogluePrincipal);
        }
    }

    private static void deleteRecursive(Content content, Iterator parentIterator, Database db, boolean skipRelationCheck, boolean skipServiceBindings, boolean forceDelete, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException, Exception {
        List referenceBeanList;
        if (!skipRelationCheck && (referenceBeanList = RegistryController.getController().getReferencingObjectsForContent(content.getId(), -1, db)) != null && referenceBeanList.size() > 0) {
            throw new ConstraintException("ContentVersion.stateId", "3305");
        }
        Collection children = content.getChildren();
        Iterator childrenIterator = children.iterator();
        while (childrenIterator.hasNext()) {
            Content childContent = (Content)childrenIterator.next();
            ContentController.deleteRecursive(childContent, childrenIterator, db, skipRelationCheck, skipServiceBindings, forceDelete, infogluePrincipal);
        }
        content.setChildren(new ArrayList());
        boolean isDeletable = ContentController.getIsDeletable(content, infogluePrincipal, db);
        if (forceDelete || isDeletable) {
            ContentVersionController.getContentVersionController().deleteVersionsForContent(content, db, forceDelete, infogluePrincipal);
            if (!skipServiceBindings) {
                ServiceBindingController.deleteServiceBindingsReferencingContent(content, db);
            }
            if (parentIterator != null) {
                parentIterator.remove();
            }
        } else {
            throw new ConstraintException("ContentVersion.stateId", "3300", content.getName());
        }
        db.remove((Object)content);
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("globalKey", "infoglue");
        PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
        ps.remove("content_" + content.getContentId() + "_allowedContentTypeNames");
        ps.remove("content_" + content.getContentId() + "_defaultContentTypeName");
        ps.remove("content_" + content.getContentId() + "_initialLanguageId");
    }

    private static boolean getIsDeletable(Content content, InfoGluePrincipal infogluePrincipal, Database db) throws SystemException {
        boolean hasAccess;
        boolean isDeletable = true;
        if (content.getIsProtected().equals(ContentVO.YES) && !(hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infogluePrincipal, "Content.Delete", "" + content.getId()))) {
            return false;
        }
        Collection contentVersions = content.getContentVersions();
        for (ContentVersion contentVersion : contentVersions) {
            if (contentVersion.getStateId().intValue() != ContentVersionVO.PUBLISHED_STATE.intValue() || !contentVersion.getIsActive().booleanValue()) continue;
            logger.info((Object)"The content had a published version so we cannot delete it..");
            isDeletable = false;
            break;
        }
        return isDeletable;
    }

    public ContentVO update(ContentVO contentVO) throws ConstraintException, SystemException {
        return this.update(contentVO, null);
    }

    public ContentVO update(ContentVO contentVO, Integer contentTypeDefinitionId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        Content content = null;
        ContentController.beginTransaction(db);
        try {
            content = (Content)ContentController.getObjectWithId(ContentImpl.class, contentVO.getId(), db);
            content.setVO(contentVO);
            if (contentTypeDefinitionId != null) {
                ContentTypeDefinition contentTypeDefinition = ContentTypeDefinitionController.getController().getContentTypeDefinitionWithId(contentTypeDefinitionId, db);
                content.setContentTypeDefinition((ContentTypeDefinitionImpl)contentTypeDefinition);
            }
            ContentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return content.getValueObject();
    }

    public List getAvailableLanguagesForContentWithId(Integer contentId, Database db) throws ConstraintException, SystemException, Exception {
        RepositoryImpl repository;
        ArrayList<LanguageVO> availableLanguageVOList = new ArrayList<LanguageVO>();
        Content content = this.getContentWithId(contentId, db);
        if (content != null && (repository = content.getRepository()) != null) {
            List availableRepositoryLanguageList = RepositoryLanguageController.getController().getRepositoryLanguageListWithRepositoryId(repository.getId(), db);
            for (RepositoryLanguage repositoryLanguage : availableRepositoryLanguageList) {
                availableLanguageVOList.add(repositoryLanguage.getLanguage().getValueObject());
            }
        }
        return availableLanguageVOList;
    }

    public static ContentVO getParentContent(Integer contentId) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ContentVO parentContentVO = null;
        ContentController.beginTransaction(db);
        try {
            Content content = (Content)ContentController.getObjectWithId(ContentImpl.class, contentId, db);
            ContentImpl parent = content.getParentContent();
            if (parent != null) {
                parentContentVO = parent.getValueObject();
            }
            ContentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return parentContentVO;
    }

    public static ContentVO getParentContent(Integer contentId, Database db) throws SystemException, Bug {
        ContentVO parentContentVO = null;
        Content content = (Content)ContentController.getObjectWithId(ContentImpl.class, contentId, db);
        logger.info((Object)("CONTENT:" + content.getName()));
        ContentImpl parent = content.getParentContent();
        if (parent != null) {
            parentContentVO = parent.getValueObject();
        }
        return parentContentVO;
    }

    public static void addChildContent(ContentVO parentVO, ContentVO childVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ContentController.beginTransaction(db);
        try {
            Content parent = (Content)ContentController.getObjectWithId(ContentImpl.class, parentVO.getContentId(), db);
            Content child = (Content)ContentController.getObjectWithId(ContentImpl.class, childVO.getContentId(), db);
            parent.getChildren().add(child);
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static void removeChildContent(ContentVO parentVO, ContentVO childVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ContentController.beginTransaction(db);
        try {
            Content parent = (Content)ContentController.getObjectWithId(ContentImpl.class, parentVO.getContentId(), db);
            Content child = (Content)ContentController.getObjectWithId(ContentImpl.class, childVO.getContentId(), db);
            parent.getChildren().remove(child);
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void moveContent(ContentVO contentVO, Integer newParentContentId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentController.beginTransaction(db);
        try {
            this.moveContent(contentVO, newParentContentId, db);
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + ce.getMessage()));
            ContentController.rollbackTransaction(db);
            throw new SystemException(ce.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void moveContent(ContentVO contentVO, Integer newParentContentId, Database db) throws ConstraintException, SystemException {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Content content = null;
        Content newParentContent = null;
        ContentImpl oldParentContent = null;
        contentVO.validate();
        if (newParentContentId == null) {
            logger.warn((Object)"You must specify the new parent-content......");
            throw new ConstraintException("Content.parentContentId", "3303");
        }
        if (contentVO.getId().intValue() == newParentContentId.intValue()) {
            logger.warn((Object)"You cannot have the content as it's own parent......");
            throw new ConstraintException("Content.parentContentId", "3301");
        }
        content = this.getContentWithId(contentVO.getContentId(), db);
        oldParentContent = content.getParentContent();
        newParentContent = this.getContentWithId(newParentContentId, db);
        if (oldParentContent.getId().intValue() == newParentContentId.intValue()) {
            logger.warn((Object)"You cannot specify the same folder as it originally was located in......");
            throw new ConstraintException("Content.parentContentId", "3304");
        }
        ContentImpl tempContent = newParentContent.getParentContent();
        while (tempContent != null) {
            if (tempContent.getId().intValue() == content.getId().intValue()) {
                logger.warn((Object)"You cannot move the content to a child under it......");
                throw new ConstraintException("Content.parentContentId", "3302");
            }
            tempContent = tempContent.getParentContent();
        }
        oldParentContent.getChildren().remove(content);
        content.setParentContent((ContentImpl)newParentContent);
        this.changeRepositoryRecursive(content, newParentContent.getRepository());
        newParentContent.getChildren().add(content);
        ceb.throwIfNotEmpty();
    }

    private void changeRepositoryRecursive(Content content, Repository newRepository) {
        if (content.getRepository().getId().intValue() != newRepository.getId().intValue()) {
            content.setRepository((RepositoryImpl)newRepository);
            for (Content childContent : content.getChildren()) {
                this.changeRepositoryRecursive(childContent, newRepository);
            }
        }
    }

    public List getContentVOWithContentTypeDefinition(String contentTypeDefinitionName) throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ContentController.beginTransaction(db);
        try {
            List result = this.getContentVOWithContentTypeDefinition(contentTypeDefinitionName, db);
            ContentController.commitTransaction(db);
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public List getContentVOWithContentTypeDefinition(String contentTypeDefinitionName, Database db) throws SystemException {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("method", "selectListOnContentTypeName");
        ArrayList argumentList = new ArrayList();
        String[] names = contentTypeDefinitionName.split(",");
        int i = 0;
        while (i < names.length) {
            HashMap<String, String> argument = new HashMap<String, String>();
            argument.put("contentTypeDefinitionName", names[i]);
            argumentList.add(argument);
            ++i;
        }
        arguments.put("arguments", argumentList);
        try {
            return this.getContentVOList(arguments, db);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public List getContentVOList(HashMap argumentHashMap) throws SystemException, Bug {
        List<ContentVO> contents = null;
        String method = (String)argumentHashMap.get("method");
        logger.info((Object)("method:" + method));
        if (method.equalsIgnoreCase("selectContentListOnIdList")) {
            contents = new ArrayList();
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            for (HashMap argument : arguments) {
                Integer contentId = new Integer((String)argument.get("contentId"));
                logger.info((Object)("Getting the content with Id:" + contentId));
                contents.add(this.getContentVOWithId(contentId));
            }
        } else if (method.equalsIgnoreCase("selectListOnContentTypeName")) {
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            contents = this.getContentVOListByContentTypeNames(arguments);
        }
        return contents;
    }

    public List getContentVOList(HashMap argumentHashMap, Database db) throws SystemException, Exception {
        List<ContentVO> contents = null;
        String method = (String)argumentHashMap.get("method");
        logger.info((Object)("method:" + method));
        if (method.equalsIgnoreCase("selectContentListOnIdList")) {
            contents = new ArrayList();
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            for (HashMap argument : arguments) {
                Integer contentId = new Integer((String)argument.get("contentId"));
                logger.info((Object)("Getting the content with Id:" + contentId));
                contents.add(this.getSmallContentVOWithId(contentId, db));
            }
        } else if (method.equalsIgnoreCase("selectListOnContentTypeName")) {
            List arguments = (List)argumentHashMap.get("arguments");
            logger.info((Object)("Arguments:" + arguments.size()));
            contents = this.getContentVOListByContentTypeNames(arguments, db);
        }
        return contents;
    }

    protected List getContentVOListByContentTypeNames(List arguments) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        ArrayList<ContentVO> contents = new ArrayList<ContentVO>();
        ContentController.beginTransaction(db);
        try {
            for (HashMap argument : arguments) {
                String contentTypeDefinitionName = (String)argument.get("contentTypeDefinitionName");
                OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.MediumContentImpl c WHERE c.contentTypeDefinition.name = $1 ORDER BY c.contentId");
                oql.bind((Object)contentTypeDefinitionName);
                QueryResults results = oql.execute((short)0);
                while (results.hasMore()) {
                    MediumContentImpl content = (MediumContentImpl)results.next();
                    contents.add(content.getValueObject());
                }
                results.close();
                oql.close();
            }
            ContentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contents;
    }

    protected List getContentVOListByContentTypeNames(List arguments, Database db) throws SystemException, Exception {
        ArrayList<ContentVO> contents = new ArrayList<ContentVO>();
        for (HashMap argument : arguments) {
            String contentTypeDefinitionName = (String)argument.get("contentTypeDefinitionName");
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.MediumContentImpl c WHERE c.contentTypeDefinition.name = $1 ORDER BY c.contentId");
            oql.bind((Object)contentTypeDefinitionName);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                MediumContentImpl content = (MediumContentImpl)results.next();
                contents.add(content.getValueObject());
            }
            results.close();
            oql.close();
        }
        return contents;
    }

    public ContentVO getRootContentVO(Integer repositoryId, String userName) throws ConstraintException, SystemException {
        if (repositoryId == null || repositoryId < 1) {
            return null;
        }
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Content content = null;
        ContentController.beginTransaction(db);
        try {
            logger.info((Object)("Fetching the root content for the repository " + repositoryId));
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.SmallContentImpl c WHERE is_undefined(c.parentContentId) AND c.repositoryId = $1");
            oql.bind((Object)repositoryId);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                content = (Content)results.next();
            } else {
                logger.info((Object)"Found no rootContent so we create a new....");
                ContentVO rootContentVO = new ContentVO();
                RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(repositoryId);
                rootContentVO.setCreatorName(userName);
                rootContentVO.setName(repositoryVO.getName());
                rootContentVO.setIsBranch(new Boolean(true));
                content = this.create(db, null, null, repositoryId, rootContentVO);
            }
            results.close();
            oql.close();
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return content == null ? null : content.getValueObject();
    }

    public ContentVO getRootContentVO(Integer repositoryId, String userName, boolean createIfNonExisting) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        Content content = null;
        ContentController.beginTransaction(db);
        try {
            content = this.getRootContent(db, repositoryId, userName, createIfNonExisting);
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return content == null ? null : content.getValueObject();
    }

    public Content getRootContent(Database db, Integer repositoryId, String userName, boolean createIfNonExisting) throws ConstraintException, SystemException, Exception {
        Content content = null;
        logger.info((Object)("Fetching the root content for the repository " + repositoryId));
        OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.ContentImpl c WHERE is_undefined(c.parentContent) AND c.repository.repositoryId = $1");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            content = (Content)results.next();
        } else if (createIfNonExisting) {
            logger.info((Object)"Found no rootContent so we create a new....");
            ContentVO rootContentVO = new ContentVO();
            RepositoryVO repositoryVO = RepositoryController.getController().getRepositoryVOWithId(repositoryId);
            rootContentVO.setCreatorName(userName);
            rootContentVO.setName(repositoryVO.getName());
            rootContentVO.setIsBranch(new Boolean(true));
            content = this.create(db, null, null, repositoryId, rootContentVO);
        }
        results.close();
        oql.close();
        return content;
    }

    public Content getRootContent(Integer repositoryId, Database db) throws ConstraintException, SystemException, Exception {
        Content content = null;
        OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.ContentImpl c WHERE is_undefined(c.parentContent) AND c.repository.repositoryId = $1");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute();
        logger.info((Object)("Fetching entity in read/write mode" + repositoryId));
        if (results.hasMore()) {
            content = (Content)results.next();
        }
        results.close();
        oql.close();
        return content;
    }

    public List getContentChildrenVOList(Integer parentContentId) throws ConstraintException, SystemException {
        String key = "" + parentContentId;
        logger.info((Object)("key:" + key));
        List cachedChildContentVOList = (List)CacheController.getCachedObject("childContentCache", key);
        if (cachedChildContentVOList != null) {
            logger.info((Object)("There was an cached childContentVOList:" + cachedChildContentVOList.size()));
            return cachedChildContentVOList;
        }
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List childrenVOList = null;
        ContentController.beginTransaction(db);
        try {
            Content content = this.getContentWithId(parentContentId, db);
            Collection children = content.getChildren();
            childrenVOList = ContentController.toVOList(children);
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        CacheController.cacheObject("childContentCache", key, childrenVOList);
        return childrenVOList;
    }

    public ContentTypeDefinitionVO getContentTypeDefinition(Integer contentId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ContentTypeDefinitionVO contentTypeDefinitionVO = null;
        ContentController.beginTransaction(db);
        try {
            Content content = this.getReadOnlyMediumContentWithId(contentId, db);
            if (content != null && content.getContentTypeDefinition() != null) {
                contentTypeDefinitionVO = content.getContentTypeDefinition().getValueObject();
            }
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentTypeDefinitionVO;
    }

    public List getRepositoryLanguages(Integer contentId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List languages = null;
        ContentController.beginTransaction(db);
        try {
            languages = this.getAvailableLanguagesForContentWithId(contentId, db);
            ceb.throwIfNotEmpty();
            ContentController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            ContentController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return languages;
    }

    public static List getBoundContents(Integer serviceBindingId) throws SystemException, Exception {
        List result = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ContentController.beginTransaction(db);
        try {
            result = ContentController.getBoundContents(db, serviceBindingId);
            ContentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return result;
    }

    public static List getBoundContents(Database db, Integer serviceBindingId) throws SystemException, Exception {
        ServiceDefinitionImpl serviceDefinition;
        ArrayList<ContentVO> result = new ArrayList<ContentVO>();
        ServiceBinding serviceBinding = ServiceBindingController.getServiceBindingWithId(serviceBindingId, db);
        if (serviceBinding != null && (serviceDefinition = serviceBinding.getServiceDefinition()) != null) {
            String serviceClassName = serviceDefinition.getClassName();
            BaseService service = (BaseService)Class.forName(serviceClassName).newInstance();
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put("method", "selectContentListOnIdList");
            ArrayList qualifyerList = new ArrayList();
            Collection qualifyers = serviceBinding.getBindingQualifyers();
            qualifyers = ContentController.sortQualifyers(qualifyers);
            for (Qualifyer qualifyer : qualifyers) {
                HashMap<String, String> argument = new HashMap<String, String>();
                argument.put(qualifyer.getName(), qualifyer.getValue());
                qualifyerList.add(argument);
            }
            arguments.put("arguments", qualifyerList);
            List contents = service.selectMatchingEntities(arguments);
            if (contents != null) {
                for (ContentVO candidate : contents) {
                    result.add(candidate);
                }
            }
        }
        return result;
    }

    public static List getInTransactionBoundContents(Database db, Integer serviceBindingId) throws SystemException, Exception {
        ServiceDefinitionImpl serviceDefinition;
        ArrayList<ContentVO> result = new ArrayList<ContentVO>();
        ServiceBindingController.getController();
        ServiceBinding serviceBinding = ServiceBindingController.getReadOnlyServiceBindingWithId(serviceBindingId, db);
        if (serviceBinding != null && (serviceDefinition = serviceBinding.getServiceDefinition()) != null) {
            String serviceClassName = serviceDefinition.getClassName();
            BaseService service = (BaseService)Class.forName(serviceClassName).newInstance();
            HashMap<String, Object> arguments = new HashMap<String, Object>();
            arguments.put("method", "selectContentListOnIdList");
            ArrayList qualifyerList = new ArrayList();
            Collection qualifyers = serviceBinding.getBindingQualifyers();
            qualifyers = ContentController.sortQualifyers(qualifyers);
            for (Qualifyer qualifyer : qualifyers) {
                HashMap<String, String> argument = new HashMap<String, String>();
                argument.put(qualifyer.getName(), qualifyer.getValue());
                qualifyerList.add(argument);
            }
            arguments.put("arguments", qualifyerList);
            List contents = service.selectMatchingEntities(arguments, db);
            if (contents != null) {
                for (ContentVO candidate : contents) {
                    result.add(candidate);
                }
            }
        }
        return result;
    }

    private static List sortQualifyers(Collection qualifyers) {
        ArrayList<Qualifyer> sortedQualifyers = new ArrayList<Qualifyer>();
        try {
            for (Qualifyer qualifyer : qualifyers) {
                int index = 0;
                for (Qualifyer sortedQualifyer : sortedQualifyers) {
                    if (sortedQualifyer.getSortOrder() > qualifyer.getSortOrder()) break;
                    ++index;
                }
                sortedQualifyers.add(index, qualifyer);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("The sorting of qualifyers failed:" + e.getMessage()), (Throwable)e);
        }
        return sortedQualifyers;
    }

    public List getRepositoryContents(Integer repositoryId, Database db) throws SystemException, Exception {
        ArrayList<MediumContentImpl> contents = new ArrayList<MediumContentImpl>();
        OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.MediumContentImpl c WHERE c.repositoryId = $1 ORDER BY c.contentId");
        oql.bind((Object)repositoryId);
        QueryResults results = oql.execute((short)0);
        while (results.hasMore()) {
            MediumContentImpl content = (MediumContentImpl)results.next();
            contents.add(content);
        }
        results.close();
        oql.close();
        return contents;
    }

    public ContentVO getContentVOWithPath(Integer repositoryId, String path, boolean forceFolders, InfoGluePrincipal creator) throws SystemException, Exception {
        ContentVO contentVO = null;
        Database db = CastorDatabaseService.getDatabase();
        ContentController.beginTransaction(db);
        try {
            contentVO = this.getContentVOWithPath(repositoryId, path, forceFolders, creator, db);
            ContentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVO;
    }

    public ContentVO getContentVOWithPath(Integer repositoryId, String path, boolean forceFolders, InfoGluePrincipal creator, Database db) throws SystemException, Exception {
        ContentVO content = this.getRootContent(repositoryId, db).getValueObject();
        String[] paths = path.split("/");
        if (path.equals("")) {
            return content;
        }
        int i = 0;
        while (i < paths.length) {
            String name = paths[i];
            ContentVO childContent = this.getChildVOWithName(content.getContentId(), name, db);
            if (childContent != null) {
                content = childContent;
            } else {
                if (childContent == null && !forceFolders) {
                    throw new SystemException("There exists no content with the path [" + path + "].");
                }
                logger.info((Object)("   CREATE " + name));
                ContentVO contentVO = new ContentVO();
                contentVO.setIsBranch(Boolean.TRUE);
                contentVO.setCreatorName(creator.getName());
                contentVO.setName(name);
                Content newContent = this.create(db, content.getId(), null, repositoryId, contentVO);
                if (newContent != null) {
                    content = newContent.getValueObject();
                }
            }
            ++i;
        }
        return content;
    }

    private ContentVO getChildVOWithName(Integer parentContentId, String name, Database db) throws Exception {
        ContentVO contentVO = null;
        OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.MediumContentImpl c WHERE c.parentContentId = $1 AND c.name = $2");
        oql.bind((Object)parentContentId);
        oql.bind((Object)name);
        QueryResults results = oql.execute((short)0);
        if (results.hasMore()) {
            MediumContentImpl content = (MediumContentImpl)results.next();
            contentVO = content.getValueObject();
        }
        results.close();
        oql.close();
        return contentVO;
    }

    public List getContentVOWithParentRecursive(Integer contentId) throws ConstraintException, SystemException {
        return this.getContentVOWithParentRecursive(contentId, new ArrayList());
    }

    private List getContentVOWithParentRecursive(Integer contentId, List resultList) throws ConstraintException, SystemException {
        resultList.add(this.getContentVOWithId(contentId));
        List childContentList = ContentController.getContentController().getContentChildrenVOList(contentId);
        for (ContentVO contentVO : childContentList) {
            this.getContentVOWithParentRecursive(contentVO.getId(), resultList);
        }
        return resultList;
    }

    public String getContentAttribute(Integer contentId, Integer languageId, String attributeName) throws Exception {
        String attribute = "Undefined";
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageId);
        attribute = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO, attributeName, false);
        return attribute;
    }

    public String getContentAttribute(Database db, Integer contentId, Integer languageId, String attributeName) throws Exception {
        String attribute = "Undefined";
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId, db);
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageId, db);
        if (contentVersionVO != null) {
            attribute = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO, attributeName, false);
        }
        return attribute;
    }

    public String getContentAttribute(Database db, Integer contentId, Integer languageId, String attributeName, boolean useLanguageFallBack) throws Exception {
        String attribute = "Undefined";
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId, db);
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageId, db);
        if (contentVersionVO == null && useLanguageFallBack) {
            LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId(), db);
            contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), masterLanguageVO.getId(), db);
        }
        if (contentVersionVO != null) {
            attribute = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO, attributeName, false);
        }
        return attribute;
    }

    @Override
    public BaseEntityVO getNewVO() {
        return new ContentVO();
    }

    public String getContentPath(Integer contentId) throws ConstraintException, SystemException, Bug, Exception {
        return this.getContentPath(contentId, false, false);
    }

    public String getContentPath(Integer contentId, boolean includeRootContent, boolean includeRepositoryName) throws ConstraintException, SystemException, Bug, Exception {
        RepositoryVO repositoryVO;
        StringBuffer sb = new StringBuffer();
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
        sb.insert(0, contentVO.getName());
        while (contentVO.getParentContentId() != null) {
            contentVO = ContentController.getContentController().getContentVOWithId(contentVO.getParentContentId());
            if (!includeRootContent && contentVO.getParentContentId() == null) continue;
            sb.insert(0, String.valueOf(contentVO.getName()) + "/");
        }
        if (includeRepositoryName && (repositoryVO = RepositoryController.getController().getRepositoryVOWithId(contentVO.getRepositoryId())) != null) {
            sb.insert(0, String.valueOf(repositoryVO.getName()) + " - /");
        }
        return sb.toString();
    }

    public List<ContentVO> getUpcomingExpiringContents(int numberOfWeeks) throws Exception {
        ArrayList<ContentVO> contentVOList = new ArrayList<ContentVO>();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ContentController.beginTransaction(db);
        try {
            OQLQuery oql = db.getOQLQuery("SELECT c FROM org.infoglue.cms.entities.content.impl.simple.ContentImpl c WHERE c.expireDateTime > $1 AND c.expireDateTime < $2 AND c.publishDateTime < $3");
            Calendar now = Calendar.getInstance();
            Date currentDate = now.getTime();
            oql.bind((Object)currentDate);
            now.add(6, numberOfWeeks);
            Date futureDate = now.getTime();
            oql.bind((Object)futureDate);
            oql.bind((Object)currentDate);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                ContentImpl content = (ContentImpl)results.next();
                contentVOList.add(content.getValueObject());
            }
            results.close();
            oql.close();
            ContentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ContentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentVOList;
    }
}

