/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.DigitalAssetController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.DigitalAssetVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.security.InfoGluePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentCleanerController
extends BaseController {
    private static final Logger logger = Logger.getLogger(ContentCleanerController.class);
    private static final LanguageController languageController = LanguageController.getController();
    private static final ContentController contentController = ContentController.getContentController();
    private static final ContentVersionController contentVersionController = ContentVersionController.getContentVersionController();
    private static final DigitalAssetController digitalAssetController = DigitalAssetController.getController();
    public static final int FACTOR_KB = 1024;
    public static final int FACTOR_MB = 0x100000;
    public static final int FACTOR_GB = 0x40000000;
    private float recoveredDiskSpaceCnt = 0.0f;
    private Long elapsedTime = 0L;
    private Integer deletedContentVersionsCnt = 0;
    private Integer deletedDigitalAssetsCnt = 0;

    public static ContentCleanerController getContentCleanerController() {
        return new ContentCleanerController();
    }

    private ContentCleanerController() {
    }

    public void cleanSweep(int hitSize2Retain, InfoGluePrincipal principal) throws Exception {
        try {
            Database db = CastorDatabaseService.getDatabase();
            ContentCleanerController.beginTransaction(db);
            List languageVOList = languageController.getLanguageVOList(db);
            List contentVOList = contentController.getContentVOList();
            ContentCleanerController.commitTransaction(db);
            for (ContentVO contentVO : contentVOList) {
                this.clean(contentVO, hitSize2Retain, (List<LanguageVO>)languageVOList, principal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clean(Integer contentId, int hitSize2Retain, InfoGluePrincipal principal) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        ContentCleanerController.beginTransaction(db);
        ContentVO contentVO = contentController.getContentVOWithId(contentId);
        List languageVOList = languageController.getLanguageVOList(db);
        ContentCleanerController.commitTransaction(db);
        this.clean(contentVO, hitSize2Retain, (List<LanguageVO>)languageVOList, principal);
    }

    public void clean(Integer contentId, int hitSize2Retain, List<LanguageVO> languageVOList, InfoGluePrincipal principal) throws Exception {
        Database db = CastorDatabaseService.getDatabase();
        ContentCleanerController.beginTransaction(db);
        ContentVO contentVO = contentController.getContentVOWithId(contentId);
        ContentCleanerController.commitTransaction(db);
        this.clean(contentVO, hitSize2Retain, languageVOList, principal);
    }

    public void clean(ContentVO contentVO, int hitSize2Retain, List<LanguageVO> languageVOList, InfoGluePrincipal principal) throws Exception {
        if (contentVO.getIsBranch().booleanValue()) {
            List childs = contentController.getContentChildrenVOList(contentVO.getContentId());
            for (ContentVO child : childs) {
                this.clean(child, hitSize2Retain, languageVOList, principal);
            }
        }
        for (LanguageVO languageVO : languageVOList) {
            this.clean(contentVO, hitSize2Retain, languageVO, principal);
        }
    }

    private void clean(ContentVO contentVO, int hitSize2Retain, LanguageVO languageVO, InfoGluePrincipal principal) throws Exception {
        List<ContentVersionVO> contentVersionsList2Retain = this.collectContentVersionsList2Retain(contentVO, languageVO, hitSize2Retain);
        if (contentVersionsList2Retain.size() >= hitSize2Retain) {
            this.cleanContent(contentVO, languageVO, contentVersionsList2Retain, principal);
        }
    }

    private void cleanContent(ContentVO contentVO, LanguageVO languageVO, List<ContentVersionVO> contentVersionsList2Retain, InfoGluePrincipal principal) throws Exception {
        long startTime = System.currentTimeMillis();
        Database db = CastorDatabaseService.getDatabase();
        ContentCleanerController.beginTransaction(db);
        List<ContentVersionVO> contentVerisionList = contentVersionController.getContentVersionsWithParentAndLanguage(contentVO.getContentId(), languageVO.getLanguageId(), db);
        ContentCleanerController.commitTransaction(db);
        logger.info((Object)(String.valueOf(contentVerisionList.size()) + "  content versions found for contentId " + contentVO.getContentId()));
        logger.info((Object)"I will hunt them down and clean them all.");
        for (ContentVersionVO contentVersion : contentVerisionList) {
            if (this.isRetainedContentVersion(contentVersion, contentVersionsList2Retain)) continue;
            Integer contentVersionId = contentVersion.getContentVersionId();
            logger.info((Object)("Listing digital assets for content version:" + contentVersionId));
            List items = DigitalAssetController.getDigitalAssetVOList(contentVersionId);
            logger.info((Object)(String.valueOf(items.size()) + " digital assets for content version " + contentVersionId + " found."));
            for (DigitalAssetVO digitalAsset : items) {
                Integer digitalAssetId = digitalAsset.getDigitalAssetId();
                this.recoveredDiskSpaceCnt += (float)digitalAsset.getAssetFileSize().intValue();
                logger.info((Object)("\tDead Digital Asset: " + digitalAsset.getAssetFileName()));
                contentVersionController.deleteDigitalAssetRelation(contentVersionId, digitalAssetId, principal);
                DigitalAssetController.delete(digitalAssetId);
                this.deletedDigitalAssetsCnt = this.deletedDigitalAssetsCnt + 1;
            }
            contentVersionController.forceDelete(contentVersion);
            this.deletedContentVersionsCnt = this.deletedContentVersionsCnt + 1;
            logger.info((Object)("ContentVersion: " + contentVersion.getContentVersionId() + " Is Dead Meat."));
        }
        this.elapsedTime = this.elapsedTime + (System.currentTimeMillis() - startTime);
    }

    private boolean isRetainedContentVersion(ContentVersionVO contentVersion, List<ContentVersionVO> contentVerisionList2Retain) {
        for (ContentVersionVO retainedContentVersion : contentVerisionList2Retain) {
            if (contentVersion.getContentVersionId().intValue() != retainedContentVersion.getContentVersionId().intValue()) continue;
            return true;
        }
        return false;
    }

    private List<ContentVersionVO> collectContentVersionsList2Retain(ContentVO contentVO, LanguageVO languageVO, int hitSize) throws Exception {
        ContentVersion latestPublished;
        Integer contentId = contentVO.getContentId();
        Integer languageId = languageVO.getLanguageId();
        Database db = CastorDatabaseService.getDatabase();
        ContentCleanerController.beginTransaction(db);
        List<ContentVersionVO> contentVersionsList2Retain = contentVersionController.getLatestActiveContentVersionsForHitSize(contentId, languageId, hitSize, db);
        if (!this.hasState(contentVersionsList2Retain, ContentVersionVO.PUBLISHED_STATE) && (latestPublished = contentVersionController.getLatestPublishedContentVersion(contentId, languageId, db)) != null) {
            contentVersionsList2Retain.add(latestPublished.getValueObject());
        }
        ContentCleanerController.commitTransaction(db);
        return contentVersionsList2Retain;
    }

    private boolean hasState(List<ContentVersionVO> contentVerisionsList2Retain, Integer state) {
        for (ContentVersionVO contentVersion : contentVerisionsList2Retain) {
            if (contentVersion.getStateId().intValue() != state.intValue()) continue;
            return true;
        }
        return false;
    }

    public float getCDSFactor(int factor) {
        return this.recoveredDiskSpaceCnt / (float)factor;
    }

    public Integer getDeletedDigitalAsstesCounter() {
        return this.deletedDigitalAssetsCnt;
    }

    public Integer getDeletedContentVersionsCounter() {
        return this.deletedContentVersionsCnt;
    }

    public Long getElapsedTime() {
        return this.elapsedTime;
    }

    @Override
    public BaseEntityVO getNewVO() {
        return null;
    }
}

