/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentCategory;
import org.infoglue.cms.entities.content.ContentCategoryVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl;
import org.infoglue.cms.entities.content.impl.simple.ContentVersionImpl;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public class ContentCategoryController
extends BaseController {
    private static final ContentCategoryController instance = new ContentCategoryController();
    private static final String findByContentVersion = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl c ").append("WHERE c.contentVersion.contentVersionId = $1").toString();
    private static final String findByContentVersionAttribute = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl c ").append("WHERE c.attributeName = $1 ").append("AND c.contentVersion.contentVersionId = $2").append("ORDER BY c.category.name").toString();
    private static final String findByCategory = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.content.impl.simple.ContentCategoryImpl c ").append("WHERE c.category.categoryId = $1 ").toString();

    public static ContentCategoryController getController() {
        return instance;
    }

    private ContentCategoryController() {
    }

    public ContentCategoryVO findById(Integer id) throws SystemException {
        return (ContentCategoryVO)ContentCategoryController.getVOWithId(ContentCategoryImpl.class, id);
    }

    public List findByContentVersionAttribute(String attribute, Integer versionId) throws SystemException {
        List contentCategoryVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ContentCategoryController.beginTransaction(db);
        try {
            List contentCategories = this.findByContentVersionAttribute(attribute, versionId, db, true);
            if (contentCategories != null) {
                contentCategoryVOList = ContentCategoryController.toVOList(contentCategories);
            }
            ContentCategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            ContentCategoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentCategoryVOList;
    }

    public List findByContentVersionAttribute(String attribute, Integer versionId, Database db, boolean readOnly) throws SystemException {
        ArrayList<ContentCategory> contentCategoryList = new ArrayList<ContentCategory>();
        ContentVersion contentVersion = null;
        contentVersion = readOnly ? ContentVersionController.getContentVersionController().getReadOnlyContentVersionWithId(versionId, db) : ContentVersionController.getContentVersionController().getContentVersionWithId(versionId, db);
        Collection contentCategories = contentVersion.getContentCategories();
        if (contentCategories != null) {
            for (ContentCategory contentCategory : contentCategories) {
                if (!contentCategory.getAttributeName().equals(attribute)) continue;
                contentCategoryList.add(contentCategory);
            }
        }
        return contentCategoryList;
    }

    public List findByContentVersionAttribute(String attribute, ContentVersion contentVersion, Database db, boolean readOnly) throws SystemException {
        Collection contentCategories;
        ArrayList<ContentCategory> contentCategoryList = new ArrayList<ContentCategory>();
        if (contentVersion != null && (contentCategories = contentVersion.getContentCategories()) != null) {
            for (ContentCategory contentCategory : contentCategories) {
                if (!contentCategory.getAttributeName().equals(attribute)) continue;
                contentCategoryList.add(contentCategory);
            }
        }
        return contentCategoryList;
    }

    public List findByContentVersion(Integer versionId) throws SystemException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(versionId);
        return ContentCategoryController.executeQuery(findByContentVersion, params);
    }

    public List findByContentVersion(Integer versionId, Database db) throws SystemException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(versionId);
        return ContentCategoryController.executeQuery(findByContentVersion, params, db);
    }

    public List findByCategory(Integer categoryId) throws SystemException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(categoryId);
        return ContentCategoryController.executeQuery(findByCategory, params);
    }

    public ContentCategoryVO save(ContentCategoryVO c, InfoGluePrincipal principal) throws SystemException {
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().checkStateAndChangeIfNeeded(c.getContentVersionId(), principal);
        c.setContentVersionId(contentVersionVO.getId());
        return c.isUnsaved() ? this.create(c) : (ContentCategoryVO)ContentCategoryController.updateEntity(ContentCategoryImpl.class, c);
    }

    private ContentCategoryVO create(ContentCategoryVO c) throws SystemException {
        Database db = ContentCategoryController.beginTransaction();
        try {
            ContentCategory contentCategory = this.createWithDatabase(c, db);
            ContentCategoryController.commitTransaction(db);
            return contentCategory.getValueObject();
        }
        catch (Exception e) {
            ContentCategoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public ContentCategory createWithDatabase(ContentCategoryVO c, Database db) throws SystemException, PersistenceException {
        Category category = (Category)ContentCategoryController.getObjectWithId(CategoryImpl.class, c.getCategory().getId(), db);
        ContentVersion contentVersion = (ContentVersion)ContentCategoryController.getObjectWithId(ContentVersionImpl.class, c.getContentVersionId(), db);
        ContentCategoryImpl contentCategory = new ContentCategoryImpl();
        contentCategory.setValueObject(c);
        contentCategory.setCategory((CategoryImpl)category);
        contentCategory.setContentVersion((ContentVersionImpl)contentVersion);
        db.create((Object)contentCategory);
        contentVersion.getContentCategories().add(contentCategory);
        return contentCategory;
    }

    public List create(List categoryVOList, ContentVersionVO contentVersionVO, String attributeName) throws SystemException {
        ArrayList<ContentCategoryVO> contentCategoryVOList = new ArrayList<ContentCategoryVO>();
        Database db = ContentCategoryController.beginTransaction();
        try {
            for (CategoryVO categoryVO : categoryVOList) {
                Category category = (Category)ContentCategoryController.getObjectWithId(CategoryImpl.class, categoryVO.getId(), db);
                ContentVersion contentVersion = (ContentVersion)ContentCategoryController.getObjectWithId(ContentVersionImpl.class, contentVersionVO.getId(), db);
                ContentCategoryVO contentCategoryVO = new ContentCategoryVO();
                contentCategoryVO.setAttributeName(attributeName);
                contentCategoryVO.setContentVersionId(contentVersionVO.getId());
                ContentCategory contentCategory = this.createWithDatabase(contentCategoryVO, category, contentVersion, db);
                contentCategoryVOList.add(contentCategory.getValueObject());
            }
            ContentCategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            ContentCategoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return contentCategoryVOList;
    }

    public List create(List categoryList, ContentVersion contentVersion, String attributeName, Database db) throws SystemException, Exception {
        ArrayList<ContentCategory> contentCategoryList = new ArrayList<ContentCategory>();
        for (Category category : categoryList) {
            ContentCategoryVO contentCategoryVO = new ContentCategoryVO();
            contentCategoryVO.setAttributeName(attributeName);
            contentCategoryVO.setContentVersionId(contentVersion.getId());
            ContentCategory contentCategory = this.createWithDatabase(contentCategoryVO, category, contentVersion, db);
            contentVersion.getContentCategories().add(contentCategory);
            contentCategoryList.add(contentCategory);
        }
        return contentCategoryList;
    }

    public ContentCategory createWithDatabase(ContentCategoryVO c, Category category, ContentVersion contentVersion, Database db) throws SystemException, PersistenceException {
        ContentCategoryImpl contentCategory = new ContentCategoryImpl();
        contentCategory.setValueObject(c);
        contentCategory.setCategory((CategoryImpl)category);
        contentCategory.setContentVersion((ContentVersionImpl)contentVersion);
        db.create((Object)contentCategory);
        return contentCategory;
    }

    public void delete(Integer id, InfoGluePrincipal principal) throws SystemException {
        Database db = ContentCategoryController.beginTransaction();
        try {
            ContentCategory contentCategory = (ContentCategory)ContentCategoryController.getObjectWithId(ContentCategoryImpl.class, id, db);
            ContentVersion contentVersion = ContentVersionController.getContentVersionController().checkStateAndChangeIfNeeded(contentCategory.getContentVersionId(), principal, db);
            Iterator contentCategoriesIterator = contentVersion.getContentCategories().iterator();
            while (contentCategoriesIterator.hasNext()) {
                ContentCategory currentContentCategory = (ContentCategory)contentCategoriesIterator.next();
                ContentCategoryVO currentContentCategoryVO = currentContentCategory.getValueObject();
                if (!currentContentCategoryVO.getAttributeName().equals(contentCategory.getAttributeName()) || !currentContentCategory.getCategory().getId().equals(contentCategory.getCategory().getId())) continue;
                contentCategoriesIterator.remove();
                db.remove((Object)currentContentCategory);
                break;
            }
            ContentCategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            ContentCategoryController.rollbackTransaction(db);
            e.printStackTrace();
            throw new SystemException(e.getMessage());
        }
    }

    public void deleteByContentVersion(Integer versionId) throws SystemException {
        ContentCategoryController.delete(this.findByContentVersion(versionId));
    }

    public void deleteByContentVersion(ContentVersion contentVersion, Database db) throws SystemException, Exception {
        Iterator contentVersionIterator = contentVersion.getContentCategories().iterator();
        while (contentVersionIterator.hasNext()) {
            ContentCategory contentCategory = (ContentCategory)contentVersionIterator.next();
            contentVersionIterator.remove();
            db.remove((Object)contentCategory);
        }
    }

    public void deleteByContentVersion(Integer versionId, Database db) throws SystemException {
        ContentCategoryController.delete(this.findByContentVersion(versionId), db);
    }

    public void deleteByCategory(Integer categoryId) throws SystemException {
        ContentCategoryController.delete(this.findByCategory(categoryId));
    }

    public void deleteByCategory(Integer categoryId, Database db) throws SystemException {
        ContentCategoryController.delete(this.findByCategory(categoryId), db);
    }

    public void deleteByContentVersionAttribute(String attribute, Integer versionId) throws SystemException {
        ContentCategoryController.delete(this.findByContentVersionAttribute(attribute, versionId));
    }

    public void deleteByContentVersionAttribute(String attribute, Integer versionId, Database db) throws SystemException {
        ContentCategoryController.delete(this.findByContentVersionAttribute(attribute, versionId), db);
    }

    private static void delete(Collection contentCategories) throws SystemException {
        Database db = ContentCategoryController.beginTransaction();
        try {
            ContentCategoryController.delete(contentCategories, db);
            ContentCategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            ContentCategoryController.rollbackTransaction(db);
            throw new SystemException(e);
        }
    }

    private static void delete(Collection contentCategories, Database db) throws SystemException {
        Iterator i = contentCategories.iterator();
        while (i.hasNext()) {
            ContentCategoryController.deleteEntity(ContentCategoryImpl.class, ((ContentCategoryVO)i.next()).getId(), db);
        }
    }

    public BaseEntityVO getNewVO() {
        return new ContentCategoryVO();
    }
}

