/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryConditions;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.exception.SystemException;

class ConditionsParser {
    private static final String AND_START = "{";
    private static final String AND_END = "}";
    private static final String OR_START = "[";
    private static final String OR_END = "]";
    private static final String CONDITION_DELIMITER = ",";
    private static final String CATEGORY_DELIMITER = "=";

    ConditionsParser() {
    }

    public CategoryConditions parse(String s) {
        String parseString = s == null ? "" : s;
        StringTokenizer st = new StringTokenizer(AND_START + parseString + AND_END, "{}[],", true);
        List tokens = this.tokensToList(st);
        CategoryConditions conditions = this.createContainer(tokens);
        this.parse(conditions, tokens);
        return conditions;
    }

    private void parse(CategoryConditions conditions, List tokens) {
        if (tokens.isEmpty() || this.isContainerEndToken(tokens)) {
            return;
        }
        if (this.isContainerStartToken(tokens)) {
            this.parseContainer(conditions, tokens);
        } else if (this.isConditionDelimiterToken(tokens)) {
            this.parseConditionDelimiter(conditions, tokens);
        } else {
            this.parseCategory(conditions, tokens);
        }
        this.parse(conditions, tokens);
    }

    private void parseContainer(CategoryConditions conditions, List tokens) {
        CategoryConditions newConditions = this.createContainer(tokens);
        String startToken = (String)tokens.remove(0);
        this.parse(newConditions, tokens);
        this.matchContainerTokens(startToken, tokens);
        conditions.add(newConditions);
    }

    private void parseConditionDelimiter(CategoryConditions conditions, List tokens) {
        if (!conditions.hasCondition()) {
            throw new IllegalArgumentException("ConditionsParser.parseConditionDelimiter() - empty condition.");
        }
        tokens.remove(0);
    }

    private void parseCategory(CategoryConditions conditions, List tokens) {
        String token = (String)tokens.remove(0);
        List terms = this.tokensToList(new StringTokenizer(token, CATEGORY_DELIMITER, true));
        if (terms.size() != 3) {
            throw new IllegalArgumentException("ConditionsParser.parseCategory() - illegal category syntax.");
        }
        String attributeName = (String)terms.get(0);
        String path = (String)terms.get(2);
        try {
            CategoryVO categoryVO = CategoryController.getController().findByPath(path);
            if (categoryVO == null) {
                throw new IllegalArgumentException("ConditionsParser.parseCategory() - no such category [" + path + "].");
            }
            conditions.addCategory(attributeName, categoryVO);
        }
        catch (SystemException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("ConditionsParser.parseCategory() - unknown category path [" + path + "].");
        }
    }

    private CategoryConditions createContainer(List tokens) {
        if (tokens.size() < 2) {
            throw new IllegalArgumentException("ConditionsParser.createContainer() - no trailing container delimiter.");
        }
        String startToken = (String)tokens.get(0);
        String endToken = (String)tokens.get(tokens.size() - 1);
        if (AND_START.equals(startToken)) {
            return CategoryConditions.createAndConditions();
        }
        if (OR_START.equals(startToken)) {
            return CategoryConditions.createOrConditions();
        }
        throw new IllegalArgumentException("ConditionsParser.createContainer() - illegal state.");
    }

    private boolean isContainerStartToken(List tokens) {
        if (tokens.isEmpty()) {
            return false;
        }
        String token = (String)tokens.get(0);
        return AND_START.equals(token) || OR_START.equals(token);
    }

    private boolean isContainerEndToken(List tokens) {
        if (tokens.isEmpty()) {
            return false;
        }
        String token = (String)tokens.get(0);
        return AND_END.equals(token) || OR_END.equals(token);
    }

    private boolean isConditionDelimiterToken(List tokens) {
        if (tokens.isEmpty()) {
            return false;
        }
        String token = (String)tokens.get(0);
        return CONDITION_DELIMITER.equals(token);
    }

    private void matchContainerTokens(String startToken, List tokens) {
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("ConditionsParser.matchContainerTokens() - no closing container token.");
        }
        String endToken = (String)tokens.remove(0);
        if (startToken.equals(AND_START) && !endToken.equals(AND_END)) {
            throw new IllegalArgumentException("ConditionsParser.matchContainerTokens() - no matching closing container token.");
        }
        if (startToken.equals(OR_START) && !endToken.equals(OR_END)) {
            throw new IllegalArgumentException("ConditionsParser.matchContainerTokens() - no matching closing container token.");
        }
    }

    private List tokensToList(StringTokenizer st) {
        ArrayList<Object> result = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            result.add(st.nextElement());
        }
        return result;
    }
}

