/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.parsers.DOMParser;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.databeans.ComponentPropertyDefinition;
import org.infoglue.cms.applications.databeans.ComponentPropertyOptionDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ComponentPropertyDefinitionController
extends BaseController {
    public static ComponentPropertyDefinitionController getController() {
        return new ComponentPropertyDefinitionController();
    }

    public List getComponentPropertyDefinitions(Database db, Integer contentId, Integer languageId) throws Exception {
        ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId, db);
        ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, languageId, db);
        if (contentVersionVO == null) {
            LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId(), db);
            contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentId, masterLanguageVO.getId(), db);
        }
        String propertyXML = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO, "ComponentProperties", false);
        return this.parseComponentPropertyDefinitions(propertyXML);
    }

    public List parseComponentPropertyDefinitions(String xml) {
        ArrayList<ComponentPropertyDefinition> componentPropertyDefinitions = new ArrayList<ComponentPropertyDefinition>();
        if (xml == null || xml.equals("")) {
            return componentPropertyDefinitions;
        }
        try {
            InputSource xmlSource = new InputSource(new StringReader(xml));
            DOMParser parser = new DOMParser();
            parser.parse(xmlSource);
            Document document = parser.getDocument();
            NodeList nl = document.getElementsByTagName("properties");
            int i = 0;
            while (i < nl.getLength()) {
                Node propertiesNode = nl.item(i);
                Element propertiesElement = (Element)propertiesNode;
                NodeList propertyNodeList = propertiesElement.getElementsByTagName("property");
                int j = 0;
                while (j < propertyNodeList.getLength()) {
                    Node propertyNode = propertyNodeList.item(j);
                    Element propertyElement = (Element)propertyNode;
                    String name = propertyElement.getAttribute("name");
                    String displayName = propertyElement.getAttribute("displayName");
                    String type = propertyElement.getAttribute("type");
                    String entity = propertyElement.getAttribute("entity");
                    String multiple = propertyElement.getAttribute("multiple");
                    String assetBinding = propertyElement.getAttribute("assetBinding");
                    String isPuffContentForPage = propertyElement.getAttribute("isPuffContentForPage");
                    String allowedContentTypeNames = propertyElement.getAttribute("allowedContentTypeDefinitionNames");
                    String description = propertyElement.getAttribute("description");
                    String defaultValue = propertyElement.getAttribute("defaultValue");
                    String dataProvider = propertyElement.getAttribute("dataProvider");
                    String dataProviderParameters = propertyElement.getAttribute("dataProviderParameters");
                    String WYSIWYGEnabled = propertyElement.getAttribute("WYSIWYGEnabled");
                    String WYSIWYGToolbar = propertyElement.getAttribute("WYSIWYGToolbar");
                    String autoCreateContent = propertyElement.getAttribute("autoCreateContent");
                    String autoCreateContentMethod = propertyElement.getAttribute("autoCreateContentMethod");
                    String autoCreateContentPath = propertyElement.getAttribute("autoCreateContentPath");
                    String customMarkup = propertyElement.getAttribute("customMarkup");
                    ComponentPropertyDefinition cpd = new ComponentPropertyDefinition(name, displayName, type, entity, new Boolean(multiple), new Boolean(assetBinding), new Boolean(isPuffContentForPage), allowedContentTypeNames, description, defaultValue, new Boolean(WYSIWYGEnabled), WYSIWYGToolbar, dataProvider, dataProviderParameters, new Boolean(autoCreateContent), autoCreateContentMethod, autoCreateContentPath, customMarkup);
                    NodeList optionsNodeList = propertyElement.getElementsByTagName("option");
                    int k = 0;
                    while (k < optionsNodeList.getLength()) {
                        Node optionNode = optionsNodeList.item(k);
                        Element optionElement = (Element)optionNode;
                        String optionName = optionElement.getAttribute("name");
                        String optionValue = optionElement.getAttribute("value");
                        ComponentPropertyOptionDefinition cpod = new ComponentPropertyOptionDefinition(optionName, optionValue);
                        cpd.getOptions().add(cpod);
                        ++k;
                    }
                    componentPropertyDefinitions.add(cpd);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return componentPropertyDefinitions;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

