/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.applications.databeans.ComponentPropertyDefinition;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ComponentPropertyDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.ContentTypeAttribute;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.ContentComparator;
import org.infoglue.deliver.applications.databeans.DeliveryContext;
import org.infoglue.deliver.controllers.kernel.impl.simple.NodeDeliveryController;
import org.infoglue.deliver.util.CacheController;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)ComponentController.class.getName());

    public static ComponentController getController() {
        return new ComponentController();
    }

    public List getComponentVOList(String sortAttribute, String direction, String[] allowedComponentNames, String[] disallowedComponentNames, InfoGluePrincipal principal) throws SystemException, Bug, Exception {
        List componentVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            ComponentController.beginTransaction(db);
            componentVOList = this.getComponentVOList(sortAttribute, direction, allowedComponentNames, disallowedComponentNames, db, principal);
            ComponentController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            ComponentController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch a list of users in this group. Reason:" + e.getMessage(), e);
        }
        return componentVOList;
    }

    public List getComponentVOList(String sortAttribute, String direction, String[] allowedComponentNames, String[] disallowedComponentNames, Database db, InfoGluePrincipal principal) throws SystemException, Bug, Exception {
        String componentsKey;
        List components;
        if (principal == null) {
            return null;
        }
        String allowedComponentNamesString = "";
        if (allowedComponentNames != null) {
            int i = 0;
            while (i < allowedComponentNames.length) {
                allowedComponentNamesString = String.valueOf(allowedComponentNames[i]) + ":";
                ++i;
            }
        }
        String disallowedComponentNamesString = "";
        if (disallowedComponentNames != null) {
            int i = 0;
            while (i < disallowedComponentNames.length) {
                disallowedComponentNamesString = String.valueOf(disallowedComponentNames[i]) + ":";
                ++i;
            }
        }
        if ((components = (List)CacheController.getCachedObject("componentContentsCache", componentsKey = "components_" + sortAttribute + "_" + direction + "_" + allowedComponentNamesString + "_" + disallowedComponentNamesString + "_" + principal.getName())) != null) {
            logger.info((Object)("There was cached components:" + components.size()));
        } else {
            components = this.getComponents(allowedComponentNames, disallowedComponentNames, principal, db);
            for (ContentVO contentVO : components) {
                LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId(), db);
                ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVO.getId(), masterLanguage.getId(), db);
                String groupName = "Unknown";
                String description = "Unknown";
                if (contentVersion != null) {
                    groupName = ContentVersionController.getContentVersionController().getAttributeValue(contentVersion.getValueObject(), "GroupName", false);
                    description = ContentVersionController.getContentVersionController().getAttributeValue(contentVersion.getValueObject(), "Description", false);
                }
                contentVO.getExtraProperties().put("GroupName", groupName);
                contentVO.getExtraProperties().put("Description", description);
            }
            CacheController.cacheObject("componentContentsCache", componentsKey, components);
        }
        ContentComparator comparator = new ContentComparator(sortAttribute, direction, null);
        Collections.sort(components, comparator);
        return components;
    }

    public List getComponents(String[] allowedComponentNames, String[] disallowedComponentNames, InfoGluePrincipal principal) throws Exception {
        int i;
        boolean isAllowed;
        ContentVO contentVO;
        Iterator resultsIterator;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("method", "selectListOnContentTypeName");
        ArrayList argumentList = new ArrayList();
        HashMap<String, String> argument = new HashMap<String, String>();
        argument.put("contentTypeDefinitionName", "HTMLTemplate");
        argumentList.add(argument);
        HashMap<String, String> argument2 = new HashMap<String, String>();
        argument2.put("contentTypeDefinitionName", "PagePartTemplate");
        argumentList.add(argument2);
        arguments.put("arguments", argumentList);
        List results = ContentControllerProxy.getController().getACContentVOList(principal, arguments);
        if (allowedComponentNames != null && allowedComponentNames.length > 0) {
            resultsIterator = results.iterator();
            while (resultsIterator.hasNext()) {
                contentVO = (ContentVO)resultsIterator.next();
                isAllowed = false;
                i = 0;
                while (i < allowedComponentNames.length) {
                    if (contentVO.getName().equals(allowedComponentNames[i])) {
                        isAllowed = true;
                    }
                    ++i;
                }
                if (isAllowed) continue;
                resultsIterator.remove();
            }
        }
        if (disallowedComponentNames != null && disallowedComponentNames.length > 0) {
            resultsIterator = results.iterator();
            while (resultsIterator.hasNext()) {
                contentVO = (ContentVO)resultsIterator.next();
                isAllowed = true;
                i = 0;
                while (i < disallowedComponentNames.length) {
                    if (contentVO.getName().equals(disallowedComponentNames[i])) {
                        isAllowed = false;
                    }
                    ++i;
                }
                if (isAllowed) continue;
                resultsIterator.remove();
            }
        }
        return results;
    }

    public List getComponents(String[] allowedComponentNames, String[] disallowedComponentNames, InfoGluePrincipal principal, Database db) throws Exception {
        int i;
        boolean isAllowed;
        ContentVO contentVO;
        Iterator resultsIterator;
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("method", "selectListOnContentTypeName");
        ArrayList argumentList = new ArrayList();
        HashMap<String, String> argument = new HashMap<String, String>();
        argument.put("contentTypeDefinitionName", "HTMLTemplate");
        argumentList.add(argument);
        HashMap<String, String> argument2 = new HashMap<String, String>();
        argument2.put("contentTypeDefinitionName", "PagePartTemplate");
        argumentList.add(argument2);
        arguments.put("arguments", argumentList);
        List results = ContentControllerProxy.getController().getACContentVOList(principal, arguments, db);
        if (allowedComponentNames != null && allowedComponentNames.length > 0) {
            resultsIterator = results.iterator();
            while (resultsIterator.hasNext()) {
                contentVO = (ContentVO)resultsIterator.next();
                isAllowed = false;
                i = 0;
                while (i < allowedComponentNames.length) {
                    if (contentVO.getName().equals(allowedComponentNames[i])) {
                        isAllowed = true;
                    }
                    ++i;
                }
                if (isAllowed) continue;
                resultsIterator.remove();
            }
        }
        if (disallowedComponentNames != null && disallowedComponentNames.length > 0) {
            resultsIterator = results.iterator();
            while (resultsIterator.hasNext()) {
                contentVO = (ContentVO)resultsIterator.next();
                isAllowed = true;
                i = 0;
                while (i < disallowedComponentNames.length) {
                    if (contentVO.getName().equals(disallowedComponentNames[i])) {
                        isAllowed = false;
                    }
                    ++i;
                }
                if (isAllowed) continue;
                resultsIterator.remove();
            }
        }
        return results;
    }

    public void checkAndAutoCreateContents(Integer siteNodeId, Integer languageId, Integer masterLanguageId, String assetKey, Integer newComponentId, Document document, Integer componentContentId, InfoGluePrincipal principal) throws Exception, SystemException, Bug, ConstraintException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ComponentController.beginTransaction(db);
        try {
            this.checkAndAutoCreateContents(db, siteNodeId, languageId, masterLanguageId, assetKey, newComponentId, document, componentContentId, principal);
            ComponentController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            ComponentController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void checkAndAutoCreateContents(Database db, Integer siteNodeId, Integer languageId, Integer masterLanguageId, String assetKey, Integer newComponentId, Document document, Integer componentContentId, InfoGluePrincipal principal) throws Exception, SystemException, Bug, ConstraintException {
        List componentPropertyDefinitions = ComponentPropertyDefinitionController.getController().getComponentPropertyDefinitions(db, componentContentId, masterLanguageId);
        for (ComponentPropertyDefinition componentPropertyDefinition : componentPropertyDefinitions) {
            logger.info((Object)("componentPropertyDefinition:" + componentPropertyDefinition));
            if (!componentPropertyDefinition.getAutoCreateContent().booleanValue()) continue;
            logger.info((Object)("componentPropertyDefinition vill ha en auto create:" + componentPropertyDefinition));
            String method = componentPropertyDefinition.getAutoCreateContentMethod();
            String path = componentPropertyDefinition.getAutoCreateContentPath();
            String allowedContentTypeNames = componentPropertyDefinition.getAllowedContentTypeNames();
            String allowedContentTypeName = allowedContentTypeNames.split(",")[0];
            ContentTypeDefinitionVO createContentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithName(allowedContentTypeName, db);
            logger.info((Object)("method:" + method));
            logger.info((Object)("path:" + path));
            logger.info((Object)("createContentTypeDefinitionVO:" + createContentTypeDefinitionVO.getName()));
            if (path.indexOf("/") == 0) {
                path = path.substring(1);
            }
            SiteNodeController.getController();
            SiteNodeVO siteNodeVO = SiteNodeController.getSiteNodeVOWithId(siteNodeId, db);
            ContentVO parentContentVO = ContentController.getContentController().getRootContent(db, siteNodeVO.getRepositoryId(), principal.getName(), true).getValueObject();
            if (method.equals("siteStructure")) {
                String siteNodePath = SiteNodeController.getController().getSiteNodePath(siteNodeVO.getId(), db);
                logger.info((Object)("siteNodePath:" + siteNodePath));
                parentContentVO = ContentController.getContentController().getContentVOWithPath(siteNodeVO.getRepositoryId(), String.valueOf(path) + siteNodePath, true, principal, db);
            } else if (method.equals("fixedPath")) {
                parentContentVO = ContentController.getContentController().getContentVOWithPath(siteNodeVO.getRepositoryId(), path, true, principal, db);
            }
            ContentVO autoContentVO = new ContentVO();
            autoContentVO.setName(String.valueOf(siteNodeVO.getName()) + " - " + componentPropertyDefinition.getName());
            autoContentVO.setCreatorName(principal.getName());
            autoContentVO.setIsBranch(false);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><article xmlns=\"x-schema:ArticleSchema.xml\"><attributes>");
            List contentTypeAttributes = ContentTypeDefinitionController.getController().getContentTypeAttributes(createContentTypeDefinitionVO.getSchemaValue());
            for (ContentTypeAttribute contentTypeAttribute : contentTypeAttributes) {
                String initialValue = null;
                if (contentTypeAttribute.getContentTypeAttribute("initialData") != null && contentTypeAttribute.getContentTypeAttribute("initialData").getContentTypeAttributeParameterValue() != null) {
                    contentTypeAttribute.getContentTypeAttribute("initialData").getContentTypeAttributeParameterValue().getValue("label");
                }
                if (initialValue == null || initialValue.trim().equals("")) {
                    initialValue = "State " + contentTypeAttribute.getName();
                }
                sb.append("<" + contentTypeAttribute.getName() + "><![CDATA[" + initialValue + "]]></" + contentTypeAttribute.getName() + ">");
            }
            sb.append("</attributes></article>");
            String defaultValue = sb.toString();
            ContentVersionVO autoContentVersionVO = new ContentVersionVO();
            autoContentVersionVO.setVersionComment("Automatically created");
            autoContentVersionVO.setVersionModifier(principal.getName());
            autoContentVersionVO.setVersionValue(defaultValue);
            autoContentVO = ContentController.getContentController().create(db, parentContentVO.getId(), createContentTypeDefinitionVO.getId(), siteNodeVO.getRepositoryId(), autoContentVO).getValueObject();
            ContentVersionController.getContentVersionController().create(autoContentVO.getId(), languageId, autoContentVersionVO, null, db);
            Locale locale = LanguageController.getController().getLocaleWithId(languageId, db);
            LanguageVO masterLanguageVO = LanguageController.getController().getMasterLanguage(siteNodeVO.getRepositoryId(), db);
            String entity = "Content";
            Integer entityId = new Integer(autoContentVO.getId());
            String propertyName = componentPropertyDefinition.getName();
            ComponentController.getController().addComponentPropertyBinding(document, locale, siteNodeId, languageId, masterLanguageVO.getId(), entity, entityId, propertyName, newComponentId, path, assetKey, principal);
        }
    }

    public void addComponentPropertyBinding(Document document, Locale locale, Integer siteNodeId, Integer languageId, Integer masterLanguageId, String entity, Integer entityId, String propertyName, Integer componentId, String path, String assetKey, InfoGluePrincipal principal) throws Exception {
        String componentPropertyXPath = "//component[@id=" + componentId + "]/properties/property[@name='" + propertyName + "']";
        NodeList anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
        if (anl.getLength() == 0) {
            String componentXPath = "//component[@id=" + componentId + "]/properties";
            NodeList componentNodeList = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentXPath);
            if (componentNodeList.getLength() > 0) {
                Element componentProperties = (Element)componentNodeList.item(0);
                if (entity.equalsIgnoreCase("SiteNode")) {
                    this.addPropertyElement(componentProperties, propertyName, path, "siteNodeBinding", locale);
                } else {
                    this.addPropertyElement(componentProperties, propertyName, path, "contentBinding", locale);
                }
                anl = XPathAPI.selectNodeList((Node)document.getDocumentElement(), (String)componentPropertyXPath);
            }
        }
        if (anl.getLength() > 0) {
            Element component = (Element)anl.item(0);
            component.setAttribute("path", path);
            NamedNodeMap attributes = component.getAttributes();
            logger.debug((Object)("NumberOfAttributes:" + attributes.getLength() + ":" + attributes));
            ArrayList<String> removableAttributes = new ArrayList<String>();
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                logger.debug((Object)("Node:" + node.getNodeName()));
                if (node.getNodeName().startsWith("path_")) {
                    removableAttributes.add(node.getNodeName());
                }
                ++i;
            }
            for (String attributeName : removableAttributes) {
                logger.debug((Object)("Removing node:" + attributeName));
                component.removeAttribute(attributeName);
            }
            NodeList children = component.getChildNodes();
            int i2 = 0;
            while (i2 < children.getLength()) {
                Node node = children.item(i2);
                component.removeChild(node);
                ++i2;
            }
            this.addBindingElement(component, entity, entityId, assetKey);
        }
    }

    private String getPageComponentsString(Integer siteNodeId, Integer languageId, InfoGluePrincipal principal) throws SystemException, Exception {
        String template = null;
        try {
            ContentVO contentVO = NodeDeliveryController.getNodeDeliveryController(siteNodeId, languageId, new Integer(-1)).getBoundContent(principal, siteNodeId, languageId, true, "Meta information", DeliveryContext.getDeliveryContext());
            if (contentVO == null) {
                throw new SystemException("There was no template bound to this page which makes it impossible to render.");
            }
            ContentVersionVO contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), languageId);
            if (contentVersionVO == null) {
                SiteNodeVO siteNodeVO = SiteNodeController.getController().getSiteNodeVOWithId(siteNodeId);
                LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(siteNodeVO.getRepositoryId());
                contentVersionVO = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(contentVO.getId(), masterLanguage.getLanguageId());
            }
            if ((template = ContentVersionController.getContentVersionController().getAttributeValue(contentVersionVO.getId(), "ComponentStructure", false)) == null) {
                throw new SystemException("There was no template bound to this page which makes it impossible to render.");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return template;
    }

    private Element addPropertyElement(Element parent, String name, String path, String type, Locale locale) {
        Element element = parent.getOwnerDocument().createElement("property");
        element.setAttribute("name", name);
        if (type.equalsIgnoreCase("siteNodeBinding") || type.equalsIgnoreCase("contentBinding")) {
            element.setAttribute("path", path);
            element.setAttribute("path_" + locale.getLanguage(), path);
        } else {
            element.setAttribute("path_" + locale.getLanguage(), path);
        }
        element.setAttribute("type", type);
        parent.appendChild(element);
        return element;
    }

    private Element addBindingElement(Element parent, String entity, Integer entityId, String assetKey) {
        Element element = parent.getOwnerDocument().createElement("binding");
        element.setAttribute("entityId", entityId.toString());
        element.setAttribute("entity", entity);
        if (assetKey != null && !assetKey.equals("")) {
            element.setAttribute("assetKey", assetKey);
        }
        parent.appendChild(element);
        return element;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

