/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentCategoryController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Category;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.entities.management.impl.simple.CategoryImpl;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)CategoryController.class.getName());
    private static final CategoryController instance = new CategoryController();
    private static final ContentCategoryController contentCategoryStore = ContentCategoryController.getController();
    private static final String findByParent = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.CategoryImpl c ").append("WHERE c.parentId = $1 ").append("ORDER BY c.name ASC").toString();
    private static final String findActiveByParent = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.CategoryImpl c ").append("WHERE c.parentId = $1 ").append("AND c.active = $2 ").append("ORDER BY c.name ASC").toString();
    private static final String findRootCategories = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.CategoryImpl c ").append("WHERE is_undefined(c.parentId) ").append("ORDER BY c.name ASC").toString();
    private static final String findActiveRootCategories = new StringBuffer("SELECT c ").append("FROM org.infoglue.cms.entities.management.impl.simple.CategoryImpl c ").append("WHERE is_undefined(c.parentId) ").append("AND c.active = $1 ").append("ORDER BY c.name ASC").toString();

    public static CategoryController getController() {
        return instance;
    }

    private CategoryController() {
    }

    public CategoryVO findById(Integer id) throws SystemException {
        return (CategoryVO)CategoryController.getVOWithId(CategoryImpl.class, id);
    }

    public Category findById(Integer id, Database db) throws SystemException {
        return (Category)CategoryController.getObjectWithId(CategoryImpl.class, id, db);
    }

    public CategoryVO findByPath(String path) throws SystemException {
        CategoryVO categoryVO = null;
        String[] nodes = path.substring(1).split("/");
        if (nodes.length > 0) {
            List rootCategories = this.findRootCategories();
            String name = nodes[0];
            categoryVO = this.getCategoryVOWithNameInList(rootCategories, name);
            int i = 1;
            while (i < nodes.length) {
                categoryVO = this.getCategoryVOWithNameInList(this.findByParent(categoryVO.getId()), nodes[i]);
                ++i;
            }
        }
        return categoryVO;
    }

    public CategoryVO findByPath(String path, Database db) throws SystemException {
        CategoryVO categoryVO = null;
        String[] nodes = path.substring(1).split("/");
        if (nodes.length > 0) {
            List rootCategories = this.findRootCategoryVOList(db);
            String name = nodes[0];
            categoryVO = this.getCategoryVOWithNameInList(rootCategories, name);
            int i = 1;
            while (i < nodes.length) {
                categoryVO = this.getCategoryVOWithNameInList(this.findByParent(categoryVO.getId(), db), nodes[i]);
                ++i;
            }
        }
        return categoryVO;
    }

    public String getCategoryPath(Integer categoryId) throws SystemException {
        String path = "";
        Database db = CastorDatabaseService.getDatabase();
        try {
            CategoryController.beginTransaction(db);
            path = this.getCategoryPath(categoryId, db);
            CategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            CategoryController.rollbackTransaction(db);
        }
        return path;
    }

    public String getCategoryPath(Integer categoryId, Database db) throws SystemException {
        StringBuffer path = new StringBuffer();
        Category category = this.findById(categoryId, db);
        if (category != null) {
            path.insert(0, "/" + category.getName());
            while (category.getParentId() != null) {
                if ((category = this.findById(category.getParentId(), db)) == null) continue;
                path.insert(0, "/" + category.getName());
            }
        }
        return path.toString();
    }

    private CategoryVO getCategoryVOWithNameInList(List categoryVOList, String name) {
        CategoryVO categoryVO = null;
        for (CategoryVO currentCategoryVO : categoryVOList) {
            logger.info((Object)("currentCategoryVO:" + currentCategoryVO.getName() + "=" + name));
            if (!currentCategoryVO.getName().equalsIgnoreCase(name)) continue;
            categoryVO = currentCategoryVO;
            break;
        }
        return categoryVO;
    }

    public List findByParent(Integer parentId) throws SystemException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(parentId);
        return CategoryController.executeQuery(findByParent, params);
    }

    public List findByParent(Integer parentId, Database db) throws SystemException {
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(parentId);
        return CategoryController.executeQuery(findByParent, params, db);
    }

    public List findActiveByParent(Integer parentId) throws SystemException {
        ArrayList<Constable> params = new ArrayList<Constable>();
        params.add(parentId);
        params.add(Boolean.TRUE);
        return CategoryController.executeQuery(findActiveByParent, params);
    }

    public CategoryVO findWithChildren(Integer id) throws SystemException {
        CategoryVO c = this.findById(id);
        c.setChildren(this.findByParent(c.getId()));
        return c;
    }

    public CategoryVO findWithChildren(Integer id, Database db) throws SystemException {
        Category c = this.findById(id, db);
        c.getValueObject().setChildren(CategoryController.toVOList(this.findByParent(c.getId(), db)));
        return c.getValueObject();
    }

    public List findRootCategories() throws SystemException {
        return CategoryController.executeQuery(findRootCategories);
    }

    public List findRootCategories(Database db) throws SystemException {
        return CategoryController.executeQuery(findRootCategories, db);
    }

    public List findRootCategoryVOList(Database db) throws SystemException {
        List categories = CategoryController.executeQuery(findRootCategories, db);
        return categories != null ? CategoryController.toVOList(categories) : null;
    }

    public List findAllActiveCategories() throws SystemException {
        ArrayList<Boolean> params = new ArrayList<Boolean>();
        params.add(Boolean.TRUE);
        List roots = CategoryController.executeQuery(findActiveRootCategories, params);
        for (CategoryVO root : roots) {
            root.setChildren(this.findAllActiveChildren(root.getId()));
        }
        return roots;
    }

    public List findAllActiveCategories(boolean includePaths) throws SystemException {
        ArrayList<Boolean> params = new ArrayList<Boolean>();
        params.add(Boolean.TRUE);
        List roots = CategoryController.executeQuery(findActiveRootCategories, params);
        for (CategoryVO root : roots) {
            if (includePaths) {
                String categoryPath = this.getCategoryPath(root.getCategoryId());
                root.setCategoryPath(categoryPath);
            }
            root.setChildren(this.findAllActiveChildren(root.getId(), includePaths));
        }
        return roots;
    }

    public List getAuthorizedActiveChildren(Integer parentId, InfoGluePrincipal infogluePrincipal) throws SystemException {
        List children = this.findActiveByParent(parentId);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            CategoryVO child = (CategoryVO)iter.next();
            if (!this.getIsAccessApproved(child.getCategoryId(), infogluePrincipal)) {
                iter.remove();
            }
            List subChildren = this.findAllActiveChildren(child.getId());
            for (CategoryVO subChild : subChildren) {
                if (!this.getIsAccessApproved(subChild.getCategoryId(), infogluePrincipal)) continue;
                child.getChildren().add(subChild);
            }
        }
        return children;
    }

    public List findAllActiveChildren(Integer parentId) throws SystemException {
        List children = this.findActiveByParent(parentId);
        for (CategoryVO child : children) {
            child.setChildren(this.findAllActiveChildren(child.getId()));
        }
        return children;
    }

    public List findAllActiveChildren(Integer parentId, boolean includePaths) throws SystemException {
        List children = this.findActiveByParent(parentId);
        for (CategoryVO child : children) {
            if (includePaths) {
                String categoryPath = CategoryController.getController().getCategoryPath(child.getCategoryId());
                child.setCategoryPath(categoryPath);
            }
            child.setChildren(this.findAllActiveChildren(child.getId()));
        }
        return children;
    }

    public Category save(CategoryVO c, Database db) throws SystemException {
        return c.isUnsaved() ? this.create(c, db) : (Category)((Object)CategoryController.updateEntity(CategoryImpl.class, c, db));
    }

    private Category create(CategoryVO c, Database db) throws SystemException {
        CategoryImpl impl = new CategoryImpl(c);
        return (CategoryImpl)CategoryController.createEntity(impl);
    }

    public CategoryVO save(CategoryVO c) throws SystemException {
        return c.isUnsaved() ? this.create(c) : (CategoryVO)CategoryController.updateEntity(CategoryImpl.class, c);
    }

    private CategoryVO create(CategoryVO c) throws SystemException {
        CategoryImpl impl = new CategoryImpl(c);
        return ((CategoryImpl)CategoryController.createEntity(impl)).getValueObject();
    }

    public CategoryVO moveCategory(Integer categoryId, Integer newParentId) throws SystemException {
        CategoryVO category = this.findById(categoryId);
        category.setParentId(newParentId);
        return this.save(category);
    }

    public void delete(Integer id) throws SystemException {
        contentCategoryStore.deleteByCategory(id);
        CategoryController.deleteEntity(CategoryImpl.class, id);
        this.deleteChildren(id);
    }

    private void deleteChildren(Integer id) throws SystemException {
        List children = this.findByParent(id);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.delete(((CategoryVO)iter.next()).getId());
        }
    }

    @Override
    public BaseEntityVO getNewVO() {
        return new CategoryVO();
    }

    public boolean getIsAccessApproved(Integer categoryId, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        logger.info((Object)("getIsAccessApproved for " + categoryId + " AND " + infoGluePrincipal));
        boolean hasAccess = false;
        Database db = CastorDatabaseService.getDatabase();
        CategoryController.beginTransaction(db);
        try {
            hasAccess = AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Category.Read", categoryId.toString());
            CategoryController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            CategoryController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return hasAccess;
    }

    public void compareAndCompleteCategoryLists(List remoteCategoryVOList, List<CategoryVO> allLocalCategories, CategoryVO localParentCategory, Map handledRemoteCategoryPaths, Map request) throws SystemException {
        for (CategoryVO remoteCategoryVO : remoteCategoryVOList) {
            boolean categoryExists = false;
            CategoryVO localCategoryVO2 = null;
            for (CategoryVO localCategoryVO2 : allLocalCategories) {
                if (!localCategoryVO2.getName().equals(remoteCategoryVO.getName())) continue;
                categoryExists = true;
                break;
            }
            boolean skipLocalCategory = false;
            if (!categoryExists) {
                Database db = CastorDatabaseService.getDatabase();
                try {
                    CategoryController.beginTransaction(db);
                    String remoteParentPath = remoteCategoryVO.getCategoryPath();
                    String isCategorySelected = (String)request.get(String.valueOf(remoteParentPath) + "_transfer");
                    if (isCategorySelected != null && isCategorySelected.equals("true")) {
                        skipLocalCategory = true;
                        this.handleSubCategories(localParentCategory, remoteCategoryVO, handledRemoteCategoryPaths, request, db);
                    }
                    CategoryController.commitTransaction(db);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CategoryController.rollbackTransaction(db);
                }
            }
            if (remoteCategoryVO.getChildren() == null || remoteCategoryVO.getChildren().size() <= 0) continue;
            if (localCategoryVO2 != null && !skipLocalCategory) {
                this.compareAndCompleteCategoryLists(remoteCategoryVO.getChildren(), localCategoryVO2.getChildren(), localCategoryVO2, handledRemoteCategoryPaths, request);
                continue;
            }
            this.compareAndCompleteCategoryLists(remoteCategoryVO.getChildren(), new ArrayList<CategoryVO>(), null, handledRemoteCategoryPaths, request);
        }
    }

    public void handleSubCategories(CategoryVO localParentCategory, CategoryVO remoteCategoryVO, Map handledRemoteCategoryPaths, Map request, Database db) throws SystemException {
        String isCategorySelected = (String)request.get(String.valueOf(remoteCategoryVO.getCategoryPath()) + "_transfer");
        if (isCategorySelected != null && isCategorySelected.equals("true")) {
            if (handledRemoteCategoryPaths.containsKey(remoteCategoryVO.getCategoryPath())) {
                logger.info((Object)("Category with path " + remoteCategoryVO.getCategoryPath() + " was allready handled."));
            } else {
                logger.info((Object)("Creating local version of:" + remoteCategoryVO + " under " + localParentCategory));
                remoteCategoryVO.setCategoryId(null);
                if (localParentCategory != null) {
                    remoteCategoryVO.setParentId(localParentCategory.getId());
                }
                Category newLocalCategory = CategoryController.getController().save(remoteCategoryVO, db);
                handledRemoteCategoryPaths.put(remoteCategoryVO.getCategoryPath(), "true");
                List subCategories = remoteCategoryVO.getChildren();
                for (CategoryVO subCategory : subCategories) {
                    logger.info((Object)("subCategory:[" + subCategory + "]"));
                    this.handleSubCategories(newLocalCategory.getValueObject(), subCategory, handledRemoteCategoryPaths, request, db);
                }
            }
        }
    }
}

