/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryAndCondition;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryAndConditions;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryOrConditions;
import org.infoglue.cms.controllers.kernel.impl.simple.ConditionsParser;
import org.infoglue.cms.controllers.kernel.impl.simple.ICategoryCondition;
import org.infoglue.cms.controllers.kernel.impl.simple.ICategoryContainerCondition;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class CategoryConditions
implements ICategoryContainerCondition {
    private static final String LEFT = "(";
    private static final String RIGHT = ")";
    private static final String SPACE = " ";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private List children = new ArrayList();
    private String delimiter;

    protected CategoryConditions(String delimiter) {
        this.delimiter = delimiter;
    }

    public void add(ICategoryCondition condition) {
        if (condition != null) {
            this.children.add(condition);
        }
    }

    public void addCategory(String attributeName, CategoryVO categoryVO) {
        this.children.add(new CategoryAndCondition(attributeName, categoryVO));
    }

    public ICategoryContainerCondition and() {
        CategoryConditions container = CategoryConditions.createAndConditions();
        this.add(container);
        return container;
    }

    public ICategoryContainerCondition or() {
        CategoryConditions container = CategoryConditions.createOrConditions();
        this.add(container);
        return container;
    }

    public static CategoryConditions createAndConditions() {
        return new CategoryAndConditions();
    }

    public static CategoryConditions createOrConditions() {
        return new CategoryOrConditions();
    }

    public static CategoryConditions parse(String s) {
        return new ConditionsParser().parse(s);
    }

    public String getWhereClauseOQL(List bindings) {
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        for (ICategoryCondition condition : this.children) {
            if (!condition.hasCondition()) continue;
            if (counter++ > 0) {
                sb.append(SPACE + this.delimiter + SPACE);
            }
            sb.append(condition.getWhereClauseOQL(bindings));
        }
        return counter > 1 ? LEFT + sb.toString() + RIGHT : sb.toString();
    }

    public Collection getFromClauseTables() {
        ArrayList result = new ArrayList();
        for (ICategoryCondition condition : this.children) {
            String useImprovedContentCategorySearch = CmsPropertyHandler.getUseImprovedContentCategorySearch();
            if (useImprovedContentCategorySearch == null || !useImprovedContentCategorySearch.equalsIgnoreCase("false")) continue;
            result.addAll(condition.getFromClauseTables());
        }
        return result;
    }

    public boolean hasCondition() {
        for (ICategoryCondition condition : this.children) {
            if (!condition.hasCondition()) continue;
            return true;
        }
        return false;
    }
}

