/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.exception.SystemException;

public abstract class BaseUCCController {
    private static final Logger logger = Logger.getLogger((String)BaseUCCController.class.getName());

    protected void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected void commitTransaction(Database db) throws SystemException {
        try {
            db.commit();
            db.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected void rollbackTransaction(Database db) throws SystemException {
        try {
            if (db.isActive()) {
                db.rollback();
                db.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected Collection toCollection(Enumeration enumeration) {
        HashSet set = new HashSet();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return Collections.unmodifiableSet(set);
    }
}

