/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryResults;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.kernel.IBaseEntity;
import org.infoglue.cms.entities.kernel.ValidatableEntityVO;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.InterceptorVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.interceptors.InfoGlueInterceptor;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;
import org.infoglue.cms.util.validators.ConstraintRule;
import org.infoglue.cms.util.validators.EmailValidator;
import org.infoglue.cms.util.validators.StringValidator;
import org.infoglue.deliver.util.CacheController;

public abstract class BaseController {
    private static final Logger logger = Logger.getLogger((String)BaseController.class.getName());

    protected void intercept(Map hashMap, String InterceptionPointName, InfoGluePrincipal infogluePrincipal) throws ConstraintException, SystemException, Bug, Exception {
        this.intercept(hashMap, InterceptionPointName, infogluePrincipal, true);
    }

    protected void intercept(Map hashMap, String InterceptionPointName, InfoGluePrincipal infogluePrincipal, boolean allowCreatorAccess) throws ConstraintException, SystemException, Bug, Exception {
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(InterceptionPointName);
        if (interceptionPointVO == null) {
            throw new SystemException("The InterceptionPoint " + InterceptionPointName + " was not found. The system will not work unless you restore it.");
        }
        List interceptors = InterceptionPointController.getController().getInterceptorsVOList(interceptionPointVO.getInterceptionPointId());
        for (InterceptorVO interceptorVO : interceptors) {
            logger.info((Object)("Adding interceptorVO:" + interceptorVO.getName()));
            try {
                InfoGlueInterceptor infoGlueInterceptor = (InfoGlueInterceptor)Class.forName(interceptorVO.getClassName()).newInstance();
                infoGlueInterceptor.intercept(infogluePrincipal, interceptionPointVO, hashMap, allowCreatorAccess);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("The interceptor " + interceptorVO.getClassName() + "was not found: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void intercept(Map hashMap, String InterceptionPointName, InfoGluePrincipal infogluePrincipal, Database db) throws ConstraintException, SystemException, Bug, Exception {
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(InterceptionPointName, db);
        if (interceptionPointVO == null) {
            throw new SystemException("The InterceptionPoint " + InterceptionPointName + " was not found. The system will not work unless you restore it.");
        }
        List interceptors = InterceptionPointController.getController().getInterceptorsVOList(interceptionPointVO.getInterceptionPointId(), db);
        for (InterceptorVO interceptorVO : interceptors) {
            logger.info((Object)("Adding interceptorVO:" + interceptorVO.getName()));
            try {
                InfoGlueInterceptor infoGlueInterceptor = (InfoGlueInterceptor)Class.forName(interceptorVO.getClassName()).newInstance();
                infoGlueInterceptor.intercept(infogluePrincipal, interceptionPointVO, hashMap, db);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("The interceptor " + interceptorVO.getClassName() + "was not found: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void intercept(Map hashMap, String InterceptionPointName, InfoGluePrincipal infogluePrincipal, boolean allowCreatorAccess, Database db) throws ConstraintException, SystemException, Bug, Exception {
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(InterceptionPointName, db);
        if (interceptionPointVO == null) {
            throw new SystemException("The InterceptionPoint " + InterceptionPointName + " was not found. The system will not work unless you restore it.");
        }
        List interceptors = InterceptionPointController.getController().getInterceptorsVOList(interceptionPointVO.getInterceptionPointId(), db);
        for (InterceptorVO interceptorVO : interceptors) {
            logger.info((Object)("Adding interceptorVO:" + interceptorVO.getName()));
            try {
                InfoGlueInterceptor infoGlueInterceptor = (InfoGlueInterceptor)Class.forName(interceptorVO.getClassName()).newInstance();
                infoGlueInterceptor.intercept(infogluePrincipal, interceptionPointVO, hashMap, allowCreatorAccess, db);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("The interceptor " + interceptorVO.getClassName() + "was not found: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static Integer getEntityId(Object entity) throws Bug {
        Integer entityId = new Integer(-1);
        try {
            entityId = ((IBaseEntity)entity).getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Bug("Unable to retrieve object id");
        }
        return entityId;
    }

    protected static Object createEntity(Object entity) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        BaseController.beginTransaction(db);
        try {
            db.create(entity);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            BaseController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return entity;
    }

    protected static Object createEntity(Object entity, Database db) throws SystemException, Bug, Exception {
        db.create(entity);
        return entity;
    }

    public static void deleteEntity(Class entClass, Integer id) throws Bug, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        Object entity = null;
        BaseController.beginTransaction(db);
        try {
            entity = BaseController.getObjectWithId(entClass, id, db);
            db.remove(entity);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            BaseController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static void deleteEntity(Class entClass, String id) throws Bug, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        Object entity = null;
        BaseController.beginTransaction(db);
        try {
            entity = BaseController.getObjectWithId(entClass, id, db);
            db.remove(entity);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            BaseController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public static void deleteEntity(Class entClass, String id, Database db) throws Bug, SystemException, Exception {
        Object entity = BaseController.getObjectWithId(entClass, id, db);
        db.remove(entity);
    }

    public static void deleteEntity(Class entClass, Integer id, Database db) throws Bug, SystemException {
        Object entity = null;
        try {
            entity = BaseController.getObjectWithId(entClass, id, db);
            db.remove(entity);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public static BaseEntityVO updateEntity(Class arg, BaseEntityVO vo) throws Bug, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        IBaseEntity entity = null;
        BaseController.beginTransaction(db);
        try {
            entity = (IBaseEntity)BaseController.getObjectWithId(arg, vo.getId(), db);
            entity.setVO(vo);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            BaseController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return entity.getVO();
    }

    public static BaseEntityVO updateEntity(Class arg, BaseEntityVO vo, Database db) throws Bug, SystemException {
        IBaseEntity entity = null;
        entity = (IBaseEntity)BaseController.getObjectWithId(arg, vo.getId(), db);
        entity.setVO(vo);
        return entity.getVO();
    }

    public static BaseEntityVO updateEntity(Class entClass, BaseEntityVO vo, String collectionMethod, Class manyClass, String[] manyIds) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        IBaseEntity entity = null;
        BaseController.beginTransaction(db);
        try {
            ArrayList<IBaseEntity> manyList = new ArrayList<IBaseEntity>();
            if (manyIds != null) {
                int i = 0;
                while (i < manyIds.length) {
                    IBaseEntity manyEntity = (IBaseEntity)BaseController.getObjectWithId(manyClass, new Integer(manyIds[i]), db);
                    logger.info((Object)("!!Using experimental code: BaseController::update. getting " + manyEntity.toString()));
                    manyList.add(manyEntity);
                    ++i;
                }
            }
            entity = (IBaseEntity)BaseController.getObjectWithId(entClass, vo.getId(), db);
            entity.setVO(vo);
            Object[] arg = new Object[]{manyList};
            Class[] parm = new Class[]{Collection.class};
            entity.getClass().getDeclaredMethod(collectionMethod, parm).invoke((Object)entity, arg);
            ceb.throwIfNotEmpty();
            BaseController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            BaseController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            BaseController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return entity.getVO();
    }

    public static IBaseEntity updateEntity(Class entClass, BaseEntityVO vo, String collectionMethod, Class manyClass, String[] manyIds, Database db) throws ConstraintException, SystemException, Exception {
        IBaseEntity entity = null;
        ArrayList<IBaseEntity> manyList = new ArrayList<IBaseEntity>();
        if (manyIds != null) {
            int i = 0;
            while (i < manyIds.length) {
                IBaseEntity manyEntity = (IBaseEntity)BaseController.getObjectWithId(manyClass, new Integer(manyIds[i]), db);
                logger.info((Object)("!!Using experimental code: BaseController::update. getting " + manyEntity.toString()));
                manyList.add(manyEntity);
                ++i;
            }
        }
        entity = (IBaseEntity)BaseController.getObjectWithId(entClass, vo.getId(), db);
        entity.setVO(vo);
        Object[] arg = new Object[]{manyList};
        Class[] parm = new Class[]{Collection.class};
        entity.getClass().getDeclaredMethod(collectionMethod, parm).invoke((Object)entity, arg);
        return entity;
    }

    protected static Object getObjectWithId(Class arg, Integer id, Database db) throws SystemException, Bug {
        Object object = null;
        try {
            logger.info((Object)("Loading " + arg + " in read/write mode."));
            object = db.load(arg, (Object)id);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (object == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return object;
    }

    protected static Object getObjectWithIdAsReadOnly(Class arg, Integer id, Database db) throws SystemException, Bug {
        Object object = null;
        try {
            object = db.load(arg, (Object)id, (short)0);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (object == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return object;
    }

    protected static Object getObjectWithId(Class arg, String id, Database db) throws SystemException, Bug {
        Object object = null;
        try {
            logger.info((Object)("Loading " + arg + " in read/write mode."));
            object = db.load(arg, (Object)id);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (object == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return object;
    }

    public static List toVOList(Collection baseEntities) throws SystemException, Bug {
        ArrayList<Object> resultVOList = new ArrayList<Object>();
        if (baseEntities != null) {
            Object o2 = null;
            try {
                for (Object o2 : baseEntities) {
                    resultVOList.add(o2.getClass().getDeclaredMethod("getValueObject", new Class[0]).invoke(o2, new Object[0]));
                }
            }
            catch (NoSuchMethodException e) {
                throw new Bug("The object in list was of the wrong type: " + o2.getClass().getName() + ". This should never happen.", e);
            }
            catch (Exception e) {
                throw new SystemException("An error occurred when we tried to convert the collection to a valueList. Reason:" + e.getMessage(), e);
            }
        }
        return resultVOList;
    }

    public static List toModifiableVOList(Collection baseEntities) throws SystemException, Bug {
        ArrayList<Object> resultVOList = new ArrayList<Object>();
        if (baseEntities != null) {
            Object o2 = null;
            try {
                for (Object o2 : baseEntities) {
                    resultVOList.add(o2.getClass().getDeclaredMethod("getValueObject", new Class[0]).invoke(o2, new Object[0]));
                }
            }
            catch (NoSuchMethodException e) {
                throw new Bug("The object in list was of the wrong type: " + o2.getClass().getName() + ". This should never happen.", e);
            }
            catch (Exception e) {
                throw new SystemException("An error occurred when we tried to convert the collection to a valueList. Reason:" + e.getMessage(), e);
            }
        }
        return resultVOList;
    }

    public static Object getVOWithId(Class arg, Integer id) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        BaseEntityVO ret = null;
        try {
            BaseController.beginTransaction(db);
            ret = BaseController.getVOWithId(arg, id, db);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            BaseController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        return ret;
    }

    public static BaseEntityVO getVOWithId(Class arg, Integer id, Database db) throws SystemException, Bug {
        IBaseEntity vo = null;
        try {
            vo = (IBaseEntity)db.load(arg, (Object)id, (short)0);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (vo == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return vo.getVO();
    }

    public static Object getVOWithId(Class arg, String id) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        BaseEntityVO ret = null;
        try {
            BaseController.beginTransaction(db);
            ret = BaseController.getVOWithId(arg, id, db);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            BaseController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        return ret;
    }

    public static BaseEntityVO getVOWithId(Class arg, String id, Database db) throws SystemException, Bug {
        IBaseEntity vo = null;
        try {
            vo = (IBaseEntity)db.load(arg, (Object)id, (short)0);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch the object " + arg.getName() + ". Reason:" + e.getMessage(), e);
        }
        if (vo == null) {
            throw new Bug("The object with id [" + id + "] was not found. This should never happen.");
        }
        return vo.getVO();
    }

    public static List getAllVOObjects(Class arg, String orderByAttribute, String direction) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        List ret = null;
        try {
            BaseController.beginTransaction(db);
            ret = BaseController.getAllVOObjects(arg, orderByAttribute, direction, db);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            BaseController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return ret;
    }

    public static List getAllVOObjects(Class arg, String orderByField, String direction, Database db) throws SystemException, Bug {
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            logger.info((Object)("BaseHelper::GetAllObjects for " + arg.getName()));
            OQLQuery oql = db.getOQLQuery("SELECT u FROM " + arg.getName() + " u ORDER BY u." + orderByField + " " + direction);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                Object o = results.next();
                resultList.add(o.getClass().getDeclaredMethod("getValueObject", new Class[0]).invoke(o, new Object[0]));
            }
        }
        catch (NoSuchMethodException e) {
            throw new Bug("The object [" + arg.getName() + "] is of the wrong type. This should never happen.", e);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return resultList;
    }

    public List getAllVOObjects(Class arg, String primaryKey) throws SystemException, Bug {
        Database db = CastorDatabaseService.getDatabase();
        List ret = null;
        try {
            BaseController.beginTransaction(db);
            ret = this.getAllVOObjects(arg, primaryKey, db);
            BaseController.commitTransaction(db);
        }
        catch (Exception e) {
            BaseController.rollbackTransaction(db);
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return ret;
    }

    public List getAllVOObjects(Class arg, String primaryKey, Database db) throws SystemException, Bug {
        ArrayList<BaseEntityVO> resultList = new ArrayList<BaseEntityVO>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT u FROM " + arg.getName() + " u ORDER BY u." + primaryKey);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                IBaseEntity baseEntity = (IBaseEntity)results.next();
                resultList.add(baseEntity.getVO());
            }
        }
        catch (ClassCastException e) {
            throw new Bug("The object [" + arg.getName() + "] is of the wrong type. This should never happen.", e);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return resultList;
    }

    public List getAllObjects(Class arg, String primaryKey, Database db) throws SystemException, Bug {
        ArrayList<IBaseEntity> resultList = new ArrayList<IBaseEntity>();
        try {
            OQLQuery oql = db.getOQLQuery("SELECT u FROM " + arg.getName() + " u ORDER BY u." + primaryKey);
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                IBaseEntity baseEntity = (IBaseEntity)results.next();
                resultList.add(baseEntity);
            }
        }
        catch (ClassCastException e) {
            throw new Bug("The object [" + arg.getName() + "] is of the wrong type. This should never happen.", e);
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch " + arg.getName() + " Reason:" + e.getMessage(), e);
        }
        return resultList;
    }

    protected static List executeQuery(String query) throws SystemException {
        return BaseController.executeQuery(query, Collections.EMPTY_LIST);
    }

    protected static List executeQuery(String query, Database db) throws SystemException {
        return BaseController.executeQuery(query, Collections.EMPTY_LIST, db);
    }

    protected static List executeQuery(String query, List params) throws SystemException {
        Database db = BaseController.beginTransaction();
        try {
            List results = new ArrayList();
            results = Collections.list(BaseController.createQuery(db, query, params).execute((short)0));
            BaseController.commitTransaction(db);
            return BaseController.toVOList(results);
        }
        catch (Exception e) {
            logger.error((Object)("Error executing " + query), (Throwable)e);
            BaseController.rollbackTransaction(db);
            throw new SystemException(e.getMessage(), e);
        }
    }

    protected static List executeQuery(String query, List params, Database db) throws SystemException {
        try {
            List resultList = new ArrayList();
            OQLQuery oql = BaseController.createQuery(db, query, params);
            QueryResults results = oql.execute();
            resultList = Collections.list(results);
            results.close();
            oql.close();
            return resultList;
        }
        catch (Exception e) {
            logger.error((Object)("Error executing " + query), (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
    }

    protected static OQLQuery createQuery(Database db, String query, List params) throws PersistenceException {
        OQLQuery oql = db.getOQLQuery(query);
        if (params != null) {
            Iterator i = params.iterator();
            while (i.hasNext()) {
                oql.bind(i.next());
            }
        }
        return oql;
    }

    public static ConstraintExceptionBuffer validateEntity(ValidatableEntityVO vo) {
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        vo.PrepareValidation();
        for (ConstraintRule cr : vo.getConstraintRules()) {
            Integer intId = vo.getId();
            logger.info((Object)("Validating object id: " + intId));
            switch (cr.getConstraintType()) {
                case 1: {
                    if (cr.getValue() == null) break;
                    StringValidator v = new EmailValidator(cr.getFieldName());
                    v.setObjectClass(vo.getConstraintRuleList().getEntityClass());
                    v.setRange(cr.getValidRange());
                    v.setIsRequired(cr.required);
                    v.setMustBeUnique(cr.unique);
                    v.setExcludeId(intId);
                    v.validate((String)cr.getValue(), ceb);
                    break;
                }
                case 0: {
                    if (cr.getValue() == null) break;
                    StringValidator v = new StringValidator(cr.getFieldName());
                    v.setObjectClass(vo.getConstraintRuleList().getEntityClass());
                    v.setRange(cr.getValidRange());
                    v.setIsRequired(cr.required);
                    v.setMustBeUnique(cr.unique);
                    v.setExcludeId(intId);
                    v.validate((String)cr.getValue(), ceb);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        return ceb;
    }

    protected static Database beginTransaction() throws SystemException {
        Database db = CastorDatabaseService.getDatabase();
        BaseController.beginTransaction(db);
        return db;
    }

    protected static void beginTransaction(Database db) throws SystemException {
        try {
            db.begin();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to begin an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected static void commitTransaction(Database db) throws SystemException {
        try {
            db.commit();
            db.close();
        }
        catch (TransactionAbortedException tae) {
            if (tae.getCause() instanceof LockNotGrantedException) {
                throw new SystemException("The resource you tried to modify have just been updated by another user. Please try again later. System message: " + tae.getCause().getMessage());
            }
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + tae.getMessage(), tae);
        }
        catch (LockNotGrantedException lnge) {
            throw new SystemException("The resource you tried to modify have just been updated by another user. Please try again later. System message: " + lnge.getMessage());
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to commit an transaction. Reason:" + e.getMessage(), e);
        }
    }

    protected static void rollbackTransaction(Database db) throws SystemException {
        try {
            if (db != null && db.isActive()) {
                db.rollback();
                db.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
        }
    }

    protected static void closeDatabase(Database db) throws SystemException {
        try {
            if (db != null) {
                db.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred when we tried to rollback an transaction. Reason:" + e.getMessage()));
        }
    }

    public String getLocalizedString(Locale locale, String key) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key);
    }

    public String getLocalizedString(Locale locale, String key, Object arg1) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key, arg1);
    }

    public String getLocalizedString(Locale locale, String key, Object arg1, Object arg2) {
        StringManager stringManager = StringManagerFactory.getPresentationStringManager("org.infoglue.cms.applications", locale);
        return stringManager.getString(key, arg1, arg2);
    }

    public Locale getUserPrefferedLocale(String userName) {
        Locale locale = Locale.ENGLISH;
        if (userName != null) {
            try {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("globalKey", "infoglue");
                PropertySet ps = PropertySetManager.getInstance((String)"jdbc", args);
                String languageCode = ps.getString("principal_" + userName + "_languageCode");
                locale = this.getLocaleWithCode(languageCode);
            }
            catch (Exception e) {
                logger.warn((Object)("Error getting users prefferred language: " + e.getMessage()), (Throwable)e);
            }
        }
        return locale;
    }

    public Locale getLocaleWithCode(String languageCode) {
        String key = languageCode;
        logger.info((Object)("key:" + key));
        Locale locale = (Locale)CacheController.getCachedObject("localeCache", key);
        if (locale != null) {
            logger.info((Object)("There was an cached locale:" + locale));
        } else {
            locale = Locale.getDefault();
            if (languageCode != null) {
                try {
                    locale = new Locale(languageCode);
                }
                catch (Exception e) {
                    logger.error((Object)("An error occurred in getLocaleWithCode: getting locale with languageCode:" + languageCode + "," + e), (Throwable)e);
                }
            }
            CacheController.cacheObject("localeCache", key, locale);
        }
        return locale;
    }

    public abstract BaseEntityVO getNewVO();
}

