/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ServiceBindingController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeTypeDefinitionController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.AvailableServiceBinding;
import org.infoglue.cms.entities.management.AvailableServiceBindingVO;
import org.infoglue.cms.entities.management.SiteNodeTypeDefinition;
import org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl;
import org.infoglue.cms.entities.management.impl.simple.ServiceDefinitionImpl;
import org.infoglue.cms.entities.management.impl.simple.SmallAvailableServiceBindingImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.deliver.util.CacheController;

public class AvailableServiceBindingController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)AvailableServiceBindingController.class.getName());

    public static AvailableServiceBindingController getController() {
        return new AvailableServiceBindingController();
    }

    public AvailableServiceBindingVO getAvailableServiceBindingVOWithId(Integer availableServiceBindingId) throws SystemException, Bug {
        return (AvailableServiceBindingVO)AvailableServiceBindingController.getVOWithId(SmallAvailableServiceBindingImpl.class, availableServiceBindingId);
    }

    public AvailableServiceBindingVO create(AvailableServiceBindingVO vo) throws ConstraintException, SystemException {
        AvailableServiceBinding ent = new AvailableServiceBindingImpl();
        ent.setValueObject(vo);
        ent = (AvailableServiceBinding)AvailableServiceBindingController.createEntity(ent);
        return ent.getValueObject();
    }

    public void delete(AvailableServiceBindingVO availableServiceBindingVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        try {
            try {
                AvailableServiceBindingController.beginTransaction(db);
                List serviceBindingList = ServiceBindingController.getController().getServiceBindingList(availableServiceBindingVO.getId(), db);
                AvailableServiceBinding availableServiceBinding = AvailableServiceBindingController.getController().getAvailableServiceBindingWithId(availableServiceBindingVO.getId(), db);
                Collection siteNodeTypeDefinitionList = availableServiceBinding.getSiteNodeTypeDefinitions();
                if (serviceBindingList != null && serviceBindingList.size() > 0 || siteNodeTypeDefinitionList != null && siteNodeTypeDefinitionList.size() > 0) {
                    throw new ConstraintException("AvailableServiceBinding.deleteAction", "3100");
                }
                AvailableServiceBindingController.deleteEntity(AvailableServiceBindingImpl.class, availableServiceBindingVO.getAvailableServiceBindingId(), db);
                AvailableServiceBindingController.commitTransaction(db);
            }
            catch (ConstraintException ce) {
                AvailableServiceBindingController.rollbackTransaction(db);
                throw ce;
            }
            catch (SystemException se) {
                AvailableServiceBindingController.rollbackTransaction(db);
                throw se;
            }
            catch (Exception e) {
                AvailableServiceBindingController.rollbackTransaction(db);
                throw new SystemException("An error occurred in AvailableServiceBindingController.delete(). Reason:" + e.getMessage(), e);
            }
        }
        finally {
            AvailableServiceBindingController.closeDatabase(db);
        }
    }

    public AvailableServiceBinding getAvailableServiceBindingWithId(Integer availableServiceBindingId, Database db) throws SystemException, Bug {
        return (AvailableServiceBinding)AvailableServiceBindingController.getObjectWithId(AvailableServiceBindingImpl.class, availableServiceBindingId, db);
    }

    public AvailableServiceBinding getReadOnlyAvailableServiceBindingWithId(Integer availableServiceBindingId, Database db) throws SystemException, Bug {
        return (AvailableServiceBinding)AvailableServiceBindingController.getObjectWithIdAsReadOnly(AvailableServiceBindingImpl.class, availableServiceBindingId, db);
    }

    public List getAvailableServiceBindingVOList() throws SystemException, Bug {
        return this.getAllVOObjects(SmallAvailableServiceBindingImpl.class, "availableServiceBindingId");
    }

    public AvailableServiceBindingVO getAvailableServiceBindingVOWithName(String name) throws SystemException, Bug {
        String key = name;
        logger.info((Object)("key:" + key));
        AvailableServiceBindingVO availableServiceBindingVO = (AvailableServiceBindingVO)CacheController.getCachedObject("availableServiceBindingCache", key);
        if (availableServiceBindingVO != null) {
            logger.info((Object)("There was an cached availableServiceBindingVO:" + availableServiceBindingVO));
        } else {
            Database db = CastorDatabaseService.getDatabase();
            ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
            AvailableServiceBindingController.beginTransaction(db);
            try {
                availableServiceBindingVO = this.getAvailableServiceBindingVOWithName(name, db);
                CacheController.cacheObject("availableServiceBindingCache", key, availableServiceBindingVO);
                AvailableServiceBindingController.commitTransaction(db);
            }
            catch (Exception e) {
                AvailableServiceBindingController.rollbackTransaction(db);
                throw new SystemException("An error occurred when we tried to fetch a list of AvailableServiceBinding. Reason:" + e.getMessage(), e);
            }
        }
        return availableServiceBindingVO;
    }

    public AvailableServiceBindingVO getAvailableServiceBindingVOWithName(String name, Database db) throws SystemException, Bug, Exception {
        String key = name;
        logger.info((Object)("key:" + key));
        AvailableServiceBindingVO availableServiceBindingVO = (AvailableServiceBindingVO)CacheController.getCachedObject("availableServiceBindingCache", key);
        if (availableServiceBindingVO != null) {
            logger.info((Object)("There was an cached availableServiceBindingVO:" + availableServiceBindingVO));
        } else {
            OQLQuery oql = db.getOQLQuery("SELECT asb FROM org.infoglue.cms.entities.management.impl.simple.SmallAvailableServiceBindingImpl asb WHERE asb.name = $1");
            oql.bind((Object)name);
            QueryResults results = oql.execute((short)0);
            if (results.hasMore()) {
                AvailableServiceBinding availableServiceBinding = (AvailableServiceBinding)results.next();
                availableServiceBindingVO = availableServiceBinding.getValueObject();
                logger.info((Object)("Found availableServiceBinding:" + availableServiceBindingVO.getName()));
            }
            results.close();
            oql.close();
            CacheController.cacheObject("availableServiceBindingCache", key, availableServiceBindingVO);
        }
        return availableServiceBindingVO;
    }

    public AvailableServiceBinding getAvailableServiceBindingWithName(String name, Database db, boolean readOnly) throws SystemException, Bug {
        AvailableServiceBinding availableServiceBinding = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT asb FROM org.infoglue.cms.entities.management.impl.simple.AvailableServiceBindingImpl as asb WHERE asb.name = $1 order by asb.name");
            oql.bind((Object)name);
            QueryResults results = null;
            if (readOnly) {
                results = oql.execute((short)0);
            } else {
                logger.info((Object)("Fetching entity in read/write mode:" + name));
                results = oql.execute();
            }
            if (results.hasMore()) {
                availableServiceBinding = (AvailableServiceBinding)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a named AvailableServiceBinding. Reason:" + e.getMessage(), e);
        }
        return availableServiceBinding;
    }

    public SmallAvailableServiceBindingImpl getSmallAvailableServiceBindingWithName(String name, Database db, boolean readOnly) throws SystemException, Bug {
        SmallAvailableServiceBindingImpl availableServiceBinding = null;
        try {
            OQLQuery oql = db.getOQLQuery("SELECT asb FROM org.infoglue.cms.entities.management.impl.simple.SmallAvailableServiceBindingImpl as asb WHERE asb.name = $1 order by asb.name");
            oql.bind((Object)name);
            QueryResults results = null;
            if (readOnly) {
                results = oql.execute((short)0);
            } else {
                logger.info((Object)("Fetching entity in read/write mode:" + name));
                results = oql.execute();
            }
            if (results.hasMore()) {
                availableServiceBinding = (SmallAvailableServiceBindingImpl)results.next();
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a named AvailableServiceBinding. Reason:" + e.getMessage(), e);
        }
        return availableServiceBinding;
    }

    public List getAssignedAvailableServiceBindings(Integer siteNodeTypeDefinitionId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List assignedAvailableServiceBindingVOList = null;
        AvailableServiceBindingController.beginTransaction(db);
        try {
            SiteNodeTypeDefinition siteNodeTypeDefinition = SiteNodeTypeDefinitionController.getController().getSiteNodeTypeDefinitionWithId(siteNodeTypeDefinitionId, db);
            Collection assignedAvailableServiceBinding = siteNodeTypeDefinition.getAvailableServiceBindings();
            assignedAvailableServiceBindingVOList = AvailableServiceBindingController.toVOList(assignedAvailableServiceBinding);
            ceb.throwIfNotEmpty();
            AvailableServiceBindingController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            AvailableServiceBindingController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            AvailableServiceBindingController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return assignedAvailableServiceBindingVOList;
    }

    public AvailableServiceBindingVO update(AvailableServiceBindingVO availableServiceBindingVO) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        AvailableServiceBinding availableServiceBinding = null;
        AvailableServiceBindingController.beginTransaction(db);
        try {
            availableServiceBinding = this.getAvailableServiceBindingWithId(availableServiceBindingVO.getAvailableServiceBindingId(), db);
            availableServiceBinding.setValueObject(availableServiceBindingVO);
            ceb.throwIfNotEmpty();
            AvailableServiceBindingController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            AvailableServiceBindingController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            AvailableServiceBindingController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return availableServiceBinding.getValueObject();
    }

    public AvailableServiceBindingVO update(AvailableServiceBindingVO availableServiceBindingVO, String[] values) throws ConstraintException, SystemException {
        return (AvailableServiceBindingVO)AvailableServiceBindingController.updateEntity(AvailableServiceBindingImpl.class, availableServiceBindingVO, "setServiceDefinitions", ServiceDefinitionImpl.class, values);
    }

    public AvailableServiceBinding update(Integer availableServiceBindingId, String[] values, Database db) throws ConstraintException, SystemException {
        AvailableServiceBinding availableServiceBinding = this.getAvailableServiceBindingWithId(availableServiceBindingId, db);
        return (AvailableServiceBinding)((Object)AvailableServiceBindingController.updateEntity(AvailableServiceBindingImpl.class, availableServiceBinding.getVO(), "setServiceDefinitions", ServiceDefinitionImpl.class, values));
    }

    public List getServiceDefinitionVOList(Integer availableServiceBindingId) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        List serviceDefinitionVOList = null;
        AvailableServiceBindingController.beginTransaction(db);
        try {
            serviceDefinitionVOList = this.getServiceDefinitionVOList(db, availableServiceBindingId);
            ceb.throwIfNotEmpty();
            AvailableServiceBindingController.commitTransaction(db);
        }
        catch (ConstraintException ce) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + ce), (Throwable)ce);
            AvailableServiceBindingController.rollbackTransaction(db);
            throw ce;
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            AvailableServiceBindingController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return serviceDefinitionVOList;
    }

    public List getServiceDefinitionVOList(Database db, Integer availableServiceBindingId) throws ConstraintException, SystemException {
        List serviceDefinitionVOList = null;
        AvailableServiceBinding availableServiceBinding = this.getReadOnlyAvailableServiceBindingWithId(availableServiceBindingId, db);
        Collection serviceDefinitionList = availableServiceBinding.getServiceDefinitions();
        serviceDefinitionVOList = AvailableServiceBindingController.toVOList(serviceDefinitionList);
        return serviceDefinitionVOList;
    }

    public BaseEntityVO getNewVO() {
        return new AvailableServiceBindingVO();
    }
}

