/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.QueryResults;
import org.infoglue.cms.applications.contenttool.actions.databeans.AccessRightsUserRow;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.InterceptionPointController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.AccessRight;
import org.infoglue.cms.entities.management.AccessRightGroup;
import org.infoglue.cms.entities.management.AccessRightGroupVO;
import org.infoglue.cms.entities.management.AccessRightRole;
import org.infoglue.cms.entities.management.AccessRightRoleVO;
import org.infoglue.cms.entities.management.AccessRightUser;
import org.infoglue.cms.entities.management.AccessRightUserVO;
import org.infoglue.cms.entities.management.AccessRightVO;
import org.infoglue.cms.entities.management.InterceptionPoint;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.management.impl.simple.AccessRightGroupImpl;
import org.infoglue.cms.entities.management.impl.simple.AccessRightImpl;
import org.infoglue.cms.entities.management.impl.simple.AccessRightRoleImpl;
import org.infoglue.cms.entities.management.impl.simple.AccessRightUserImpl;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.deliver.util.CacheController;

public class AccessRightController
extends BaseController {
    private static final Logger logger = Logger.getLogger((String)AccessRightController.class.getName());

    public static AccessRightController getController() {
        return new AccessRightController();
    }

    public AccessRight getAccessRightWithId(Integer accessRightId, Database db) throws SystemException, Bug {
        return (AccessRight)AccessRightController.getObjectWithId(AccessRightImpl.class, accessRightId, db);
    }

    public AccessRightVO getAccessRightVOWithId(Integer accessRightId) throws SystemException, Bug {
        return (AccessRightVO)AccessRightController.getVOWithId(AccessRightImpl.class, accessRightId);
    }

    public List getAccessRightVOList() throws SystemException, Bug {
        return this.getAllVOObjects(AccessRightImpl.class, "accessRightId");
    }

    public List getAccessRightVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(AccessRightImpl.class, "accessRightId", db);
    }

    public List getAccessRightUserVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(AccessRightUserImpl.class, "accessRightUserId", db);
    }

    public List getAccessRightRoleVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(AccessRightRoleImpl.class, "accessRightRoleId", db);
    }

    public List getAccessRightGroupVOList(Database db) throws SystemException, Bug {
        return this.getAllVOObjects(AccessRightGroupImpl.class, "accessRightGroupId", db);
    }

    public List getAccessRightVOList(String interceptionPointName, String parameters, Database db) throws SystemException, Bug {
        String key = interceptionPointName + "_" + parameters;
        ArrayList<AccessRightVO> accessRightVOList = (ArrayList<AccessRightVO>)CacheController.getCachedObject("authorizationCache", key);
        if (accessRightVOList != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("There was an cached accessRightVOList:" + accessRightVOList));
            }
            return accessRightVOList;
        }
        accessRightVOList = new ArrayList<AccessRightVO>();
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(interceptionPointName);
        List accessRightList = this.getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), parameters, db);
        for (AccessRight accessRight : accessRightList) {
            Collection approvedRoles = accessRight.getRoles();
            Collection approvedGroups = accessRight.getGroups();
            Collection approvedUsers = accessRight.getUsers();
            AccessRightVO vo = accessRight.getValueObject();
            vo.getRoles().addAll(AccessRightController.toVOList(approvedRoles));
            vo.getGroups().addAll(AccessRightController.toVOList(approvedGroups));
            vo.getUsers().addAll(AccessRightController.toVOList(approvedUsers));
            accessRightVOList.add(vo);
        }
        if (accessRightVOList != null) {
            CacheController.cacheObject("authorizationCache", key, accessRightVOList);
        }
        return accessRightVOList;
    }

    public List getAccessRightGroupVOList(Integer accessRightId) throws SystemException, Bug {
        List accessRightGroupVOList = new ArrayList();
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            AccessRight accessRight = this.getAccessRightWithId(accessRightId, db);
            if (accessRight != null) {
                accessRightGroupVOList = AccessRightController.toVOList(accessRight.getGroups());
            }
            logger.info((Object)("accessRightGroupVOList:" + accessRightGroupVOList.size()));
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return accessRightGroupVOList;
    }

    public List getAccessRightVOList(Integer interceptionPointId, String parameters, String roleName) throws SystemException, Bug {
        List accessRightVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            accessRightVOList = this.getAccessRightVOList(db, interceptionPointId, parameters, roleName);
            logger.info((Object)("accessRightVOList:" + accessRightVOList.size()));
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return accessRightVOList;
    }

    public List getAccessRightVOList(Database db, Integer interceptionPointId, String parameters, String roleName) throws SystemException, Bug {
        List accessRightVOList = null;
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithId(interceptionPointId);
        accessRightVOList = interceptionPointVO.getUsesExtraDataForAccessControl() != false ? AccessRightController.toVOList(this.getAccessRightList(interceptionPointId, parameters, roleName, db)) : AccessRightController.toVOList(this.getAccessRightList(interceptionPointId, roleName, db));
        logger.info((Object)("accessRightVOList:" + accessRightVOList.size()));
        return accessRightVOList;
    }

    public List getAccessRightVOListOnly(Integer interceptionPointId, String parameters) throws SystemException, Bug {
        List accessRightVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            accessRightVOList = this.getAccessRightVOListOnly(db, interceptionPointId, parameters);
            logger.info((Object)("accessRightVOList:" + accessRightVOList.size()));
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return accessRightVOList;
    }

    public List getAccessRightVOListOnly(Database db, Integer interceptionPointId, String parameters) throws SystemException, Bug {
        List accessRightVOList = null;
        InterceptionPointVO interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithId(interceptionPointId);
        accessRightVOList = interceptionPointVO.getUsesExtraDataForAccessControl() != false ? AccessRightController.toVOList(this.getAccessRightListOnlyReadOnly(interceptionPointId, parameters, db)) : AccessRightController.toVOList(this.getAccessRightList(interceptionPointId, db));
        logger.info((Object)("accessRightVOList:" + accessRightVOList.size()));
        return accessRightVOList;
    }

    public List getAccessRightList(String interceptionPointName, String parameters, String roleName, Database db) throws SystemException, Bug {
        List accessRightList = this.getAccessRightList(InterceptionPointController.getController().getInterceptionPointVOWithName(interceptionPointName).getId(), parameters, roleName, db);
        return accessRightList;
    }

    public List getAccessRightList(Integer interceptionPointId, String parameters, String roleName, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            OQLQuery oql = null;
            if (parameters == null || parameters.length() == 0) {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND (is_undefined(f.parameters) OR f.parameters = $2) AND f.roles.roleName = $3");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
                oql.bind((Object)roleName);
            } else {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND f.parameters = $2 AND f.roles.roleName = $3");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
                oql.bind((Object)roleName);
            }
            QueryResults results = oql.execute();
            logger.info((Object)("Fetching entity in read/write mode" + interceptionPointId));
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public List getAccessRightListOnly(Integer interceptionPointId, String parameters, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            OQLQuery oql = null;
            if (parameters == null || parameters.length() == 0) {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND (is_undefined(f.parameters) OR f.parameters = $2)");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
            } else {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND f.parameters = $2");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
            }
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public List getAccessRightListOnlyReadOnly(Integer interceptionPointId, String parameters, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            OQLQuery oql = null;
            if (parameters == null || parameters.length() == 0) {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND (is_undefined(f.parameters) OR f.parameters = $2)");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
            } else {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND f.parameters = $2");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
            }
            QueryResults results = oql.execute((short)0);
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public List getAccessRightListForEntity(Integer interceptionPointId, String parameters, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            OQLQuery oql = null;
            if (parameters == null || parameters.length() == 0) {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND (is_undefined(f.parameters) OR f.parameters = $2)");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
            } else {
                oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND f.parameters = $2");
                oql.bind((Object)interceptionPointId);
                oql.bind((Object)parameters);
            }
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Function. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public List getAccessRightList(Integer interceptionPointId, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            logger.info((Object)"getAccessRightList(Integer interceptionPointId, Database db)");
            logger.info((Object)("interceptionPointId: " + interceptionPointId));
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1");
            oql.bind((Object)interceptionPointId);
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                logger.info((Object)("accessRight:" + accessRight.getAccessRightId()));
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Function. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public List getAccessRightList(String roleName, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            logger.info((Object)"getAccessRightList(String roleName, Database db)");
            logger.info((Object)("roleName: " + roleName));
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.roles.roleName = $1");
            oql.bind((Object)roleName);
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                logger.info((Object)("accessRight:" + accessRight.getAccessRightId()));
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Function. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public List getAccessRightList(Integer interceptionPointId, String roleName, Database db) throws SystemException, Bug {
        ArrayList<AccessRight> accessRightList = new ArrayList<AccessRight>();
        try {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"getAccessRightList(Integer interceptionPointId, String roleName, Database db)");
                logger.info((Object)("interceptionPointId: " + interceptionPointId));
                logger.info((Object)("roleName: " + roleName));
            }
            OQLQuery oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightImpl f WHERE f.interceptionPoint = $1 AND f.roles.roleName = $2");
            oql.bind((Object)interceptionPointId);
            oql.bind((Object)roleName);
            QueryResults results = oql.execute();
            logger.info((Object)"Fetching entity in read/write mode");
            while (results.hasMore()) {
                AccessRight accessRight = (AccessRight)results.next();
                accessRightList.add(accessRight);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Function. Reason:" + e.getMessage(), e);
        }
        return accessRightList;
    }

    public AccessRight create(AccessRightVO accessRightVO, InterceptionPoint interceptionPoint, Database db) throws SystemException, Exception {
        AccessRightImpl accessRight = new AccessRightImpl();
        accessRight.setValueObject(accessRightVO);
        accessRight.setInterceptionPoint(interceptionPoint);
        db.create((Object)accessRight);
        return accessRight;
    }

    public AccessRightVO update(AccessRightVO AccessRightVO2) throws ConstraintException, SystemException {
        return (AccessRightVO)AccessRightController.updateEntity(AccessRightImpl.class, AccessRightVO2);
    }

    public void update(String parameters, HttpServletRequest request) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        logger.info((Object)("parameters:" + parameters));
        try {
            AccessRightController.beginTransaction(db);
            int interceptionPointIndex = 0;
            String interceptionPointIdString = request.getParameter(String.valueOf(interceptionPointIndex) + "_InterceptionPointId");
            while (interceptionPointIdString != null) {
                this.delete(new Integer(interceptionPointIdString), parameters, false, db);
                AccessRightVO accessRightVO = new AccessRightVO();
                accessRightVO.setParameters(parameters);
                AccessRight accessRight = null;
                int roleIndex = 0;
                String roleName = request.getParameter(String.valueOf(interceptionPointIdString) + "_" + roleIndex + "_roleName");
                while (roleName != null) {
                    String hasAccess = request.getParameter(String.valueOf(interceptionPointIdString) + "_" + roleName + "_hasAccess");
                    if (hasAccess != null) {
                        if (accessRight == null) {
                            InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithId(new Integer(interceptionPointIdString), db);
                            accessRight = this.create(accessRightVO, interceptionPoint, db);
                        }
                        AccessRightRoleVO accessRightRoleVO = new AccessRightRoleVO();
                        accessRightRoleVO.setRoleName(roleName);
                        AccessRightRole accessRightRole = this.createAccessRightRole(db, accessRightRoleVO, accessRight);
                        accessRight.getRoles().add(accessRightRole);
                    }
                    roleName = request.getParameter(String.valueOf(interceptionPointIdString) + "_" + ++roleIndex + "_roleName");
                }
                int groupIndex = 0;
                String groupName = request.getParameter(String.valueOf(interceptionPointIdString) + "_" + groupIndex + "_groupName");
                while (groupName != null) {
                    if (accessRight == null) {
                        InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithId(new Integer(interceptionPointIdString), db);
                        accessRight = this.create(accessRightVO, interceptionPoint, db);
                    }
                    AccessRightGroupVO accessRightGroupVO = new AccessRightGroupVO();
                    accessRightGroupVO.setGroupName(groupName);
                    AccessRightGroup accessRightGroup = this.createAccessRightGroup(db, accessRightGroupVO, accessRight);
                    accessRight.getGroups().add(accessRightGroup);
                    groupName = request.getParameter(String.valueOf(interceptionPointIdString) + "_" + ++groupIndex + "_groupName");
                }
                interceptionPointIdString = request.getParameter(String.valueOf(++interceptionPointIndex) + "_InterceptionPointId");
            }
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void updateGroups(Integer accessRightId, String parameters, String[] groupNames) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        logger.info((Object)("parameters:" + parameters));
        try {
            AccessRightController.beginTransaction(db);
            AccessRight accessRight = this.getAccessRightWithId(accessRightId, db);
            Iterator groupsIterator = accessRight.getGroups().iterator();
            while (groupsIterator.hasNext()) {
                AccessRightGroup accessRightGroup = (AccessRightGroup)groupsIterator.next();
                groupsIterator.remove();
                db.remove((Object)accessRightGroup);
            }
            if (groupNames != null) {
                int i = 0;
                while (i < groupNames.length) {
                    String groupName = groupNames[i];
                    AccessRightGroupVO accessRightGroupVO = new AccessRightGroupVO();
                    accessRightGroupVO.setGroupName(groupName);
                    AccessRightGroup accessRightGroup = this.createAccessRightGroup(db, accessRightGroupVO, accessRight);
                    accessRight.getGroups().add(accessRightGroup);
                    ++i;
                }
            }
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void addUser(String interceptionPointCategory, String parameters, String userName, HttpServletRequest request) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        logger.info((Object)("parameters:" + parameters));
        try {
            AccessRightController.beginTransaction(db);
            try {
                InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController(db).getUser(userName);
                if (infoGluePrincipal == null) {
                    throw new SystemException("The user named " + userName + " does not exist in the system.");
                }
            }
            catch (Exception e) {
                throw new SystemException("The user named " + userName + " does not exist in the system.");
            }
            List accessRightsUsers = this.getAccessRightsUsers(interceptionPointCategory, parameters, userName, db);
            Iterator accessRightsUsersIterator = accessRightsUsers.iterator();
            while (accessRightsUsersIterator.hasNext()) {
                AccessRightUser accessRightUser = (AccessRightUser)accessRightsUsersIterator.next();
                db.remove((Object)accessRightUser.getAccessRight());
                accessRightsUsersIterator.remove();
                db.remove((Object)accessRightUser);
            }
            int interceptionPointIndex = 0;
            String interceptionPointIdString = request.getParameter(String.valueOf(interceptionPointIndex) + "_InterceptionPointId");
            while (interceptionPointIdString != null) {
                String hasAccess = request.getParameter(String.valueOf(interceptionPointIdString) + "_hasAccess");
                AccessRight accessRight = null;
                if (hasAccess != null) {
                    List accessRights = this.getAccessRightListForEntity(new Integer(interceptionPointIdString), parameters, db);
                    if (accessRights == null || accessRights.size() == 0) {
                        AccessRightVO accessRightVO = new AccessRightVO();
                        accessRightVO.setParameters(parameters);
                        InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithId(new Integer(interceptionPointIdString), db);
                        accessRight = this.create(accessRightVO, interceptionPoint, db);
                    } else {
                        accessRight = (AccessRight)accessRights.get(0);
                    }
                    if (userName != null && accessRight != null) {
                        AccessRightUserVO accessRightUserVO = new AccessRightUserVO();
                        accessRightUserVO.setUserName(userName);
                        AccessRightUser accessRightUser = this.createAccessRightUser(db, accessRightUserVO, accessRight);
                        accessRight.getUsers().add(accessRightUser);
                    }
                }
                interceptionPointIdString = request.getParameter(String.valueOf(++interceptionPointIndex) + "_InterceptionPointId");
            }
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void addUserRights(String[] interceptionPointNames, String parameters, InfoGluePrincipal principal) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            int i = 0;
            while (i < interceptionPointNames.length) {
                String interceptionPointName = interceptionPointNames[i];
                InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithName(interceptionPointName, db);
                if (interceptionPoint != null) {
                    AccessRightVO accessRightVO = new AccessRightVO();
                    accessRightVO.setParameters(parameters);
                    AccessRight accessRight = this.create(accessRightVO, interceptionPoint, db);
                    if (principal != null && accessRight != null) {
                        AccessRightUserVO accessRightUserVO = new AccessRightUserVO();
                        accessRightUserVO.setUserName(principal.getName());
                        AccessRightUser accessRightUser = this.createAccessRightUser(db, accessRightUserVO, accessRight);
                        accessRight.getUsers().add(accessRightUser);
                    }
                }
                ++i;
            }
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void deleteUser(String interceptionPointCategory, String parameters, String userName, HttpServletRequest request) throws ConstraintException, SystemException {
        Database db = CastorDatabaseService.getDatabase();
        logger.info((Object)("parameters:" + parameters));
        try {
            AccessRightController.beginTransaction(db);
            List accessRightsUsers = this.getAccessRightsUsers(interceptionPointCategory, parameters, userName, db);
            Iterator accessRightsUsersIterator = accessRightsUsers.iterator();
            while (accessRightsUsersIterator.hasNext()) {
                AccessRightUser accessRightUser = (AccessRightUser)accessRightsUsersIterator.next();
                accessRightUser.getAccessRight().getUsers().remove(accessRightUser);
                accessRightsUsersIterator.remove();
                db.remove((Object)accessRightUser);
            }
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public AccessRightRole createAccessRightRole(Database db, AccessRightRoleVO accessRightRoleVO, AccessRight accessRight) throws SystemException, Exception {
        AccessRightRoleImpl accessRightRole = new AccessRightRoleImpl();
        accessRightRole.setValueObject(accessRightRoleVO);
        accessRightRole.setAccessRight(accessRight);
        db.create((Object)accessRightRole);
        return accessRightRole;
    }

    public AccessRightGroup createAccessRightGroup(Database db, AccessRightGroupVO accessRightGroupVO, AccessRight accessRight) throws SystemException, Exception {
        AccessRightGroupImpl accessRightGroup = new AccessRightGroupImpl();
        accessRightGroup.setValueObject(accessRightGroupVO);
        accessRightGroup.setAccessRight(accessRight);
        db.create((Object)accessRightGroup);
        return accessRightGroup;
    }

    public AccessRightUser createAccessRightUser(Database db, AccessRightUserVO accessRightUserVO, AccessRight accessRight) throws SystemException, Exception {
        AccessRightUserImpl accessRightUser = new AccessRightUserImpl();
        accessRightUser.setValueObject(accessRightUserVO);
        accessRightUser.setAccessRight(accessRight);
        db.create((Object)accessRightUser);
        return accessRightUser;
    }

    public void delete(String roleName) throws SystemException, Exception {
        Database db = CastorDatabaseService.getDatabase();
        logger.info((Object)("roleName:" + roleName));
        try {
            AccessRightController.beginTransaction(db);
            List accessRightList = this.getAccessRightList(roleName, db);
            for (AccessRight accessRight : accessRightList) {
                db.remove((Object)accessRight);
            }
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
    }

    public void delete(Integer interceptionPointId, String parameters, boolean deleteUsers, Database db) throws SystemException, Exception {
        List accessRightList = this.getAccessRightListOnly(interceptionPointId, parameters, db);
        for (AccessRight accessRight : accessRightList) {
            Iterator rolesIterator = accessRight.getRoles().iterator();
            while (rolesIterator.hasNext()) {
                AccessRightRole accessRightRole = (AccessRightRole)rolesIterator.next();
                rolesIterator.remove();
                db.remove((Object)accessRightRole);
            }
            Iterator groupsIterator = accessRight.getGroups().iterator();
            while (groupsIterator.hasNext()) {
                AccessRightGroup accessRightGroup = (AccessRightGroup)groupsIterator.next();
                groupsIterator.remove();
                db.remove((Object)accessRightGroup);
            }
            if (deleteUsers) {
                Iterator usersIterator = accessRight.getUsers().iterator();
                while (usersIterator.hasNext()) {
                    AccessRightUser accessRightUser = (AccessRightUser)usersIterator.next();
                    usersIterator.remove();
                    db.remove((Object)accessRightUser);
                }
                db.remove((Object)accessRight);
                continue;
            }
            if (accessRight.getUsers() != null && accessRight.getUsers().size() != 0) continue;
            db.remove((Object)accessRight);
        }
    }

    public boolean getIsPrincipalAuthorized(InfoGluePrincipal infoGluePrincipal, String interceptionPointName, String parameters) throws SystemException {
        if (infoGluePrincipal == null) {
            return false;
        }
        if (infoGluePrincipal != null && infoGluePrincipal.getIsAdministrator()) {
            return true;
        }
        boolean isPrincipalAuthorized = false;
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            isPrincipalAuthorized = this.getIsPrincipalAuthorized(db, infoGluePrincipal, interceptionPointName, parameters);
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return isPrincipalAuthorized;
    }

    public boolean getIsPrincipalAuthorized(Database db, InfoGluePrincipal infoGluePrincipal, String interceptionPointName, String extraParameters) throws SystemException {
        InterceptionPointVO interceptionPointVO;
        Boolean cachedIsPrincipalAuthorized;
        if (infoGluePrincipal == null) {
            return false;
        }
        if (infoGluePrincipal != null && infoGluePrincipal.getIsAdministrator()) {
            return true;
        }
        String key = infoGluePrincipal.getName() + "_" + interceptionPointName + "_" + extraParameters;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("key:" + key));
            logger.info((Object)("infoGluePrincipal:" + infoGluePrincipal.getName()));
        }
        if ((cachedIsPrincipalAuthorized = (Boolean)CacheController.getCachedObjectFromAdvancedCache("personalAuthorizationCache", key)) != null) {
            if (logger.isInfoEnabled() && !cachedIsPrincipalAuthorized.booleanValue()) {
                logger.info((Object)("Principal " + infoGluePrincipal.getName() + " was not allowed to " + interceptionPointName + " on " + extraParameters + " (Cached value)"));
            }
            return cachedIsPrincipalAuthorized;
        }
        boolean isPrincipalAuthorized = false;
        boolean limitOnGroups = false;
        boolean principalHasRole = false;
        boolean principalHasGroup = false;
        List roles = infoGluePrincipal.getRoles();
        List groups = infoGluePrincipal.getGroups();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("roles:" + roles.size()));
            logger.info((Object)("groups:" + groups.size()));
        }
        if ((interceptionPointVO = InterceptionPointController.getController().getInterceptionPointVOWithName(interceptionPointName, db)) == null) {
            return true;
        }
        List accessRightList = this.getAccessRightListOnlyReadOnly(interceptionPointVO.getId(), extraParameters, db);
        if ((interceptionPointName.equalsIgnoreCase("ContentVersion.Read") || interceptionPointName.equalsIgnoreCase("ContentVersion.Write") || interceptionPointName.equalsIgnoreCase("ContentVersion.Delete") || interceptionPointName.equalsIgnoreCase("ContentVersion.Publish")) && (accessRightList == null || accessRightList.size() == 0)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("accessRightList:" + accessRightList.size()));
            }
            return true;
        }
        Iterator accessRightListIterator = accessRightList.iterator();
        block0: while (accessRightListIterator.hasNext() && !isPrincipalAuthorized) {
            AccessRight accessRight = (AccessRight)accessRightListIterator.next();
            Collection approvedRoles = accessRight.getRoles();
            Collection approvedGroups = accessRight.getGroups();
            Collection approvedUsers = accessRight.getUsers();
            for (AccessRightUser accessRightUser : approvedUsers) {
                if (!accessRightUser.getUserName().equals(infoGluePrincipal.getName())) continue;
                isPrincipalAuthorized = true;
            }
            if (isPrincipalAuthorized) continue;
            block2: for (InfoGlueRole role : roles) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("role:" + role.getName()));
                }
                for (AccessRightRole accessRightRole : approvedRoles) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(role.getName() + " = " + accessRightRole.getRoleName()));
                    }
                    if (!accessRightRole.getRoleName().equals(role.getName())) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Principal " + infoGluePrincipal.getName() + " has role " + accessRightRole.getRoleName()));
                    }
                    principalHasRole = true;
                    break block2;
                }
            }
            for (AccessRightGroup accessRightGroup : approvedGroups) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("accessRightGroup:" + accessRightGroup.getGroupName()));
                }
                limitOnGroups = true;
                for (InfoGlueGroup group : groups) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(group.getName() + " = " + accessRightGroup.getGroupName()));
                    }
                    if (!accessRightGroup.getGroupName().equals(group.getName())) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Principal " + infoGluePrincipal.getName() + " has group " + accessRightGroup.getGroupName()));
                    }
                    principalHasGroup = true;
                    continue block0;
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("principalHasRole: " + principalHasRole));
            logger.info((Object)("principalHasGroup: " + principalHasGroup));
            logger.info((Object)("limitOnGroups: " + limitOnGroups));
        }
        if (principalHasRole && principalHasGroup || principalHasRole && !limitOnGroups) {
            isPrincipalAuthorized = true;
        }
        if (logger.isInfoEnabled() && !isPrincipalAuthorized) {
            logger.info((Object)("Principal " + infoGluePrincipal.getName() + " was not allowed to " + interceptionPointName + " on " + extraParameters));
        }
        CacheController.cacheObjectInAdvancedCache("personalAuthorizationCache", key, new Boolean(isPrincipalAuthorized), new String[]{infoGluePrincipal.getName()}, true);
        return isPrincipalAuthorized;
    }

    public boolean getIsPrincipalAuthorized(InfoGluePrincipal infoGluePrincipal, String interceptionPointName) throws SystemException {
        return this.getIsPrincipalAuthorized(infoGluePrincipal, interceptionPointName, false);
    }

    public boolean getIsPrincipalAuthorized(InfoGluePrincipal infoGluePrincipal, String interceptionPointName, boolean returnSuccessIfInterceptionPointNotDefined) throws SystemException {
        if (infoGluePrincipal.getIsAdministrator()) {
            return true;
        }
        String key = infoGluePrincipal.getName() + "_" + interceptionPointName + "_" + returnSuccessIfInterceptionPointNotDefined;
        logger.info((Object)("key:" + key));
        Boolean cachedIsPrincipalAuthorized = (Boolean)CacheController.getCachedObjectFromAdvancedCache("personalAuthorizationCache", key);
        if (cachedIsPrincipalAuthorized != null) {
            if (logger.isInfoEnabled() && !cachedIsPrincipalAuthorized.booleanValue()) {
                logger.info((Object)("Principal " + infoGluePrincipal.getName() + " was not allowed to " + interceptionPointName));
            }
            return cachedIsPrincipalAuthorized;
        }
        boolean isPrincipalAuthorized = false;
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            isPrincipalAuthorized = this.getIsPrincipalAuthorized(db, infoGluePrincipal, interceptionPointName, returnSuccessIfInterceptionPointNotDefined, false);
            CacheController.cacheObjectInAdvancedCache("personalAuthorizationCache", key, new Boolean(isPrincipalAuthorized), new String[]{infoGluePrincipal.getName()}, true);
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.info((Object)("An error occurred so we should not complete the transaction:" + e));
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return isPrincipalAuthorized;
    }

    public boolean getIsPrincipalAuthorized(Database db, InfoGluePrincipal infoGluePrincipal, String interceptionPointName) throws SystemException {
        return this.getIsPrincipalAuthorized(db, infoGluePrincipal, interceptionPointName, false, false);
    }

    public boolean getIsPrincipalAuthorized(Database db, InfoGluePrincipal infoGluePrincipal, String interceptionPointName, boolean returnSuccessIfInterceptionPointNotDefined, boolean returnFailureIfInterceptionPointNotDefined) throws SystemException {
        if (infoGluePrincipal.getIsAdministrator()) {
            return true;
        }
        boolean isPrincipalAuthorized = false;
        boolean limitOnGroups = false;
        boolean principalHasRole = false;
        boolean principalHasGroup = false;
        List roles = infoGluePrincipal.getRoles();
        List groups = infoGluePrincipal.getGroups();
        InterceptionPoint interceptionPoint = InterceptionPointController.getController().getInterceptionPointWithName(interceptionPointName, db);
        if (interceptionPoint == null && returnSuccessIfInterceptionPointNotDefined) {
            return true;
        }
        if (interceptionPoint == null && returnFailureIfInterceptionPointNotDefined) {
            return false;
        }
        List accessRightList = this.getAccessRightList(interceptionPoint.getId(), db);
        Iterator accessRightListIterator = accessRightList.iterator();
        block0: while (accessRightListIterator.hasNext() && !isPrincipalAuthorized) {
            AccessRight accessRight = (AccessRight)accessRightListIterator.next();
            Collection approvedRoles = accessRight.getRoles();
            Collection approvedGroups = accessRight.getGroups();
            Collection approvedUsers = accessRight.getUsers();
            for (AccessRightUser accessRightUser : approvedUsers) {
                if (!accessRightUser.getUserName().equals(infoGluePrincipal.getName())) continue;
                isPrincipalAuthorized = true;
            }
            if (isPrincipalAuthorized) continue;
            block2: for (InfoGlueRole role : roles) {
                logger.info((Object)("role:" + role.getName()));
                for (AccessRightRole accessRightRole : approvedRoles) {
                    if (!accessRightRole.getRoleName().equals(role.getName())) continue;
                    principalHasRole = true;
                    break block2;
                }
            }
            for (AccessRightGroup accessRightGroup : approvedGroups) {
                logger.info((Object)("accessRightGroup:" + accessRightGroup.getGroupName()));
                limitOnGroups = true;
                for (InfoGlueGroup group : groups) {
                    if (!accessRightGroup.getGroupName().equals(group.getName())) continue;
                    principalHasGroup = true;
                    continue block0;
                }
            }
        }
        if (principalHasRole && principalHasGroup || principalHasRole && !limitOnGroups) {
            isPrincipalAuthorized = true;
        }
        if (logger.isInfoEnabled() && !isPrincipalAuthorized) {
            logger.info((Object)("Principal " + infoGluePrincipal.getName() + " was not allowed to " + interceptionPointName));
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("isPrincipalAuthorized:" + isPrincipalAuthorized));
        }
        return isPrincipalAuthorized;
    }

    public Collection getAccessRightsUserRows(String interceptionPointCategory, String parameters) throws SystemException, Bug {
        Collection principalVOList = null;
        Database db = CastorDatabaseService.getDatabase();
        try {
            AccessRightController.beginTransaction(db);
            principalVOList = this.getAccessRightsUserRows(interceptionPointCategory, parameters, db);
            AccessRightController.commitTransaction(db);
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            AccessRightController.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        return principalVOList;
    }

    public Collection getAccessRightsUserRows(String interceptionPointCategory, String parameters, Database db) throws SystemException, Bug {
        HashMap<String, AccessRightsUserRow> accessRightsUserRows = new HashMap<String, AccessRightsUserRow>();
        try {
            List accessRightUsers = this.getAccessRightsUsers(interceptionPointCategory, parameters, db);
            Iterator accessRightUsersIterator = accessRightUsers.iterator();
            while (accessRightUsersIterator.hasNext()) {
                try {
                    AccessRightUser accessRightUser = (AccessRightUser)accessRightUsersIterator.next();
                    AccessRightsUserRow accessRightsUserRow = (AccessRightsUserRow)accessRightsUserRows.get(accessRightUser.getUserName());
                    if (accessRightsUserRow == null) {
                        InfoGluePrincipal infoGluePrincipal = UserControllerProxy.getController(db).getUser(accessRightUser.getUserName());
                        if (infoGluePrincipal == null) continue;
                        AccessRightsUserRow newAccessRightsUserRow = new AccessRightsUserRow();
                        newAccessRightsUserRow.setUserName(infoGluePrincipal.getName());
                        newAccessRightsUserRow.getAccessRights().put(accessRightUser.getAccessRight().getInterceptionPoint().getId(), new Boolean(true));
                        accessRightsUserRows.put(infoGluePrincipal.getName(), newAccessRightsUserRow);
                        continue;
                    }
                    accessRightsUserRow.getAccessRights().put(accessRightUser.getAccessRight().getInterceptionPoint().getId(), new Boolean(true));
                }
                catch (Exception e) {
                    logger.info((Object)("An user did not exist although given access rights:" + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights. Reason:" + e.getMessage(), e);
        }
        return accessRightsUserRows.values();
    }

    public List getAccessRightsUsers(String interceptionPointCategory, String parameters, Database db) throws SystemException, Bug {
        ArrayList<AccessRightUser> accessRightsUsers = new ArrayList<AccessRightUser>();
        try {
            OQLQuery oql = null;
            if (parameters == null || parameters.length() == 0) {
                oql = db.getOQLQuery("SELECT aru FROM org.infoglue.cms.entities.management.impl.simple.AccessRightUserImpl aru WHERE aru.accessRight.interceptionPoint.category = $1 AND (is_undefined(aru.accessRight.parameters) OR aru.accessRight.parameters = $2)");
                oql.bind((Object)interceptionPointCategory);
                oql.bind((Object)parameters);
            } else {
                oql = db.getOQLQuery("SELECT aru FROM org.infoglue.cms.entities.management.impl.simple.AccessRightUserImpl aru WHERE aru.accessRight.interceptionPoint.category = $1 AND aru.accessRight.parameters = $2");
                oql.bind((Object)interceptionPointCategory);
                oql.bind((Object)parameters);
            }
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                AccessRightUser accessRightUser = (AccessRightUser)results.next();
                accessRightsUsers.add(accessRightUser);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights. Reason:" + e.getMessage(), e);
        }
        return accessRightsUsers;
    }

    public List getAccessRightsUsers(String interceptionPointCategory, String parameters, String userName, Database db) throws SystemException, Bug {
        ArrayList<AccessRightUser> accessRightsUsers = new ArrayList<AccessRightUser>();
        try {
            OQLQuery oql = null;
            if (parameters == null || parameters.length() == 0) {
                oql = db.getOQLQuery("SELECT aru FROM org.infoglue.cms.entities.management.impl.simple.AccessRightUserImpl aru WHERE aru.accessRight.interceptionPoint.category = $1 AND (is_undefined(aru.accessRight.parameters) OR aru.accessRight.parameters = $2) AND aru.userName = $3");
                oql.bind((Object)interceptionPointCategory);
                oql.bind((Object)parameters);
                oql.bind((Object)userName);
            } else {
                oql = db.getOQLQuery("SELECT aru FROM org.infoglue.cms.entities.management.impl.simple.AccessRightUserImpl aru WHERE aru.accessRight.interceptionPoint.category = $1 AND aru.accessRight.parameters = $2 AND aru.userName = $3");
                oql.bind((Object)interceptionPointCategory);
                oql.bind((Object)parameters);
                oql.bind((Object)userName);
            }
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                AccessRightUser accessRightUser = (AccessRightUser)results.next();
                accessRightsUsers.add(accessRightUser);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights. Reason:" + e.getMessage(), e);
        }
        return accessRightsUsers;
    }

    public List getAccessRightUserList(String userName, Database db) throws SystemException, Bug {
        ArrayList<AccessRightUser> accessRightUserList = new ArrayList<AccessRightUser>();
        try {
            OQLQuery oql = null;
            oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightUserImpl f WHERE f.userName = $1");
            oql.bind((Object)userName);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                AccessRightUser accessRightUser = (AccessRightUser)results.next();
                Integer accessRightId = accessRightUser.getAccessRight().getAccessRightId();
                accessRightUserList.add(accessRightUser);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights users. Reason:" + e.getMessage(), e);
        }
        return accessRightUserList;
    }

    public List getAccessRightRoleList(String roleName, Database db, boolean readOnly) throws SystemException, Bug {
        ArrayList<AccessRightRole> accessRightRoleList = new ArrayList<AccessRightRole>();
        try {
            OQLQuery oql = null;
            oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightRoleImpl f WHERE f.roleName = $1");
            oql.bind((Object)roleName);
            QueryResults results = readOnly ? oql.execute((short)0) : oql.execute();
            while (results.hasMore()) {
                AccessRightRole accessRightRole = (AccessRightRole)results.next();
                Integer accessRightId = accessRightRole.getAccessRight().getAccessRightId();
                if (accessRightRole.getAccessRight() == null && !readOnly) {
                    db.remove((Object)accessRightRole);
                    continue;
                }
                accessRightRoleList.add(accessRightRole);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights users. Reason:" + e.getMessage(), e);
        }
        return accessRightRoleList;
    }

    public List getAccessRightGroupList(String groupName, Database db) throws SystemException, Bug {
        ArrayList<AccessRightGroup> accessRightGroupList = new ArrayList<AccessRightGroup>();
        try {
            OQLQuery oql = null;
            oql = db.getOQLQuery("SELECT f FROM org.infoglue.cms.entities.management.impl.simple.AccessRightGroupImpl f WHERE f.groupName = $1");
            oql.bind((Object)groupName);
            QueryResults results = oql.execute();
            while (results.hasMore()) {
                AccessRightGroup accessRightGroup = (AccessRightGroup)results.next();
                Integer accessRightId = accessRightGroup.getAccessRight().getAccessRightId();
                accessRightGroupList.add(accessRightGroup);
            }
            results.close();
            oql.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SystemException("An error occurred when we tried to fetch a list of Access rights users. Reason:" + e.getMessage(), e);
        }
        return accessRightGroupList;
    }

    public BaseEntityVO getNewVO() {
        return new AccessRightVO();
    }
}

