/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.controllers.kernel.impl.simple;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infoglue.cms.controllers.kernel.impl.simple.ExtendedSearchController;
import org.infoglue.cms.controllers.kernel.impl.simple.ICategoryCondition;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.util.CmsPropertyHandler;

abstract class AbstractCategoryCondition
implements ICategoryCondition {
    protected static final String LEFT = "(";
    protected static final String RIGHT = ")";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String AND = "AND";
    protected static final String OR = "OR";
    private static final String CATEGORY_ALIAS_PREFIX = "cat";
    private static final String CONTENT_CATEGORY_ALIAS_PREFIX = "ccat";
    private static final String CONTENT_VERSION_ALIAS = "cv";
    private static final String CATEGORY_TABLE = "cmCategory";
    private static final String CONTENT_CATEGORY_TABLE = "cmContentCategory";
    protected static final String ONE_CATEGORY_CLAUSE = " (cat{0}.categoryId={1} AND ccat{0}.attributeName={2}) ";
    protected static final String CATEGORY_CLAUSE = "(cat{0}.active=1 AND {1} AND ccat{0}.categoryId = cat{0}.categoryId  AND ccat{0}.ContentVersionId=cv.ContentVersionId)";
    protected static final String CATEGORY_CLAUSE_SHORT = "(cat{0}.active=1 AND {1} AND ccat{0}.categoryId = cat{0}.categoryId  AND ccat{0}.ContVerId=cv.ContVerId)";
    protected static final String CATEGORY_CLAUSE_GENERAL = "(cv.contentVersionId IN (SELECT contentVersionId from cmContentCategory WHERE categoryId={0} AND attributeName={1}))";
    protected static final String CATEGORY_CLAUSE_GENERAL_SHORT = "(cv.contVerId IN (SELECT contVerId from cmContentCategory WHERE categoryId={0} AND attributeName={1}))";
    private static int counter;
    private Integer uniqueID = this.createUniqueId();

    private synchronized Integer createUniqueId() {
        return new Integer(counter++);
    }

    AbstractCategoryCondition() {
    }

    protected String getUniqueID() {
        return this.uniqueID == null ? "" : this.uniqueID.toString();
    }

    protected String getBindingVariable(Collection bindings) {
        return "$" + (bindings.size() + 1);
    }

    public Collection getFromClauseTables() {
        ArrayList<String> result = new ArrayList<String>();
        String useImprovedContentCategorySearch = CmsPropertyHandler.getUseImprovedContentCategorySearch();
        if (useImprovedContentCategorySearch != null && useImprovedContentCategorySearch.equalsIgnoreCase("false")) {
            result.add("cmCategory cat" + this.uniqueID);
            result.add("cmContentCategory ccat" + this.uniqueID);
        }
        return result;
    }

    protected String getOneCategoryClause(String attributeName, CategoryVO categoryVO, List bindings) {
        String categoryVariable = this.getBindingVariable(bindings);
        bindings.add(categoryVO.getId());
        String nameVariable = this.getBindingVariable(bindings);
        bindings.add(attributeName);
        String useImprovedContentCategorySearch = CmsPropertyHandler.getUseImprovedContentCategorySearch();
        if (useImprovedContentCategorySearch != null && useImprovedContentCategorySearch.equalsIgnoreCase("false")) {
            return MessageFormat.format(ONE_CATEGORY_CLAUSE, this.getUniqueID(), categoryVariable, nameVariable);
        }
        String categoryClause = ExtendedSearchController.useFull() ? CATEGORY_CLAUSE_GENERAL : CATEGORY_CLAUSE_GENERAL_SHORT;
        return MessageFormat.format(categoryClause, categoryVariable, nameVariable);
    }

    public boolean hasCondition() {
        return true;
    }
}

